/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.hierarchy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.semanticweb.HermiT.hierarchy.ClassificationProgressMonitor;
import org.semanticweb.HermiT.hierarchy.Hierarchy;
import org.semanticweb.HermiT.hierarchy.HierarchyNode;
import org.semanticweb.HermiT.model.Atom;
import org.semanticweb.HermiT.model.AtomicConcept;
import org.semanticweb.HermiT.model.Individual;
import org.semanticweb.HermiT.tableau.ExtensionTable;
import org.semanticweb.HermiT.tableau.Node;
import org.semanticweb.HermiT.tableau.ReasoningTaskDescription;
import org.semanticweb.HermiT.tableau.Tableau;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeterministicClassification {
    protected final Tableau m_tableau;
    protected final ClassificationProgressMonitor m_progressMonitor;
    protected final AtomicConcept m_topElement;
    protected final AtomicConcept m_bottomElement;
    protected final Set<AtomicConcept> m_elements;

    public DeterministicClassification(Tableau tableau, ClassificationProgressMonitor classificationProgressMonitor, AtomicConcept atomicConcept, AtomicConcept atomicConcept2, Set<AtomicConcept> set2) {
        this.m_tableau = tableau;
        this.m_progressMonitor = classificationProgressMonitor;
        this.m_topElement = atomicConcept;
        this.m_bottomElement = atomicConcept2;
        this.m_elements = set2;
    }

    public Hierarchy<AtomicConcept> classify() {
        if (!this.m_tableau.isDeterministic()) {
            throw new IllegalStateException("Internal error: DeterministicClassificationManager can be used only with a deterministic tableau.");
        }
        Individual individual = Individual.createAnonymous("fresh-individual");
        if (!this.m_tableau.isSatisfiable(true, Collections.singleton(Atom.create(this.m_topElement, individual)), null, null, null, null, ReasoningTaskDescription.isConceptSatisfiable(this.m_topElement))) {
            return Hierarchy.emptyHierarchy(this.m_elements, this.m_topElement, this.m_bottomElement);
        }
        HashMap<AtomicConcept, GraphNode<AtomicConcept>> hashMap = new HashMap<AtomicConcept, GraphNode<AtomicConcept>>();
        for (AtomicConcept atomicConcept : this.m_elements) {
            Set<AtomicConcept> set2;
            HashMap<Individual, Node> hashMap2 = new HashMap<Individual, Node>();
            hashMap2.put(individual, null);
            if (!this.m_tableau.isSatisfiable(true, Collections.singleton(Atom.create(atomicConcept, individual)), null, null, null, hashMap2, ReasoningTaskDescription.isConceptSatisfiable(atomicConcept))) {
                set2 = this.m_elements;
            } else {
                set2 = new HashSet<AtomicConcept>();
                set2.add(this.m_topElement);
                ExtensionTable.Retrieval retrieval = this.m_tableau.getExtensionManager().getBinaryExtensionTable().createRetrieval(new boolean[]{false, true}, ExtensionTable.View.TOTAL);
                retrieval.getBindingsBuffer()[1] = ((Node)hashMap2.get(individual)).getCanonicalNode();
                retrieval.open();
                while (!retrieval.afterLast()) {
                    Object object = retrieval.getTupleBuffer()[0];
                    if (object instanceof AtomicConcept && this.m_elements.contains(object)) {
                        set2.add((AtomicConcept)object);
                    }
                    retrieval.next();
                }
            }
            hashMap.put(atomicConcept, new GraphNode<AtomicConcept>(atomicConcept, set2));
            this.m_progressMonitor.elementClassified(atomicConcept);
        }
        return DeterministicClassification.buildHierarchy(this.m_topElement, this.m_bottomElement, hashMap);
    }

    public static <T> Hierarchy<T> buildHierarchy(T t, T t2, Map<T, GraphNode<T>> map2) {
        HierarchyNode<T> hierarchyNode = new HierarchyNode<T>(t);
        HierarchyNode<T> hierarchyNode2 = new HierarchyNode<T>(t2);
        Hierarchy<T> hierarchy = new Hierarchy<T>(hierarchyNode, hierarchyNode2);
        ArrayList<HierarchyNode<T>> arrayList = new ArrayList<HierarchyNode<T>>();
        DeterministicClassification.visit(new Stack<GraphNode<T>>(), new DFSIndex(), map2, map2.get(t2), hierarchy, arrayList);
        HashMap hashMap = new HashMap();
        ArrayList<GraphNode<T>> arrayList2 = new ArrayList<GraphNode<T>>();
        for (int i = 0; i < arrayList.size(); ++i) {
            HierarchyNode hierarchyNode3;
            HierarchyNode hierarchyNode4 = (HierarchyNode)arrayList.get(i);
            HashSet<Object> hashSet = new HashSet<Object>();
            hashSet.add(hierarchyNode4);
            hashMap.put(hierarchyNode4, hashSet);
            arrayList2.clear();
            for (Object object : hierarchyNode4.m_equivalentElements) {
                hierarchyNode3 = map2.get(object);
                for (Object t3 : ((GraphNode)((Object)hierarchyNode3)).m_successors) {
                    GraphNode<T> graphNode = map2.get(t3);
                    if (graphNode == null) continue;
                    arrayList2.add(graphNode);
                }
            }
            Collections.sort(arrayList2, TopologicalOrderComparator.INSTANCE);
            for (int j = arrayList2.size() - 1; j >= 0; --j) {
                Object object;
                object = (GraphNode)arrayList2.get(j);
                hierarchyNode3 = hierarchy.m_nodesByElements.get(((GraphNode)object).m_element);
                if (hashSet.contains(hierarchyNode3)) continue;
                hierarchyNode4.m_parentNodes.add(hierarchyNode3);
                hierarchyNode3.m_childNodes.add(hierarchyNode4);
                hashSet.add(hierarchyNode3);
                hashSet.addAll((Collection)hashMap.get(hierarchyNode3));
            }
        }
        return hierarchy;
    }

    protected static <T> void visit(Stack<GraphNode<T>> stack, DFSIndex dFSIndex, Map<T, GraphNode<T>> map2, GraphNode<T> graphNode, Hierarchy<T> hierarchy, List<HierarchyNode<T>> list) {
        GraphNode<T> graphNode2;
        graphNode.m_dfsIndex = dFSIndex.m_value++;
        graphNode.m_SCChead = graphNode;
        stack.push(graphNode);
        for (Object object : graphNode.m_successors) {
            graphNode2 = map2.get(object);
            if (graphNode2 == null) continue;
            if (graphNode2.notVisited()) {
                DeterministicClassification.visit(stack, dFSIndex, map2, graphNode2, hierarchy, list);
            }
            if (graphNode2.isAssignedToSCC() || graphNode2.m_SCChead.m_dfsIndex >= graphNode.m_SCChead.m_dfsIndex) continue;
            graphNode.m_SCChead = graphNode2.m_SCChead;
        }
        if (graphNode.m_SCChead == graphNode) {
            Object object;
            int n = list.size();
            object = new HashSet();
            do {
                graphNode2 = stack.pop();
                graphNode2.m_topologicalOrderIndex = n;
                object.add(graphNode2.m_element);
            } while (graphNode2 != graphNode);
            HierarchyNode<T> hierarchyNode = object.contains(hierarchy.getTopNode().m_representative) ? hierarchy.getTopNode() : (object.contains(hierarchy.getBottomNode().m_representative) ? hierarchy.getBottomNode() : new HierarchyNode(graphNode.m_element));
            for (Object e2 : object) {
                hierarchyNode.m_equivalentElements.add(e2);
                hierarchy.m_nodesByElements.put(e2, hierarchyNode);
            }
            list.add(hierarchyNode);
        }
    }

    protected static class DFSIndex {
        public int m_value;

        protected DFSIndex() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class TopologicalOrderComparator
    implements Comparator<GraphNode<?>> {
        public static final TopologicalOrderComparator INSTANCE = new TopologicalOrderComparator();

        protected TopologicalOrderComparator() {
        }

        @Override
        public int compare(GraphNode<?> graphNode, GraphNode<?> graphNode2) {
            return graphNode.m_topologicalOrderIndex - graphNode2.m_topologicalOrderIndex;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GraphNode<T> {
        public final T m_element;
        public final Set<T> m_successors;
        public int m_dfsIndex;
        public GraphNode<T> m_SCChead;
        public int m_topologicalOrderIndex;

        public GraphNode(T t, Set<T> set2) {
            this.m_element = t;
            this.m_successors = set2;
            this.m_dfsIndex = -1;
            this.m_SCChead = null;
            this.m_topologicalOrderIndex = -1;
        }

        public boolean notVisited() {
            return this.m_dfsIndex == -1;
        }

        public boolean isAssignedToSCC() {
            return this.m_topologicalOrderIndex != -1;
        }
    }
}

