/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.hierarchy;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HierarchyNode<E> {
    protected final E m_representative;
    protected final Set<E> m_equivalentElements;
    protected final Set<HierarchyNode<E>> m_parentNodes;
    protected final Set<HierarchyNode<E>> m_childNodes;

    public HierarchyNode(E e2) {
        this.m_representative = e2;
        this.m_equivalentElements = new HashSet();
        this.m_equivalentElements.add(this.m_representative);
        this.m_parentNodes = new HashSet<HierarchyNode<E>>();
        this.m_childNodes = new HashSet<HierarchyNode<E>>();
    }

    public HierarchyNode(E e2, Set<E> set2, Set<HierarchyNode<E>> set3, Set<HierarchyNode<E>> set4) {
        this.m_representative = e2;
        this.m_equivalentElements = set2;
        this.m_parentNodes = set3;
        this.m_childNodes = set4;
    }

    public E getRepresentative() {
        return this.m_representative;
    }

    public boolean isEquivalentElement(E e2) {
        return this.m_equivalentElements.contains(e2);
    }

    public boolean isAncestorElement(E e2) {
        for (HierarchyNode<E> hierarchyNode : this.getAncestorNodes()) {
            if (!hierarchyNode.isEquivalentElement(e2)) continue;
            return true;
        }
        return false;
    }

    public boolean isDescendantElement(E e2) {
        for (HierarchyNode<E> hierarchyNode : this.getDescendantNodes()) {
            if (!hierarchyNode.isEquivalentElement(e2)) continue;
            return true;
        }
        return false;
    }

    public Set<E> getEquivalentElements() {
        return Collections.unmodifiableSet(this.m_equivalentElements);
    }

    public Set<HierarchyNode<E>> getParentNodes() {
        return Collections.unmodifiableSet(this.m_parentNodes);
    }

    public Set<HierarchyNode<E>> getChildNodes() {
        return Collections.unmodifiableSet(this.m_childNodes);
    }

    public Set<HierarchyNode<E>> getAncestorNodes() {
        return HierarchyNode.getAncestorNodes(Collections.singleton(this));
    }

    public Set<HierarchyNode<E>> getDescendantNodes() {
        return HierarchyNode.getDescendantNodes(Collections.singleton(this));
    }

    public String toString() {
        return this.m_equivalentElements.toString();
    }

    public static <T> Set<HierarchyNode<T>> getAncestorNodes(Set<HierarchyNode<T>> set2) {
        HashSet<HierarchyNode<T>> hashSet = new HashSet<HierarchyNode<T>>();
        LinkedList<HierarchyNode<T>> linkedList = new LinkedList<HierarchyNode<T>>(set2);
        while (!linkedList.isEmpty()) {
            HierarchyNode hierarchyNode = (HierarchyNode)linkedList.poll();
            if (!hashSet.add(hierarchyNode)) continue;
            linkedList.addAll(hierarchyNode.getParentNodes());
        }
        return hashSet;
    }

    public static <T> Set<HierarchyNode<T>> getDescendantNodes(Set<HierarchyNode<T>> set2) {
        HashSet<HierarchyNode<T>> hashSet = new HashSet<HierarchyNode<T>>();
        LinkedList<HierarchyNode<T>> linkedList = new LinkedList<HierarchyNode<T>>(set2);
        while (!linkedList.isEmpty()) {
            HierarchyNode hierarchyNode = (HierarchyNode)linkedList.poll();
            if (!hashSet.add(hierarchyNode)) continue;
            linkedList.addAll(hierarchyNode.getChildNodes());
        }
        return hashSet;
    }
}

