/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.hierarchy;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.semanticweb.HermiT.Prefixes;
import org.semanticweb.HermiT.Reasoner;
import org.semanticweb.HermiT.graph.Graph;
import org.semanticweb.HermiT.hierarchy.AtomicConceptElement;
import org.semanticweb.HermiT.hierarchy.DeterministicClassification;
import org.semanticweb.HermiT.hierarchy.Hierarchy;
import org.semanticweb.HermiT.hierarchy.HierarchyNode;
import org.semanticweb.HermiT.hierarchy.RoleElementManager;
import org.semanticweb.HermiT.model.Atom;
import org.semanticweb.HermiT.model.AtomicConcept;
import org.semanticweb.HermiT.model.AtomicRole;
import org.semanticweb.HermiT.model.DLClause;
import org.semanticweb.HermiT.model.DLOntology;
import org.semanticweb.HermiT.model.DLPredicate;
import org.semanticweb.HermiT.model.Individual;
import org.semanticweb.HermiT.model.Inequality;
import org.semanticweb.HermiT.model.InverseRole;
import org.semanticweb.HermiT.model.Role;
import org.semanticweb.HermiT.monitor.TableauMonitor;
import org.semanticweb.HermiT.tableau.ExtensionManager;
import org.semanticweb.HermiT.tableau.ExtensionTable;
import org.semanticweb.HermiT.tableau.InterruptFlag;
import org.semanticweb.HermiT.tableau.Node;
import org.semanticweb.HermiT.tableau.NodeType;
import org.semanticweb.HermiT.tableau.ReasoningTaskDescription;
import org.semanticweb.HermiT.tableau.Tableau;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLLogicalAxiom;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.reasoner.ReasonerProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstanceManager {
    public static final int thresholdForAdditionalAxioms = 10000;
    protected final InterruptFlag m_interruptFlag;
    protected final Reasoner m_reasoner;
    protected final TableauMonitor m_tableauMonitor;
    protected final Individual[] m_individuals;
    protected final HashSet<AtomicRole> m_complexRoles;
    protected final Map<AtomicConcept, AtomicConceptElement> m_conceptToElement;
    protected final AtomicConcept m_topConcept;
    protected final AtomicConcept m_bottomConcept;
    protected Hierarchy<AtomicConcept> m_currentConceptHierarchy;
    protected final RoleElementManager m_roleElementManager;
    protected final RoleElementManager.RoleElement m_topRoleElement;
    protected final RoleElementManager.RoleElement m_bottomRoleElement;
    protected Hierarchy<RoleElementManager.RoleElement> m_currentRoleHierarchy;
    protected final boolean m_usesInverseRoles;
    protected final Map<Individual, Node> m_nodesForIndividuals;
    protected final Map<Node, Individual> m_individualsForNodes;
    protected final Map<Node, Set<Node>> m_canonicalNodeToDetMergedNodes;
    protected final Map<Node, Set<Node>> m_canonicalNodeToNonDetMergedNodes;
    protected boolean m_isInconsistent;
    protected boolean m_realizationCompleted;
    protected boolean m_roleRealizationCompleted;
    protected boolean m_usesClassifiedConceptHierarchy;
    protected boolean m_usesClassifiedObjectRoleHierarchy;
    protected boolean m_classesInitialised;
    protected boolean m_propertiesInitialised;
    protected boolean m_readingOffFoundPossibleConceptInstance;
    protected boolean m_readingOffFoundPossiblePropertyInstance;
    protected final Map<Individual, Set<Individual>> m_individualToEquivalenceClass;
    protected Map<Set<Individual>, Set<Set<Individual>>> m_individualToPossibleEquivalenceClass;
    protected final ExtensionTable.Retrieval m_binaryRetrieval0Bound;
    protected final ExtensionTable.Retrieval m_binaryRetrieval1Bound;
    protected final ExtensionTable.Retrieval m_binaryRetrieval01Bound;
    protected final ExtensionTable.Retrieval m_ternaryRetrieval1Bound;
    protected final ExtensionTable.Retrieval m_ternaryRetrieval0Bound;
    protected final ExtensionTable.Retrieval m_ternaryRetrieval012Bound;
    protected int m_currentIndividualIndex = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public InstanceManager(InterruptFlag interruptFlag, Reasoner reasoner, Hierarchy<AtomicConcept> hierarchy, Hierarchy<Role> hierarchy2) {
        this.m_interruptFlag = interruptFlag;
        this.m_interruptFlag.startTask();
        try {
            void var6_9;
            Set<Object> set2;
            this.m_reasoner = reasoner;
            this.m_tableauMonitor = this.m_reasoner.getTableau().getTableauMonitor();
            DLOntology dLOntology = this.m_reasoner.getDLOntology();
            this.m_individuals = new ArrayList<Individual>(dLOntology.getAllIndividuals()).toArray(new Individual[0]);
            this.m_complexRoles = new HashSet();
            this.m_individualToEquivalenceClass = new HashMap<Individual, Set<Individual>>();
            this.m_nodesForIndividuals = new HashMap<Individual, Node>();
            for (Individual individual : this.m_individuals) {
                this.m_nodesForIndividuals.put(individual, null);
                set2 = new HashSet<Individual>();
                set2.add(individual);
                this.m_individualToEquivalenceClass.put(individual, set2);
                this.m_interruptFlag.checkInterrupt();
            }
            this.m_individualsForNodes = new HashMap<Node, Individual>();
            this.m_canonicalNodeToDetMergedNodes = new HashMap<Node, Set<Node>>();
            this.m_canonicalNodeToNonDetMergedNodes = new HashMap<Node, Set<Node>>();
            this.m_individualToPossibleEquivalenceClass = null;
            this.m_topConcept = AtomicConcept.THING;
            this.m_bottomConcept = AtomicConcept.NOTHING;
            this.m_conceptToElement = new HashMap<AtomicConcept, AtomicConceptElement>();
            this.m_conceptToElement.put(this.m_topConcept, new AtomicConceptElement(null, null));
            Object var6_7 = null;
            HashSet<AtomicConcept> hashSet = null;
            if (hierarchy != null) {
                this.setToClassifiedConceptHierarchy(hierarchy);
            } else {
                Graph<AtomicConcept> graph = new Graph<AtomicConcept>();
                hashSet = new HashSet<AtomicConcept>();
                hashSet.add(this.m_topConcept);
                hashSet.add(this.m_bottomConcept);
                for (AtomicConcept atomicConcept : dLOntology.getAllAtomicConcepts()) {
                    if (!Prefixes.isInternalIRI(atomicConcept.getIRI())) {
                        hashSet.add(atomicConcept);
                        this.addKnownConceptSubsumption(graph, atomicConcept, atomicConcept);
                        this.addKnownConceptSubsumption(graph, atomicConcept, this.m_topConcept);
                        this.addKnownConceptSubsumption(graph, this.m_bottomConcept, atomicConcept);
                    }
                    this.m_interruptFlag.checkInterrupt();
                }
                this.addKnownConceptSubsumption(graph, this.m_bottomConcept, this.m_bottomConcept);
            }
            this.m_roleElementManager = new RoleElementManager();
            Graph<Role> graph = null;
            this.m_topRoleElement = this.m_roleElementManager.getRoleElement(AtomicRole.TOP_OBJECT_ROLE);
            this.m_bottomRoleElement = this.m_roleElementManager.getRoleElement(AtomicRole.BOTTOM_OBJECT_ROLE);
            this.m_usesInverseRoles = dLOntology.hasInverseRoles();
            Object var9_18 = null;
            set2 = dLOntology.getAllComplexObjectRoles();
            if (hierarchy2 != null) {
                this.setToClassifiedRoleHierarchy(hierarchy2);
                for (Role role : set2) {
                    if (!(role instanceof AtomicRole) || role == AtomicRole.TOP_OBJECT_ROLE || role == AtomicRole.BOTTOM_OBJECT_ROLE) continue;
                    this.m_complexRoles.add((AtomicRole)role);
                }
            } else {
                graph = new Graph<Role>();
                HashSet<AtomicRole> hashSet2 = new HashSet<AtomicRole>();
                hashSet2.add(AtomicRole.TOP_OBJECT_ROLE);
                hashSet2.add(AtomicRole.BOTTOM_OBJECT_ROLE);
                hashSet2.addAll(dLOntology.getAllAtomicObjectRoles());
                for (Role role : hashSet2) {
                    this.addKnownRoleSubsumption(graph, role, role);
                    this.addKnownRoleSubsumption(graph, role, AtomicRole.TOP_OBJECT_ROLE);
                    this.addKnownRoleSubsumption(graph, AtomicRole.BOTTOM_OBJECT_ROLE, role);
                    if (set2.contains(role) && role instanceof AtomicRole && role != AtomicRole.TOP_OBJECT_ROLE && role != AtomicRole.BOTTOM_OBJECT_ROLE) {
                        this.m_complexRoles.add((AtomicRole)role);
                    }
                    this.m_interruptFlag.checkInterrupt();
                }
                this.addKnownRoleSubsumption(graph, AtomicRole.BOTTOM_OBJECT_ROLE, AtomicRole.BOTTOM_OBJECT_ROLE);
            }
            if (hierarchy == null || hierarchy2 == null) {
                void var9_20;
                this.updateKnownSubsumptionsUsingToldSubsumers(dLOntology.getDLClauses(), (Graph<AtomicConcept>)var6_9, hashSet, graph, (Set<Role>)var9_20);
            }
            if (hierarchy == null) {
                this.m_currentConceptHierarchy = this.buildTransitivelyReducedConceptHierarchy((Graph<AtomicConcept>)var6_9);
            }
            if (hierarchy2 == null) {
                this.m_currentRoleHierarchy = this.buildTransitivelyReducedRoleHierarchy(graph);
            }
            Iterator iterator = this.m_reasoner.getTableau().getExtensionManager();
            this.m_binaryRetrieval0Bound = ((ExtensionManager)((Object)iterator)).getBinaryExtensionTable().createRetrieval(new boolean[]{true, false}, ExtensionTable.View.TOTAL);
            this.m_binaryRetrieval1Bound = ((ExtensionManager)((Object)iterator)).getBinaryExtensionTable().createRetrieval(new boolean[]{false, true}, ExtensionTable.View.TOTAL);
            this.m_binaryRetrieval01Bound = ((ExtensionManager)((Object)iterator)).getBinaryExtensionTable().createRetrieval(new boolean[]{true, true}, ExtensionTable.View.TOTAL);
            this.m_ternaryRetrieval1Bound = ((ExtensionManager)((Object)iterator)).getTernaryExtensionTable().createRetrieval(new boolean[]{false, true, false}, ExtensionTable.View.TOTAL);
            this.m_ternaryRetrieval0Bound = ((ExtensionManager)((Object)iterator)).getTernaryExtensionTable().createRetrieval(new boolean[]{true, false, false}, ExtensionTable.View.TOTAL);
            this.m_ternaryRetrieval012Bound = ((ExtensionManager)((Object)iterator)).getTernaryExtensionTable().createRetrieval(new boolean[]{true, true, true}, ExtensionTable.View.TOTAL);
        }
        finally {
            this.m_interruptFlag.endTask();
        }
    }

    protected void addKnownConceptSubsumption(Graph<AtomicConcept> graph, AtomicConcept atomicConcept, AtomicConcept atomicConcept2) {
        graph.addEdge(atomicConcept, atomicConcept2);
    }

    protected void addKnownRoleSubsumption(Graph<Role> graph, Role role, Role role2) {
        graph.addEdge(role, role2);
        if (this.m_usesInverseRoles) {
            graph.addEdge(role.getInverse(), role2.getInverse());
        }
    }

    protected void updateKnownSubsumptionsUsingToldSubsumers(Set<DLClause> set2, Graph<AtomicConcept> graph, Set<AtomicConcept> set3, Graph<Role> graph2, Set<Role> set4) {
        boolean bl;
        boolean bl2 = graph != null;
        boolean bl3 = bl = graph2 != null;
        if (bl2 || bl) {
            for (DLClause dLClause : set2) {
                if (dLClause.getHeadLength() == 1 && dLClause.getBodyLength() == 1) {
                    DLPredicate dLPredicate;
                    DLPredicate dLPredicate2;
                    DLPredicate dLPredicate3 = dLClause.getHeadAtom(0).getDLPredicate();
                    DLPredicate dLPredicate4 = dLClause.getBodyAtom(0).getDLPredicate();
                    if (bl2 && dLPredicate3 instanceof AtomicConcept && dLPredicate4 instanceof AtomicConcept) {
                        dLPredicate2 = (AtomicConcept)dLPredicate3;
                        dLPredicate = (AtomicConcept)dLPredicate4;
                        if (set3.contains(dLPredicate2) && set3.contains(dLPredicate)) {
                            this.addKnownConceptSubsumption(graph, (AtomicConcept)dLPredicate, (AtomicConcept)dLPredicate2);
                        }
                    } else if (bl && dLPredicate3 instanceof AtomicRole && dLPredicate4 instanceof AtomicRole) {
                        dLPredicate2 = (AtomicRole)dLPredicate3;
                        dLPredicate = (AtomicRole)dLPredicate4;
                        if (set4.contains(dLPredicate2) && set4.contains(dLPredicate)) {
                            if (dLClause.getBodyAtom(0).getArgument(0) != dLClause.getHeadAtom(0).getArgument(0)) {
                                this.addKnownRoleSubsumption(graph2, InverseRole.create((AtomicRole)dLPredicate), (Role)((Object)dLPredicate2));
                            } else {
                                this.addKnownRoleSubsumption(graph2, (Role)((Object)dLPredicate), (Role)((Object)dLPredicate2));
                            }
                        }
                    }
                }
                this.m_interruptFlag.checkInterrupt();
            }
        }
    }

    protected Hierarchy<AtomicConcept> buildTransitivelyReducedConceptHierarchy(Graph<AtomicConcept> graph) {
        HashMap<AtomicConcept, DeterministicClassification.GraphNode<AtomicConcept>> hashMap = new HashMap<AtomicConcept, DeterministicClassification.GraphNode<AtomicConcept>>();
        for (AtomicConcept atomicConcept : graph.getElements()) {
            hashMap.put(atomicConcept, new DeterministicClassification.GraphNode<AtomicConcept>(atomicConcept, graph.getSuccessors(atomicConcept)));
        }
        this.m_interruptFlag.checkInterrupt();
        return DeterministicClassification.buildHierarchy(this.m_topConcept, this.m_bottomConcept, hashMap);
    }

    public void setToClassifiedConceptHierarchy(Hierarchy<AtomicConcept> hierarchy) {
        if (hierarchy != this.m_currentConceptHierarchy) {
            this.m_currentConceptHierarchy = hierarchy;
            if (this.m_classesInitialised && this.m_individuals.length > 0) {
                Object object;
                Set set2;
                Object object2;
                AtomicConcept atomicConcept;
                for (HierarchyNode<AtomicConcept> hierarchyNode : this.m_currentConceptHierarchy.getAllNodesSet()) {
                    if (hierarchyNode.m_representative == this.m_bottomConcept) continue;
                    atomicConcept = hierarchyNode.getRepresentative();
                    object2 = new HashSet();
                    set2 = null;
                    for (AtomicConcept atomicConcept2 : hierarchyNode.getEquivalentElements()) {
                        if (!this.m_conceptToElement.containsKey(atomicConcept2)) continue;
                        object = this.m_conceptToElement.get(atomicConcept2);
                        object2.addAll(((AtomicConceptElement)object).m_knownInstances);
                        if (set2 == null) {
                            set2 = new HashSet<Individual>(((AtomicConceptElement)object).m_possibleInstances);
                        } else {
                            set2.retainAll(((AtomicConceptElement)object).m_possibleInstances);
                        }
                        this.m_conceptToElement.remove(atomicConcept2);
                    }
                    if (set2 != null) {
                        set2.removeAll((Collection<?>)object2);
                    }
                    if (object2.isEmpty() && set2 == null && atomicConcept != this.m_topConcept) continue;
                    this.m_conceptToElement.put(atomicConcept, new AtomicConceptElement((Set<Individual>)object2, set2));
                }
                LinkedList linkedList = new LinkedList();
                linkedList.addAll(this.m_currentConceptHierarchy.m_bottomNode.m_parentNodes);
                while (!linkedList.isEmpty()) {
                    HierarchyNode hierarchyNode = (HierarchyNode)linkedList.remove();
                    atomicConcept = (AtomicConcept)hierarchyNode.getRepresentative();
                    object2 = this.m_conceptToElement.get(atomicConcept);
                    if (object2 != null) {
                        set2 = hierarchyNode.getAncestorNodes();
                        set2.remove(hierarchyNode);
                        for (HierarchyNode hierarchyNode2 : set2) {
                            object = (AtomicConcept)hierarchyNode2.getRepresentative();
                            AtomicConceptElement atomicConceptElement = this.m_conceptToElement.get(object);
                            if (atomicConceptElement == null) continue;
                            atomicConceptElement.m_knownInstances.removeAll(((AtomicConceptElement)object2).m_knownInstances);
                            atomicConceptElement.m_possibleInstances.removeAll(((AtomicConceptElement)object2).m_knownInstances);
                            atomicConceptElement.m_possibleInstances.removeAll(((AtomicConceptElement)object2).m_possibleInstances);
                        }
                        for (HierarchyNode hierarchyNode3 : hierarchyNode.getParentNodes()) {
                            if (linkedList.contains(hierarchyNode3)) continue;
                            linkedList.add(hierarchyNode3);
                        }
                    }
                    this.m_interruptFlag.checkInterrupt();
                }
            }
            this.m_usesClassifiedConceptHierarchy = true;
        }
    }

    protected Hierarchy<RoleElementManager.RoleElement> buildTransitivelyReducedRoleHierarchy(Graph<Role> graph) {
        HashMap<Role, DeterministicClassification.GraphNode<Role>> hashMap = new HashMap<Role, DeterministicClassification.GraphNode<Role>>();
        for (Role role : graph.getElements()) {
            hashMap.put(role, new DeterministicClassification.GraphNode<Role>(role, graph.getSuccessors(role)));
        }
        this.m_interruptFlag.checkInterrupt();
        return this.transformRoleHierarchy(DeterministicClassification.buildHierarchy(AtomicRole.TOP_OBJECT_ROLE, AtomicRole.BOTTOM_OBJECT_ROLE, hashMap));
    }

    protected Hierarchy<RoleElementManager.RoleElement> transformRoleHierarchy(Hierarchy<Role> hierarchy) {
        Hierarchy<AtomicRole> hierarchy2 = this.removeInverses(hierarchy);
        Hierarchy.Transformer<Role, RoleElementManager.RoleElement> transformer = new Hierarchy.Transformer<Role, RoleElementManager.RoleElement>(){

            @Override
            public RoleElementManager.RoleElement transform(Role role) {
                InstanceManager.this.m_interruptFlag.checkInterrupt();
                if (!(role instanceof AtomicRole)) {
                    throw new IllegalArgumentException("Internal error: The instance manager should only use atomic roles, but here we got a hierarchy element for an inverse role:" + role);
                }
                return InstanceManager.this.m_roleElementManager.getRoleElement((AtomicRole)role);
            }

            @Override
            public RoleElementManager.RoleElement determineRepresentative(Role role, Set<RoleElementManager.RoleElement> set2) {
                RoleElementManager.RoleElement roleElement = this.transform(role);
                for (RoleElementManager.RoleElement roleElement2 : set2) {
                    Set<Individual> set3;
                    if (roleElement2.equals(roleElement)) continue;
                    for (Individual individual : roleElement2.m_knownRelations.keySet()) {
                        set3 = roleElement.m_knownRelations.get(individual);
                        if (set3 == null) {
                            set3 = new HashSet<Individual>();
                            roleElement.m_knownRelations.put(individual, set3);
                        }
                        set3.addAll((Collection<Individual>)roleElement2.m_knownRelations.get(individual));
                    }
                    for (Individual individual : roleElement2.m_possibleRelations.keySet()) {
                        set3 = roleElement.m_possibleRelations.get(individual);
                        if (set3 == null) continue;
                        set3.retainAll((Collection)roleElement2.m_possibleRelations.get(individual));
                    }
                    roleElement2.m_knownRelations.clear();
                    roleElement2.m_possibleRelations.clear();
                }
                InstanceManager.this.m_interruptFlag.checkInterrupt();
                return roleElement;
            }
        };
        return hierarchy2.transform(transformer, null);
    }

    protected Hierarchy<AtomicRole> removeInverses(Hierarchy<Role> hierarchy) {
        Object object;
        HashMap<Object, DeterministicClassification.GraphNode<AtomicRole>> hashMap = new HashMap<Object, DeterministicClassification.GraphNode<AtomicRole>>();
        HashSet<AtomicRole> hashSet = new HashSet<AtomicRole>();
        HashSet<AtomicRole> hashSet2 = new HashSet<AtomicRole>();
        hashSet.add(this.m_bottomRoleElement.m_role);
        while (!hashSet.isEmpty()) {
            object = (AtomicRole)hashSet.iterator().next();
            hashSet2.add((AtomicRole)object);
            HierarchyNode<Role> hierarchyNode = hierarchy.getNodeForElement((Role)object);
            Serializable serializable = new HashSet<AtomicRole>();
            this.findNextHierarchyNodeWithAtomic((Set<AtomicRole>)((Object)serializable), hierarchyNode);
            hashMap.put(object, new DeterministicClassification.GraphNode<AtomicRole>((AtomicRole)object, (Set<AtomicRole>)((Object)serializable)));
            hashSet.addAll((Collection<AtomicRole>)((Object)serializable));
            hashSet.removeAll(hashSet2);
            this.m_interruptFlag.checkInterrupt();
        }
        object = DeterministicClassification.buildHierarchy(this.m_topRoleElement.m_role, this.m_bottomRoleElement.m_role, hashMap);
        for (Serializable serializable : ((Hierarchy)object).m_nodesByElements.keySet()) {
            HierarchyNode<HashSet<AtomicRole>> hierarchyNode = hierarchy.getNodeForElement((Role)serializable);
            HierarchyNode<HashSet<AtomicRole>> hierarchyNode2 = ((Hierarchy)object).getNodeForElement(serializable);
            for (Role role : hierarchyNode.m_equivalentElements) {
                if (!(role instanceof AtomicRole)) continue;
                hierarchyNode2.m_equivalentElements.add((AtomicRole)role);
            }
            this.m_interruptFlag.checkInterrupt();
        }
        return object;
    }

    public void setToClassifiedRoleHierarchy(Hierarchy<Role> hierarchy) {
        this.m_currentRoleHierarchy = this.transformRoleHierarchy(hierarchy);
        if (this.m_propertiesInitialised && this.m_individuals.length > 0) {
            LinkedList linkedList = new LinkedList();
            linkedList.add(this.m_currentRoleHierarchy.m_bottomNode);
            while (!linkedList.isEmpty()) {
                HierarchyNode hierarchyNode = (HierarchyNode)linkedList.remove();
                RoleElementManager.RoleElement roleElement = (RoleElementManager.RoleElement)hierarchyNode.getRepresentative();
                Set set2 = hierarchyNode.getAncestorNodes();
                set2.remove(hierarchyNode);
                for (HierarchyNode hierarchyNode2 : set2) {
                    Set<Individual> set3;
                    RoleElementManager.RoleElement roleElement2 = (RoleElementManager.RoleElement)hierarchyNode2.m_representative;
                    Map<Individual, Set<Individual>> map2 = roleElement2.m_knownRelations;
                    Map<Individual, Set<Individual>> map3 = roleElement2.m_possibleRelations;
                    for (Individual individual : roleElement.m_knownRelations.keySet()) {
                        set3 = map2.get(individual);
                        if (set3 != null) {
                            set3.removeAll((Collection)roleElement.m_knownRelations.get(individual));
                            if (set3.isEmpty()) {
                                map2.remove(individual);
                            }
                        }
                        if ((set3 = map3.get(individual)) == null) continue;
                        set3.removeAll((Collection)roleElement.m_knownRelations.get(individual));
                        if (!set3.isEmpty()) continue;
                        map3.remove(individual);
                    }
                    for (Individual individual : roleElement.m_possibleRelations.keySet()) {
                        set3 = map3.get(individual);
                        if (set3 == null) continue;
                        set3.removeAll((Collection)roleElement.m_possibleRelations.get(individual));
                        if (!set3.isEmpty()) continue;
                        map3.remove(individual);
                    }
                }
                for (HierarchyNode hierarchyNode2 : hierarchyNode.getParentNodes()) {
                    if (linkedList.contains(hierarchyNode2)) continue;
                    linkedList.add(hierarchyNode2);
                }
                this.m_interruptFlag.checkInterrupt();
            }
        }
        this.m_usesClassifiedObjectRoleHierarchy = true;
    }

    protected void findNextHierarchyNodeWithAtomic(Set<AtomicRole> set2, HierarchyNode<Role> hierarchyNode) {
        for (HierarchyNode<Role> hierarchyNode2 : hierarchyNode.getParentNodes()) {
            HashSet<AtomicRole> hashSet = new HashSet<AtomicRole>();
            for (Role role : hierarchyNode2.getEquivalentElements()) {
                if (!(role instanceof AtomicRole)) continue;
                hashSet.add((AtomicRole)role);
            }
            if (!hashSet.isEmpty()) {
                set2.add((AtomicRole)hashSet.iterator().next());
                continue;
            }
            if (hierarchyNode2 == hierarchyNode) continue;
            this.findNextHierarchyNodeWithAtomic(set2, hierarchyNode2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OWLAxiom[] getAxiomsForReadingOffCompexProperties(OWLDataFactory oWLDataFactory, ReasonerProgressMonitor reasonerProgressMonitor, int n, int n2) {
        if (this.m_complexRoles.size() > 0) {
            Object object;
            int n3 = 0;
            ArrayList<OWLClassAssertionAxiom> arrayList = new ArrayList<OWLClassAssertionAxiom>();
            this.m_interruptFlag.startTask();
            try {
                while (this.m_currentIndividualIndex < this.m_individuals.length && n3 < 10000) {
                    object = this.m_individuals[this.m_currentIndividualIndex];
                    for (AtomicRole atomicRole : this.m_complexRoles) {
                        ++n;
                        if (reasonerProgressMonitor != null) {
                            reasonerProgressMonitor.reasonerTaskProgressChanged(n, n2);
                        }
                        OWLObjectProperty oWLObjectProperty = oWLDataFactory.getOWLObjectProperty(IRI.create(atomicRole.getIRI()));
                        String string2 = ((Individual)object).getIRI();
                        OWLClass oWLClass = oWLDataFactory.getOWLClass(IRI.create("internal:individual-concept#" + string2));
                        OWLLogicalAxiom oWLLogicalAxiom = oWLDataFactory.getOWLClassAssertionAxiom(oWLClass, oWLDataFactory.getOWLNamedIndividual(IRI.create(string2)));
                        arrayList.add((OWLClassAssertionAxiom)oWLLogicalAxiom);
                        AtomicConcept atomicConcept = AtomicConcept.create("internal:individual-concept#" + atomicRole.getIRI() + "#" + string2);
                        OWLClass oWLClass2 = oWLDataFactory.getOWLClass(IRI.create(atomicConcept.getIRI()));
                        oWLLogicalAxiom = oWLDataFactory.getOWLSubClassOfAxiom(oWLClass, oWLDataFactory.getOWLObjectAllValuesFrom(oWLObjectProperty, oWLClass2));
                        arrayList.add((OWLClassAssertionAxiom)oWLLogicalAxiom);
                        n3 += 2;
                        this.m_interruptFlag.checkInterrupt();
                    }
                    ++this.m_currentIndividualIndex;
                }
            }
            finally {
                this.m_interruptFlag.endTask();
            }
            object = new OWLAxiom[arrayList.size()];
            return arrayList.toArray((T[])object);
        }
        this.m_currentIndividualIndex = this.m_individuals.length - 1;
        return new OWLAxiom[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeKnowAndPossibleClassInstances(Tableau tableau, ReasonerProgressMonitor reasonerProgressMonitor, int n, int n2) {
        if (!this.m_classesInitialised) {
            this.m_interruptFlag.startTask();
            try {
                this.initializeIndividualsForNodes();
                if (!this.m_propertiesInitialised) {
                    this.initializeSameAs();
                }
                n = this.readOffClassInstancesByIndividual(tableau, reasonerProgressMonitor, n, n2);
                if (!this.m_readingOffFoundPossibleConceptInstance && this.m_usesClassifiedConceptHierarchy) {
                    this.m_realizationCompleted = true;
                }
                this.m_classesInitialised = true;
                this.m_individualsForNodes.clear();
                this.m_canonicalNodeToDetMergedNodes.clear();
                this.m_canonicalNodeToNonDetMergedNodes.clear();
            }
            finally {
                this.m_interruptFlag.endTask();
            }
        }
    }

    protected int readOffClassInstancesByIndividual(Tableau tableau, ReasonerProgressMonitor reasonerProgressMonitor, int n, int n2) {
        for (Individual individual : this.m_individuals) {
            Node node2 = this.m_nodesForIndividuals.get(individual);
            boolean bl = this.readOffTypes(individual, node2);
            if (!bl) {
                AtomicConceptElement atomicConceptElement = this.m_conceptToElement.get(this.m_topConcept);
                if (atomicConceptElement == null) {
                    atomicConceptElement = new AtomicConceptElement(null, null);
                    this.m_conceptToElement.put(this.m_topConcept, atomicConceptElement);
                }
                atomicConceptElement.m_knownInstances.add(individual);
            }
            ++n;
            if (reasonerProgressMonitor != null) {
                reasonerProgressMonitor.reasonerTaskProgressChanged(n, n2);
            }
            this.m_interruptFlag.checkInterrupt();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int initializeKnowAndPossiblePropertyInstances(Tableau tableau, ReasonerProgressMonitor reasonerProgressMonitor, int n, int n2, int n3) {
        if (!this.m_propertiesInitialised) {
            this.m_interruptFlag.startTask();
            try {
                this.initializeIndividualsForNodes();
                if (!this.m_classesInitialised) {
                    this.initializeSameAs();
                }
                n2 = this.readOffPropertyInstancesByIndividual(tableau, this.m_individualsForNodes, reasonerProgressMonitor, n2, n3, n);
                if (this.m_currentIndividualIndex >= this.m_individuals.length - 1) {
                    if (!this.m_readingOffFoundPossiblePropertyInstance) {
                        this.m_roleRealizationCompleted = true;
                    }
                    this.m_propertiesInitialised = true;
                }
                this.m_individualsForNodes.clear();
            }
            finally {
                this.m_interruptFlag.endTask();
            }
        }
        return n2;
    }

    protected int readOffPropertyInstancesByIndividual(Tableau tableau, Map<Node, Individual> map2, ReasonerProgressMonitor reasonerProgressMonitor, int n, int n2, int n3) {
        int n4 = n3 == 0 ? this.m_individuals.length : this.m_currentIndividualIndex;
        for (int i = n3; i < n4; ++i) {
            Individual individual = this.m_individuals[i];
            Node node2 = this.m_nodesForIndividuals.get(individual);
            if (n3 == 0) {
                if (!node2.isMerged()) {
                    this.readOffPropertyInstances(node2);
                }
                ++n;
                if (reasonerProgressMonitor != null) {
                    reasonerProgressMonitor.reasonerTaskProgressChanged(n, n2);
                }
            }
            if (i < this.m_currentIndividualIndex) {
                n = this.readOffComplexRoleSuccessors(individual, node2, reasonerProgressMonitor, n, n2);
            }
            this.m_interruptFlag.checkInterrupt();
        }
        return n;
    }

    protected void initializeIndividualsForNodes() {
        for (Individual individual : this.m_individuals) {
            Node node2 = this.m_nodesForIndividuals.get(individual);
            this.m_individualsForNodes.put(node2, individual);
            if (node2.isMerged()) {
                Set<Node> set2;
                Node node3 = node2.getCanonicalNode();
                if (node2.getCanonicalNodeDependencySet() == null) {
                    set2 = this.m_canonicalNodeToDetMergedNodes.get(node3);
                    if (set2 == null) {
                        set2 = new HashSet<Node>();
                        this.m_canonicalNodeToDetMergedNodes.put(node3, set2);
                    }
                    set2.add(node2);
                } else {
                    set2 = this.m_canonicalNodeToNonDetMergedNodes.get(node3);
                    if (set2 == null) {
                        set2 = new HashSet<Node>();
                        this.m_canonicalNodeToNonDetMergedNodes.put(node3, set2);
                    }
                    set2.add(node2);
                }
            }
            this.m_interruptFlag.checkInterrupt();
        }
    }

    protected void initializeSameAs() {
        this.m_individualToPossibleEquivalenceClass = new HashMap<Set<Individual>, Set<Set<Individual>>>();
        for (Node node2 : this.m_individualsForNodes.keySet()) {
            Node node3 = node2.getMergedInto();
            if (node3 != null) {
                Individual individual = this.m_individualsForNodes.get(node2);
                Individual individual2 = this.m_individualsForNodes.get(node3);
                Set<Individual> set2 = this.m_individualToEquivalenceClass.get(individual);
                Set<Individual> set3 = this.m_individualToEquivalenceClass.get(individual2);
                if (node2.getMergedIntoDependencySet().isEmpty()) {
                    set2.addAll(set3);
                    this.m_individualToEquivalenceClass.put(individual2, set2);
                } else {
                    Set<Set<Individual>> set4 = this.m_individualToPossibleEquivalenceClass.get(set2);
                    if (set4 == null) {
                        set4 = new HashSet<Set<Individual>>();
                        this.m_individualToPossibleEquivalenceClass.put(set2, set4);
                    }
                    set4.add(set3);
                }
            }
            this.m_interruptFlag.checkInterrupt();
        }
    }

    protected boolean readOffTypes(Individual individual, Node node2) {
        boolean bl = false;
        this.m_binaryRetrieval1Bound.getBindingsBuffer()[1] = node2.getCanonicalNode();
        this.m_binaryRetrieval1Bound.open();
        Object[] objectArray = this.m_binaryRetrieval1Bound.getTupleBuffer();
        while (!this.m_binaryRetrieval1Bound.afterLast()) {
            AtomicConcept atomicConcept;
            Object object = objectArray[0];
            if (object instanceof AtomicConcept && !(atomicConcept = (AtomicConcept)object).equals(this.m_topConcept) && !Prefixes.isInternalIRI(atomicConcept.getIRI())) {
                HierarchyNode<AtomicConcept> hierarchyNode = this.m_currentConceptHierarchy.getNodeForElement(atomicConcept);
                AtomicConcept atomicConcept2 = hierarchyNode.getRepresentative();
                AtomicConceptElement atomicConceptElement = this.m_conceptToElement.get(atomicConcept2);
                if (atomicConceptElement == null) {
                    atomicConceptElement = new AtomicConceptElement(null, null);
                    this.m_conceptToElement.put(atomicConcept2, atomicConceptElement);
                }
                bl = true;
                if (this.m_binaryRetrieval1Bound.getDependencySet().isEmpty()) {
                    this.addKnownConceptInstance(hierarchyNode, atomicConceptElement, individual);
                } else {
                    this.addPossibleConceptInstance(hierarchyNode, atomicConceptElement, individual);
                    this.m_readingOffFoundPossibleConceptInstance = true;
                }
            }
            this.m_interruptFlag.checkInterrupt();
            this.m_binaryRetrieval1Bound.next();
        }
        return bl;
    }

    protected void readOffPropertyInstances(Node node2) {
        this.m_ternaryRetrieval1Bound.getBindingsBuffer()[1] = node2;
        this.m_ternaryRetrieval1Bound.open();
        Object[] objectArray = this.m_ternaryRetrieval1Bound.getTupleBuffer();
        while (!this.m_ternaryRetrieval1Bound.afterLast()) {
            AtomicRole atomicRole;
            Object object = objectArray[0];
            Node node3 = (Node)objectArray[2];
            if (object instanceof AtomicRole && !node3.isMerged() && node3.getNodeType() == NodeType.NAMED_NODE && this.m_individualsForNodes.containsKey(node3) && node3.isActive() && !(atomicRole = (AtomicRole)object).equals(AtomicRole.TOP_OBJECT_ROLE) && this.m_roleElementManager.m_roleToElement.containsKey(atomicRole)) {
                Individual individual;
                Individual individual2;
                Set<Node> set2;
                RoleElementManager.RoleElement roleElement = this.m_currentRoleHierarchy.getNodeForElement(this.m_roleElementManager.getRoleElement(atomicRole)).getRepresentative();
                Set<Node> set3 = this.m_canonicalNodeToDetMergedNodes.get(node2);
                if (set3 == null) {
                    set3 = new HashSet<Node>();
                }
                set3.add(node2);
                Set<Node> set4 = this.m_canonicalNodeToNonDetMergedNodes.get(node2);
                if (set4 == null) {
                    set4 = new HashSet<Node>();
                }
                if ((set2 = this.m_canonicalNodeToDetMergedNodes.get(node3)) == null) {
                    set2 = new HashSet<Node>();
                }
                set2.add(node3);
                Set<Node> set5 = this.m_canonicalNodeToNonDetMergedNodes.get(node3);
                if (set5 == null) {
                    set5 = new HashSet<Node>();
                }
                for (Node node4 : set3) {
                    individual2 = this.m_individualsForNodes.get(node4);
                    for (Node node5 : set2) {
                        individual = this.m_individualsForNodes.get(node5);
                        if (this.m_ternaryRetrieval1Bound.getDependencySet().isEmpty()) {
                            this.addKnownRoleInstance(roleElement, individual2, individual);
                            continue;
                        }
                        this.m_readingOffFoundPossiblePropertyInstance = true;
                        this.addPossibleRoleInstance(roleElement, individual2, individual);
                    }
                    for (Node node5 : set5) {
                        individual = this.m_individualsForNodes.get(node5);
                        this.m_readingOffFoundPossiblePropertyInstance = true;
                        this.addPossibleRoleInstance(roleElement, individual2, individual);
                    }
                }
                for (Node node4 : set4) {
                    individual2 = this.m_individualsForNodes.get(node4);
                    set5.addAll(set2);
                    for (Node node5 : set5) {
                        individual = this.m_individualsForNodes.get(node5);
                        this.m_readingOffFoundPossiblePropertyInstance = true;
                        this.addPossibleRoleInstance(roleElement, individual2, individual);
                    }
                }
            }
            this.m_interruptFlag.checkInterrupt();
            this.m_ternaryRetrieval1Bound.next();
        }
    }

    protected int readOffComplexRoleSuccessors(Individual individual, Node node2, ReasonerProgressMonitor reasonerProgressMonitor, int n, int n2) {
        String string2 = individual.getIRI();
        for (AtomicRole atomicRole : this.m_complexRoles) {
            AtomicConcept atomicConcept = AtomicConcept.create("internal:individual-concept#" + atomicRole.getIRI() + "#" + string2);
            this.m_binaryRetrieval0Bound.getBindingsBuffer()[0] = atomicConcept;
            this.m_binaryRetrieval0Bound.open();
            Object[] objectArray = this.m_binaryRetrieval0Bound.getTupleBuffer();
            while (!this.m_binaryRetrieval0Bound.afterLast()) {
                Node node3 = (Node)objectArray[1];
                if (node3.isActive() && node3.getNodeType() == NodeType.NAMED_NODE && this.m_individualsForNodes.containsKey(node3)) {
                    Individual individual2;
                    RoleElementManager.RoleElement roleElement = this.m_currentRoleHierarchy.getNodeForElement(this.m_roleElementManager.getRoleElement(atomicRole)).getRepresentative();
                    Set<Node> set2 = this.m_canonicalNodeToDetMergedNodes.get(node3);
                    if (set2 == null) {
                        set2 = new HashSet<Node>();
                    }
                    set2.add(node3);
                    Set<Node> set3 = this.m_canonicalNodeToNonDetMergedNodes.get(node3);
                    if (set3 == null) {
                        set3 = new HashSet<Node>();
                    }
                    for (Node node4 : set2) {
                        individual2 = this.m_individualsForNodes.get(node4);
                        if (this.m_binaryRetrieval0Bound.getDependencySet().isEmpty()) {
                            this.addKnownRoleInstance(roleElement, individual, individual2);
                            continue;
                        }
                        this.m_readingOffFoundPossiblePropertyInstance = true;
                        this.addPossibleRoleInstance(roleElement, individual, individual2);
                    }
                    for (Node node4 : set3) {
                        individual2 = this.m_individualsForNodes.get(node4);
                        this.m_readingOffFoundPossiblePropertyInstance = true;
                        this.addPossibleRoleInstance(roleElement, individual, individual2);
                    }
                }
                this.m_interruptFlag.checkInterrupt();
                this.m_binaryRetrieval0Bound.next();
            }
            ++n;
            if (reasonerProgressMonitor == null) continue;
            reasonerProgressMonitor.reasonerTaskProgressChanged(n, n2);
        }
        return n;
    }

    protected void addKnownConceptInstance(HierarchyNode<AtomicConcept> hierarchyNode, AtomicConceptElement atomicConceptElement, Individual individual) {
        AtomicConceptElement atomicConceptElement2;
        Set<HierarchyNode<AtomicConcept>> set2 = hierarchyNode.getDescendantNodes();
        for (HierarchyNode<AtomicConcept> hierarchyNode2 : set2) {
            atomicConceptElement2 = this.m_conceptToElement.get(hierarchyNode2.getRepresentative());
            if (atomicConceptElement2 != null && atomicConceptElement2.m_knownInstances.contains(individual)) {
                return;
            }
            this.m_interruptFlag.checkInterrupt();
        }
        atomicConceptElement.m_knownInstances.add(individual);
        set2 = hierarchyNode.getAncestorNodes();
        set2.remove(hierarchyNode);
        for (HierarchyNode<AtomicConcept> hierarchyNode2 : set2) {
            atomicConceptElement2 = this.m_conceptToElement.get(hierarchyNode2.getRepresentative());
            if (atomicConceptElement2 == null) continue;
            atomicConceptElement2.m_knownInstances.remove(individual);
            atomicConceptElement2.m_possibleInstances.remove(individual);
        }
    }

    protected void addPossibleConceptInstance(HierarchyNode<AtomicConcept> hierarchyNode, AtomicConceptElement atomicConceptElement, Individual individual) {
        AtomicConceptElement atomicConceptElement2;
        Set<HierarchyNode<AtomicConcept>> set2 = hierarchyNode.getDescendantNodes();
        for (HierarchyNode<AtomicConcept> hierarchyNode2 : set2) {
            atomicConceptElement2 = this.m_conceptToElement.get(hierarchyNode2.getRepresentative());
            if (atomicConceptElement2 != null && (atomicConceptElement2.m_knownInstances.contains(individual) || atomicConceptElement2.m_possibleInstances.contains(individual))) {
                return;
            }
            this.m_interruptFlag.checkInterrupt();
        }
        atomicConceptElement.m_possibleInstances.add(individual);
        set2 = hierarchyNode.getAncestorNodes();
        set2.remove(hierarchyNode);
        for (HierarchyNode<AtomicConcept> hierarchyNode2 : set2) {
            atomicConceptElement2 = this.m_conceptToElement.get(hierarchyNode2.getRepresentative());
            if (atomicConceptElement2 != null) {
                atomicConceptElement2.m_possibleInstances.remove(individual);
                if (atomicConceptElement2.m_possibleInstances.isEmpty() && atomicConceptElement2.m_knownInstances.isEmpty() && hierarchyNode2.getRepresentative() != this.m_topConcept) {
                    this.m_conceptToElement.remove(hierarchyNode2.getRepresentative());
                }
            }
            this.m_interruptFlag.checkInterrupt();
        }
    }

    protected void addKnownRoleInstance(RoleElementManager.RoleElement roleElement, Individual individual, Individual individual2) {
        if (!roleElement.equals(this.m_topRoleElement)) {
            HierarchyNode<RoleElementManager.RoleElement> hierarchyNode = this.m_currentRoleHierarchy.getNodeForElement(roleElement);
            Set<HierarchyNode<RoleElementManager.RoleElement>> set2 = hierarchyNode.getDescendantNodes();
            for (HierarchyNode<RoleElementManager.RoleElement> hierarchyNode2 : set2) {
                for (RoleElementManager.RoleElement roleElement2 : hierarchyNode2.getEquivalentElements()) {
                    if (!roleElement2.isKnown(individual, individual2)) continue;
                    return;
                }
                this.m_interruptFlag.checkInterrupt();
            }
            roleElement.addKnown(individual, individual2);
            set2 = hierarchyNode.getAncestorNodes();
            set2.remove(hierarchyNode);
            for (HierarchyNode<RoleElementManager.RoleElement> hierarchyNode2 : set2) {
                hierarchyNode2.getRepresentative().removeKnown(individual, individual2);
                this.m_interruptFlag.checkInterrupt();
            }
        }
    }

    protected void addPossibleRoleInstance(RoleElementManager.RoleElement roleElement, Individual individual, Individual individual2) {
        if (!roleElement.equals(this.m_topRoleElement)) {
            HierarchyNode<RoleElementManager.RoleElement> hierarchyNode = this.m_currentRoleHierarchy.getNodeForElement(roleElement);
            Set<HierarchyNode<RoleElementManager.RoleElement>> set2 = hierarchyNode.getDescendantNodes();
            for (HierarchyNode<RoleElementManager.RoleElement> hierarchyNode2 : set2) {
                for (RoleElementManager.RoleElement roleElement2 : hierarchyNode2.getEquivalentElements()) {
                    if (!roleElement2.isPossible(individual, individual2)) continue;
                    return;
                }
                this.m_interruptFlag.checkInterrupt();
            }
            roleElement.addPossible(individual, individual2);
            set2 = hierarchyNode.getAncestorNodes();
            set2.remove(hierarchyNode);
            for (HierarchyNode<RoleElementManager.RoleElement> hierarchyNode2 : set2) {
                for (RoleElementManager.RoleElement roleElement2 : hierarchyNode2.getEquivalentElements()) {
                    if (!roleElement2.isPossible(individual, individual2)) continue;
                    roleElement2.removePossible(individual, individual2);
                }
                this.m_interruptFlag.checkInterrupt();
            }
        }
    }

    public void setInconsistent() {
        this.m_isInconsistent = true;
        this.m_realizationCompleted = true;
        this.m_roleRealizationCompleted = true;
        this.m_usesClassifiedConceptHierarchy = true;
        this.m_usesClassifiedObjectRoleHierarchy = true;
        this.m_currentConceptHierarchy = null;
        this.m_currentRoleHierarchy = null;
    }

    public void realize(ReasonerProgressMonitor reasonerProgressMonitor) {
        assert (this.m_usesClassifiedConceptHierarchy);
        if (this.m_readingOffFoundPossibleConceptInstance && !this.m_realizationCompleted) {
            if (reasonerProgressMonitor != null) {
                reasonerProgressMonitor.reasonerTaskStarted("Computing instances for all classes");
            }
            int n = this.m_currentConceptHierarchy.m_nodesByElements.values().size();
            int n2 = 0;
            LinkedList linkedList = new LinkedList();
            HashSet<HierarchyNode> hashSet = new HashSet<HierarchyNode>();
            linkedList.addAll(this.m_currentConceptHierarchy.m_bottomNode.m_parentNodes);
            while (!linkedList.isEmpty()) {
                if (reasonerProgressMonitor != null) {
                    reasonerProgressMonitor.reasonerTaskProgressChanged(n2, n);
                }
                HierarchyNode hierarchyNode = (HierarchyNode)linkedList.remove();
                hashSet.add(hierarchyNode);
                ++n2;
                AtomicConcept atomicConcept = (AtomicConcept)hierarchyNode.getRepresentative();
                AtomicConceptElement atomicConceptElement = this.m_conceptToElement.get(atomicConcept);
                if (atomicConceptElement != null) {
                    Set set2 = hierarchyNode.getParentNodes();
                    for (HierarchyNode hierarchyNode2 : set2) {
                        if (hashSet.contains(hierarchyNode2) || linkedList.contains(hierarchyNode2)) continue;
                        linkedList.add(hierarchyNode2);
                    }
                    if (atomicConceptElement.hasPossibles()) {
                        HashSet hashSet2 = new HashSet();
                        for (Individual individual : atomicConceptElement.getPossibleInstances()) {
                            if (this.isInstance(individual, atomicConcept)) {
                                atomicConceptElement.m_knownInstances.add(individual);
                                continue;
                            }
                            hashSet2.add(individual);
                        }
                        atomicConceptElement.m_possibleInstances.clear();
                        for (HierarchyNode hierarchyNode3 : set2) {
                            AtomicConcept atomicConcept2 = (AtomicConcept)hierarchyNode3.getRepresentative();
                            AtomicConceptElement atomicConceptElement2 = this.m_conceptToElement.get(atomicConcept2);
                            if (atomicConceptElement2 == null) {
                                atomicConceptElement2 = new AtomicConceptElement(null, hashSet2);
                                this.m_conceptToElement.put(atomicConcept2, atomicConceptElement2);
                                continue;
                            }
                            if (atomicConcept2.equals(this.m_topConcept)) {
                                this.m_conceptToElement.get((Object)this.m_topConcept).m_knownInstances.addAll(hashSet2);
                                continue;
                            }
                            atomicConceptElement2.addPossibles(hashSet2);
                        }
                    }
                }
                this.m_interruptFlag.checkInterrupt();
            }
            if (reasonerProgressMonitor != null) {
                reasonerProgressMonitor.reasonerTaskStopped();
            }
        }
        this.m_realizationCompleted = true;
    }

    public void realizeObjectRoles(ReasonerProgressMonitor reasonerProgressMonitor) {
        if (this.m_readingOffFoundPossiblePropertyInstance && !this.m_roleRealizationCompleted) {
            if (reasonerProgressMonitor != null) {
                reasonerProgressMonitor.reasonerTaskStarted("Computing instances for all object properties...");
            }
            int n = this.m_currentRoleHierarchy.m_nodesByElements.values().size();
            int n2 = 0;
            LinkedList linkedList = new LinkedList();
            HashSet<HierarchyNode> hashSet = new HashSet<HierarchyNode>();
            linkedList.add(this.m_currentRoleHierarchy.m_bottomNode);
            while (!linkedList.isEmpty()) {
                if (reasonerProgressMonitor != null) {
                    reasonerProgressMonitor.reasonerTaskProgressChanged(n2, n);
                }
                HierarchyNode hierarchyNode = (HierarchyNode)linkedList.remove();
                hashSet.add(hierarchyNode);
                ++n2;
                RoleElementManager.RoleElement roleElement = (RoleElementManager.RoleElement)hierarchyNode.getRepresentative();
                AtomicRole atomicRole = roleElement.getRole();
                Set set2 = hierarchyNode.getParentNodes();
                for (HierarchyNode hierarchyNode2 : set2) {
                    if (linkedList.contains(hierarchyNode2) || hashSet.contains(hierarchyNode2)) continue;
                    linkedList.add(hierarchyNode2);
                }
                if (roleElement.hasPossibles()) {
                    for (Individual individual : roleElement.m_possibleRelations.keySet()) {
                        HashSet<Individual> hashSet2 = new HashSet<Individual>();
                        for (Individual individual2 : roleElement.m_possibleRelations.get(individual)) {
                            if (this.isRoleInstance(atomicRole, individual, individual2)) {
                                roleElement.addKnown(individual, individual2);
                                continue;
                            }
                            hashSet2.add(individual);
                        }
                        for (HierarchyNode hierarchyNode3 : set2) {
                            RoleElementManager.RoleElement roleElement2 = (RoleElementManager.RoleElement)hierarchyNode3.getRepresentative();
                            if (roleElement2.equals(this.m_topRoleElement)) continue;
                            roleElement2.addPossibles(individual, hashSet2);
                        }
                    }
                    roleElement.m_possibleRelations.clear();
                }
                this.m_interruptFlag.checkInterrupt();
            }
            if (reasonerProgressMonitor != null) {
                reasonerProgressMonitor.reasonerTaskStopped();
            }
        }
        this.m_roleRealizationCompleted = true;
    }

    public Set<HierarchyNode<AtomicConcept>> getTypes(Individual individual, boolean bl) {
        if (this.m_isInconsistent) {
            return Collections.singleton(this.m_currentConceptHierarchy.m_bottomNode);
        }
        HashSet<HierarchyNode<AtomicConcept>> hashSet = new HashSet<HierarchyNode<AtomicConcept>>();
        assert (!bl || this.m_usesClassifiedConceptHierarchy);
        LinkedList linkedList = new LinkedList();
        linkedList.add(this.m_currentConceptHierarchy.m_bottomNode);
        while (!linkedList.isEmpty()) {
            HierarchyNode hierarchyNode = (HierarchyNode)linkedList.remove();
            Set set2 = hierarchyNode.getParentNodes();
            AtomicConcept atomicConcept = (AtomicConcept)hierarchyNode.getRepresentative();
            AtomicConceptElement atomicConceptElement = this.m_conceptToElement.get(atomicConcept);
            if (atomicConceptElement != null && atomicConceptElement.isPossible(individual)) {
                if (this.isInstance(individual, atomicConcept)) {
                    atomicConceptElement.setToKnown(individual);
                } else {
                    for (HierarchyNode hierarchyNode2 : set2) {
                        AtomicConcept atomicConcept2 = (AtomicConcept)hierarchyNode2.getRepresentative();
                        AtomicConceptElement atomicConceptElement2 = this.m_conceptToElement.get(atomicConcept2);
                        if (atomicConceptElement2 == null) {
                            atomicConceptElement2 = new AtomicConceptElement(null, null);
                            this.m_conceptToElement.put(atomicConcept2, atomicConceptElement2);
                        }
                        atomicConceptElement2.addPossible(individual);
                    }
                }
            }
            if (atomicConceptElement != null && atomicConceptElement.isKnown(individual)) {
                if (bl) {
                    hashSet.add(hierarchyNode);
                    continue;
                }
                hashSet.addAll(hierarchyNode.getAncestorNodes());
                continue;
            }
            for (HierarchyNode hierarchyNode2 : set2) {
                if (linkedList.contains(hierarchyNode2)) continue;
                linkedList.add(hierarchyNode2);
            }
        }
        return hashSet;
    }

    public boolean hasType(Individual individual, AtomicConcept atomicConcept, boolean bl) {
        HierarchyNode<AtomicConcept> hierarchyNode = this.m_currentConceptHierarchy.getNodeForElement(atomicConcept);
        if (hierarchyNode == null) {
            return false;
        }
        return this.hasType(individual, hierarchyNode, bl);
    }

    public boolean hasType(Individual individual, HierarchyNode<AtomicConcept> hierarchyNode, boolean bl) {
        block9: {
            block8: {
                assert (!bl || this.m_usesClassifiedConceptHierarchy);
                AtomicConcept atomicConcept = hierarchyNode.getRepresentative();
                if (atomicConcept == this.m_bottomConcept) {
                    return false;
                }
                AtomicConceptElement atomicConceptElement = this.m_conceptToElement.get(atomicConcept);
                if (atomicConceptElement != null && atomicConceptElement.isKnown(individual) || !bl && hierarchyNode == this.m_currentConceptHierarchy.m_topNode) {
                    return true;
                }
                if (atomicConceptElement == null || !atomicConceptElement.isPossible(individual)) break block8;
                if (this.isInstance(individual, atomicConcept)) {
                    atomicConceptElement.setToKnown(individual);
                    return true;
                }
                atomicConceptElement.m_possibleInstances.remove(individual);
                if (atomicConceptElement.m_knownInstances.isEmpty() && atomicConceptElement.m_possibleInstances.isEmpty() && atomicConcept != this.m_topConcept) {
                    this.m_conceptToElement.remove(atomicConcept);
                }
                for (HierarchyNode<AtomicConcept> hierarchyNode2 : hierarchyNode.getParentNodes()) {
                    AtomicConcept atomicConcept2 = hierarchyNode2.getRepresentative();
                    AtomicConceptElement atomicConceptElement2 = this.m_conceptToElement.get(atomicConcept2);
                    if (atomicConceptElement2 == null) {
                        atomicConceptElement2 = new AtomicConceptElement(null, null);
                        this.m_conceptToElement.put(atomicConcept2, atomicConceptElement2);
                    }
                    atomicConceptElement2.addPossible(individual);
                }
                break block9;
            }
            if (bl) break block9;
            for (HierarchyNode<AtomicConcept> hierarchyNode3 : hierarchyNode.getChildNodes()) {
                if (!this.hasType(individual, hierarchyNode3, false)) continue;
                return true;
            }
        }
        return false;
    }

    public Set<Individual> getInstances(AtomicConcept atomicConcept, boolean bl) {
        HashSet<Individual> hashSet = new HashSet<Individual>();
        HierarchyNode<AtomicConcept> hierarchyNode = this.m_currentConceptHierarchy.getNodeForElement(atomicConcept);
        if (hierarchyNode == null) {
            return hashSet;
        }
        this.getInstancesForNode(hierarchyNode, hashSet, bl);
        return hashSet;
    }

    public Set<Individual> getInstances(HierarchyNode<AtomicConcept> hierarchyNode, boolean bl) {
        HashSet<Individual> hashSet = new HashSet<Individual>();
        HierarchyNode<AtomicConcept> hierarchyNode2 = this.m_currentConceptHierarchy.getNodeForElement((AtomicConcept)hierarchyNode.m_representative);
        if (hierarchyNode2 == null) {
            if (!bl) {
                for (HierarchyNode<AtomicConcept> hierarchyNode3 : hierarchyNode.getChildNodes()) {
                    this.getInstancesForNode(hierarchyNode3, hashSet, bl);
                }
            }
        } else {
            this.getInstancesForNode(hierarchyNode2, hashSet, bl);
        }
        return hashSet;
    }

    /*
     * WARNING - void declaration
     */
    protected void getInstancesForNode(HierarchyNode<AtomicConcept> hierarchyNode, Set<Individual> set2, boolean bl) {
        assert (!bl || this.m_usesClassifiedConceptHierarchy);
        AtomicConcept atomicConcept = hierarchyNode.getRepresentative();
        if (!bl && atomicConcept.equals(this.m_topConcept)) {
            void object;
            Individual[] individualArray = this.m_individuals;
            int n = individualArray.length;
            boolean bl2 = false;
            while (object < n) {
                Individual individual = individualArray[object];
                if (InstanceManager.isResultRelevantIndividual(individual)) {
                    set2.add(individual);
                }
                ++object;
            }
            return;
        }
        AtomicConceptElement atomicConceptElement = this.m_conceptToElement.get(atomicConcept);
        if (atomicConceptElement != null) {
            Set<Individual> set3 = atomicConceptElement.getPossibleInstances();
            if (!set3.isEmpty()) {
                for (Individual individual : new HashSet(set3)) {
                    if (this.isInstance(individual, atomicConcept)) {
                        atomicConceptElement.setToKnown(individual);
                        continue;
                    }
                    atomicConceptElement.m_possibleInstances.remove(individual);
                    if (atomicConceptElement.m_knownInstances.isEmpty() && atomicConceptElement.m_possibleInstances.isEmpty() && atomicConcept != this.m_topConcept) {
                        this.m_conceptToElement.remove(atomicConcept);
                    }
                    for (HierarchyNode<AtomicConcept> hierarchyNode2 : hierarchyNode.getParentNodes()) {
                        HierarchyNode<AtomicConcept> hierarchyNode3 = (AtomicConcept)hierarchyNode2.getRepresentative();
                        AtomicConceptElement atomicConceptElement2 = this.m_conceptToElement.get(hierarchyNode3);
                        if (atomicConceptElement2 == null) {
                            atomicConceptElement2 = new AtomicConceptElement(null, null);
                            this.m_conceptToElement.put((AtomicConcept)((Object)hierarchyNode3), atomicConceptElement2);
                        }
                        atomicConceptElement2.addPossible(individual);
                    }
                }
            }
            for (Individual individual : atomicConceptElement.getKnownInstances()) {
                if (!InstanceManager.isResultRelevantIndividual(individual)) continue;
                boolean bl3 = true;
                if (bl) {
                    for (HierarchyNode<AtomicConcept> hierarchyNode3 : hierarchyNode.getChildNodes()) {
                        if (!this.hasType(individual, hierarchyNode3, false)) continue;
                        bl3 = false;
                        break;
                    }
                }
                if (bl && !bl3) continue;
                set2.add(individual);
            }
        }
        if (!bl) {
            for (HierarchyNode hierarchyNode4 : hierarchyNode.getChildNodes()) {
                if (hierarchyNode4 == this.m_currentConceptHierarchy.m_bottomNode) continue;
                this.getInstancesForNode(hierarchyNode4, set2, false);
            }
        }
    }

    public boolean hasObjectRoleRelationship(AtomicRole atomicRole, Individual individual, Individual individual2) {
        RoleElementManager.RoleElement roleElement = this.m_roleElementManager.getRoleElement(atomicRole);
        HierarchyNode<RoleElementManager.RoleElement> hierarchyNode = this.m_currentRoleHierarchy.getNodeForElement(roleElement);
        if (hierarchyNode == null) {
            return false;
        }
        return this.hasObjectRoleRelationship(hierarchyNode, individual, individual2);
    }

    public boolean hasObjectRoleRelationship(HierarchyNode<RoleElementManager.RoleElement> hierarchyNode, Individual individual, Individual individual2) {
        boolean bl;
        RoleElementManager.RoleElement roleElement = hierarchyNode.getRepresentative();
        if (roleElement.isKnown(individual, individual2) || roleElement.equals(this.m_topRoleElement)) {
            return true;
        }
        List<Individual> list = Arrays.asList(this.m_individuals);
        boolean bl2 = bl = !list.contains(individual) || !list.contains(individual2);
        if (roleElement.isPossible(individual, individual2) || bl) {
            if (this.isRoleInstance(roleElement.getRole(), individual, individual2)) {
                if (!bl) {
                    roleElement.setToKnown(individual, individual2);
                }
                return true;
            }
            for (HierarchyNode<RoleElementManager.RoleElement> hierarchyNode2 : hierarchyNode.getParentNodes()) {
                hierarchyNode2.getRepresentative().addPossible(individual, individual2);
            }
        } else {
            for (HierarchyNode<RoleElementManager.RoleElement> hierarchyNode3 : hierarchyNode.getChildNodes()) {
                if (!this.hasObjectRoleRelationship(hierarchyNode3, individual, individual2)) continue;
                return true;
            }
        }
        return false;
    }

    public Map<Individual, Set<Individual>> getObjectPropertyInstances(AtomicRole atomicRole) {
        HashMap<Individual, Set<Individual>> hashMap = new HashMap<Individual, Set<Individual>>();
        HierarchyNode<RoleElementManager.RoleElement> hierarchyNode = this.m_currentRoleHierarchy.getNodeForElement(this.m_roleElementManager.getRoleElement(atomicRole));
        if (hierarchyNode == null) {
            return hashMap;
        }
        this.getObjectPropertyInstances(hierarchyNode, hashMap);
        return hashMap;
    }

    /*
     * WARNING - void declaration
     */
    protected void getObjectPropertyInstances(HierarchyNode<RoleElementManager.RoleElement> hierarchyNode, Map<Individual, Set<Individual>> map2) {
        RoleElementManager.RoleElement roleElement = hierarchyNode.getRepresentative();
        if (roleElement.equals(this.m_topRoleElement) || this.m_isInconsistent) {
            void var7_13;
            HashSet<Individual> hashSet = new HashSet<Individual>();
            Individual[] individualArray = this.m_individuals;
            int n = individualArray.length;
            boolean bl = false;
            while (var7_13 < n) {
                Individual individual = individualArray[var7_13];
                if (InstanceManager.isResultRelevantIndividual(individual)) {
                    hashSet.add(individual);
                    map2.put(individual, hashSet);
                }
                ++var7_13;
            }
            return;
        }
        Map<Individual, Set<Individual>> map3 = roleElement.getPossibleRelations();
        for (Individual iterator : new HashSet<Individual>(map3.keySet())) {
            for (HashSet<Individual> hashSet : new HashSet(map3.get(iterator))) {
                if (this.isRoleInstance(roleElement.getRole(), iterator, (Individual)((Object)hashSet))) {
                    roleElement.setToKnown(iterator, (Individual)((Object)hashSet));
                    continue;
                }
                for (HierarchyNode<RoleElementManager.RoleElement> hierarchyNode2 : hierarchyNode.getParentNodes()) {
                    hierarchyNode2.getRepresentative().addPossible(iterator, (Individual)((Object)hashSet));
                }
            }
        }
        Map<Individual, Set<Individual>> map4 = roleElement.getKnownRelations();
        for (Individual individual : map4.keySet()) {
            HashSet<Individual> hashSet;
            if (!InstanceManager.isResultRelevantIndividual(individual)) continue;
            hashSet = map2.get(individual);
            boolean bl = false;
            if (hashSet == null) {
                hashSet = new HashSet<Individual>();
                bl = true;
            }
            for (Individual individual2 : (Set)map4.get(individual)) {
                if (!InstanceManager.isResultRelevantIndividual(individual2)) continue;
                hashSet.add(individual2);
            }
            if (!bl || hashSet.isEmpty()) continue;
            map2.put(individual, hashSet);
        }
        for (HierarchyNode<RoleElementManager.RoleElement> hierarchyNode3 : hierarchyNode.getChildNodes()) {
            this.getObjectPropertyInstances(hierarchyNode3, map2);
        }
    }

    public Set<Individual> getObjectPropertyValues(AtomicRole atomicRole, Individual individual) {
        HashSet<Individual> hashSet = new HashSet<Individual>();
        HierarchyNode<RoleElementManager.RoleElement> hierarchyNode = this.m_currentRoleHierarchy.getNodeForElement(this.m_roleElementManager.getRoleElement(atomicRole));
        this.getObjectPropertyValues(hierarchyNode, individual, hashSet);
        return hashSet;
    }

    public Set<Individual> getObjectPropertySubjects(AtomicRole atomicRole, Individual individual) {
        HashSet<Individual> hashSet = new HashSet<Individual>();
        HierarchyNode<RoleElementManager.RoleElement> hierarchyNode = this.m_currentRoleHierarchy.getNodeForElement(this.m_roleElementManager.getRoleElement(atomicRole));
        this.getObjectPropertySubjects(hierarchyNode, individual, hashSet);
        return hashSet;
    }

    /*
     * WARNING - void declaration
     */
    protected void getObjectPropertySubjects(HierarchyNode<RoleElementManager.RoleElement> hierarchyNode, Individual individual, Set<Individual> set2) {
        RoleElementManager.RoleElement roleElement = hierarchyNode.getRepresentative();
        if (roleElement.equals(this.m_topRoleElement) || this.m_isInconsistent) {
            void object;
            Individual[] individualArray = this.m_individuals;
            int n = individualArray.length;
            boolean bl = false;
            while (object < n) {
                Individual individual2 = individualArray[object];
                if (InstanceManager.isResultRelevantIndividual(individual2)) {
                    set2.add(individual2);
                }
                ++object;
            }
            return;
        }
        Map<Individual, Set<Individual>> map2 = roleElement.getKnownRelations();
        for (Individual individual3 : new HashSet<Individual>(map2.keySet())) {
            if (!InstanceManager.isResultRelevantIndividual(individual3) || !map2.get(individual3).contains(individual)) continue;
            set2.add(individual3);
        }
        map2 = roleElement.getPossibleRelations();
        for (Individual individual4 : new HashSet<Individual>(map2.keySet())) {
            if (InstanceManager.isResultRelevantIndividual(individual4) && map2.get(individual4).contains(individual) && this.isRoleInstance(roleElement.getRole(), individual4, individual)) {
                roleElement.setToKnown(individual4, individual);
                set2.add(individual4);
                continue;
            }
            for (HierarchyNode<RoleElementManager.RoleElement> hierarchyNode2 : hierarchyNode.getParentNodes()) {
                hierarchyNode2.getRepresentative().addPossible(individual4, individual);
            }
        }
        for (HierarchyNode hierarchyNode3 : hierarchyNode.getChildNodes()) {
            this.getObjectPropertySubjects(hierarchyNode3, individual, set2);
        }
    }

    protected void getObjectPropertyValues(HierarchyNode<RoleElementManager.RoleElement> hierarchyNode, Individual individual, Set<Individual> set2) {
        Object object;
        Object object2;
        RoleElementManager.RoleElement roleElement = hierarchyNode.getRepresentative();
        if (roleElement.equals(this.m_topRoleElement) || this.m_isInconsistent) {
            for (Individual individual2 : this.m_individuals) {
                if (!InstanceManager.isResultRelevantIndividual(individual2)) continue;
                set2.add(individual2);
            }
            return;
        }
        Set<Individual> set3 = roleElement.getPossibleRelations().get(individual);
        if (set3 != null) {
            object2 = new HashSet<Individual>(set3).iterator();
            while (object2.hasNext()) {
                object = (Individual)object2.next();
                if (this.isRoleInstance(roleElement.getRole(), individual, (Individual)object)) {
                    roleElement.setToKnown(individual, (Individual)object);
                    continue;
                }
                for (HierarchyNode<RoleElementManager.RoleElement> hierarchyNode2 : hierarchyNode.getParentNodes()) {
                    hierarchyNode2.getRepresentative().addPossible(individual, (Individual)object);
                }
            }
        }
        if ((object2 = roleElement.getKnownRelations().get(individual)) != null) {
            object = object2.iterator();
            while (object.hasNext()) {
                Individual individual2 = (Individual)object.next();
                if (!InstanceManager.isResultRelevantIndividual(individual2)) continue;
                set2.add(individual2);
            }
        }
        for (HierarchyNode hierarchyNode3 : hierarchyNode.getChildNodes()) {
            this.getObjectPropertyValues(hierarchyNode3, individual, set2);
        }
    }

    public Set<Individual> getSameAsIndividuals(Individual individual) {
        Set<Individual> set2 = this.m_individualToEquivalenceClass.get(individual);
        Set<Set<Individual>> set3 = this.m_individualToPossibleEquivalenceClass.get(set2);
        if (set3 != null) {
            while (!set3.isEmpty()) {
                Object object;
                Set<Individual> set4 = set3.iterator().next();
                set3.remove(set4);
                if (set3.isEmpty()) {
                    this.m_individualToPossibleEquivalenceClass.remove(set2);
                }
                Individual object2 = (Individual)set4.iterator().next();
                if (this.isSameIndividual(set2.iterator().next(), object2)) {
                    set2.addAll((Collection<Individual>)set4);
                    set2.addAll((Collection<Individual>)this.m_individualToEquivalenceClass.get(object2));
                    object = set4.iterator();
                    while (object.hasNext()) {
                        Individual individual2 = (Individual)object.next();
                        this.m_individualToEquivalenceClass.put(individual2, set2);
                    }
                    continue;
                }
                object = this.m_individualToPossibleEquivalenceClass.get(set4);
                if (object == null || !object.contains(set2)) continue;
                object.remove(set2);
                if (!object.isEmpty()) continue;
                this.m_individualToPossibleEquivalenceClass.remove(set4);
            }
        }
        for (Set set4 : new HashSet<Set<Individual>>(this.m_individualToPossibleEquivalenceClass.keySet())) {
            if (set4 == set2 || !this.m_individualToPossibleEquivalenceClass.get(set4).contains(set2) || !this.isSameIndividual(set2.iterator().next(), (Individual)set4.iterator().next())) continue;
            this.m_individualToPossibleEquivalenceClass.get(set4).remove(set2);
            if (this.m_individualToPossibleEquivalenceClass.get(set4).isEmpty()) {
                this.m_individualToPossibleEquivalenceClass.remove(set4);
            }
            for (Individual individual2 : set4) {
                this.m_individualToEquivalenceClass.put(individual2, set2);
            }
            set2.addAll(set4);
        }
        return set2;
    }

    public boolean isSameIndividual(Individual individual, Individual individual2) {
        return !this.m_reasoner.getTableau().isSatisfiable(true, false, Collections.singleton(Atom.create(Inequality.INSTANCE, individual, individual2)), null, null, null, null, new ReasoningTaskDescription(true, "is {0} same as {1}", individual, individual2));
    }

    public void computeSameAsEquivalenceClasses(ReasonerProgressMonitor reasonerProgressMonitor) {
        if (!this.m_individualToPossibleEquivalenceClass.isEmpty()) {
            int n = this.m_individualToPossibleEquivalenceClass.keySet().size();
            if (n > 0 && reasonerProgressMonitor != null) {
                reasonerProgressMonitor.reasonerTaskStarted("Precompute same individuals");
            }
            while (!this.m_individualToPossibleEquivalenceClass.isEmpty()) {
                Set<Individual> set2 = this.m_individualToPossibleEquivalenceClass.keySet().iterator().next();
                this.getSameAsIndividuals(set2.iterator().next());
                if (reasonerProgressMonitor == null) continue;
                reasonerProgressMonitor.reasonerTaskProgressChanged(n - this.m_individualToPossibleEquivalenceClass.keySet().size(), n);
            }
            if (reasonerProgressMonitor != null) {
                reasonerProgressMonitor.reasonerTaskStopped();
            }
        }
    }

    protected boolean isInstance(Individual individual, AtomicConcept atomicConcept) {
        boolean bl;
        boolean bl2 = bl = !this.m_reasoner.getTableau().isSatisfiable(true, false, null, Collections.singleton(Atom.create(atomicConcept, individual)), null, null, null, ReasoningTaskDescription.isInstanceOf(atomicConcept, individual));
        if (this.m_tableauMonitor != null) {
            if (bl) {
                this.m_tableauMonitor.possibleInstanceIsInstance();
            } else {
                this.m_tableauMonitor.possibleInstanceIsNotInstance();
            }
        }
        return bl;
    }

    protected boolean isRoleInstance(Role role, Individual individual, Individual individual2) {
        boolean bl;
        AtomicRole atomicRole;
        Serializable serializable;
        OWLDataFactory oWLDataFactory = this.m_reasoner.getDataFactory();
        if (role instanceof InverseRole) {
            serializable = individual;
            individual = individual2;
            individual2 = serializable;
            atomicRole = ((InverseRole)role).getInverseOf();
        } else {
            atomicRole = (AtomicRole)role;
        }
        serializable = oWLDataFactory.getOWLObjectProperty(IRI.create(atomicRole.getIRI()));
        OWLNamedIndividual oWLNamedIndividual = oWLDataFactory.getOWLNamedIndividual(IRI.create(individual.getIRI()));
        OWLNamedIndividual oWLNamedIndividual2 = oWLDataFactory.getOWLNamedIndividual(IRI.create(individual2.getIRI()));
        OWLClass oWLClass = oWLDataFactory.getOWLClass(IRI.create("internal:pseudo-nominal"));
        OWLObjectAllValuesFrom oWLObjectAllValuesFrom = oWLDataFactory.getOWLObjectAllValuesFrom((OWLObjectPropertyExpression)serializable, oWLClass.getObjectComplementOf());
        OWLClassAssertionAxiom oWLClassAssertionAxiom = oWLDataFactory.getOWLClassAssertionAxiom(oWLObjectAllValuesFrom, oWLNamedIndividual);
        OWLClassAssertionAxiom oWLClassAssertionAxiom2 = oWLDataFactory.getOWLClassAssertionAxiom(oWLClass, oWLNamedIndividual2);
        Tableau tableau = this.m_reasoner.getTableau(oWLClassAssertionAxiom, oWLClassAssertionAxiom2);
        boolean bl2 = bl = !tableau.isSatisfiable(true, true, null, null, null, null, null, new ReasoningTaskDescription(true, "is {0} connected to {1} via {2}", individual, individual2, atomicRole));
        if (this.m_tableauMonitor != null) {
            if (bl) {
                this.m_tableauMonitor.possibleInstanceIsInstance();
            } else {
                this.m_tableauMonitor.possibleInstanceIsNotInstance();
            }
        }
        return bl;
    }

    protected static boolean isResultRelevantIndividual(Individual individual) {
        return !individual.isAnonymous() && !Prefixes.isInternalIRI(individual.getIRI());
    }

    public boolean realizationCompleted() {
        return this.m_realizationCompleted;
    }

    public boolean objectPropertyRealizationCompleted() {
        return this.m_roleRealizationCompleted;
    }

    public boolean sameAsIndividualsComputed() {
        return this.m_individualToPossibleEquivalenceClass.isEmpty();
    }

    public boolean areClassesInitialised() {
        return this.m_classesInitialised;
    }

    public boolean arePropertiesInitialised() {
        return this.m_propertiesInitialised;
    }

    public int getCurrentIndividualIndex() {
        return this.m_currentIndividualIndex;
    }

    public Map<Individual, Node> getNodesForIndividuals() {
        return this.m_nodesForIndividuals;
    }
}

