/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.hierarchy;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.semanticweb.HermiT.model.AtomicRole;
import org.semanticweb.HermiT.model.Individual;

public class RoleElementManager {
    public static final String LB = System.getProperty("line.separator");
    protected final Map<AtomicRole, RoleElement> m_roleToElement = new HashMap<AtomicRole, RoleElement>();

    protected RoleElementManager() {
    }

    public RoleElement getRoleElement(AtomicRole atomicRole) {
        if (this.m_roleToElement.containsKey(atomicRole)) {
            return this.m_roleToElement.get(atomicRole);
        }
        RoleElement roleElement = new RoleElement(atomicRole);
        this.m_roleToElement.put(atomicRole, roleElement);
        return roleElement;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (AtomicRole atomicRole : this.m_roleToElement.keySet()) {
            stringBuffer.append(atomicRole);
            stringBuffer.append(" -> ");
            stringBuffer.append(this.m_roleToElement.get(atomicRole).toString());
            stringBuffer.append(LB);
        }
        return stringBuffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class RoleElement {
        protected final AtomicRole m_role;
        protected Map<Individual, Set<Individual>> m_knownRelations;
        protected Map<Individual, Set<Individual>> m_possibleRelations;

        protected RoleElement(AtomicRole atomicRole) {
            this.m_role = atomicRole;
            this.m_knownRelations = new HashMap<Individual, Set<Individual>>();
            this.m_possibleRelations = new HashMap<Individual, Set<Individual>>();
        }

        public AtomicRole getRole() {
            return this.m_role;
        }

        public boolean isKnown(Individual individual, Individual individual2) {
            return this.m_knownRelations.containsKey(individual) && this.m_knownRelations.get(individual).contains(individual2);
        }

        public boolean isPossible(Individual individual, Individual individual2) {
            return this.m_possibleRelations.containsKey(individual) && this.m_possibleRelations.get(individual).contains(individual2);
        }

        public Map<Individual, Set<Individual>> getKnownRelations() {
            return this.m_knownRelations;
        }

        public Map<Individual, Set<Individual>> getPossibleRelations() {
            return this.m_possibleRelations;
        }

        public boolean hasPossibles() {
            return !this.m_possibleRelations.isEmpty();
        }

        public void setToKnown(Individual individual, Individual individual2) {
            Set<Individual> set2 = this.m_possibleRelations.get(individual);
            set2.remove(individual2);
            if (set2.isEmpty()) {
                this.m_possibleRelations.remove(individual);
            }
            this.addKnown(individual, individual2);
        }

        public boolean addKnown(Individual individual, Individual individual2) {
            Set<Individual> set2 = this.m_knownRelations.get(individual);
            if (set2 == null) {
                set2 = new HashSet<Individual>();
                this.m_knownRelations.put(individual, set2);
            }
            return set2.add(individual2);
        }

        public boolean addKnowns(Individual individual, Set<Individual> set2) {
            Set<Individual> set3 = this.m_knownRelations.get(individual);
            if (set3 == null) {
                set3 = new HashSet<Individual>();
                this.m_knownRelations.put(individual, set3);
            }
            return set3.addAll(set2);
        }

        public boolean removeKnown(Individual individual, Individual individual2) {
            Set<Individual> set2 = this.m_knownRelations.get(individual);
            boolean bl = false;
            if (set2 != null) {
                bl = set2.remove(individual2);
                if (set2.isEmpty()) {
                    this.m_knownRelations.remove(individual);
                }
            }
            return bl;
        }

        public boolean addPossible(Individual individual, Individual individual2) {
            Set<Individual> set2 = this.m_possibleRelations.get(individual);
            if (set2 == null) {
                set2 = new HashSet<Individual>();
                this.m_possibleRelations.put(individual, set2);
            }
            return set2.add(individual2);
        }

        public boolean removePossible(Individual individual, Individual individual2) {
            Set<Individual> set2 = this.m_possibleRelations.get(individual);
            boolean bl = false;
            if (set2 != null) {
                bl = set2.remove(individual2);
                if (set2.isEmpty()) {
                    this.m_possibleRelations.remove(individual);
                }
            }
            return bl;
        }

        public boolean addPossibles(Individual individual, Set<Individual> set2) {
            Set<Individual> set3 = this.m_possibleRelations.get(individual);
            if (set3 == null) {
                set3 = new HashSet<Individual>();
                this.m_possibleRelations.put(individual, set3);
            }
            return set3.addAll(set2);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.m_role);
            stringBuffer.append(" (known instances: ");
            boolean bl = false;
            for (Individual individual : this.m_knownRelations.keySet()) {
                for (Individual individual2 : this.m_knownRelations.get(individual)) {
                    if (bl) {
                        stringBuffer.append(", ");
                        bl = true;
                    }
                    stringBuffer.append("(");
                    stringBuffer.append(individual.toString());
                    stringBuffer.append(", ");
                    stringBuffer.append(individual2.toString());
                    stringBuffer.append(")");
                }
            }
            stringBuffer.append(" | possible instances: ");
            bl = false;
            for (Individual individual : this.m_possibleRelations.keySet()) {
                for (Individual individual2 : this.m_possibleRelations.get(individual)) {
                    if (bl) {
                        stringBuffer.append(", ");
                        bl = true;
                    }
                    stringBuffer.append("(");
                    stringBuffer.append(individual.toString());
                    stringBuffer.append(", ");
                    stringBuffer.append(individual2.toString());
                    stringBuffer.append(")");
                }
            }
            stringBuffer.append(") ");
            return stringBuffer.toString();
        }
    }
}

