/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.model;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.semanticweb.HermiT.Prefixes;
import org.semanticweb.HermiT.model.AnnotatedEquality;
import org.semanticweb.HermiT.model.DLPredicate;
import org.semanticweb.HermiT.model.Equality;
import org.semanticweb.HermiT.model.Individual;
import org.semanticweb.HermiT.model.Inequality;
import org.semanticweb.HermiT.model.InterningManager;
import org.semanticweb.HermiT.model.NodeIDLessEqualThan;
import org.semanticweb.HermiT.model.Term;
import org.semanticweb.HermiT.model.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Atom
implements Serializable {
    private static final long serialVersionUID = 7884900540178779422L;
    public static final Set<DLPredicate> s_infixPredicates = new HashSet<DLPredicate>();
    protected final DLPredicate m_dlPredicate;
    protected final Term[] m_arguments;
    protected static InterningManager<Atom> s_interningManager;

    protected Atom(DLPredicate dLPredicate, Term[] termArray) {
        this.m_dlPredicate = dLPredicate;
        this.m_arguments = termArray;
        if (this.m_dlPredicate.getArity() != this.m_arguments.length) {
            throw new IllegalArgumentException("The arity of the predicate must be equal to the number of arguments.");
        }
    }

    public DLPredicate getDLPredicate() {
        return this.m_dlPredicate;
    }

    public int getArity() {
        return this.m_arguments.length;
    }

    public Term getArgument(int n) {
        return this.m_arguments[n];
    }

    public Variable getArgumentVariable(int n) {
        if (this.m_arguments[n] instanceof Variable) {
            return (Variable)this.m_arguments[n];
        }
        return null;
    }

    public void getVariables(Set<Variable> set2) {
        for (int i = this.m_arguments.length - 1; i >= 0; --i) {
            Term term = this.m_arguments[i];
            if (!(term instanceof Variable)) continue;
            set2.add((Variable)term);
        }
    }

    public void getIndividuals(Set<Individual> set2) {
        for (int i = this.m_arguments.length - 1; i >= 0; --i) {
            Term term = this.m_arguments[i];
            if (!(term instanceof Individual)) continue;
            set2.add((Individual)term);
        }
    }

    public boolean containsVariable(Variable variable) {
        for (int i = this.m_arguments.length - 1; i >= 0; --i) {
            if (!this.m_arguments[i].equals(variable)) continue;
            return true;
        }
        return false;
    }

    public Atom replaceDLPredicate(DLPredicate dLPredicate) {
        return Atom.create(dLPredicate, this.m_arguments);
    }

    public String toString(Prefixes prefixes) {
        StringBuffer stringBuffer = new StringBuffer();
        if (s_infixPredicates.contains(this.m_dlPredicate)) {
            stringBuffer.append(this.m_arguments[0].toString(prefixes));
            stringBuffer.append(' ');
            stringBuffer.append(this.m_dlPredicate.toString(prefixes));
            stringBuffer.append(' ');
            stringBuffer.append(this.m_arguments[1].toString(prefixes));
        } else if (this.m_dlPredicate instanceof AnnotatedEquality) {
            AnnotatedEquality annotatedEquality = (AnnotatedEquality)this.m_dlPredicate;
            stringBuffer.append('[');
            stringBuffer.append(this.m_arguments[0].toString(prefixes));
            stringBuffer.append(' ');
            stringBuffer.append("==");
            stringBuffer.append(' ');
            stringBuffer.append(this.m_arguments[1].toString(prefixes));
            stringBuffer.append("]@atMost(");
            stringBuffer.append(annotatedEquality.getCaridnality());
            stringBuffer.append(' ');
            stringBuffer.append(annotatedEquality.getOnRole().toString(prefixes));
            stringBuffer.append(' ');
            stringBuffer.append(annotatedEquality.getToConcept().toString(prefixes));
            stringBuffer.append(")(");
            stringBuffer.append(this.m_arguments[2].toString(prefixes));
            stringBuffer.append(')');
        } else {
            stringBuffer.append(this.m_dlPredicate.toString(prefixes));
            stringBuffer.append('(');
            for (int i = 0; i < this.m_arguments.length; ++i) {
                if (i != 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(this.m_arguments[i].toString(prefixes));
            }
            stringBuffer.append(')');
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toString(Prefixes.STANDARD_PREFIXES);
    }

    protected Object readResolve() {
        return s_interningManager.intern(this);
    }

    public static Atom create(DLPredicate dLPredicate, Term ... termArray) {
        return s_interningManager.intern(new Atom(dLPredicate, termArray));
    }

    static {
        s_infixPredicates.add(Equality.INSTANCE);
        s_infixPredicates.add(Inequality.INSTANCE);
        s_infixPredicates.add(NodeIDLessEqualThan.INSTANCE);
        s_interningManager = new InterningManager<Atom>(){

            @Override
            protected boolean equal(Atom atom2, Atom atom3) {
                if (atom2.m_dlPredicate != atom3.m_dlPredicate) {
                    return false;
                }
                for (int i = atom2.m_arguments.length - 1; i >= 0; --i) {
                    if (atom2.m_arguments[i] == atom3.m_arguments[i]) continue;
                    return false;
                }
                return true;
            }

            @Override
            protected int getHashCode(Atom atom2) {
                int n = atom2.m_dlPredicate.hashCode();
                for (int i = atom2.m_arguments.length - 1; i >= 0; --i) {
                    n += atom2.m_arguments[i].hashCode();
                }
                return n;
            }
        };
    }
}

