/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.model;

import org.semanticweb.HermiT.Prefixes;
import org.semanticweb.HermiT.datatypes.DatatypeRegistry;
import org.semanticweb.HermiT.datatypes.MalformedLiteralException;
import org.semanticweb.HermiT.model.InterningManager;
import org.semanticweb.HermiT.model.Term;

public class Constant
extends Term {
    private static final long serialVersionUID = -8143911431654640690L;
    protected final String m_lexicalForm;
    protected final String m_datatypeURI;
    protected final Object m_dataValue;
    protected static InterningManager<Constant> s_interningManager = new InterningManager<Constant>(){

        @Override
        protected boolean equal(Constant constant, Constant constant2) {
            return constant.m_lexicalForm.equals(constant2.m_lexicalForm) && constant.m_datatypeURI.equals(constant2.m_datatypeURI);
        }

        @Override
        protected int getHashCode(Constant constant) {
            return constant.m_lexicalForm.hashCode() + constant.m_datatypeURI.hashCode();
        }
    };

    protected Constant(String string2, String string3, Object object) {
        this.m_lexicalForm = string2;
        this.m_datatypeURI = string3;
        this.m_dataValue = object;
    }

    public String getLexicalForm() {
        return this.m_lexicalForm;
    }

    public String getDatatypeURI() {
        return this.m_datatypeURI;
    }

    public Object getDataValue() {
        return this.m_dataValue;
    }

    public boolean isAnonymous() {
        return "internal:anonymous-constants".equals(this.m_datatypeURI);
    }

    public String toString() {
        return this.toString(Prefixes.STANDARD_PREFIXES);
    }

    public String toString(Prefixes prefixes) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('\"');
        block4: for (int i = 0; i < this.m_lexicalForm.length(); ++i) {
            char c = this.m_lexicalForm.charAt(i);
            switch (c) {
                case '\"': {
                    stringBuffer.append("\\\"");
                    continue block4;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    continue block4;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        stringBuffer.append("\"^^");
        stringBuffer.append(prefixes.abbreviateIRI(this.m_datatypeURI));
        return stringBuffer.toString();
    }

    protected Object readResolve() {
        return s_interningManager.intern(this);
    }

    public static Constant create(String string2, String string3) throws MalformedLiteralException {
        Object object = DatatypeRegistry.parseLiteral(string2, string3);
        return s_interningManager.intern(new Constant(string2, string3, object));
    }

    public static Constant createAnonymous(String string2) {
        return Constant.create(string2, "internal:anonymous-constants");
    }
}

