/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.model;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.semanticweb.HermiT.Prefixes;
import org.semanticweb.HermiT.model.AtLeastConcept;
import org.semanticweb.HermiT.model.Atom;
import org.semanticweb.HermiT.model.AtomicConcept;
import org.semanticweb.HermiT.model.AtomicRole;
import org.semanticweb.HermiT.model.Constant;
import org.semanticweb.HermiT.model.DLClause;
import org.semanticweb.HermiT.model.DLPredicate;
import org.semanticweb.HermiT.model.DatatypeRestriction;
import org.semanticweb.HermiT.model.DescriptionGraph;
import org.semanticweb.HermiT.model.ExistsDescriptionGraph;
import org.semanticweb.HermiT.model.Individual;
import org.semanticweb.HermiT.model.LiteralConcept;
import org.semanticweb.HermiT.model.Role;
import org.semanticweb.HermiT.model.Term;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DLOntology
implements Serializable {
    private static final long serialVersionUID = 3189937959595369812L;
    protected static final String CRLF = System.getProperty("line.separator");
    protected final String m_ontologyIRI;
    protected final Set<DLClause> m_dlClauses;
    protected final Set<Atom> m_positiveFacts;
    protected final Set<Atom> m_negativeFacts;
    protected final boolean m_hasInverseRoles;
    protected final boolean m_hasAtMostRestrictions;
    protected final boolean m_hasNominals;
    protected final boolean m_hasDatatypes;
    protected final boolean m_isHorn;
    protected final Set<AtomicConcept> m_allAtomicConcepts;
    protected final int m_numberOfExternalConcepts;
    protected final Set<AtomicRole> m_allAtomicObjectRoles;
    protected final Set<Role> m_allComplexObjectRoles;
    protected final Set<AtomicRole> m_allAtomicDataRoles;
    protected final Set<DatatypeRestriction> m_allUnknownDatatypeRestrictions;
    protected final Set<String> m_definedDatatypeIRIs;
    protected final Set<Individual> m_allIndividuals;
    protected final Set<DescriptionGraph> m_allDescriptionGraphs;
    protected final Map<AtomicRole, Map<Individual, Set<Constant>>> m_dataPropertyAssertions;

    public DLOntology(String string2, Set<DLClause> set2, Set<Atom> set3, Set<Atom> set4, Set<AtomicConcept> set5, Set<AtomicRole> set6, Set<Role> set7, Set<AtomicRole> set8, Set<DatatypeRestriction> set9, Set<String> set10, Set<Individual> set11, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        Object object;
        this.m_ontologyIRI = string2;
        this.m_dlClauses = set2;
        this.m_positiveFacts = set3;
        this.m_negativeFacts = set4;
        this.m_hasInverseRoles = bl;
        this.m_hasAtMostRestrictions = bl2;
        this.m_hasNominals = bl3;
        this.m_hasDatatypes = bl4;
        this.m_allAtomicConcepts = set5 == null ? new TreeSet<AtomicConcept>(AtomicConceptComparator.INSTANCE) : set5;
        int n = 0;
        for (AtomicConcept object2 : this.m_allAtomicConcepts) {
            if (Prefixes.isInternalIRI(object2.getIRI())) continue;
            ++n;
        }
        this.m_numberOfExternalConcepts = n;
        this.m_allAtomicObjectRoles = set6 == null ? new TreeSet<AtomicRole>(AtomicRoleComparator.INSTANCE) : set6;
        this.m_allComplexObjectRoles = set7 == null ? new HashSet<Role>() : set7;
        this.m_allAtomicDataRoles = set8 == null ? new TreeSet<AtomicRole>(AtomicRoleComparator.INSTANCE) : set8;
        this.m_allUnknownDatatypeRestrictions = set9 == null ? new HashSet<DatatypeRestriction>() : set9;
        this.m_definedDatatypeIRIs = set10 == null ? new HashSet<String>() : set10;
        this.m_allIndividuals = set11 == null ? new TreeSet<Individual>(IndividualComparator.INSTANCE) : set11;
        this.m_allDescriptionGraphs = new HashSet<DescriptionGraph>();
        boolean bl5 = true;
        for (DLClause dLClause : this.m_dlClauses) {
            int n2;
            if (dLClause.getHeadLength() > 1) {
                bl5 = false;
            }
            for (n2 = dLClause.getBodyLength() - 1; n2 >= 0; --n2) {
                object = dLClause.getBodyAtom(n2).getDLPredicate();
                this.addDLPredicate((DLPredicate)object);
            }
            for (n2 = dLClause.getHeadLength() - 1; n2 >= 0; --n2) {
                object = dLClause.getHeadAtom(n2).getDLPredicate();
                this.addDLPredicate((DLPredicate)object);
            }
        }
        this.m_isHorn = bl5;
        this.m_dataPropertyAssertions = new HashMap<AtomicRole, Map<Individual, Set<Constant>>>();
        for (Atom atom2 : this.m_positiveFacts) {
            Set<Constant> set12;
            Map<Object, Object> map2;
            Term term;
            this.addDLPredicate(atom2.getDLPredicate());
            for (int i = 0; i < atom2.getArity(); ++i) {
                object = atom2.getArgument(i);
                if (!(object instanceof Individual)) continue;
                this.m_allIndividuals.add((Individual)object);
            }
            if (atom2.getArity() != 2 || !((term = atom2.getArgument(1)) instanceof Constant)) continue;
            object = (Individual)atom2.getArgument(0);
            assert (atom2.getDLPredicate() instanceof AtomicRole);
            AtomicRole atomicRole = (AtomicRole)atom2.getDLPredicate();
            if (this.m_dataPropertyAssertions.containsKey(atomicRole)) {
                map2 = this.m_dataPropertyAssertions.get(atomicRole);
            } else {
                map2 = new HashMap();
                this.m_dataPropertyAssertions.put(atomicRole, map2);
            }
            if (map2.containsKey(object)) {
                set12 = (Set)map2.get(object);
            } else {
                set12 = new HashSet();
                map2.put(object, set12);
            }
            set12.add((Constant)term);
        }
        for (Atom atom3 : this.m_negativeFacts) {
            this.addDLPredicate(atom3.getDLPredicate());
            for (int i = 0; i < atom3.getArity(); ++i) {
                object = atom3.getArgument(i);
                if (!(object instanceof Individual)) continue;
                this.m_allIndividuals.add((Individual)object);
            }
        }
    }

    protected void addDLPredicate(DLPredicate dLPredicate) {
        if (dLPredicate instanceof AtomicConcept) {
            this.m_allAtomicConcepts.add((AtomicConcept)dLPredicate);
        } else if (dLPredicate instanceof AtLeastConcept) {
            LiteralConcept literalConcept = ((AtLeastConcept)dLPredicate).getToConcept();
            if (literalConcept instanceof AtomicConcept) {
                this.m_allAtomicConcepts.add((AtomicConcept)literalConcept);
            }
        } else if (dLPredicate instanceof DescriptionGraph) {
            this.m_allDescriptionGraphs.add((DescriptionGraph)dLPredicate);
        } else if (dLPredicate instanceof ExistsDescriptionGraph) {
            this.m_allDescriptionGraphs.add(((ExistsDescriptionGraph)dLPredicate).getDescriptionGraph());
        }
    }

    public String getOntologyIRI() {
        return this.m_ontologyIRI;
    }

    public Set<AtomicConcept> getAllAtomicConcepts() {
        return this.m_allAtomicConcepts;
    }

    public boolean containsAtomicConcept(AtomicConcept atomicConcept) {
        return this.m_allAtomicConcepts.contains(atomicConcept);
    }

    public int getNumberOfExternalConcepts() {
        return this.m_numberOfExternalConcepts;
    }

    public Set<AtomicRole> getAllAtomicObjectRoles() {
        return this.m_allAtomicObjectRoles;
    }

    public boolean containsObjectRole(AtomicRole atomicRole) {
        return this.m_allAtomicObjectRoles.contains(atomicRole);
    }

    public Set<Role> getAllComplexObjectRoles() {
        return this.m_allComplexObjectRoles;
    }

    public boolean isComplexObjectRole(Role role) {
        return this.m_allComplexObjectRoles.contains(role);
    }

    public Set<AtomicRole> getAllAtomicDataRoles() {
        return this.m_allAtomicDataRoles;
    }

    public boolean containsDataRole(AtomicRole atomicRole) {
        return this.m_allAtomicDataRoles.contains(atomicRole);
    }

    public Set<DatatypeRestriction> getAllUnknownDatatypeRestrictions() {
        return this.m_allUnknownDatatypeRestrictions;
    }

    public Set<Individual> getAllIndividuals() {
        return this.m_allIndividuals;
    }

    public boolean containsIndividual(Individual individual) {
        return this.m_allIndividuals.contains(individual);
    }

    public Set<DescriptionGraph> getAllDescriptionGraphs() {
        return this.m_allDescriptionGraphs;
    }

    public Set<DLClause> getDLClauses() {
        return this.m_dlClauses;
    }

    public Set<Atom> getPositiveFacts() {
        return this.m_positiveFacts;
    }

    public Map<AtomicRole, Map<Individual, Set<Constant>>> getDataPropertyAssertions() {
        return this.m_dataPropertyAssertions;
    }

    public Set<Atom> getNegativeFacts() {
        return this.m_negativeFacts;
    }

    public boolean hasInverseRoles() {
        return this.m_hasInverseRoles;
    }

    public boolean hasAtMostRestrictions() {
        return this.m_hasAtMostRestrictions;
    }

    public boolean hasNominals() {
        return this.m_hasNominals;
    }

    public boolean hasDatatypes() {
        return this.m_hasDatatypes;
    }

    public boolean hasUnknownDatatypeRestrictions() {
        return !this.m_allUnknownDatatypeRestrictions.isEmpty();
    }

    public boolean isHorn() {
        return this.m_isHorn;
    }

    public Set<String> getDefinedDatatypeIRIs() {
        return this.m_definedDatatypeIRIs;
    }

    protected Set<AtomicConcept> getBodyOnlyAtomicConcepts() {
        HashSet<AtomicConcept> hashSet = new HashSet<AtomicConcept>(this.m_allAtomicConcepts);
        for (DLClause dLClause : this.m_dlClauses) {
            for (int i = 0; i < dLClause.getHeadLength(); ++i) {
                DLPredicate dLPredicate = dLClause.getHeadAtom(i).getDLPredicate();
                hashSet.remove(dLPredicate);
                if (!(dLPredicate instanceof AtLeastConcept)) continue;
                hashSet.remove(((AtLeastConcept)dLPredicate).getToConcept());
            }
        }
        return hashSet;
    }

    protected Set<AtomicRole> computeGraphAtomicRoles() {
        HashSet<AtomicRole> hashSet = new HashSet<AtomicRole>();
        for (DescriptionGraph object : this.m_allDescriptionGraphs) {
            for (int dLClause = 0; dLClause < object.getNumberOfEdges(); ++dLClause) {
                DescriptionGraph.Edge edge = object.getEdge(dLClause);
                hashSet.add(edge.getAtomicRole());
            }
        }
        boolean bl = true;
        while (bl) {
            bl = false;
            for (DLClause dLClause : this.m_dlClauses) {
                if (!this.containsAtomicRoles(dLClause, hashSet) || !this.addAtomicRoles(dLClause, hashSet)) continue;
                bl = true;
            }
        }
        return hashSet;
    }

    protected boolean containsAtomicRoles(DLClause dLClause, Set<AtomicRole> set2) {
        DLPredicate dLPredicate;
        int n;
        for (n = 0; n < dLClause.getBodyLength(); ++n) {
            dLPredicate = dLClause.getBodyAtom(n).getDLPredicate();
            if (!(dLPredicate instanceof AtomicRole) || !set2.contains(dLPredicate)) continue;
            return true;
        }
        for (n = 0; n < dLClause.getHeadLength(); ++n) {
            dLPredicate = dLClause.getHeadAtom(n).getDLPredicate();
            if (!(dLPredicate instanceof AtomicRole) || !set2.contains(dLPredicate)) continue;
            return true;
        }
        return false;
    }

    protected boolean addAtomicRoles(DLClause dLClause, Set<AtomicRole> set2) {
        DLPredicate dLPredicate;
        int n;
        boolean bl = false;
        for (n = 0; n < dLClause.getBodyLength(); ++n) {
            dLPredicate = dLClause.getBodyAtom(n).getDLPredicate();
            if (!(dLPredicate instanceof AtomicRole) || !set2.add((AtomicRole)dLPredicate)) continue;
            bl = true;
        }
        for (n = 0; n < dLClause.getHeadLength(); ++n) {
            dLPredicate = dLClause.getHeadAtom(n).getDLPredicate();
            if (!(dLPredicate instanceof AtomicRole) || !set2.add((AtomicRole)dLPredicate)) continue;
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public String toString(Prefixes prefixes) {
        void var4_8;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Prefixes: [");
        stringBuffer.append(CRLF);
        for (Map.Entry<String, String> object : prefixes.getPrefixIRIsByPrefixName().entrySet()) {
            stringBuffer.append("  ");
            stringBuffer.append(object.getKey());
            stringBuffer.append(" = <");
            stringBuffer.append(object.getValue());
            stringBuffer.append('>');
            stringBuffer.append(CRLF);
        }
        stringBuffer.append("]");
        stringBuffer.append(CRLF);
        stringBuffer.append("Deterministic DL-clauses: [");
        stringBuffer.append(CRLF);
        int n = 0;
        for (DLClause dLClause : this.m_dlClauses) {
            if (dLClause.getHeadLength() > 1) continue;
            ++n;
            stringBuffer.append("  ");
            stringBuffer.append(dLClause.toString(prefixes));
            stringBuffer.append(CRLF);
        }
        stringBuffer.append("]");
        stringBuffer.append(CRLF);
        stringBuffer.append("Disjunctive DL-clauses: [");
        stringBuffer.append(CRLF);
        boolean bl = false;
        int n2 = 0;
        for (DLClause dLClause : this.m_dlClauses) {
            if (dLClause.getHeadLength() <= 1) continue;
            ++var4_8;
            n2 += dLClause.getHeadLength();
            stringBuffer.append("  ");
            stringBuffer.append(dLClause.toString(prefixes));
            stringBuffer.append(CRLF);
        }
        stringBuffer.append("]");
        stringBuffer.append(CRLF);
        stringBuffer.append("ABox: [");
        stringBuffer.append(CRLF);
        for (Atom atom2 : this.m_positiveFacts) {
            stringBuffer.append("  ");
            stringBuffer.append(atom2.toString(prefixes));
            stringBuffer.append(CRLF);
        }
        for (Atom atom3 : this.m_negativeFacts) {
            stringBuffer.append("  !");
            stringBuffer.append(atom3.toString(prefixes));
            stringBuffer.append(CRLF);
        }
        stringBuffer.append("]");
        stringBuffer.append(CRLF);
        stringBuffer.append("Statistics: [");
        stringBuffer.append(CRLF);
        stringBuffer.append("  Number of deterministic clauses: " + n);
        stringBuffer.append(CRLF);
        stringBuffer.append("  Number of nondeterministic clauses: " + (int)var4_8);
        stringBuffer.append(CRLF);
        stringBuffer.append("  Number of disjunctions: " + n2);
        stringBuffer.append(CRLF);
        stringBuffer.append("  Number of positive facts: " + this.m_positiveFacts.size());
        stringBuffer.append(CRLF);
        stringBuffer.append("  Number of negative facts: " + this.m_negativeFacts.size());
        stringBuffer.append(CRLF);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public String getStatistics() {
        return this.getStatistics(null, null, null);
    }

    protected String getStatistics(Integer n, Integer n2, Integer n3) {
        if (n == null || n2 == null || n3 == null) {
            n = 0;
            n2 = 0;
            n3 = 0;
            for (DLClause dLClause : this.m_dlClauses) {
                Integer n4;
                Integer n5;
                if (dLClause.getHeadLength() <= 1) {
                    n5 = n;
                    n4 = n = Integer.valueOf(n + 1);
                    continue;
                }
                n5 = n2;
                n4 = n2 = Integer.valueOf(n2 + 1);
                n3 = n3 + dLClause.getHeadLength();
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DL clauses statistics: [");
        stringBuffer.append(CRLF);
        stringBuffer.append("  Number of deterministic clauses: " + n);
        stringBuffer.append(CRLF);
        stringBuffer.append("  Number of nondeterministic clauses: " + n2);
        stringBuffer.append(CRLF);
        stringBuffer.append("  Overall number of disjunctions: " + n3);
        stringBuffer.append(CRLF);
        stringBuffer.append("  Number of positive facts: " + this.m_positiveFacts.size());
        stringBuffer.append(CRLF);
        stringBuffer.append("  Number of negative facts: " + this.m_negativeFacts.size());
        stringBuffer.append(CRLF);
        stringBuffer.append("  Inverses: " + this.hasInverseRoles());
        stringBuffer.append(CRLF);
        stringBuffer.append("  At-Mosts: " + this.hasAtMostRestrictions());
        stringBuffer.append(CRLF);
        stringBuffer.append("  Datatypes: " + this.hasDatatypes());
        stringBuffer.append(CRLF);
        stringBuffer.append("  Nominals: " + this.hasNominals());
        stringBuffer.append(CRLF);
        stringBuffer.append("  Number of atomic concepts: " + this.m_allAtomicConcepts.size());
        stringBuffer.append(CRLF);
        stringBuffer.append("  Number of object properties: " + this.m_allAtomicObjectRoles.size());
        stringBuffer.append(CRLF);
        stringBuffer.append("  Number of data properties: " + this.m_allAtomicDataRoles.size());
        stringBuffer.append(CRLF);
        stringBuffer.append("  Number of individuals: " + this.m_allIndividuals.size());
        stringBuffer.append(CRLF);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toString(Prefixes.STANDARD_PREFIXES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(File file2) throws IOException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
        try {
            this.save(bufferedOutputStream);
        }
        finally {
            ((OutputStream)bufferedOutputStream).close();
        }
    }

    public void save(OutputStream outputStream) throws IOException {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
        objectOutputStream.writeObject(this);
        objectOutputStream.flush();
    }

    public static DLOntology load(InputStream inputStream) throws IOException {
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            return (DLOntology)objectInputStream.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            IOException iOException = new IOException();
            iOException.initCause(classNotFoundException);
            throw iOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DLOntology load(File file2) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file2));
        try {
            DLOntology dLOntology = DLOntology.load(bufferedInputStream);
            return dLOntology;
        }
        finally {
            ((InputStream)bufferedInputStream).close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IndividualComparator
    implements Serializable,
    Comparator<Individual> {
        private static final long serialVersionUID = 2386841732225838685L;
        public static final Comparator<Individual> INSTANCE = new IndividualComparator();

        @Override
        public int compare(Individual individual, Individual individual2) {
            return individual.getIRI().compareTo(individual2.getIRI());
        }

        protected Object readResolve() {
            return INSTANCE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AtomicRoleComparator
    implements Serializable,
    Comparator<AtomicRole> {
        private static final long serialVersionUID = 3483541702854959793L;
        public static final Comparator<AtomicRole> INSTANCE = new AtomicRoleComparator();

        @Override
        public int compare(AtomicRole atomicRole, AtomicRole atomicRole2) {
            return atomicRole.getIRI().compareTo(atomicRole2.getIRI());
        }

        protected Object readResolve() {
            return INSTANCE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AtomicConceptComparator
    implements Serializable,
    Comparator<AtomicConcept> {
        private static final long serialVersionUID = 2386841732225838685L;
        public static final Comparator<AtomicConcept> INSTANCE = new AtomicConceptComparator();

        @Override
        public int compare(AtomicConcept atomicConcept, AtomicConcept atomicConcept2) {
            return atomicConcept.getIRI().compareTo(atomicConcept2.getIRI());
        }

        protected Object readResolve() {
            return INSTANCE;
        }
    }
}

