/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.model;

import org.semanticweb.HermiT.Prefixes;
import org.semanticweb.HermiT.model.AtomicDataRange;
import org.semanticweb.HermiT.model.AtomicNegationDataRange;
import org.semanticweb.HermiT.model.Constant;
import org.semanticweb.HermiT.model.InterningManager;
import org.semanticweb.HermiT.model.LiteralDataRange;

public class DatatypeRestriction
extends AtomicDataRange {
    private static final long serialVersionUID = 524235536504588458L;
    public static final String[] NO_FACET_URIs = new String[0];
    public static final Constant[] NO_FACET_VALUES = new Constant[0];
    protected final String m_datatypeURI;
    protected final String[] m_facetURIs;
    protected final Constant[] m_facetValues;
    protected static InterningManager<DatatypeRestriction> s_interningManager = new InterningManager<DatatypeRestriction>(){

        @Override
        protected boolean equal(DatatypeRestriction datatypeRestriction, DatatypeRestriction datatypeRestriction2) {
            if (!datatypeRestriction.m_datatypeURI.equals(datatypeRestriction2.m_datatypeURI) || datatypeRestriction.m_facetURIs.length != datatypeRestriction2.m_facetURIs.length) {
                return false;
            }
            for (int i = datatypeRestriction.m_facetURIs.length - 1; i >= 0; --i) {
                if (this.contains(datatypeRestriction2, datatypeRestriction.m_facetURIs[i], datatypeRestriction.m_facetValues[i])) continue;
                return false;
            }
            return true;
        }

        protected boolean contains(DatatypeRestriction datatypeRestriction, String string2, Object object) {
            for (int i = datatypeRestriction.m_facetURIs.length - 1; i >= 0; --i) {
                if (!datatypeRestriction.m_facetURIs[i].equals(string2) || !datatypeRestriction.m_facetValues[i].equals(object)) continue;
                return true;
            }
            return false;
        }

        @Override
        protected int getHashCode(DatatypeRestriction datatypeRestriction) {
            int n = datatypeRestriction.m_datatypeURI.hashCode();
            for (int i = datatypeRestriction.m_facetURIs.length - 1; i >= 0; --i) {
                n += datatypeRestriction.m_facetURIs[i].hashCode() + datatypeRestriction.m_facetValues[i].hashCode();
            }
            return n;
        }
    };

    public DatatypeRestriction(String string2, String[] stringArray, Constant[] constantArray) {
        this.m_datatypeURI = string2;
        this.m_facetURIs = stringArray;
        this.m_facetValues = constantArray;
    }

    public String getDatatypeURI() {
        return this.m_datatypeURI;
    }

    public int getNumberOfFacetRestrictions() {
        return this.m_facetURIs.length;
    }

    public String getFacetURI(int n) {
        return this.m_facetURIs[n];
    }

    public Constant getFacetValue(int n) {
        return this.m_facetValues[n];
    }

    public LiteralDataRange getNegation() {
        return AtomicNegationDataRange.create(this);
    }

    public boolean isAlwaysTrue() {
        return false;
    }

    public boolean isAlwaysFalse() {
        return false;
    }

    public String toString(Prefixes prefixes) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(prefixes.abbreviateIRI(this.m_datatypeURI));
        if (this.m_facetURIs.length > 0) {
            stringBuffer.append('[');
            for (int i = 0; i < this.m_facetURIs.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(prefixes.abbreviateIRI(this.m_facetURIs[i]));
                stringBuffer.append('=');
                stringBuffer.append(this.m_facetValues[i].toString(prefixes));
            }
            stringBuffer.append(']');
        }
        return stringBuffer.toString();
    }

    protected Object readResolve() {
        return s_interningManager.intern(this);
    }

    public static DatatypeRestriction create(String string2, String[] stringArray, Constant[] constantArray) {
        return s_interningManager.intern(new DatatypeRestriction(string2, stringArray, constantArray));
    }
}

