/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.model;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InterningManager<E> {
    protected static final double LOAD_FACTOR = 0.75;
    protected final ReferenceQueue<E> m_referenceQueue = new ReferenceQueue();
    protected Entry<E>[] m_entries = this.createEntries(16);
    protected int m_size = 0;
    protected int m_resizeThreshold = (int)((double)this.m_entries.length * 0.75);

    public synchronized E intern(E e2) {
        this.processQueue();
        int n = this.getHashCode(e2);
        int n2 = this.getIndexFor(n, this.m_entries.length);
        Entry<E> entry = null;
        Entry<E> entry2 = this.m_entries[n2];
        while (entry2 != null) {
            if (n == entry2.m_hashCode) {
                Object t = entry2.get();
                if (t == null) {
                    if (entry == null) {
                        this.m_entries[n2] = entry2.m_next;
                    } else {
                        entry.m_next = entry2.m_next;
                    }
                    --this.m_size;
                } else if (this.equal(e2, t)) {
                    return (E)t;
                }
            }
            entry = entry2;
            entry2 = entry2.m_next;
        }
        if (this.m_size >= this.m_resizeThreshold) {
            int n3 = this.m_entries.length * 2;
            Entry<E>[] entryArray = this.createEntries(n3);
            for (int i = 0; i < this.m_entries.length; ++i) {
                Entry<E> entry3 = this.m_entries[i];
                while (entry3 != null) {
                    Entry entry4 = entry3.m_next;
                    if (entry3.get() == null) {
                        --this.m_size;
                    } else {
                        int n4 = this.getIndexFor(entry3.m_hashCode, n3);
                        entry3.m_next = entryArray[n4];
                        entryArray[n4] = entry3;
                    }
                    entry3 = entry4;
                }
            }
            this.m_entries = entryArray;
            this.m_resizeThreshold = (int)((double)n3 * 0.75);
            n2 = this.getIndexFor(n, this.m_entries.length);
        }
        Entry<E> entry5 = new Entry<E>(e2, this.m_referenceQueue, n, this.m_entries[n2]);
        this.m_entries[n2] = entry5;
        ++this.m_size;
        return e2;
    }

    protected final int getIndexFor(int n, int n2) {
        return n & n2 - 1;
    }

    protected void removeEntry(Entry<E> entry) {
        int n = this.getIndexFor(entry.m_hashCode, this.m_entries.length);
        Entry<E> entry2 = null;
        Entry<E> entry3 = this.m_entries[n];
        while (entry3 != null) {
            if (entry3 == entry) {
                --this.m_size;
                if (entry2 == null) {
                    this.m_entries[n] = entry3.m_next;
                } else {
                    entry2.m_next = entry3.m_next;
                }
                return;
            }
            entry2 = entry3;
            entry3 = entry3.m_next;
        }
    }

    protected void processQueue() {
        Entry entry = (Entry)this.m_referenceQueue.poll();
        while (entry != null) {
            this.removeEntry(entry);
            entry = (Entry)this.m_referenceQueue.poll();
        }
    }

    protected final Entry<E>[] createEntries(int n) {
        return new Entry[n];
    }

    protected abstract int getHashCode(E var1);

    protected abstract boolean equal(E var1, E var2);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class Entry<E>
    extends WeakReference<E> {
        public final int m_hashCode;
        public Entry<E> m_next;

        public Entry(E e2, ReferenceQueue<E> referenceQueue, int n, Entry<E> entry) {
            super(e2, referenceQueue);
            this.m_hashCode = n;
            this.m_next = entry;
        }
    }
}

