/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.monitor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.semanticweb.HermiT.Prefixes;
import org.semanticweb.HermiT.monitor.TableauMonitorAdapter;
import org.semanticweb.HermiT.tableau.BranchingPoint;
import org.semanticweb.HermiT.tableau.Node;
import org.semanticweb.HermiT.tableau.ReasoningTaskDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CountingMonitor
extends TableauMonitorAdapter {
    private static final long serialVersionUID = -8144444618897251350L;
    protected long m_problemStartTime;
    protected long m_validationStartTime;
    protected int m_testNo = 0;
    protected long m_time;
    protected int m_numberOfBacktrackings;
    protected int m_numberOfNodes;
    protected int m_numberOfBlockedNodes;
    protected ReasoningTaskDescription m_reasoningTaskDescription;
    protected boolean m_testResult;
    protected int m_initialModelSize;
    protected int m_initiallyBlocked;
    protected int m_initiallyInvalid;
    protected int m_noValidations;
    protected long m_validationTime;
    protected final Map<String, List<TestRecord>> m_testRecords = new HashMap<String, List<TestRecord>>();
    protected long m_overallTime = 0L;
    protected int m_overallNumberOfBacktrackings = 0;
    protected int m_overallNumberOfNodes = 0;
    protected int m_overallNumberOfBlockedNodes = 0;
    protected int m_overallNumberOfTests = 0;
    protected int m_overallNumberOfClashes = 0;
    protected int m_possibleInstancesTested = 0;
    protected int m_possibleInstancesInstances = 0;
    protected int m_overallInitialModelSize = 0;
    protected int m_overallInitiallyBlocked = 0;
    protected int m_overallInitiallyInvalid = 0;
    protected int m_overallNoValidations = 0;
    protected long m_overallValidationTime = 0L;

    public void reset() {
        this.m_problemStartTime = 0L;
        this.m_validationStartTime = 0L;
        this.m_time = 0L;
        this.m_numberOfBacktrackings = 0;
        this.m_numberOfNodes = 0;
        this.m_numberOfBlockedNodes = 0;
        this.m_reasoningTaskDescription = null;
        this.m_testResult = false;
        this.m_initialModelSize = 0;
        this.m_initiallyBlocked = 0;
        this.m_initiallyInvalid = 0;
        this.m_noValidations = 0;
        this.m_validationTime = 0L;
        this.m_testRecords.clear();
        this.m_overallTime = 0L;
        this.m_overallNumberOfBacktrackings = 0;
        this.m_overallNumberOfNodes = 0;
        this.m_overallNumberOfBlockedNodes = 0;
        this.m_overallNumberOfTests = 0;
        this.m_overallNumberOfClashes = 0;
        this.m_possibleInstancesTested = 0;
        this.m_possibleInstancesInstances = 0;
        this.m_overallInitialModelSize = 0;
        this.m_overallInitiallyBlocked = 0;
        this.m_overallInitiallyInvalid = 0;
        this.m_overallNoValidations = 0;
        this.m_overallValidationTime = 0L;
    }

    @Override
    public void isSatisfiableStarted(ReasoningTaskDescription reasoningTaskDescription) {
        super.isSatisfiableStarted(reasoningTaskDescription);
        ++this.m_testNo;
        this.m_reasoningTaskDescription = reasoningTaskDescription;
        ++this.m_overallNumberOfTests;
        this.m_problemStartTime = System.currentTimeMillis();
        this.m_numberOfBacktrackings = 0;
        this.m_numberOfNodes = 0;
        this.m_numberOfBlockedNodes = 0;
        this.m_initialModelSize = 0;
        this.m_initiallyBlocked = 0;
        this.m_initiallyInvalid = 0;
        this.m_noValidations = 0;
        this.m_validationTime = 0L;
    }

    @Override
    public void isSatisfiableFinished(ReasoningTaskDescription reasoningTaskDescription, boolean bl) {
        super.isSatisfiableFinished(reasoningTaskDescription, bl);
        if (reasoningTaskDescription.flipSatisfiabilityResult()) {
            bl = !bl;
        }
        this.m_testResult = bl;
        this.m_time = System.currentTimeMillis() - this.m_problemStartTime;
        String string2 = this.m_reasoningTaskDescription.getMessagePattern();
        List<TestRecord> list = this.m_testRecords.get(string2);
        if (list == null) {
            list = new ArrayList<TestRecord>();
            this.m_testRecords.put(string2, list);
        }
        list.add(new TestRecord(this.m_time, this.m_reasoningTaskDescription.getTaskDescription(Prefixes.STANDARD_PREFIXES), this.m_testResult));
        this.m_overallTime += this.m_time;
        this.m_overallNumberOfBacktrackings += this.m_numberOfBacktrackings;
        this.m_numberOfNodes = this.m_tableau.getNumberOfNodesInTableau() - this.m_tableau.getNumberOfMergedOrPrunedNodes();
        for (Node node2 = this.m_tableau.getFirstTableauNode(); node2 != null; node2 = node2.getNextTableauNode()) {
            if (!node2.isActive() || !node2.isBlocked() || !node2.hasUnprocessedExistentials()) continue;
            ++this.m_numberOfBlockedNodes;
        }
        this.m_overallNumberOfNodes += this.m_numberOfNodes;
        this.m_overallNumberOfBlockedNodes += this.m_numberOfBlockedNodes;
        this.m_overallInitialModelSize += this.m_initialModelSize;
        this.m_overallInitiallyBlocked += this.m_initiallyBlocked;
        this.m_overallInitiallyInvalid += this.m_initiallyInvalid;
        this.m_overallNoValidations += this.m_noValidations;
        this.m_overallValidationTime += this.m_validationTime;
    }

    @Override
    public void backtrackToFinished(BranchingPoint branchingPoint) {
        ++this.m_numberOfBacktrackings;
    }

    @Override
    public void possibleInstanceIsInstance() {
        ++this.m_possibleInstancesTested;
        ++this.m_possibleInstancesInstances;
    }

    @Override
    public void possibleInstanceIsNotInstance() {
        ++this.m_possibleInstancesTested;
    }

    @Override
    public void blockingValidationStarted() {
        ++this.m_noValidations;
        if (this.m_noValidations == 1) {
            for (Node node2 = this.m_tableau.getFirstTableauNode(); node2 != null; node2 = node2.getNextTableauNode()) {
                if (!node2.isActive()) continue;
                ++this.m_initialModelSize;
                if (!node2.isBlocked() || !node2.hasUnprocessedExistentials()) continue;
                ++this.m_initiallyBlocked;
            }
        }
        this.m_validationStartTime = System.currentTimeMillis();
    }

    @Override
    public void blockingValidationFinished(int n) {
        this.m_validationTime += System.currentTimeMillis() - this.m_validationStartTime;
        if (this.m_noValidations == 1) {
            this.m_initiallyInvalid = n;
        }
    }

    public Set<String> getUsedMessagePatterns() {
        return this.m_testRecords.keySet();
    }

    public List<TestRecord> getTimeSortedTestRecords(int n) {
        return this.getTimeSortedTestRecords(n, (String)null);
    }

    public List<TestRecord> getTimeSortedTestRecords(int n, ReasoningTaskDescription.StandardTestType standardTestType) {
        return this.getTimeSortedTestRecords(n, standardTestType.messagePattern);
    }

    public List<TestRecord> getTimeSortedTestRecords(int n, String string2) {
        List<Object> list = new ArrayList();
        if (string2 == null) {
            for (List<TestRecord> list2 : this.m_testRecords.values()) {
                list.addAll(list2);
            }
        } else {
            list = this.m_testRecords.get(string2);
        }
        Collections.sort(list);
        if (n > list.size()) {
            n = list.size();
        }
        return list.subList(0, n);
    }

    public long getTime() {
        return this.m_time;
    }

    public int getNumberOfBacktrackings() {
        return this.m_numberOfBacktrackings;
    }

    public int getNumberOfNodes() {
        return this.m_numberOfNodes;
    }

    public int getNumberOfBlockedNodes() {
        return this.m_numberOfBlockedNodes;
    }

    public String getTestDescription() {
        return this.m_reasoningTaskDescription.getTaskDescription(Prefixes.STANDARD_PREFIXES);
    }

    public boolean getTestResult() {
        return this.m_testResult;
    }

    public int getInitialModelSize() {
        return this.m_initialModelSize;
    }

    public int getInitiallyBlocked() {
        return this.m_initiallyBlocked;
    }

    public int getInitiallyInvalid() {
        return this.m_initiallyInvalid;
    }

    public int getNoValidations() {
        return this.m_noValidations;
    }

    public long getValidationTime() {
        return this.m_validationTime;
    }

    public long getOverallTime() {
        return this.m_overallTime;
    }

    public int getOverallNumberOfBacktrackings() {
        return this.m_overallNumberOfBacktrackings;
    }

    public int getOverallNumberOfNodes() {
        return this.m_overallNumberOfNodes;
    }

    public int getOverallNumberOfBlockedNodes() {
        return this.m_overallNumberOfBlockedNodes;
    }

    public int getOverallNumberOfTests() {
        return this.m_overallNumberOfTests;
    }

    public int getOverallNumberOfTests(ReasoningTaskDescription.StandardTestType standardTestType) {
        return this.m_testRecords.containsKey(standardTestType.messagePattern) ? this.m_testRecords.get(standardTestType.messagePattern).size() : 0;
    }

    public int getOverallNumberOfClashes() {
        return this.m_overallNumberOfClashes;
    }

    public int getNumberOfPossibleInstancesTested() {
        return this.m_possibleInstancesTested;
    }

    public int getNumberOfPossibleInstancesInstances() {
        return this.m_possibleInstancesInstances;
    }

    public int getOverallInitialModelSize() {
        return this.m_overallInitialModelSize;
    }

    public int getOverallInitiallyBlocked() {
        return this.m_overallInitiallyBlocked;
    }

    public int getOverallInitiallyInvalid() {
        return this.m_overallInitiallyInvalid;
    }

    public int getOverallNoValidations() {
        return this.m_overallNoValidations;
    }

    public long getOverallValidationTime() {
        return this.m_overallValidationTime;
    }

    public long getAverageTime() {
        if (this.m_testNo == 0) {
            return this.m_testNo;
        }
        return this.m_overallTime / (long)this.m_testNo;
    }

    public double getAverageNumberOfBacktrackings() {
        if (this.m_testNo == 0) {
            return this.m_testNo;
        }
        return this.getRounded(this.m_overallNumberOfBacktrackings, this.m_testNo);
    }

    protected double getRounded(long l, long l2) {
        return this.getRounded(l, l2, 2);
    }

    protected double getRounded(long l, long l2, int n) {
        double d = (double)l / (double)l2;
        int n2 = (int)(d * Math.pow(10.0, n));
        return (double)n2 / Math.pow(10.0, n);
    }

    public double getAverageNumberOfNodes() {
        if (this.m_testNo == 0) {
            return this.m_testNo;
        }
        return this.getRounded(this.m_overallNumberOfNodes, this.m_testNo);
    }

    public double getAverageNumberOfBlockedNodes() {
        if (this.m_testNo == 0) {
            return this.m_testNo;
        }
        return this.getRounded(this.m_overallNumberOfBlockedNodes, this.m_testNo);
    }

    public double getAverageNumberOfClashes() {
        if (this.m_testNo == 0) {
            return this.m_testNo;
        }
        return this.getRounded(this.m_overallNumberOfClashes, this.m_testNo);
    }

    public double getPossiblesToInstances() {
        if (this.m_possibleInstancesTested == 0) {
            return 0.0;
        }
        return this.getRounded(this.m_possibleInstancesInstances, this.m_possibleInstancesTested);
    }

    public double getAverageInitialModelSize() {
        if (this.m_testNo == 0) {
            return this.m_testNo;
        }
        return this.getRounded(this.m_overallInitialModelSize, this.m_testNo);
    }

    public double getAverageInitiallyBlocked() {
        if (this.m_testNo == 0) {
            return this.m_testNo;
        }
        return this.getRounded(this.m_overallInitiallyBlocked, this.m_testNo);
    }

    public double getAverageInitiallyInvalid() {
        if (this.m_testNo == 0) {
            return this.m_testNo;
        }
        return this.getRounded(this.m_overallInitiallyInvalid, this.m_testNo);
    }

    public double getAverageNoValidations() {
        if (this.m_testNo == 0) {
            return this.m_testNo;
        }
        return this.getRounded(this.m_overallNoValidations, this.m_testNo);
    }

    public long getAverageValidationTime() {
        if (this.m_testNo == 0) {
            return this.m_testNo;
        }
        return this.m_overallValidationTime / (long)this.m_testNo;
    }

    public static String millisToHoursMinutesSecondsString(long l) {
        long l2;
        long l3;
        long l4 = l / 1000L;
        long l5 = l4 % 1000L;
        String string2 = String.format(String.format("%%0%dd", 3), l5) + "ms";
        String string3 = String.format("%%0%dd", 2);
        long l6 = l4 % 60L;
        if (l6 > 0L) {
            string2 = String.format(string3, l6) + "s" + string2;
        }
        if ((l3 = l4 % 3600L / 60L) > 0L) {
            string2 = String.format(string3, l3) + "m" + string2;
        }
        if ((l2 = l4 / 3600L) > 0L) {
            string2 = String.format(string3, l2) + "h" + string2;
        }
        return string2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TestRecord
    implements Comparable<TestRecord>,
    Serializable {
        private static final long serialVersionUID = -3815493500625020183L;
        protected final long m_testTime;
        protected final String m_testDescription;
        protected final boolean m_testResult;

        public TestRecord(long l, String string2, boolean bl) {
            this.m_testTime = l;
            this.m_testDescription = string2;
            this.m_testResult = bl;
        }

        @Override
        public int compareTo(TestRecord testRecord) {
            if (this == testRecord) {
                return 0;
            }
            int n = Long.valueOf(testRecord.m_testTime).compareTo(this.m_testTime);
            if (n != 0) {
                return n;
            }
            return this.m_testDescription.compareToIgnoreCase(testRecord.m_testDescription);
        }

        public long getTestTime() {
            return this.m_testTime;
        }

        public String getTestDescription() {
            return this.m_testDescription;
        }

        public boolean getTestResult() {
            return this.m_testResult;
        }

        public String toString() {
            return this.m_testTime + " ms" + (this.m_testTime > 1000L ? " (" + CountingMonitor.millisToHoursMinutesSecondsString(this.m_testTime) + ")" : "") + " for " + this.m_testDescription + " (result: " + this.m_testResult + ")";
        }
    }
}

