/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.monitor;

import java.io.PrintWriter;
import org.semanticweb.HermiT.Prefixes;
import org.semanticweb.HermiT.monitor.TableauMonitorAdapter;
import org.semanticweb.HermiT.tableau.BranchingPoint;
import org.semanticweb.HermiT.tableau.ReasoningTaskDescription;

public class Timer
extends TableauMonitorAdapter {
    private static final long serialVersionUID = -8144444618897251350L;
    protected transient PrintWriter m_output;
    protected long m_problemStartTime;
    protected long m_lastStatusTime;
    protected int m_numberOfBacktrackings;
    protected int m_testNumber = 0;

    public Timer() {
        this.m_output = new PrintWriter(System.out);
    }

    public Timer(PrintWriter printWriter) {
        this.m_output = printWriter;
    }

    protected Object readResolve() {
        this.m_output = new PrintWriter(System.out);
        return this;
    }

    protected void start() {
        this.m_numberOfBacktrackings = 0;
        this.m_lastStatusTime = this.m_problemStartTime = System.currentTimeMillis();
    }

    public void isSatisfiableStarted(ReasoningTaskDescription reasoningTaskDescription) {
        this.m_output.print(reasoningTaskDescription.getTaskDescription(Prefixes.STANDARD_PREFIXES) + " ...");
        this.m_output.flush();
        this.start();
    }

    public void isSatisfiableFinished(ReasoningTaskDescription reasoningTaskDescription, boolean bl) {
        if (reasoningTaskDescription.flipSatisfiabilityResult()) {
            bl = !bl;
        }
        this.m_output.println(bl ? "YES" : "NO");
        this.doStatistics();
    }

    public void iterationStarted() {
        if (System.currentTimeMillis() - this.m_lastStatusTime > 30000L) {
            if (this.m_lastStatusTime == this.m_problemStartTime) {
                this.m_output.println();
            }
            this.doStatistics();
            this.m_lastStatusTime = System.currentTimeMillis();
        }
    }

    public void saturateStarted() {
        ++this.m_testNumber;
    }

    public void backtrackToFinished(BranchingPoint branchingPoint) {
        ++this.m_numberOfBacktrackings;
    }

    protected void doStatistics() {
        long l = System.currentTimeMillis() - this.m_problemStartTime;
        this.m_output.print("    Test:   ");
        this.printPadded(this.m_testNumber, 7);
        this.m_output.print("  Duration:  ");
        this.printPaddedMS(l, 7);
        this.m_output.print("   Current branching point: ");
        this.printPadded(this.m_tableau.getCurrentBranchingPointLevel(), 7);
        if (this.m_numberOfBacktrackings > 0) {
            this.m_output.print("    Backtrackings: ");
            this.m_output.print(this.m_numberOfBacktrackings);
        }
        this.m_output.println();
        this.m_output.print("    Nodes:  allocated:    ");
        this.printPadded(this.m_tableau.getNumberOfAllocatedNodes(), 7);
        this.m_output.print("    used: ");
        this.printPadded(this.m_tableau.getNumberOfNodeCreations(), 7);
        this.m_output.print("    in tableau: ");
        this.printPadded(this.m_tableau.getNumberOfNodesInTableau(), 7);
        if (this.m_tableau.getNumberOfMergedOrPrunedNodes() > 0) {
            this.m_output.print("    merged/pruned: ");
            this.m_output.print(this.m_tableau.getNumberOfMergedOrPrunedNodes());
        }
        this.m_output.println();
        this.m_output.print("    Sizes:  binary table: ");
        this.printPaddedKB(this.m_tableau.getExtensionManager().getBinaryExtensionTable().sizeInMemory() / 1000, 7);
        this.m_output.print("    ternary table: ");
        this.printPaddedKB(this.m_tableau.getExtensionManager().getTernaryExtensionTable().sizeInMemory() / 1000, 7);
        this.m_output.print("    dependency set factory: ");
        this.printPaddedKB(this.m_tableau.getDependencySetFactory().sizeInMemory() / 1000, 7);
        this.m_output.println();
        this.m_output.println();
        this.m_output.flush();
    }

    protected void printPadded(int n, int n2) {
        String string2 = String.valueOf(n);
        this.m_output.print(string2);
        for (int i = string2.length(); i < n2; ++i) {
            this.m_output.print(' ');
        }
    }

    protected void printPaddedMS(long l, int n) {
        String string2 = String.valueOf(l) + " ms";
        this.m_output.print(string2);
        for (int i = string2.length(); i < n; ++i) {
            this.m_output.print(' ');
        }
    }

    protected void printPaddedKB(int n, int n2) {
        String string2 = String.valueOf(n) + " kb";
        this.m_output.print(string2);
        for (int i = string2.length(); i < n2; ++i) {
            this.m_output.print(' ');
        }
    }
}

