/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.structural;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.semanticweb.HermiT.graph.Graph;
import org.semanticweb.HermiT.structural.OWLAxioms;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLIndividualAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectCardinalityRestriction;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import rationals.Automaton;
import rationals.NoSuchStateException;
import rationals.State;
import rationals.Transition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectPropertyInclusionManager {
    protected final Map<OWLObjectPropertyExpression, Automaton> m_automataByProperty = new HashMap<OWLObjectPropertyExpression, Automaton>();

    public ObjectPropertyInclusionManager(OWLAxioms oWLAxioms) {
        this.createAutomata(this.m_automataByProperty, oWLAxioms.m_complexObjectPropertyExpressions, oWLAxioms.m_simpleObjectPropertyInclusions, oWLAxioms.m_complexObjectPropertyInclusions);
    }

    public int rewriteNegativeObjectPropertyAssertions(OWLDataFactory oWLDataFactory, OWLAxioms oWLAxioms, int n) {
        HashSet<OWLNegativeObjectPropertyAssertionAxiom> hashSet = new HashSet<OWLNegativeObjectPropertyAssertionAxiom>();
        HashSet<OWLClassAssertionAxiom> hashSet2 = new HashSet<OWLClassAssertionAxiom>();
        for (OWLIndividualAxiom oWLIndividualAxiom : oWLAxioms.m_facts) {
            OWLNegativeObjectPropertyAssertionAxiom oWLNegativeObjectPropertyAssertionAxiom;
            OWLObjectPropertyExpression oWLObjectPropertyExpression;
            if (!(oWLIndividualAxiom instanceof OWLNegativeObjectPropertyAssertionAxiom) || !oWLAxioms.m_complexObjectPropertyExpressions.contains(oWLObjectPropertyExpression = ((OWLObjectPropertyExpression)(oWLNegativeObjectPropertyAssertionAxiom = (OWLNegativeObjectPropertyAssertionAxiom)oWLIndividualAxiom).getProperty()).getSimplified())) continue;
            OWLIndividual oWLIndividual = (OWLIndividual)oWLNegativeObjectPropertyAssertionAxiom.getObject();
            OWLClass oWLClass = oWLDataFactory.getOWLClass(IRI.create("internal:nom#" + oWLIndividual.asOWLNamedIndividual().getIRI().toString()));
            OWLObjectComplementOf oWLObjectComplementOf = oWLDataFactory.getOWLObjectComplementOf(oWLClass);
            OWLObjectAllValuesFrom oWLObjectAllValuesFrom = oWLDataFactory.getOWLObjectAllValuesFrom(oWLObjectPropertyExpression, oWLObjectComplementOf);
            OWLClass oWLClass2 = oWLDataFactory.getOWLClass(IRI.create("internal:def#" + n++));
            oWLAxioms.m_conceptInclusions.add(new OWLClassExpression[]{oWLDataFactory.getOWLObjectComplementOf(oWLClass2), oWLObjectAllValuesFrom});
            hashSet2.add(oWLDataFactory.getOWLClassAssertionAxiom(oWLClass2, oWLNegativeObjectPropertyAssertionAxiom.getSubject()));
            hashSet2.add(oWLDataFactory.getOWLClassAssertionAxiom(oWLClass, oWLIndividual));
            hashSet.add(oWLNegativeObjectPropertyAssertionAxiom);
        }
        oWLAxioms.m_facts.addAll(hashSet2);
        oWLAxioms.m_facts.removeAll(hashSet);
        return n;
    }

    public void rewriteAxioms(OWLDataFactory oWLDataFactory, OWLAxioms oWLAxioms, int n) {
        Object object4;
        Object object2;
        Serializable serializable;
        for (OWLObjectPropertyExpression object3 : oWLAxioms.m_asymmetricObjectProperties) {
            if (!oWLAxioms.m_complexObjectPropertyExpressions.contains(object3)) continue;
            throw new IllegalArgumentException("Non-simple property '" + object3 + "' or its inverse appears in asymmetric object property axiom.");
        }
        for (OWLObjectPropertyExpression oWLObjectPropertyExpression : oWLAxioms.m_irreflexiveObjectProperties) {
            if (!oWLAxioms.m_complexObjectPropertyExpressions.contains(oWLObjectPropertyExpression)) continue;
            throw new IllegalArgumentException("Non-simple property '" + oWLObjectPropertyExpression + "' or its inverse appears in irreflexive object property axiom.");
        }
        for (OWLObjectPropertyExpression[] oWLObjectPropertyExpressionArray : oWLAxioms.m_disjointObjectProperties) {
            for (int i = 0; i < oWLObjectPropertyExpressionArray.length; ++i) {
                if (!oWLAxioms.m_complexObjectPropertyExpressions.contains(oWLObjectPropertyExpressionArray[i])) continue;
                throw new IllegalArgumentException("Non-simple property '" + oWLObjectPropertyExpressionArray[i] + "' or its inverse appears in disjoint properties axiom.");
            }
        }
        HashMap hashMap = new HashMap();
        for (OWLClassExpression[] oWLClassExpressionArray : oWLAxioms.m_conceptInclusions) {
            for (int i = 0; i < oWLClassExpressionArray.length; ++i) {
                OWLClassExpression oWLClassExpression = oWLClassExpressionArray[i];
                if (oWLClassExpression instanceof OWLObjectCardinalityRestriction) {
                    serializable = (OWLObjectCardinalityRestriction)oWLClassExpression;
                    object2 = (OWLObjectPropertyExpression)serializable.getProperty();
                    if (oWLAxioms.m_complexObjectPropertyExpressions.contains(object2)) {
                        throw new IllegalArgumentException("Non-simple property '" + object2 + "' or its inverse appears in the cardinality restriction '" + serializable + "'.");
                    }
                } else if (oWLClassExpression instanceof OWLObjectHasSelf && oWLAxioms.m_complexObjectPropertyExpressions.contains((serializable = (OWLObjectHasSelf)oWLClassExpression).getProperty())) {
                    throw new IllegalArgumentException("Non-simple property '" + serializable.getProperty() + "' or its inverse appears in the Self restriction '" + serializable + "'.");
                }
                if (!(oWLClassExpression instanceof OWLObjectAllValuesFrom) || ((OWLClassExpression)(serializable = (OWLObjectAllValuesFrom)oWLClassExpression).getFiller()).equals(oWLDataFactory.getOWLThing()) || !this.m_automataByProperty.containsKey(object2 = (OWLObjectPropertyExpression)serializable.getProperty())) continue;
                object4 = (OWLClassExpression)hashMap.get(serializable);
                if (object4 == null) {
                    object4 = oWLDataFactory.getOWLClass(IRI.create("internal:all#" + n++));
                    if (serializable.getFiller() instanceof OWLObjectComplementOf || ((OWLClassExpression)serializable.getFiller()).equals(oWLDataFactory.getOWLNothing())) {
                        object4 = object4.getComplementNNF();
                    }
                    hashMap.put(serializable, object4);
                }
                oWLClassExpressionArray[i] = object4;
            }
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            OWLClassExpression oWLClassExpression;
            Object object3;
            Automaton automaton = this.m_automataByProperty.get(((OWLObjectAllValuesFrom)entry.getKey()).getProperty());
            boolean bl = entry.getValue() instanceof OWLObjectComplementOf;
            serializable = new HashMap();
            for (Object object4 : automaton.states()) {
                object3 = (State)object4;
                if (object3.isInitial()) {
                    serializable.put(object3, entry.getValue());
                    continue;
                }
                oWLClassExpression = oWLDataFactory.getOWLClass(IRI.create("internal:all#" + n++));
                if (bl) {
                    oWLClassExpression = oWLClassExpression.getComplementNNF();
                }
                serializable.put(object3, oWLClassExpression);
            }
            for (Object object4 : automaton.delta()) {
                object3 = (Transition)object4;
                oWLClassExpression = ((OWLClassExpression)serializable.get(((Transition)object3).start())).getComplementNNF();
                OWLClassExpression oWLClassExpression2 = (OWLClassExpression)serializable.get(((Transition)object3).end());
                if (((Transition)object3).label() == null) {
                    oWLAxioms.m_conceptInclusions.add(new OWLClassExpression[]{oWLClassExpression, oWLClassExpression2});
                    continue;
                }
                OWLObjectAllValuesFrom oWLObjectAllValuesFrom = oWLDataFactory.getOWLObjectAllValuesFrom((OWLObjectPropertyExpression)((Transition)object3).label(), oWLClassExpression2);
                oWLAxioms.m_conceptInclusions.add(new OWLClassExpression[]{oWLClassExpression, oWLObjectAllValuesFrom});
            }
            object2 = (OWLClassExpression)((OWLObjectAllValuesFrom)entry.getKey()).getFiller();
            object4 = automaton.terminals().iterator();
            while (object4.hasNext()) {
                object3 = object4.next();
                oWLClassExpression = ((OWLClassExpression)serializable.get(object3)).getComplementNNF();
                if (object2.isOWLNothing()) {
                    oWLAxioms.m_conceptInclusions.add(new OWLClassExpression[]{oWLClassExpression});
                    continue;
                }
                oWLAxioms.m_conceptInclusions.add(new OWLClassExpression[]{oWLClassExpression, object2});
            }
        }
    }

    protected void createAutomata(Map<OWLObjectPropertyExpression, Automaton> map2, Set<OWLObjectPropertyExpression> set2, Collection<OWLObjectPropertyExpression[]> collection, Collection<OWLAxioms.ComplexObjectPropertyInclusion> collection2) {
        Map<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>> map3 = this.findEquivalentProperties(collection);
        Set<OWLObjectPropertyExpression> set3 = this.findSymmetricProperties(collection);
        Map<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>> map4 = this.buildInversePropertiesMap(collection);
        Graph<OWLObjectPropertyExpression> graph = this.buildPropertyOrdering(collection, collection2, map3);
        this.checkForRegularity(graph, map3);
        Object object = graph.clone();
        HashSet<OWLObjectPropertyExpression> hashSet = new HashSet<OWLObjectPropertyExpression>();
        Map<OWLObjectPropertyExpression, Automaton> map5 = this.buildIndividualAutomata((Graph<OWLObjectPropertyExpression>)object, collection, collection2, map3, hashSet);
        Set<OWLObjectPropertyExpression> set4 = this.findSimpleProperties((Graph<OWLObjectPropertyExpression>)object, map5);
        graph.removeElements(set4);
        ((Graph)object).removeElements(set4);
        set2.addAll(((Graph)object).getElements());
        HashSet<OWLObjectPropertyExpression> hashSet2 = new HashSet<OWLObjectPropertyExpression>();
        for (OWLObjectPropertyExpression object2 : set2) {
            hashSet2.add(object2.getInverseProperty().getSimplified());
        }
        set2.addAll(hashSet2);
        this.connectAllAutomata(map2, graph, map4, map5, collection, set3, hashSet);
        HashMap hashMap = new HashMap();
        for (OWLObjectPropertyExpression oWLObjectPropertyExpression : map2.keySet()) {
            if (map3.get(oWLObjectPropertyExpression) == null) continue;
            Automaton automaton = map2.get(oWLObjectPropertyExpression);
            for (OWLObjectPropertyExpression oWLObjectPropertyExpression2 : map3.get(oWLObjectPropertyExpression)) {
                if (oWLObjectPropertyExpression2.equals(oWLObjectPropertyExpression) || map2.containsKey(oWLObjectPropertyExpression2)) continue;
                Automaton automaton2 = (Automaton)automaton.clone();
                hashMap.put(oWLObjectPropertyExpression2, automaton2);
                set4.remove(oWLObjectPropertyExpression2);
                set2.add(oWLObjectPropertyExpression2);
            }
        }
        map2.putAll(hashMap);
    }

    private Set<OWLObjectPropertyExpression> findSymmetricProperties(Collection<OWLObjectPropertyExpression[]> collection) {
        HashSet<OWLObjectPropertyExpression> hashSet = new HashSet<OWLObjectPropertyExpression>();
        for (OWLObjectPropertyExpression[] oWLObjectPropertyExpressionArray : collection) {
            if (!oWLObjectPropertyExpressionArray[1].getInverseProperty().getSimplified().equals(oWLObjectPropertyExpressionArray[0]) && !oWLObjectPropertyExpressionArray[1].equals(oWLObjectPropertyExpressionArray[0].getInverseProperty().getSimplified())) continue;
            hashSet.add(oWLObjectPropertyExpressionArray[0]);
            hashSet.add(oWLObjectPropertyExpressionArray[0].getInverseProperty().getSimplified());
        }
        return hashSet;
    }

    protected Map<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>> buildInversePropertiesMap(Collection<OWLObjectPropertyExpression[]> collection) {
        HashMap<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>> hashMap = new HashMap<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>>();
        for (OWLObjectPropertyExpression[] oWLObjectPropertyExpressionArray : collection) {
            if (!(oWLObjectPropertyExpressionArray[1] instanceof OWLObjectInverseOf)) continue;
            HashSet<OWLObjectPropertyExpression> hashSet = (HashSet<OWLObjectPropertyExpression>)hashMap.get(oWLObjectPropertyExpressionArray[0]);
            if (hashSet == null) {
                hashSet = new HashSet<OWLObjectPropertyExpression>();
            }
            hashSet.add(oWLObjectPropertyExpressionArray[1].getInverseProperty().getSimplified());
            hashMap.put(oWLObjectPropertyExpressionArray[0], hashSet);
        }
        return hashMap;
    }

    protected Map<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>> findEquivalentProperties(Collection<OWLObjectPropertyExpression[]> collection) {
        Graph<OWLObjectPropertyExpression> graph = new Graph<OWLObjectPropertyExpression>();
        HashMap<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>> hashMap = new HashMap<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>>();
        for (OWLObjectPropertyExpression[] object : collection) {
            if (object[0].equals(object[1]) || object[0].equals(object[1].getInverseProperty().getSimplified())) continue;
            graph.addEdge(object[0], object[1]);
        }
        graph.transitivelyClose();
        for (OWLObjectPropertyExpression oWLObjectPropertyExpression : graph.getElements()) {
            if (!graph.getSuccessors(oWLObjectPropertyExpression).contains(oWLObjectPropertyExpression) && !graph.getSuccessors(oWLObjectPropertyExpression).contains(oWLObjectPropertyExpression.getInverseProperty().getSimplified())) continue;
            HashSet<OWLObjectPropertyExpression> hashSet = new HashSet<OWLObjectPropertyExpression>();
            for (OWLObjectPropertyExpression oWLObjectPropertyExpression2 : graph.getSuccessors(oWLObjectPropertyExpression)) {
                if (oWLObjectPropertyExpression2.equals(oWLObjectPropertyExpression) || !graph.getSuccessors(oWLObjectPropertyExpression2).contains(oWLObjectPropertyExpression) && !graph.getSuccessors(oWLObjectPropertyExpression2).contains(oWLObjectPropertyExpression.getInverseProperty().getSimplified())) continue;
                hashSet.add(oWLObjectPropertyExpression2);
            }
            hashMap.put(oWLObjectPropertyExpression, hashSet);
        }
        return hashMap;
    }

    protected Set<OWLObjectPropertyExpression> findSimpleProperties(Graph<OWLObjectPropertyExpression> graph, Map<OWLObjectPropertyExpression, Automaton> map2) {
        HashSet<OWLObjectPropertyExpression> hashSet = new HashSet<OWLObjectPropertyExpression>();
        Object object = graph.clone();
        for (OWLObjectPropertyExpression object2 : graph.getElements()) {
            for (OWLObjectPropertyExpression bl : graph.getSuccessors(object2)) {
                ((Graph)object).addEdge(object2.getInverseProperty().getSimplified(), bl.getInverseProperty().getSimplified());
            }
        }
        Graph graph2 = ((Graph)object).getInverse();
        graph2.transitivelyClose();
        for (Object object2 : graph2.getElements()) {
            boolean bl = false;
            for (OWLObjectPropertyExpression oWLObjectPropertyExpression : graph2.getSuccessors(object2)) {
                if (!map2.containsKey(oWLObjectPropertyExpression) && !map2.containsKey(oWLObjectPropertyExpression.getInverseProperty().getSimplified())) continue;
                bl = true;
                break;
            }
            if (bl || map2.containsKey(object2) || map2.containsKey(object2.getInverseProperty().getSimplified())) continue;
            hashSet.add((OWLObjectPropertyExpression)object2);
        }
        return hashSet;
    }

    protected void connectAllAutomata(Map<OWLObjectPropertyExpression, Automaton> map2, Graph<OWLObjectPropertyExpression> graph, Map<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>> map3, Map<OWLObjectPropertyExpression, Automaton> map4, Collection<OWLObjectPropertyExpression[]> collection, Set<OWLObjectPropertyExpression> set2, Set<OWLObjectPropertyExpression> set3) {
        Object object32;
        Object object2 = graph.clone();
        ((Graph)object2).transitivelyClose();
        HashSet<Iterator<OWLObjectPropertyExpression>> hashSet = new HashSet<Iterator<OWLObjectPropertyExpression>>();
        for (Object object32 : ((Graph)object2).getElements()) {
            if (!((Graph)object2).getSuccessors(object32).isEmpty()) continue;
            hashSet.add((Iterator<OWLObjectPropertyExpression>)object32);
        }
        Graph<OWLObjectPropertyExpression> graph2 = graph.getInverse();
        for (OWLObjectPropertyExpression object4 : hashSet) {
            this.buildCompleteAutomataForProperties(object4, map3, map4, map2, graph2, set2, set3);
        }
        for (OWLObjectPropertyExpression oWLObjectPropertyExpression : map4.keySet()) {
            if (map2.containsKey(oWLObjectPropertyExpression)) continue;
            Automaton automaton = map4.get(oWLObjectPropertyExpression);
            if (map2.containsKey(oWLObjectPropertyExpression.getInverseProperty().getSimplified()) && graph2.getElements().contains(oWLObjectPropertyExpression.getInverseProperty().getSimplified()) || map4.containsKey(oWLObjectPropertyExpression.getInverseProperty().getSimplified())) {
                Automaton automaton2 = map2.get(oWLObjectPropertyExpression.getInverseProperty().getSimplified());
                if (automaton2 == null) {
                    automaton2 = map4.get(oWLObjectPropertyExpression.getInverseProperty().getSimplified());
                }
                this.increaseAutomatonWithInversePropertyAutomaton(automaton, automaton2);
            }
            map2.put(oWLObjectPropertyExpression, automaton);
        }
        object32 = new HashMap();
        for (OWLObjectPropertyExpression oWLObjectPropertyExpression : map2.keySet()) {
            if (map2.containsKey(oWLObjectPropertyExpression.getInverseProperty().getSimplified())) continue;
            object32.put(oWLObjectPropertyExpression.getInverseProperty().getSimplified(), this.getMirroredCopy(map2.get(oWLObjectPropertyExpression)));
        }
        map2.putAll((Map<OWLObjectPropertyExpression, Automaton>)object32);
        object32.clear();
        for (OWLObjectPropertyExpression oWLObjectPropertyExpression : map2.keySet()) {
            if (!map2.containsKey(oWLObjectPropertyExpression) || map2.containsKey(oWLObjectPropertyExpression.getInverseProperty().getSimplified())) continue;
            object32.put(oWLObjectPropertyExpression.getInverseProperty().getSimplified(), this.getMirroredCopy(map2.get(oWLObjectPropertyExpression)));
        }
        map2.putAll((Map<OWLObjectPropertyExpression, Automaton>)object32);
        object32.clear();
    }

    protected void increaseAutomatonWithInversePropertyAutomaton(Automaton automaton, Automaton automaton2) {
        State state = (State)automaton.initials().iterator().next();
        State state2 = (State)automaton.terminals().iterator().next();
        Transition transition = (Transition)automaton.deltaFrom(state, state2).iterator().next();
        this.automataConnector(automaton, this.getMirroredCopy(automaton2), transition);
    }

    protected Automaton buildCompleteAutomataForProperties(OWLObjectPropertyExpression oWLObjectPropertyExpression, Map<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>> map2, Map<OWLObjectPropertyExpression, Automaton> map3, Map<OWLObjectPropertyExpression, Automaton> map4, Graph<OWLObjectPropertyExpression> graph, Set<OWLObjectPropertyExpression> set2, Set<OWLObjectPropertyExpression> set3) {
        Object object;
        if (map4.containsKey(oWLObjectPropertyExpression)) {
            return map4.get(oWLObjectPropertyExpression);
        }
        if (map4.containsKey(oWLObjectPropertyExpression.getInverseProperty().getSimplified()) && !map3.containsKey(oWLObjectPropertyExpression)) {
            Automaton automaton = this.getMirroredCopy(map4.get(oWLObjectPropertyExpression.getInverseProperty().getSimplified()));
            map4.put(oWLObjectPropertyExpression, automaton);
            return automaton;
        }
        if (graph.getSuccessors(oWLObjectPropertyExpression).isEmpty()) {
            Automaton automaton = map3.get(oWLObjectPropertyExpression);
            if (automaton == null) {
                Set<OWLObjectPropertyExpression> set4 = map2.get(oWLObjectPropertyExpression);
                boolean bl = true;
                if (set4 != null) {
                    for (OWLObjectPropertyExpression object2 : set4) {
                        if (!map3.containsKey(object2) || object2.equals(oWLObjectPropertyExpression)) continue;
                        automaton = this.getMirroredCopy(this.buildCompleteAutomataForProperties(object2, map2, map3, map4, graph, set2, set3));
                        automaton = this.minimizeAndNormalizeAutomaton(automaton);
                        map4.put(oWLObjectPropertyExpression, automaton);
                        bl = false;
                        break;
                    }
                } else if (map3.containsKey(oWLObjectPropertyExpression.getInverseProperty().getSimplified())) {
                    automaton = this.getMirroredCopy(this.buildCompleteAutomataForProperties(oWLObjectPropertyExpression.getInverseProperty().getSimplified(), map2, map3, map4, graph, set2, set3));
                    if (!map4.containsKey(oWLObjectPropertyExpression)) {
                        automaton = this.minimizeAndNormalizeAutomaton(automaton);
                        map4.put(oWLObjectPropertyExpression, automaton);
                    } else {
                        automaton = map4.get(oWLObjectPropertyExpression);
                    }
                    bl = false;
                }
                if (bl) {
                    automaton = new Automaton();
                    State state = automaton.addState(true, false);
                    State noSuchStateException = automaton.addState(false, true);
                    try {
                        automaton.addTransition(new Transition(state, oWLObjectPropertyExpression, noSuchStateException));
                    }
                    catch (NoSuchStateException noSuchStateException2) {
                        throw new IllegalArgumentException("Could not create automaton for property at the bottom of hierarchy (simple property).");
                    }
                    this.finalizeConstruction(map4, oWLObjectPropertyExpression, automaton, set2, set3);
                }
            } else if (oWLObjectPropertyExpression.getInverseProperty().getSimplified().isAnonymous() && map3.containsKey(oWLObjectPropertyExpression.getInverseProperty().getSimplified())) {
                Automaton automaton2 = this.buildCompleteAutomataForProperties(oWLObjectPropertyExpression.getInverseProperty().getSimplified(), map2, map3, map4, graph, set2, set3);
                this.increaseAutomatonWithInversePropertyAutomaton(automaton, this.getMirroredCopy(automaton2));
                if (!map4.containsKey(oWLObjectPropertyExpression)) {
                    this.finalizeConstruction(map4, oWLObjectPropertyExpression, automaton, set2, set3);
                } else {
                    automaton = map4.get(oWLObjectPropertyExpression);
                }
            } else {
                this.increaseWithDefinedInverseIfNecessary(oWLObjectPropertyExpression, automaton, map2, map3);
                this.finalizeConstruction(map4, oWLObjectPropertyExpression, automaton, set2, set3);
            }
            return automaton;
        }
        Automaton automaton = map3.get(oWLObjectPropertyExpression);
        if (automaton == null) {
            automaton = new Automaton();
            object = automaton.addState(true, false);
            State state = automaton.addState(false, true);
            Transition transition = new Transition((State)object, oWLObjectPropertyExpression, state);
            try {
                automaton.addTransition(transition);
            }
            catch (NoSuchStateException automaton4) {
                throw new IllegalArgumentException("Could not create automaton");
            }
            for (OWLObjectPropertyExpression oWLObjectPropertyExpression2 : graph.getSuccessors(oWLObjectPropertyExpression)) {
                Automaton automaton2 = this.buildCompleteAutomataForProperties(oWLObjectPropertyExpression2, map2, map3, map4, graph, set2, set3);
                this.automataConnector(automaton, automaton2, transition);
                try {
                    automaton.addTransition(new Transition((State)object, oWLObjectPropertyExpression2, state));
                }
                catch (NoSuchStateException noSuchStateException) {
                    throw new IllegalArgumentException("Could not create automaton");
                }
            }
            if (oWLObjectPropertyExpression.getInverseProperty().getSimplified().isAnonymous() && map3.containsKey(oWLObjectPropertyExpression.getInverseProperty().getSimplified())) {
                Automaton automaton3 = this.buildCompleteAutomataForProperties(oWLObjectPropertyExpression.getInverseProperty().getSimplified(), map2, map3, map4, graph, set2, set3);
                this.increaseAutomatonWithInversePropertyAutomaton(automaton, this.getMirroredCopy(automaton3));
                if (!map4.containsKey(oWLObjectPropertyExpression)) {
                    this.finalizeConstruction(map4, oWLObjectPropertyExpression, automaton, set2, set3);
                } else {
                    automaton = map4.get(oWLObjectPropertyExpression);
                }
            } else {
                this.increaseWithDefinedInverseIfNecessary(oWLObjectPropertyExpression, automaton, map2, map3);
                if (!map4.containsKey(oWLObjectPropertyExpression)) {
                    this.finalizeConstruction(map4, oWLObjectPropertyExpression, automaton, set2, set3);
                } else {
                    automaton = map4.get(oWLObjectPropertyExpression);
                }
            }
        } else {
            for (OWLObjectPropertyExpression oWLObjectPropertyExpression3 : graph.getSuccessors(oWLObjectPropertyExpression)) {
                Object object22;
                boolean bl = false;
                for (Object object22 : automaton.delta()) {
                    Transition transition = (Transition)object22;
                    if (transition.label() == null || !transition.label().equals(oWLObjectPropertyExpression3)) continue;
                    Automaton automaton4 = this.buildCompleteAutomataForProperties(oWLObjectPropertyExpression3, map2, map3, map4, graph, set2, set3);
                    if (automaton4.delta().size() != 1) {
                        this.automataConnector(automaton, automaton4, transition);
                    }
                    bl = true;
                }
                if (bl) continue;
                Automaton automaton5 = this.buildCompleteAutomataForProperties(oWLObjectPropertyExpression3, map2, map3, map4, graph, set2, set3);
                object22 = (Transition)automaton.deltaFrom((State)automaton.initials().iterator().next(), (State)automaton.terminals().iterator().next()).iterator().next();
                this.automataConnector(automaton, automaton5, (Transition)object22);
            }
        }
        if (oWLObjectPropertyExpression.getInverseProperty().getSimplified().isAnonymous() && map3.containsKey(oWLObjectPropertyExpression.getInverseProperty().getSimplified())) {
            object = this.buildCompleteAutomataForProperties(oWLObjectPropertyExpression.getInverseProperty().getSimplified(), map2, map3, map4, graph, set2, set3);
            this.increaseAutomatonWithInversePropertyAutomaton(automaton, this.getMirroredCopy((Automaton)object));
            if (!map4.containsKey(oWLObjectPropertyExpression)) {
                this.finalizeConstruction(map4, oWLObjectPropertyExpression, automaton, set2, set3);
            } else {
                automaton = map4.get(oWLObjectPropertyExpression);
            }
        } else {
            this.increaseWithDefinedInverseIfNecessary(oWLObjectPropertyExpression, automaton, map2, map3);
            if (!map4.containsKey(oWLObjectPropertyExpression)) {
                this.finalizeConstruction(map4, oWLObjectPropertyExpression, automaton, set2, set3);
            } else {
                automaton = map4.get(oWLObjectPropertyExpression);
            }
        }
        return automaton;
    }

    private void finalizeConstruction(Map<OWLObjectPropertyExpression, Automaton> map2, OWLObjectPropertyExpression oWLObjectPropertyExpression, Automaton automaton, Set<OWLObjectPropertyExpression> set2, Set<OWLObjectPropertyExpression> set3) {
        try {
            if (set3.contains(oWLObjectPropertyExpression.getInverseProperty().getSimplified())) {
                automaton.addTransition(new Transition((State)automaton.terminals().iterator().next(), null, (State)automaton.initials().iterator().next()));
            }
        }
        catch (NoSuchStateException noSuchStateException) {
            throw new IllegalArgumentException("Could not create automaton for symmetric property: " + oWLObjectPropertyExpression);
        }
        if (set2.contains(oWLObjectPropertyExpression)) {
            Transition transition = new Transition((State)automaton.initials().iterator().next(), oWLObjectPropertyExpression.getInverseProperty().getSimplified(), (State)automaton.terminals().iterator().next());
            this.automataConnector(automaton, this.getMirroredCopy(automaton), transition);
        }
        automaton = this.minimizeAndNormalizeAutomaton(automaton);
        map2.put(oWLObjectPropertyExpression, automaton);
        map2.put(oWLObjectPropertyExpression.getInverseProperty().getSimplified(), this.getMirroredCopy(automaton));
    }

    protected void increaseWithDefinedInverseIfNecessary(OWLObjectPropertyExpression oWLObjectPropertyExpression, Automaton automaton, Map<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>> map2, Map<OWLObjectPropertyExpression, Automaton> map3) {
        Set<OWLObjectPropertyExpression> set2 = map2.get(oWLObjectPropertyExpression);
        if (set2 != null) {
            Automaton automaton2 = null;
            for (OWLObjectPropertyExpression oWLObjectPropertyExpression2 : set2) {
                if (!map3.containsKey(oWLObjectPropertyExpression2) || oWLObjectPropertyExpression2.equals(oWLObjectPropertyExpression)) continue;
                automaton2 = map3.get(oWLObjectPropertyExpression2);
                this.increaseAutomatonWithInversePropertyAutomaton(automaton, automaton2);
            }
        } else if (map3.containsKey(oWLObjectPropertyExpression.getInverseProperty().getSimplified())) {
            Automaton automaton3 = map3.get(oWLObjectPropertyExpression.getInverseProperty().getSimplified());
            this.increaseAutomatonWithInversePropertyAutomaton(automaton, automaton3);
        }
    }

    protected Automaton minimizeAndNormalizeAutomaton(Automaton automaton) {
        return automaton;
    }

    protected void useStandardAutomataConnector(Automaton automaton, Automaton automaton2, Transition transition) {
        Map<State, State> map2 = this.getDisjointUnion(automaton, automaton2);
        State state = transition.start();
        State state2 = transition.end();
        State state3 = map2.get(automaton2.initials().iterator().next());
        State state4 = map2.get(automaton2.terminals().iterator().next());
        try {
            automaton.addTransition(new Transition(state, null, state3));
            automaton.addTransition(new Transition(state4, null, state2));
        }
        catch (NoSuchStateException noSuchStateException) {
            throw new IllegalArgumentException("Could not build the Complete Automata of non-Simple Properties");
        }
    }

    protected void automataConnector(Automaton automaton, Automaton automaton2, Transition transition) {
        this.useStandardAutomataConnector(automaton, automaton2, transition);
    }

    protected Set<Transition> deltaToState(Automaton automaton, State state) {
        HashSet<Transition> hashSet = new HashSet<Transition>();
        for (Object e2 : automaton.delta()) {
            Transition transition = (Transition)e2;
            if (!transition.end().equals(state)) continue;
            hashSet.add(transition);
        }
        return hashSet;
    }

    protected Graph<OWLObjectPropertyExpression> buildPropertyOrdering(Collection<OWLObjectPropertyExpression[]> collection, Collection<OWLAxioms.ComplexObjectPropertyInclusion> collection2, Map<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>> map2) {
        Graph<OWLObjectPropertyExpression> graph = new Graph<OWLObjectPropertyExpression>();
        for (OWLObjectPropertyExpression[] object : collection) {
            if (object[0].equals(object[1]) || object[0].equals(object[1].getInverseProperty().getSimplified()) || map2.get(object[0]) != null && map2.get(object[0]).contains(object[1])) continue;
            graph.addEdge(object[0], object[1]);
        }
        for (OWLAxioms.ComplexObjectPropertyInclusion complexObjectPropertyInclusion : collection2) {
            OWLObjectPropertyExpression oWLObjectPropertyExpression = complexObjectPropertyInclusion.m_superObjectProperty;
            OWLObjectPropertyExpression oWLObjectPropertyExpression2 = null;
            OWLObjectPropertyExpression[] oWLObjectPropertyExpressionArray = complexObjectPropertyInclusion.m_subObjectProperties;
            if (oWLObjectPropertyExpressionArray.length != 2 && oWLObjectPropertyExpression.equals(oWLObjectPropertyExpressionArray[0]) && oWLObjectPropertyExpression.equals(oWLObjectPropertyExpressionArray[oWLObjectPropertyExpressionArray.length - 1])) {
                throw new IllegalArgumentException("The given property hierarchy is not regular.");
            }
            for (int i = 0; i < oWLObjectPropertyExpressionArray.length; ++i) {
                oWLObjectPropertyExpression2 = oWLObjectPropertyExpressionArray[i];
                if (oWLObjectPropertyExpressionArray.length != 2 && i > 0 && i < oWLObjectPropertyExpressionArray.length - 1 && (oWLObjectPropertyExpression2.equals(oWLObjectPropertyExpression) || map2.containsKey(oWLObjectPropertyExpression) && map2.get(oWLObjectPropertyExpression).contains(oWLObjectPropertyExpression2))) {
                    throw new IllegalArgumentException("The given property hierarchy is not regular.");
                }
                if (oWLObjectPropertyExpression2.getInverseProperty().getSimplified().equals(oWLObjectPropertyExpression)) {
                    throw new IllegalArgumentException("The given property hierarchy is not regular.");
                }
                if (oWLObjectPropertyExpression2.equals(oWLObjectPropertyExpression)) continue;
                graph.addEdge(oWLObjectPropertyExpression2, oWLObjectPropertyExpression);
            }
        }
        return graph;
    }

    protected void checkForRegularity(Graph<OWLObjectPropertyExpression> graph, Map<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>> map2) {
        Object object = graph.clone();
        boolean bl = false;
        do {
            bl = false;
            Object object2 = ((Graph)object).clone();
            for (OWLObjectPropertyExpression oWLObjectPropertyExpression : ((Graph)object2).getElements()) {
                for (OWLObjectPropertyExpression oWLObjectPropertyExpression2 : ((Graph)object2).getSuccessors(oWLObjectPropertyExpression)) {
                    if (!map2.containsKey(oWLObjectPropertyExpression) || !map2.get(oWLObjectPropertyExpression).contains(oWLObjectPropertyExpression2)) continue;
                    for (OWLObjectPropertyExpression oWLObjectPropertyExpression3 : ((Graph)object2).getSuccessors(oWLObjectPropertyExpression2)) {
                        if (oWLObjectPropertyExpression.equals(oWLObjectPropertyExpression3)) continue;
                        ((Graph)object).addEdge(oWLObjectPropertyExpression, oWLObjectPropertyExpression3);
                    }
                    bl = true;
                    ((Graph)object).getSuccessors(oWLObjectPropertyExpression).remove(oWLObjectPropertyExpression2);
                }
            }
        } while (bl);
        ((Graph)object).transitivelyClose();
        for (OWLObjectPropertyExpression oWLObjectPropertyExpression : ((Graph)object).getElements()) {
            Set<OWLObjectPropertyExpression> set2 = ((Graph)object).getSuccessors(oWLObjectPropertyExpression);
            if (!set2.contains(oWLObjectPropertyExpression) && !set2.contains(oWLObjectPropertyExpression.getInverseProperty().getSimplified())) continue;
            throw new IllegalArgumentException("The given property hierarchy is not regular.\nThere is a cyclic dependency involving property " + oWLObjectPropertyExpression);
        }
    }

    protected Map<OWLObjectPropertyExpression, Automaton> buildIndividualAutomata(Graph<OWLObjectPropertyExpression> graph, Collection<OWLObjectPropertyExpression[]> collection, Collection<OWLAxioms.ComplexObjectPropertyInclusion> collection2, Map<OWLObjectPropertyExpression, Set<OWLObjectPropertyExpression>> map2, Set<OWLObjectPropertyExpression> set2) {
        Object object;
        Object object2;
        Object object3;
        HashMap<OWLObjectPropertyExpression, Automaton> hashMap = new HashMap<OWLObjectPropertyExpression, Automaton>();
        for (OWLAxioms.ComplexObjectPropertyInclusion object42 : collection2) {
            Object object4;
            int noSuchStateException;
            State state;
            object3 = object42.m_subObjectProperties;
            object2 = object42.m_superObjectProperty;
            object = null;
            State state2 = null;
            State state3 = null;
            if (!hashMap.containsKey(object2)) {
                object = new Automaton();
                state2 = ((Automaton)object).addState(true, false);
                state3 = ((Automaton)object).addState(false, true);
                try {
                    ((Automaton)object).addTransition(new Transition(state2, object2, state3));
                }
                catch (NoSuchStateException noSuchStateException2) {
                    throw new IllegalArgumentException("Could not create automaton");
                }
            } else {
                object = (Automaton)hashMap.get(object2);
                state2 = (State)((Automaton)object).initials().iterator().next();
                state3 = (State)((Automaton)object).terminals().iterator().next();
            }
            if (((Object)object3).length == 2 && object3[0].equals(object2) && object3[1].equals(object2)) {
                try {
                    ((Automaton)object).addTransition(new Transition(state3, null, state2));
                    set2.add((OWLObjectPropertyExpression)object2);
                }
                catch (NoSuchStateException noSuchStateException3) {
                    throw new IllegalArgumentException("Could not create automaton");
                }
            }
            if (object3[0].equals(object2)) {
                state = state3;
                for (noSuchStateException = 1; noSuchStateException < ((Object)object3).length - 1; ++noSuchStateException) {
                    object4 = object3[noSuchStateException];
                    if (map2.containsKey(object2) && map2.get(object2).contains(object4)) {
                        object4 = object2;
                    }
                    try {
                        state = this.addNewTransition((Automaton)object, state, (OWLObjectPropertyExpression)object4);
                        continue;
                    }
                    catch (NoSuchStateException noSuchStateException4) {
                        throw new IllegalArgumentException("Could not create automaton");
                    }
                }
                try {
                    object4 = object3[((Object)object3).length - 1];
                    if (map2.containsKey(object2) && map2.get(object2).contains(object4)) {
                        object4 = object2;
                    }
                    ((Automaton)object).addTransition(new Transition(state, object4, state3));
                }
                catch (NoSuchStateException noSuchStateException5) {
                    throw new IllegalArgumentException("Could not create automaton");
                }
            }
            if (object3[((Object)object3).length - 1].equals(object2)) {
                state = state2;
                for (noSuchStateException = 0; noSuchStateException < ((Object)object3).length - 2; ++noSuchStateException) {
                    object4 = object3[noSuchStateException];
                    if (map2.containsKey(object2) && map2.get(object2).contains(object4)) {
                        object4 = object2;
                    }
                    try {
                        state = this.addNewTransition((Automaton)object, state, (OWLObjectPropertyExpression)object4);
                        continue;
                    }
                    catch (NoSuchStateException noSuchStateException6) {
                        throw new IllegalArgumentException("Could not create automaton");
                    }
                }
                try {
                    object4 = object3[((Object)object3).length - 2];
                    if (map2.containsKey(object2) && map2.get(object2).contains(object4)) {
                        object4 = object2;
                    }
                    ((Automaton)object).addTransition(new Transition(state, object4, state2));
                }
                catch (NoSuchStateException noSuchStateException7) {
                    throw new IllegalArgumentException("Could not create automaton");
                }
            }
            state = state2;
            for (noSuchStateException = 0; noSuchStateException < ((Object)object3).length - 1; ++noSuchStateException) {
                object4 = object3[noSuchStateException];
                if (map2.containsKey(object2) && map2.get(object2).contains(object4)) {
                    object4 = object2;
                }
                try {
                    state = this.addNewTransition((Automaton)object, state, (OWLObjectPropertyExpression)object4);
                    continue;
                }
                catch (NoSuchStateException noSuchStateException8) {
                    throw new IllegalArgumentException("Could not create automaton");
                }
            }
            try {
                object4 = object3[((Object)object3).length - 1];
                if (map2.containsKey(object2) && map2.get(object2).contains(object4)) {
                    object4 = object2;
                }
                ((Automaton)object).addTransition(new Transition(state, object4, state3));
            }
            catch (NoSuchStateException noSuchStateException9) {
                throw new IllegalArgumentException("Could not create automaton");
            }
            hashMap.put((OWLObjectPropertyExpression)object2, (Automaton)object);
        }
        for (OWLAxioms.ComplexObjectPropertyInclusion complexObjectPropertyInclusion : collection2) {
            object3 = complexObjectPropertyInclusion.m_superObjectProperty;
            object2 = complexObjectPropertyInclusion.m_subObjectProperties;
            if (((OWLObjectPropertyExpression[])object2).length != 2 || !object2[0].equals(object3) || !object2[1].equals(object3) || graph.getElements().contains(object3) || hashMap.containsKey(object3.getInverseProperty().getSimplified())) continue;
            graph.addEdge((OWLObjectPropertyExpression)object3, (OWLObjectPropertyExpression)object3);
            object = (Automaton)hashMap.get(object3);
            hashMap.put(object3.getInverseProperty().getSimplified(), this.getMirroredCopy((Automaton)object));
        }
        OWLDataFactory oWLDataFactory = OWLManager.createOWLOntologyManager().getOWLDataFactory();
        OWLObjectProperty oWLObjectProperty = oWLDataFactory.getOWLTopObjectProperty();
        if (!hashMap.keySet().contains(oWLObjectProperty)) {
            try {
                object3 = new Automaton();
                object2 = ((Automaton)object3).addState(true, false);
                object = ((Automaton)object3).addState(false, true);
                ((Automaton)object3).addTransition(new Transition((State)object2, oWLObjectProperty, (State)object));
                ((Automaton)object3).addTransition(new Transition((State)object, null, (State)object2));
                hashMap.put(oWLObjectProperty, (Automaton)object3);
            }
            catch (NoSuchStateException noSuchStateException) {
                throw new IllegalArgumentException("Could not create automaton");
            }
        }
        return hashMap;
    }

    protected Map<State, State> getDisjointUnion(Automaton automaton, Automaton automaton2) {
        HashMap<State, State> hashMap = new HashMap<State, State>();
        for (Object e2 : automaton2.states()) {
            hashMap.put((State)e2, automaton.addState(false, false));
        }
        for (Object e2 : automaton2.delta()) {
            Transition transition = (Transition)e2;
            try {
                automaton.addTransition(new Transition((State)hashMap.get(transition.start()), transition.label(), (State)hashMap.get(transition.end())));
            }
            catch (NoSuchStateException noSuchStateException) {
                throw new IllegalArgumentException("Could not create disjoint union of automata");
            }
        }
        return hashMap;
    }

    protected Automaton getMirroredCopy(Automaton automaton) {
        Object object;
        Automaton automaton2 = new Automaton();
        HashMap<State, State> hashMap = new HashMap<State, State>();
        for (Object e2 : automaton.states()) {
            object = (State)e2;
            hashMap.put((State)object, automaton2.addState(object.isTerminal(), object.isInitial()));
        }
        for (Object e2 : automaton.delta()) {
            object = (Transition)e2;
            try {
                if (((Transition)object).label() instanceof OWLObjectPropertyExpression) {
                    automaton2.addTransition(new Transition((State)hashMap.get(((Transition)object).end()), ((OWLObjectPropertyExpression)((Transition)object).label()).getInverseProperty().getSimplified(), (State)hashMap.get(((Transition)object).start())));
                    continue;
                }
                automaton2.addTransition(new Transition((State)hashMap.get(((Transition)object).end()), ((Transition)object).label(), (State)hashMap.get(((Transition)object).start())));
            }
            catch (NoSuchStateException noSuchStateException) {}
        }
        return automaton2;
    }

    protected State addNewTransition(Automaton automaton, State state, OWLObjectPropertyExpression oWLObjectPropertyExpression) throws NoSuchStateException {
        OWLObjectPropertyExpression oWLObjectPropertyExpression2 = oWLObjectPropertyExpression;
        State state2 = automaton.addState(false, false);
        automaton.addTransition(new Transition(state, oWLObjectPropertyExpression2, state2));
        return state2;
    }
}

