/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.structural;

import java.util.HashSet;
import java.util.Set;
import org.semanticweb.HermiT.Configuration;
import org.semanticweb.HermiT.Prefixes;
import org.semanticweb.HermiT.datatypes.UnsupportedDatatypeException;
import org.semanticweb.HermiT.model.Atom;
import org.semanticweb.HermiT.model.AtomicConcept;
import org.semanticweb.HermiT.model.AtomicRole;
import org.semanticweb.HermiT.model.Constant;
import org.semanticweb.HermiT.model.Equality;
import org.semanticweb.HermiT.model.Individual;
import org.semanticweb.HermiT.model.Inequality;
import org.semanticweb.HermiT.model.Term;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLIndividualAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.util.OWLAxiomVisitorAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReducedABoxOnlyClausification
extends OWLAxiomVisitorAdapter {
    protected final Configuration.WarningMonitor m_warningMonitor;
    protected final boolean m_ignoreUnsupportedDatatypes;
    protected final OWLDataFactory m_factory;
    protected final Set<AtomicConcept> m_allAtomicConcepts;
    protected final Set<AtomicRole> m_allAtomicObjectRoles;
    protected final Set<AtomicRole> m_allAtomicDataRoles;
    protected final Set<Atom> m_positiveFacts;
    protected final Set<Atom> m_negativeFacts;
    protected final Set<Individual> m_allIndividuals;

    public ReducedABoxOnlyClausification(Configuration configuration, OWLDataFactory oWLDataFactory, Set<AtomicConcept> set2, Set<AtomicRole> set3, Set<AtomicRole> set4) {
        this.m_warningMonitor = configuration.warningMonitor;
        this.m_ignoreUnsupportedDatatypes = configuration.ignoreUnsupportedDatatypes;
        this.m_factory = oWLDataFactory;
        this.m_allAtomicConcepts = set2;
        this.m_allAtomicObjectRoles = set3;
        this.m_allAtomicDataRoles = set4;
        this.m_positiveFacts = new HashSet<Atom>();
        this.m_negativeFacts = new HashSet<Atom>();
        this.m_allIndividuals = new HashSet<Individual>();
    }

    public void clausify(OWLIndividualAxiom ... oWLIndividualAxiomArray) {
        this.m_positiveFacts.clear();
        this.m_negativeFacts.clear();
        for (OWLIndividualAxiom oWLIndividualAxiom : oWLIndividualAxiomArray) {
            oWLIndividualAxiom.accept(this);
        }
    }

    public Set<Atom> getPositiveFacts() {
        return this.m_positiveFacts;
    }

    public Set<Atom> getNegativeFacts() {
        return this.m_negativeFacts;
    }

    public Set<Individual> getAllIndividuals() {
        return this.m_allIndividuals;
    }

    protected Atom getConceptAtom(OWLClass oWLClass, Term term) {
        AtomicConcept atomicConcept = AtomicConcept.create(oWLClass.getIRI().toString());
        if (this.m_allAtomicConcepts.contains(atomicConcept)) {
            return Atom.create(atomicConcept, term);
        }
        throw new IllegalArgumentException("Internal error: fresh classes in class assertions are not compatible with incremental ABox loading!");
    }

    protected Atom getRoleAtom(OWLObjectPropertyExpression oWLObjectPropertyExpression, Term term, Term term2) {
        AtomicRole atomicRole;
        if ((oWLObjectPropertyExpression = oWLObjectPropertyExpression.getSimplified()).isAnonymous()) {
            OWLObjectProperty oWLObjectProperty = oWLObjectPropertyExpression.getNamedProperty();
            atomicRole = AtomicRole.create(oWLObjectProperty.getIRI().toString());
            Term term3 = term;
            term = term2;
            term2 = term3;
        } else {
            atomicRole = AtomicRole.create(oWLObjectPropertyExpression.asOWLObjectProperty().getIRI().toString());
        }
        if (this.m_allAtomicObjectRoles.contains(atomicRole)) {
            return Atom.create(atomicRole, term, term2);
        }
        throw new IllegalArgumentException("Internal error: fresh properties in property assertions are not compatible with incremental ABox loading!");
    }

    protected Atom getRoleAtom(OWLDataPropertyExpression oWLDataPropertyExpression, Term term, Term term2) {
        if (!(oWLDataPropertyExpression instanceof OWLDataProperty)) {
            throw new IllegalStateException("Internal error: unsupported type of data property!");
        }
        AtomicRole atomicRole = AtomicRole.create(((OWLDataProperty)oWLDataPropertyExpression).getIRI().toString());
        if (this.m_allAtomicDataRoles.contains(atomicRole)) {
            return Atom.create(atomicRole, term, term2);
        }
        throw new IllegalArgumentException("Internal error: fresh properties in property assertions are not compatible with incremental ABox loading!");
    }

    protected Individual getIndividual(OWLIndividual oWLIndividual) {
        Individual individual = oWLIndividual.isAnonymous() ? Individual.createAnonymous(((Object)oWLIndividual.asOWLAnonymousIndividual().getID()).toString()) : Individual.create(oWLIndividual.asOWLNamedIndividual().getIRI().toString());
        this.m_allIndividuals.add(individual);
        return individual;
    }

    @Override
    public void visit(OWLSameIndividualAxiom oWLSameIndividualAxiom) {
        OWLIndividual[] oWLIndividualArray = new OWLIndividual[oWLSameIndividualAxiom.getIndividuals().size()];
        oWLSameIndividualAxiom.getIndividuals().toArray(oWLIndividualArray);
        for (int i = 0; i < oWLIndividualArray.length - 1; ++i) {
            this.m_positiveFacts.add(Atom.create(Equality.create(), this.getIndividual(oWLIndividualArray[i]), this.getIndividual(oWLIndividualArray[i + 1])));
        }
    }

    @Override
    public void visit(OWLDifferentIndividualsAxiom oWLDifferentIndividualsAxiom) {
        OWLIndividual[] oWLIndividualArray = new OWLIndividual[oWLDifferentIndividualsAxiom.getIndividuals().size()];
        oWLDifferentIndividualsAxiom.getIndividuals().toArray(oWLIndividualArray);
        for (int i = 0; i < oWLIndividualArray.length; ++i) {
            for (int j = i + 1; j < oWLIndividualArray.length; ++j) {
                this.m_positiveFacts.add(Atom.create(Inequality.create(), this.getIndividual(oWLIndividualArray[i]), this.getIndividual(oWLIndividualArray[j])));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void visit(OWLClassAssertionAxiom oWLClassAssertionAxiom) {
        OWLClassExpression oWLClassExpression = oWLClassAssertionAxiom.getClassExpression();
        if (oWLClassExpression instanceof OWLClass) {
            this.m_positiveFacts.add(this.getConceptAtom((OWLClass)oWLClassExpression, this.getIndividual(oWLClassAssertionAxiom.getIndividual())));
            return;
        } else if (oWLClassExpression instanceof OWLObjectHasSelf) {
            this.m_positiveFacts.add(this.getRoleAtom(((OWLObjectPropertyExpression)((OWLObjectHasSelf)oWLClassExpression).getProperty()).getNamedProperty(), (Term)this.getIndividual(oWLClassAssertionAxiom.getIndividual()), (Term)this.getIndividual(oWLClassAssertionAxiom.getIndividual())));
            return;
        } else if (oWLClassExpression instanceof OWLObjectHasValue) {
            OWLObjectHasValue oWLObjectHasValue = (OWLObjectHasValue)oWLClassExpression;
            OWLObjectPropertyExpression oWLObjectPropertyExpression = (OWLObjectPropertyExpression)oWLObjectHasValue.getProperty();
            OWLIndividual oWLIndividual = (OWLIndividual)oWLObjectHasValue.getValue();
            this.m_positiveFacts.add(this.getRoleAtom(oWLObjectPropertyExpression, (Term)this.getIndividual(oWLClassAssertionAxiom.getIndividual()), (Term)this.getIndividual(oWLIndividual)));
            return;
        } else {
            if (!(oWLClassExpression instanceof OWLObjectComplementOf)) throw new IllegalArgumentException("Internal error: invalid normal form for ABox updates.");
            OWLClassExpression oWLClassExpression2 = ((OWLObjectComplementOf)oWLClassExpression).getOperand();
            if (oWLClassExpression2 instanceof OWLClass) {
                this.m_negativeFacts.add(this.getConceptAtom((OWLClass)oWLClassExpression2, this.getIndividual(oWLClassAssertionAxiom.getIndividual())));
                return;
            } else if (oWLClassExpression2 instanceof OWLObjectHasSelf) {
                this.m_negativeFacts.add(this.getRoleAtom(((OWLObjectPropertyExpression)((OWLObjectHasSelf)oWLClassExpression2).getProperty()).getNamedProperty(), (Term)this.getIndividual(oWLClassAssertionAxiom.getIndividual()), (Term)this.getIndividual(oWLClassAssertionAxiom.getIndividual())));
                return;
            } else {
                if (!(oWLClassExpression2 instanceof OWLObjectHasValue)) throw new IllegalArgumentException("Internal error: invalid normal form for ABox updates (class assertion with negated class).");
                OWLObjectHasValue oWLObjectHasValue = (OWLObjectHasValue)oWLClassExpression2;
                OWLObjectPropertyExpression oWLObjectPropertyExpression = (OWLObjectPropertyExpression)oWLObjectHasValue.getProperty();
                OWLIndividual oWLIndividual = (OWLIndividual)oWLObjectHasValue.getValue();
                this.m_negativeFacts.add(this.getRoleAtom(oWLObjectPropertyExpression, (Term)this.getIndividual(oWLClassAssertionAxiom.getIndividual()), (Term)this.getIndividual(oWLIndividual)));
            }
        }
    }

    @Override
    public void visit(OWLObjectPropertyAssertionAxiom oWLObjectPropertyAssertionAxiom) {
        this.m_positiveFacts.add(this.getRoleAtom((OWLObjectPropertyExpression)oWLObjectPropertyAssertionAxiom.getProperty(), (Term)this.getIndividual(oWLObjectPropertyAssertionAxiom.getSubject()), (Term)this.getIndividual((OWLIndividual)oWLObjectPropertyAssertionAxiom.getObject())));
    }

    @Override
    public void visit(OWLNegativeObjectPropertyAssertionAxiom oWLNegativeObjectPropertyAssertionAxiom) {
        this.m_negativeFacts.add(this.getRoleAtom((OWLObjectPropertyExpression)oWLNegativeObjectPropertyAssertionAxiom.getProperty(), (Term)this.getIndividual(oWLNegativeObjectPropertyAssertionAxiom.getSubject()), (Term)this.getIndividual((OWLIndividual)oWLNegativeObjectPropertyAssertionAxiom.getObject())));
    }

    @Override
    public void visit(OWLDataPropertyAssertionAxiom oWLDataPropertyAssertionAxiom) {
        Constant constant = this.getConstant((OWLLiteral)oWLDataPropertyAssertionAxiom.getObject());
        this.m_positiveFacts.add(this.getRoleAtom((OWLDataPropertyExpression)oWLDataPropertyAssertionAxiom.getProperty(), (Term)this.getIndividual(oWLDataPropertyAssertionAxiom.getSubject()), (Term)constant));
    }

    @Override
    public void visit(OWLNegativeDataPropertyAssertionAxiom oWLNegativeDataPropertyAssertionAxiom) {
        Constant constant = this.getConstant((OWLLiteral)oWLNegativeDataPropertyAssertionAxiom.getObject());
        this.m_negativeFacts.add(this.getRoleAtom((OWLDataPropertyExpression)oWLNegativeDataPropertyAssertionAxiom.getProperty(), (Term)this.getIndividual(oWLNegativeDataPropertyAssertionAxiom.getSubject()), (Term)constant));
    }

    protected Constant getConstant(OWLLiteral oWLLiteral) {
        try {
            if (oWLLiteral.isRDFPlainLiteral()) {
                if (oWLLiteral.hasLang()) {
                    return Constant.create(oWLLiteral.getLiteral() + "@" + oWLLiteral.getLang(), Prefixes.s_semanticWebPrefixes.get("rdf:") + "PlainLiteral");
                }
                return Constant.create(oWLLiteral.getLiteral() + "@", Prefixes.s_semanticWebPrefixes.get("rdf:") + "PlainLiteral");
            }
            return Constant.create(oWLLiteral.getLiteral(), oWLLiteral.getDatatype().getIRI().toString());
        }
        catch (UnsupportedDatatypeException unsupportedDatatypeException) {
            if (this.m_ignoreUnsupportedDatatypes) {
                if (this.m_warningMonitor != null) {
                    this.m_warningMonitor.warning("Ignoring unsupported datatype '" + oWLLiteral.toString() + "'.");
                }
                return Constant.createAnonymous(oWLLiteral.getLiteral());
            }
            throw unsupportedDatatypeException;
        }
    }
}

