/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.tableau;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.semanticweb.HermiT.existentials.ExistentialExpansionStrategy;
import org.semanticweb.HermiT.model.Atom;
import org.semanticweb.HermiT.model.DLClause;
import org.semanticweb.HermiT.model.DLPredicate;
import org.semanticweb.HermiT.model.NodeIDLessEqualThan;
import org.semanticweb.HermiT.model.NodeIDsAscendingOrEqual;
import org.semanticweb.HermiT.model.Term;
import org.semanticweb.HermiT.model.Variable;
import org.semanticweb.HermiT.monitor.TableauMonitor;
import org.semanticweb.HermiT.tableau.DependencySet;
import org.semanticweb.HermiT.tableau.ExtensionManager;
import org.semanticweb.HermiT.tableau.ExtensionTable;
import org.semanticweb.HermiT.tableau.GroundDisjunction;
import org.semanticweb.HermiT.tableau.GroundDisjunctionHeader;
import org.semanticweb.HermiT.tableau.InterruptFlag;
import org.semanticweb.HermiT.tableau.Node;
import org.semanticweb.HermiT.tableau.Tableau;
import org.semanticweb.HermiT.tableau.UnionDependencySet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DLClauseEvaluator
implements Serializable {
    private static final long serialVersionUID = 4639844159658590456L;
    protected static final String CRLF = System.getProperty("line.separator");
    protected final InterruptFlag m_interruptFlag;
    protected final ExtensionManager m_extensionManager;
    protected final ExtensionTable.Retrieval[] m_retrievals;
    protected final Worker[] m_workers;
    protected final DLClause m_bodyDLClause;
    protected final List<DLClause> m_headDLClauses;

    public DLClauseEvaluator(Tableau tableau, DLClause dLClause, List<DLClause> list, ExtensionTable.Retrieval retrieval, BufferSupply bufferSupply, ValuesBufferManager valuesBufferManager, GroundDisjunctionHeaderManager groundDisjunctionHeaderManager, Map<Integer, UnionDependencySet> map2) {
        this.m_interruptFlag = tableau.m_interruptFlag;
        this.m_extensionManager = tableau.m_extensionManager;
        DLClauseCompiler dLClauseCompiler = new DLClauseCompiler(bufferSupply, valuesBufferManager, groundDisjunctionHeaderManager, map2, this, this.m_extensionManager, tableau.getExistentialsExpansionStrategy(), dLClause, list, retrieval);
        this.m_retrievals = new ExtensionTable.Retrieval[dLClauseCompiler.m_retrievals.size()];
        dLClauseCompiler.m_retrievals.toArray(this.m_retrievals);
        this.m_workers = new Worker[dLClauseCompiler.m_workers.size()];
        dLClauseCompiler.m_workers.toArray(this.m_workers);
        this.m_bodyDLClause = dLClause;
        this.m_headDLClauses = list;
    }

    public int getBodyLength() {
        return this.m_bodyDLClause.getBodyLength();
    }

    public Atom getBodyAtom(int n) {
        return this.m_bodyDLClause.getBodyAtom(n);
    }

    public int getNumberOfDLClauses() {
        return this.m_headDLClauses.size();
    }

    public DLClause getDLClause(int n) {
        return this.m_headDLClauses.get(n);
    }

    public int getHeadLength(int n) {
        return this.m_headDLClauses.get(n).getHeadLength();
    }

    public Atom getHeadAtom(int n, int n2) {
        return this.m_headDLClauses.get(n).getHeadAtom(n2);
    }

    public Object[] getTupleMatchedToBody(int n) {
        return this.m_retrievals[n].getTupleBuffer();
    }

    public void evaluate() {
        int n = 0;
        while (n < this.m_workers.length && !this.m_extensionManager.containsClash()) {
            this.m_interruptFlag.checkInterrupt();
            n = this.m_workers[n].execute(n);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = String.valueOf(this.m_workers.length - 1).length();
        for (int i = 0; i < this.m_workers.length; ++i) {
            String string2 = String.valueOf(i);
            for (int j = n - string2.length(); j > 0; --j) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(string2);
            stringBuffer.append(": ");
            stringBuffer.append(this.m_workers[i].toString());
            stringBuffer.append(CRLF);
        }
        return stringBuffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class ConjunctionCompiler {
        protected final BufferSupply m_bufferSupply;
        protected final ValuesBufferManager m_valuesBufferManager;
        protected final ExtensionManager m_extensionManager;
        protected final Atom[] m_bodyAtoms;
        protected final List<Variable> m_variables;
        protected final Set<Variable> m_boundSoFar;
        protected final UnionDependencySet m_unionDependencySet;
        protected final List<ExtensionTable.Retrieval> m_retrievals;
        public final List<Worker> m_workers;
        protected final List<Integer> m_labels;

        /*
         * WARNING - void declaration
         */
        public ConjunctionCompiler(BufferSupply bufferSupply, ValuesBufferManager valuesBufferManager, Map<Integer, UnionDependencySet> map2, ExtensionManager extensionManager, Atom[] atomArray, List<Variable> list) {
            this.m_bufferSupply = bufferSupply;
            this.m_valuesBufferManager = valuesBufferManager;
            this.m_extensionManager = extensionManager;
            this.m_bodyAtoms = atomArray;
            this.m_variables = new ArrayList<Variable>();
            this.m_boundSoFar = new HashSet<Variable>();
            int n = 0;
            for (int i = 0; i < this.getBodyLength(); ++i) {
                Atom serializable2 = this.getBodyAtom(i);
                for (int j = 0; j < serializable2.getArity(); ++j) {
                    Variable variable = serializable2.getArgumentVariable(j);
                    if (variable == null || this.m_variables.contains(variable) || !this.occursInBodyAtomsAfter(variable, i + 1)) continue;
                    this.m_variables.add(variable);
                }
                if (serializable2.getDLPredicate().equals(NodeIDLessEqualThan.INSTANCE) || serializable2.getDLPredicate() instanceof NodeIDsAscendingOrEqual) continue;
                ++n;
            }
            for (Variable variable : list) {
                if (this.m_variables.contains(variable)) continue;
                this.m_variables.add(variable);
            }
            if (map2 != null) {
                void var9_15;
                Integer n2 = n;
                UnionDependencySet unionDependencySet = map2.get(n2);
                if (unionDependencySet == null) {
                    UnionDependencySet unionDependencySet2 = new UnionDependencySet(n);
                    map2.put(n2, unionDependencySet2);
                }
                this.m_unionDependencySet = var9_15;
            } else {
                this.m_unionDependencySet = null;
            }
            this.m_retrievals = new ArrayList<ExtensionTable.Retrieval>();
            this.m_workers = new ArrayList<Worker>();
            this.m_labels = new ArrayList<Integer>();
        }

        protected final void generateCode(int n, ExtensionTable.Retrieval retrieval) {
            this.m_labels.add(null);
            this.m_retrievals.add(retrieval);
            int n2 = this.addLabel();
            if (n > 0) {
                this.compileCheckUnboundVariableMatches(this.getBodyAtom(0), retrieval, n2);
                this.compileGenerateBindings(retrieval, this.getBodyAtom(0));
                if (this.m_unionDependencySet != null) {
                    this.m_workers.add(new CopyDependencySet(retrieval, this.m_unionDependencySet.m_dependencySets, 0));
                }
            }
            this.compileBodyAtom(n, n2);
            this.setLabelProgramCounter(n2);
            for (Worker worker : this.m_workers) {
                BranchingWorker branchingWorker;
                int n3;
                if (!(worker instanceof BranchingWorker) || (n3 = (branchingWorker = (BranchingWorker)worker).getBranchingAddress()) >= 0) continue;
                int n4 = this.m_labels.get(-n3);
                branchingWorker.setBranchingAddress(n4);
            }
        }

        protected final boolean occursInBodyAtomsAfter(Variable variable, int n) {
            for (int i = n; i < this.getBodyLength(); ++i) {
                if (!this.getBodyAtom(i).containsVariable(variable)) continue;
                return true;
            }
            return false;
        }

        protected final void compileBodyAtom(int n, int n2) {
            if (n == this.getBodyLength()) {
                this.compileHeads();
            } else if (this.getBodyAtom(n).getDLPredicate().equals(NodeIDLessEqualThan.INSTANCE)) {
                Atom atom2 = this.getBodyAtom(n);
                int n3 = this.m_variables.indexOf(atom2.getArgumentVariable(0));
                int n4 = this.m_variables.indexOf(atom2.getArgumentVariable(1));
                assert (n3 != -1);
                assert (n4 != -1);
                this.m_workers.add(new BranchIfNotNodeIDLessEqualThan(n2, this.m_valuesBufferManager.m_valuesBuffer, n3, n4));
                this.compileBodyAtom(n + 1, n2);
            } else if (this.getBodyAtom(n).getDLPredicate() instanceof NodeIDsAscendingOrEqual) {
                Atom atom3 = this.getBodyAtom(n);
                int[] nArray = new int[atom3.getArity()];
                for (int i = 0; i < atom3.getArity(); ++i) {
                    nArray[i] = this.m_variables.indexOf(atom3.getArgumentVariable(i));
                    assert (nArray[i] != -1);
                }
                this.m_workers.add(new BranchIfNotNodeIDsAscendingOrEqual(n2, this.m_valuesBufferManager.m_valuesBuffer, nArray));
                this.compileBodyAtom(n + 1, n2);
            } else {
                int n5 = this.addLabel();
                int n6 = this.addLabel();
                Atom atom4 = this.getBodyAtom(n);
                int[] nArray = new int[atom4.getArity() + 1];
                nArray[0] = this.m_valuesBufferManager.m_bodyDLPredicatesToIndexes.get(atom4.getDLPredicate());
                for (int i = 0; i < atom4.getArity(); ++i) {
                    Term term = atom4.getArgument(i);
                    if (term instanceof Variable) {
                        if (this.m_boundSoFar.contains(term)) {
                            nArray[i + 1] = this.m_variables.indexOf((Variable)term);
                            continue;
                        }
                        nArray[i + 1] = -1;
                        continue;
                    }
                    nArray[i + 1] = this.m_valuesBufferManager.m_bodyNonvariableTermsToIndexes.get(term);
                }
                ExtensionTable.Retrieval retrieval = this.m_extensionManager.getExtensionTable(atom4.getArity() + 1).createRetrieval(nArray, this.m_valuesBufferManager.m_valuesBuffer, this.m_bufferSupply.getBuffer(atom4.getArity() + 1), false, ExtensionTable.View.EXTENSION_THIS);
                this.m_retrievals.add(retrieval);
                this.m_workers.add(new OpenRetrieval(retrieval));
                int n7 = this.m_workers.size();
                this.m_workers.add(new HasMoreRetrieval(n5, retrieval));
                this.compileCheckUnboundVariableMatches(atom4, retrieval, n6);
                this.compileGenerateBindings(retrieval, atom4);
                if (this.m_unionDependencySet != null) {
                    this.m_workers.add(new CopyDependencySet(retrieval, this.m_unionDependencySet.m_dependencySets, this.m_retrievals.size() - 1));
                }
                this.compileBodyAtom(n + 1, n6);
                this.setLabelProgramCounter(n6);
                this.m_workers.add(new NextRetrieval(retrieval));
                this.m_workers.add(new JumpTo(n7));
                this.setLabelProgramCounter(n5);
            }
        }

        protected final int getBodyLength() {
            return this.m_bodyAtoms.length;
        }

        protected final Atom getBodyAtom(int n) {
            return this.m_bodyAtoms[n];
        }

        protected final void compileCheckUnboundVariableMatches(Atom atom2, ExtensionTable.Retrieval retrieval, int n) {
            for (int i = 0; i < atom2.getArity(); ++i) {
                Variable variable = atom2.getArgumentVariable(i);
                if (variable == null || this.m_boundSoFar.contains(variable)) continue;
                for (int j = i + 1; j < atom2.getArity(); ++j) {
                    if (!variable.equals(atom2.getArgument(j))) continue;
                    this.m_workers.add(new BranchIfNotEqual(n, retrieval.getTupleBuffer(), i + 1, j + 1));
                }
            }
        }

        protected final void compileGenerateBindings(ExtensionTable.Retrieval retrieval, Atom atom2) {
            for (int i = 0; i < atom2.getArity(); ++i) {
                int n;
                Variable variable = atom2.getArgumentVariable(i);
                if (variable == null || this.m_boundSoFar.contains(variable) || (n = this.m_variables.indexOf(variable)) == -1) continue;
                this.m_workers.add(new CopyValues(retrieval.getTupleBuffer(), i + 1, this.m_valuesBufferManager.m_valuesBuffer, n));
                this.m_boundSoFar.add(variable);
            }
        }

        protected final int addLabel() {
            int n = this.m_labels.size();
            this.m_labels.add(null);
            return -n;
        }

        protected final void setLabelProgramCounter(int n) {
            this.m_labels.set(-n, this.m_workers.size());
        }

        protected abstract void compileHeads();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class DLClauseCompiler
    extends ConjunctionCompiler {
        protected final DLClauseEvaluator m_dlClauseEvalautor;
        protected final GroundDisjunctionHeaderManager m_groundDisjunctionHeaderManager;
        protected final ExistentialExpansionStrategy m_existentialExpansionStrategy;
        protected final DLClause m_bodyDLClause;
        protected final List<DLClause> m_headDLClauses;
        protected final boolean[] m_coreVariables;

        public DLClauseCompiler(BufferSupply bufferSupply, ValuesBufferManager valuesBufferManager, GroundDisjunctionHeaderManager groundDisjunctionHeaderManager, Map<Integer, UnionDependencySet> map2, DLClauseEvaluator dLClauseEvaluator, ExtensionManager extensionManager, ExistentialExpansionStrategy existentialExpansionStrategy, DLClause dLClause, List<DLClause> list, ExtensionTable.Retrieval retrieval) {
            super(bufferSupply, valuesBufferManager, map2, extensionManager, dLClause.getBodyAtoms(), DLClauseCompiler.getHeadVariables(list));
            this.m_groundDisjunctionHeaderManager = groundDisjunctionHeaderManager;
            this.m_dlClauseEvalautor = dLClauseEvaluator;
            this.m_existentialExpansionStrategy = existentialExpansionStrategy;
            this.m_bodyDLClause = dLClause;
            this.m_headDLClauses = list;
            this.m_coreVariables = new boolean[this.m_variables.size()];
            this.generateCode(1, retrieval);
        }

        protected int getNumberOfHeads() {
            return this.m_headDLClauses.size();
        }

        protected int getHeadLength(int n) {
            return this.m_headDLClauses.get(n).getHeadLength();
        }

        protected Atom getHeadAtom(int n, int n2) {
            return this.m_headDLClauses.get(n).getHeadAtom(n2);
        }

        @Override
        protected void compileHeads() {
            this.m_existentialExpansionStrategy.dlClauseBodyCompiled(this.m_workers, this.m_bodyDLClause, this.m_variables, this.m_valuesBufferManager.m_valuesBuffer, this.m_coreVariables);
            for (int i = 0; i < this.getNumberOfHeads(); ++i) {
                if (this.m_extensionManager.m_tableauMonitor != null) {
                    this.m_workers.add(new CallMatchStartedOnMonitor(this.m_extensionManager.m_tableauMonitor, this.m_dlClauseEvalautor, i));
                }
                if (this.getHeadLength(i) == 0) {
                    this.m_workers.add(new SetClash(this.m_extensionManager, this.m_unionDependencySet));
                } else if (this.getHeadLength(i) == 1) {
                    Atom atom2 = this.getHeadAtom(i, 0);
                    switch (atom2.getArity()) {
                        case 1: {
                            this.m_workers.add(new DeriveUnaryFact(this.m_extensionManager, this.m_valuesBufferManager.m_valuesBuffer, this.m_coreVariables, this.m_unionDependencySet, atom2.getDLPredicate(), this.m_variables.indexOf(atom2.getArgumentVariable(0))));
                            break;
                        }
                        case 2: {
                            this.m_workers.add(new DeriveBinaryFact(this.m_extensionManager, this.m_valuesBufferManager.m_valuesBuffer, this.m_unionDependencySet, atom2.getDLPredicate(), this.m_variables.indexOf(atom2.getArgumentVariable(0)), this.m_variables.indexOf(atom2.getArgumentVariable(1))));
                            break;
                        }
                        case 3: {
                            this.m_workers.add(new DeriveTernaryFact(this.m_extensionManager, this.m_valuesBufferManager.m_valuesBuffer, this.m_unionDependencySet, atom2.getDLPredicate(), this.m_variables.indexOf(atom2.getArgumentVariable(0)), this.m_variables.indexOf(atom2.getArgumentVariable(1)), this.m_variables.indexOf(atom2.getArgumentVariable(2))));
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unsupported atom arity.");
                        }
                    }
                } else {
                    int n = 0;
                    for (int j = 0; j < this.getHeadLength(i); ++j) {
                        n += this.getHeadAtom(i, j).getArity();
                    }
                    DLPredicate[] dLPredicateArray = new DLPredicate[this.getHeadLength(i)];
                    int[] nArray = new int[this.getHeadLength(i)];
                    int[] nArray2 = new int[n];
                    int n2 = 0;
                    for (int j = 0; j < this.getHeadLength(i); ++j) {
                        Atom atom3 = this.getHeadAtom(i, j);
                        dLPredicateArray[j] = atom3.getDLPredicate();
                        for (int k = 0; k < atom3.getArity(); ++k) {
                            Variable variable = atom3.getArgumentVariable(k);
                            int n3 = this.m_variables.indexOf(variable);
                            assert (n3 != -1);
                            nArray2[n2++] = n3;
                        }
                        if (dLPredicateArray[j].getArity() == 1) {
                            Variable variable = atom3.getArgumentVariable(0);
                            nArray[j] = this.m_variables.indexOf(variable);
                            continue;
                        }
                        nArray[j] = -1;
                    }
                    GroundDisjunctionHeader groundDisjunctionHeader = this.m_groundDisjunctionHeaderManager.get(dLPredicateArray);
                    this.m_workers.add(new DeriveDisjunction(this.m_valuesBufferManager.m_valuesBuffer, this.m_coreVariables, this.m_unionDependencySet, this.m_extensionManager.m_tableau, groundDisjunctionHeader, nArray, nArray2));
                }
                if (this.m_extensionManager.m_tableauMonitor == null) continue;
                this.m_workers.add(new CallMatchFinishedOnMonitor(this.m_extensionManager.m_tableauMonitor, this.m_dlClauseEvalautor, i));
            }
        }

        protected static List<Variable> getHeadVariables(List<DLClause> list) {
            ArrayList<Variable> arrayList = new ArrayList<Variable>();
            for (DLClause dLClause : list) {
                for (int i = 0; i < dLClause.getHeadLength(); ++i) {
                    Atom atom2 = dLClause.getHeadAtom(i);
                    for (int j = 0; j < atom2.getArity(); ++j) {
                        Variable variable = atom2.getArgumentVariable(j);
                        if (variable == null || arrayList.contains(variable)) continue;
                        arrayList.add(variable);
                    }
                }
            }
            return arrayList;
        }
    }

    protected static final class DeriveDisjunction
    implements Worker,
    Serializable {
        private static final long serialVersionUID = -3546622575743138887L;
        protected final Tableau m_tableau;
        protected final Object[] m_valuesBuffer;
        protected final boolean[] m_coreVariables;
        protected final DependencySet m_dependencySet;
        protected final GroundDisjunctionHeader m_groundDisjunctionHeader;
        protected final int[] m_copyIsCore;
        protected final int[] m_copyValuesToArguments;

        public DeriveDisjunction(Object[] objectArray, boolean[] blArray, DependencySet dependencySet, Tableau tableau, GroundDisjunctionHeader groundDisjunctionHeader, int[] nArray, int[] nArray2) {
            this.m_valuesBuffer = objectArray;
            this.m_coreVariables = blArray;
            this.m_dependencySet = dependencySet;
            this.m_tableau = tableau;
            this.m_groundDisjunctionHeader = groundDisjunctionHeader;
            this.m_copyIsCore = nArray;
            this.m_copyValuesToArguments = nArray2;
        }

        public void clear() {
        }

        public int execute(int n) {
            Node[] nodeArray = new Node[this.m_copyValuesToArguments.length];
            for (int i = this.m_copyValuesToArguments.length - 1; i >= 0; --i) {
                nodeArray[i] = (Node)this.m_valuesBuffer[this.m_copyValuesToArguments[i]];
            }
            boolean[] blArray = new boolean[this.m_copyIsCore.length];
            for (int i = this.m_copyIsCore.length - 1; i >= 0; --i) {
                int n2 = this.m_copyIsCore[i];
                blArray[i] = n2 == -1 ? true : this.m_coreVariables[n2];
            }
            GroundDisjunction groundDisjunction = new GroundDisjunction(this.m_tableau, this.m_groundDisjunctionHeader, nodeArray, blArray, this.m_tableau.m_dependencySetFactory.getPermanent(this.m_dependencySet));
            if (!groundDisjunction.isSatisfied(this.m_tableau)) {
                this.m_tableau.addGroundDisjunction(groundDisjunction);
            }
            return n + 1;
        }

        public String toString() {
            return "Derive disjunction";
        }
    }

    protected static final class DeriveTernaryFact
    implements Worker,
    Serializable {
        private static final long serialVersionUID = 1823363493615682288L;
        protected final ExtensionManager m_extensionManager;
        protected final Object[] m_valuesBuffer;
        protected final DependencySet m_dependencySet;
        protected final DLPredicate m_dlPredicate;
        protected final int m_argumentIndex1;
        protected final int m_argumentIndex2;
        protected final int m_argumentIndex3;

        public DeriveTernaryFact(ExtensionManager extensionManager, Object[] objectArray, DependencySet dependencySet, DLPredicate dLPredicate, int n, int n2, int n3) {
            this.m_extensionManager = extensionManager;
            this.m_valuesBuffer = objectArray;
            this.m_dependencySet = dependencySet;
            this.m_dlPredicate = dLPredicate;
            this.m_argumentIndex1 = n;
            this.m_argumentIndex2 = n2;
            this.m_argumentIndex3 = n3;
        }

        public int execute(int n) {
            Node node2 = (Node)this.m_valuesBuffer[this.m_argumentIndex1];
            Node node3 = (Node)this.m_valuesBuffer[this.m_argumentIndex2];
            Node node4 = (Node)this.m_valuesBuffer[this.m_argumentIndex3];
            this.m_extensionManager.addAssertion(this.m_dlPredicate, node2, node3, node4, this.m_dependencySet, true);
            return n + 1;
        }

        public String toString() {
            return "Derive ternary fact";
        }
    }

    protected static final class DeriveBinaryFact
    implements Worker,
    Serializable {
        private static final long serialVersionUID = 1823363493615682288L;
        protected final ExtensionManager m_extensionManager;
        protected final Object[] m_valuesBuffer;
        protected final DependencySet m_dependencySet;
        protected final DLPredicate m_dlPredicate;
        protected final int m_argumentIndex1;
        protected final int m_argumentIndex2;

        public DeriveBinaryFact(ExtensionManager extensionManager, Object[] objectArray, DependencySet dependencySet, DLPredicate dLPredicate, int n, int n2) {
            this.m_extensionManager = extensionManager;
            this.m_valuesBuffer = objectArray;
            this.m_dependencySet = dependencySet;
            this.m_dlPredicate = dLPredicate;
            this.m_argumentIndex1 = n;
            this.m_argumentIndex2 = n2;
        }

        public int execute(int n) {
            Node node2 = (Node)this.m_valuesBuffer[this.m_argumentIndex1];
            Node node3 = (Node)this.m_valuesBuffer[this.m_argumentIndex2];
            this.m_extensionManager.addAssertion(this.m_dlPredicate, node2, node3, this.m_dependencySet, true);
            return n + 1;
        }

        public String toString() {
            return "Derive binary fact";
        }
    }

    protected static final class DeriveUnaryFact
    implements Worker,
    Serializable {
        private static final long serialVersionUID = 7883620022252842010L;
        protected final ExtensionManager m_extensionManager;
        protected final Object[] m_valuesBuffer;
        protected final boolean[] m_coreVariables;
        protected final DependencySet m_dependencySet;
        protected final DLPredicate m_dlPredicate;
        protected final int m_argumentIndex;

        public DeriveUnaryFact(ExtensionManager extensionManager, Object[] objectArray, boolean[] blArray, DependencySet dependencySet, DLPredicate dLPredicate, int n) {
            this.m_extensionManager = extensionManager;
            this.m_valuesBuffer = objectArray;
            this.m_coreVariables = blArray;
            this.m_dependencySet = dependencySet;
            this.m_argumentIndex = n;
            this.m_dlPredicate = dLPredicate;
        }

        public int execute(int n) {
            Node node2 = (Node)this.m_valuesBuffer[this.m_argumentIndex];
            boolean bl = this.m_coreVariables[this.m_argumentIndex];
            this.m_extensionManager.addAssertion(this.m_dlPredicate, node2, this.m_dependencySet, bl);
            return n + 1;
        }

        public String toString() {
            return "Derive unary fact";
        }
    }

    protected static final class SetClash
    implements Worker,
    Serializable {
        private static final long serialVersionUID = -4981087765064918953L;
        protected final ExtensionManager m_extensionManager;
        protected final DependencySet m_dependencySet;

        public SetClash(ExtensionManager extensionManager, DependencySet dependencySet) {
            this.m_extensionManager = extensionManager;
            this.m_dependencySet = dependencySet;
        }

        public int execute(int n) {
            this.m_extensionManager.setClash(this.m_dependencySet);
            return n + 1;
        }

        public String toString() {
            return "Set clash";
        }
    }

    protected static final class CallMatchFinishedOnMonitor
    implements Worker,
    Serializable {
        private static final long serialVersionUID = 1046400921858176361L;
        protected final TableauMonitor m_tableauMonitor;
        protected final DLClauseEvaluator m_dlClauseEvaluator;
        protected final int m_dlClauseIndex;

        public CallMatchFinishedOnMonitor(TableauMonitor tableauMonitor, DLClauseEvaluator dLClauseEvaluator, int n) {
            this.m_tableauMonitor = tableauMonitor;
            this.m_dlClauseEvaluator = dLClauseEvaluator;
            this.m_dlClauseIndex = n;
        }

        public int execute(int n) {
            this.m_tableauMonitor.dlClauseMatchedFinished(this.m_dlClauseEvaluator, this.m_dlClauseIndex);
            return n + 1;
        }

        public String toString() {
            return "Monitor -> Match finished";
        }
    }

    protected static final class CallMatchStartedOnMonitor
    implements Worker,
    Serializable {
        private static final long serialVersionUID = 8736659573939242252L;
        protected final TableauMonitor m_tableauMonitor;
        protected final DLClauseEvaluator m_dlClauseEvaluator;
        protected final int m_dlClauseIndex;

        public CallMatchStartedOnMonitor(TableauMonitor tableauMonitor, DLClauseEvaluator dLClauseEvaluator, int n) {
            this.m_tableauMonitor = tableauMonitor;
            this.m_dlClauseEvaluator = dLClauseEvaluator;
            this.m_dlClauseIndex = n;
        }

        public int execute(int n) {
            this.m_tableauMonitor.dlClauseMatchedStarted(this.m_dlClauseEvaluator, this.m_dlClauseIndex);
            return n + 1;
        }

        public String toString() {
            return "Monitor -> Match started";
        }
    }

    protected static final class JumpTo
    implements BranchingWorker,
    Serializable {
        private static final long serialVersionUID = -6957866973028474739L;
        protected int m_jumpTo;

        public JumpTo(int n) {
            this.m_jumpTo = n;
        }

        public int execute(int n) {
            return this.m_jumpTo;
        }

        public int getBranchingAddress() {
            return this.m_jumpTo;
        }

        public void setBranchingAddress(int n) {
            this.m_jumpTo = n;
        }

        public String toString() {
            return "Jump to " + this.m_jumpTo;
        }
    }

    protected static final class HasMoreRetrieval
    implements BranchingWorker,
    Serializable {
        private static final long serialVersionUID = -2415094151423166585L;
        protected int m_eofProgramCounter;
        protected final ExtensionTable.Retrieval m_retrieval;

        public HasMoreRetrieval(int n, ExtensionTable.Retrieval retrieval) {
            this.m_eofProgramCounter = n;
            this.m_retrieval = retrieval;
        }

        public int execute(int n) {
            if (this.m_retrieval.afterLast()) {
                return this.m_eofProgramCounter;
            }
            return n + 1;
        }

        public int getBranchingAddress() {
            return this.m_eofProgramCounter;
        }

        public void setBranchingAddress(int n) {
            this.m_eofProgramCounter = n;
        }

        public String toString() {
            return "Branch to " + this.m_eofProgramCounter + " if " + this.m_retrieval.getBindingsBuffer()[this.m_retrieval.getBindingPositions()[0]] + " is empty";
        }
    }

    protected static final class NextRetrieval
    implements Worker,
    Serializable {
        private static final long serialVersionUID = -2787897558147109082L;
        protected final ExtensionTable.Retrieval m_retrieval;

        public NextRetrieval(ExtensionTable.Retrieval retrieval) {
            this.m_retrieval = retrieval;
        }

        public int execute(int n) {
            this.m_retrieval.next();
            return n + 1;
        }

        public String toString() {
            return "Next " + this.m_retrieval.getBindingsBuffer()[this.m_retrieval.getBindingPositions()[0]];
        }
    }

    protected static final class OpenRetrieval
    implements Worker,
    Serializable {
        private static final long serialVersionUID = 8246610603084803950L;
        protected final ExtensionTable.Retrieval m_retrieval;

        public OpenRetrieval(ExtensionTable.Retrieval retrieval) {
            this.m_retrieval = retrieval;
        }

        public int execute(int n) {
            this.m_retrieval.open();
            return n + 1;
        }

        public String toString() {
            return "Open " + this.m_retrieval.getBindingsBuffer()[this.m_retrieval.getBindingPositions()[0]];
        }
    }

    protected static final class BranchIfNotNodeIDsAscendingOrEqual
    implements BranchingWorker,
    Serializable {
        private static final long serialVersionUID = 8053779312249250349L;
        protected int m_branchProgramCounter;
        protected final Object[] m_buffer;
        protected final int[] m_nodeIndexes;

        public BranchIfNotNodeIDsAscendingOrEqual(int n, Object[] objectArray, int[] nArray) {
            this.m_branchProgramCounter = n;
            this.m_buffer = objectArray;
            this.m_nodeIndexes = nArray;
        }

        public int execute(int n) {
            boolean bl = true;
            boolean bl2 = true;
            int n2 = ((Node)this.m_buffer[this.m_nodeIndexes[0]]).getNodeID();
            for (int i = 1; i < this.m_nodeIndexes.length; ++i) {
                int n3 = ((Node)this.m_buffer[this.m_nodeIndexes[i]]).getNodeID();
                if (n2 >= n3) {
                    bl = false;
                }
                if (n3 != n2) {
                    bl2 = false;
                }
                n2 = n3;
            }
            if (!bl && bl2 || bl && !bl2) {
                return n + 1;
            }
            return this.m_branchProgramCounter;
        }

        public int getBranchingAddress() {
            return this.m_branchProgramCounter;
        }

        public void setBranchingAddress(int n) {
            this.m_branchProgramCounter = n;
        }

        public String toString() {
            return "Branch to " + this.m_branchProgramCounter + " if node IDs are not ascending or equal";
        }
    }

    protected static final class BranchIfNotNodeIDLessEqualThan
    implements BranchingWorker,
    Serializable {
        private static final long serialVersionUID = 2484359261424674914L;
        protected int m_notLessProgramCounter;
        protected final Object[] m_buffer;
        protected final int m_index1;
        protected final int m_index2;

        public BranchIfNotNodeIDLessEqualThan(int n, Object[] objectArray, int n2, int n3) {
            this.m_notLessProgramCounter = n;
            this.m_buffer = objectArray;
            this.m_index1 = n2;
            this.m_index2 = n3;
        }

        public int execute(int n) {
            if (((Node)this.m_buffer[this.m_index1]).getNodeID() <= ((Node)this.m_buffer[this.m_index2]).getNodeID()) {
                return n + 1;
            }
            return this.m_notLessProgramCounter;
        }

        public int getBranchingAddress() {
            return this.m_notLessProgramCounter;
        }

        public void setBranchingAddress(int n) {
            this.m_notLessProgramCounter = n;
        }

        public String toString() {
            return "Branch to " + this.m_notLessProgramCounter + " if " + this.m_index1 + ".ID > " + this.m_index2 + ".ID";
        }
    }

    protected static final class BranchIfNotEqual
    implements BranchingWorker,
    Serializable {
        private static final long serialVersionUID = -1880147431680856293L;
        protected int m_notEqualProgramCounter;
        protected final Object[] m_buffer;
        protected final int m_index1;
        protected final int m_index2;

        public BranchIfNotEqual(int n, Object[] objectArray, int n2, int n3) {
            this.m_notEqualProgramCounter = n;
            this.m_buffer = objectArray;
            this.m_index1 = n2;
            this.m_index2 = n3;
        }

        public int execute(int n) {
            if (this.m_buffer[this.m_index1].equals(this.m_buffer[this.m_index2])) {
                return n + 1;
            }
            return this.m_notEqualProgramCounter;
        }

        public int getBranchingAddress() {
            return this.m_notEqualProgramCounter;
        }

        public void setBranchingAddress(int n) {
            this.m_notEqualProgramCounter = n;
        }

        public String toString() {
            return "Branch to " + this.m_notEqualProgramCounter + " if " + this.m_index1 + " != " + this.m_index2;
        }
    }

    protected static final class CopyDependencySet
    implements Worker,
    Serializable {
        private static final long serialVersionUID = 705172386083123813L;
        protected final ExtensionTable.Retrieval m_retrieval;
        protected final DependencySet[] m_targetDependencySets;
        protected final int m_targetIndex;

        public CopyDependencySet(ExtensionTable.Retrieval retrieval, DependencySet[] dependencySetArray, int n) {
            this.m_retrieval = retrieval;
            this.m_targetDependencySets = dependencySetArray;
            this.m_targetIndex = n;
        }

        public int execute(int n) {
            this.m_targetDependencySets[this.m_targetIndex] = this.m_retrieval.getDependencySet();
            return n + 1;
        }

        public String toString() {
            return "Copy dependency set to " + this.m_targetIndex;
        }
    }

    protected static final class CopyValues
    implements Worker,
    Serializable {
        private static final long serialVersionUID = -4323769483485648756L;
        protected final Object[] m_fromBuffer;
        protected final int m_fromIndex;
        protected final Object[] m_toBuffer;
        protected final int m_toIndex;

        public CopyValues(Object[] objectArray, int n, Object[] objectArray2, int n2) {
            this.m_fromBuffer = objectArray;
            this.m_fromIndex = n;
            this.m_toBuffer = objectArray2;
            this.m_toIndex = n2;
        }

        public int execute(int n) {
            this.m_toBuffer[this.m_toIndex] = this.m_fromBuffer[this.m_fromIndex];
            return n + 1;
        }

        public String toString() {
            return "Copy " + this.m_fromIndex + " --> " + this.m_toIndex;
        }
    }

    protected static interface BranchingWorker
    extends Worker {
        public int getBranchingAddress();

        public void setBranchingAddress(int var1);
    }

    public static interface Worker {
        public int execute(int var1);
    }

    public static class GroundDisjunctionHeaderManager {
        protected GroundDisjunctionHeader[] m_buckets = new GroundDisjunctionHeader[1024];
        protected int m_numberOfElements = 0;
        protected int m_threshold = (int)((double)this.m_buckets.length * 0.75);

        public GroundDisjunctionHeader get(DLPredicate[] dLPredicateArray) {
            int n;
            int n2 = 0;
            for (n = 0; n < dLPredicateArray.length; ++n) {
                n2 = n2 * 7 + dLPredicateArray[n].hashCode();
            }
            n = GroundDisjunctionHeaderManager.getIndexFor(n2, this.m_buckets.length);
            GroundDisjunctionHeader groundDisjunctionHeader = this.m_buckets[n];
            while (groundDisjunctionHeader != null) {
                if (n2 == groundDisjunctionHeader.m_hashCode && groundDisjunctionHeader.isEqual(dLPredicateArray)) {
                    return groundDisjunctionHeader;
                }
                groundDisjunctionHeader = groundDisjunctionHeader.m_nextEntry;
            }
            this.m_buckets[n] = groundDisjunctionHeader = new GroundDisjunctionHeader(dLPredicateArray, n2, groundDisjunctionHeader);
            ++this.m_numberOfElements;
            if (this.m_numberOfElements >= this.m_threshold) {
                this.resize(this.m_buckets.length * 2);
            }
            return groundDisjunctionHeader;
        }

        protected void resize(int n) {
            GroundDisjunctionHeader[] groundDisjunctionHeaderArray = new GroundDisjunctionHeader[n];
            for (int i = 0; i < this.m_buckets.length; ++i) {
                GroundDisjunctionHeader groundDisjunctionHeader = this.m_buckets[i];
                while (groundDisjunctionHeader != null) {
                    GroundDisjunctionHeader groundDisjunctionHeader2 = groundDisjunctionHeader.m_nextEntry;
                    int n2 = GroundDisjunctionHeaderManager.getIndexFor(groundDisjunctionHeader.hashCode(), n);
                    groundDisjunctionHeader.m_nextEntry = groundDisjunctionHeaderArray[n2];
                    groundDisjunctionHeaderArray[n2] = groundDisjunctionHeader;
                    groundDisjunctionHeader = groundDisjunctionHeader2;
                }
            }
            this.m_buckets = groundDisjunctionHeaderArray;
            this.m_threshold = (int)((double)n * 0.75);
        }

        protected static int getIndexFor(int n, int n2) {
            n += ~(n << 9);
            n ^= n >>> 14;
            n += n << 4;
            n ^= n >>> 10;
            return n & n2 - 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ValuesBufferManager {
        public final Object[] m_valuesBuffer;
        public final Map<DLPredicate, Integer> m_bodyDLPredicatesToIndexes;
        public final int m_maxNumberOfVariables;
        public final Map<Term, Integer> m_bodyNonvariableTermsToIndexes;

        public ValuesBufferManager(Set<DLClause> set2, Map<Term, Node> map2) {
            Serializable serializable;
            HashSet<DLPredicate> hashSet = new HashSet<DLPredicate>();
            HashSet<Variable> hashSet2 = new HashSet<Variable>();
            this.m_bodyNonvariableTermsToIndexes = new HashMap<Term, Integer>();
            int n = 0;
            for (DLClause iterator : set2) {
                hashSet2.clear();
                for (int dLPredicate = iterator.getBodyLength() - 1; dLPredicate >= 0; --dLPredicate) {
                    serializable = iterator.getBodyAtom(dLPredicate);
                    hashSet.add(((Atom)serializable).getDLPredicate());
                    for (int i = 0; i < ((Atom)serializable).getArity(); ++i) {
                        Term term = ((Atom)serializable).getArgument(i);
                        if (term instanceof Variable) {
                            hashSet2.add((Variable)term);
                            continue;
                        }
                        this.m_bodyNonvariableTermsToIndexes.put(term, -1);
                    }
                }
                if (hashSet2.size() <= n) continue;
                n = hashSet2.size();
            }
            this.m_valuesBuffer = new Object[n + hashSet.size() + this.m_bodyNonvariableTermsToIndexes.size()];
            this.m_bodyDLPredicatesToIndexes = new HashMap<DLPredicate, Integer>();
            int n2 = n;
            for (DLPredicate dLPredicate : hashSet) {
                this.m_bodyDLPredicatesToIndexes.put(dLPredicate, n2);
                this.m_valuesBuffer[n2] = dLPredicate;
                ++n2;
            }
            for (Map.Entry<Term, Integer> entry : this.m_bodyNonvariableTermsToIndexes.entrySet()) {
                serializable = map2.get(entry.getKey());
                if (serializable == null) {
                    throw new IllegalArgumentException("Term '" + entry.getValue() + "' is unknown to the reasoner.");
                }
                entry.setValue(n2);
                this.m_valuesBuffer[n2] = ((Node)serializable).getCanonicalNode();
                ++n2;
            }
            this.m_maxNumberOfVariables = n;
        }
    }

    public static class BufferSupply {
        protected final List<Object[]> m_allBuffers = new ArrayList<Object[]>();
        protected final Map<Integer, List<Object[]>> m_availableBuffersByArity = new HashMap<Integer, List<Object[]>>();

        public void reuseBuffers() {
            this.m_availableBuffersByArity.clear();
            for (Object[] objectArray : this.m_allBuffers) {
                Integer n = objectArray.length;
                List<Object[]> list = this.m_availableBuffersByArity.get(n);
                if (list == null) {
                    list = new ArrayList<Object[]>();
                    this.m_availableBuffersByArity.put(n, list);
                }
                list.add(objectArray);
            }
        }

        public Object[] getBuffer(int n) {
            Object[] objectArray;
            Integer n2 = n;
            List<Object[]> list = this.m_availableBuffersByArity.get(n2);
            if (list == null || list.isEmpty()) {
                objectArray = new Object[n];
                this.m_allBuffers.add(objectArray);
            } else {
                objectArray = list.remove(list.size() - 1);
            }
            return objectArray;
        }

        public Object[][] getAllBuffers() {
            Object[][] objectArray = new Object[this.m_allBuffers.size()][];
            this.m_allBuffers.toArray((T[])objectArray);
            return objectArray;
        }
    }
}

