/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.tableau;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.semanticweb.HermiT.Prefixes;
import org.semanticweb.HermiT.datatypes.DatatypeRegistry;
import org.semanticweb.HermiT.datatypes.ValueSpaceSubset;
import org.semanticweb.HermiT.model.AtomicDataRange;
import org.semanticweb.HermiT.model.AtomicNegationDataRange;
import org.semanticweb.HermiT.model.ConstantEnumeration;
import org.semanticweb.HermiT.model.DLOntology;
import org.semanticweb.HermiT.model.DataRange;
import org.semanticweb.HermiT.model.DatatypeRestriction;
import org.semanticweb.HermiT.model.Inequality;
import org.semanticweb.HermiT.model.InternalDatatype;
import org.semanticweb.HermiT.model.LiteralDataRange;
import org.semanticweb.HermiT.monitor.TableauMonitor;
import org.semanticweb.HermiT.tableau.DependencySet;
import org.semanticweb.HermiT.tableau.ExtensionManager;
import org.semanticweb.HermiT.tableau.ExtensionTable;
import org.semanticweb.HermiT.tableau.InterruptFlag;
import org.semanticweb.HermiT.tableau.Node;
import org.semanticweb.HermiT.tableau.NodeType;
import org.semanticweb.HermiT.tableau.Tableau;
import org.semanticweb.HermiT.tableau.UnionDependencySet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DatatypeManager
implements Serializable {
    private static final long serialVersionUID = -5304869484553471737L;
    protected final InterruptFlag m_interruptFlag;
    protected final TableauMonitor m_tableauMonitor;
    protected final ExtensionManager m_extensionManager;
    protected final ExtensionTable.Retrieval m_assertionsDeltaOldRetrieval;
    protected final ExtensionTable.Retrieval m_inequalityDeltaOldRetrieval;
    protected final ExtensionTable.Retrieval m_inequality01Retrieval;
    protected final ExtensionTable.Retrieval m_inequality02Retrieval;
    protected final ExtensionTable.Retrieval m_assertions0Retrieval;
    protected final ExtensionTable.Retrieval m_assertions1Retrieval;
    protected final DConjunction m_conjunction;
    protected final List<DVariable> m_auxiliaryVariableList;
    protected final UnionDependencySet m_unionDependencySet;
    protected final boolean[] m_newVariableAdded;
    protected final Set<DatatypeRestriction> m_unknownDatatypeRestrictionsPermanent;
    protected Set<DatatypeRestriction> m_unknownDatatypeRestrictionsAdditional;

    public DatatypeManager(Tableau tableau) {
        this.m_interruptFlag = tableau.m_interruptFlag;
        this.m_tableauMonitor = tableau.m_tableauMonitor;
        this.m_extensionManager = tableau.m_extensionManager;
        this.m_assertionsDeltaOldRetrieval = this.m_extensionManager.getBinaryExtensionTable().createRetrieval(new boolean[]{false, false}, ExtensionTable.View.DELTA_OLD);
        this.m_inequalityDeltaOldRetrieval = this.m_extensionManager.getTernaryExtensionTable().createRetrieval(new boolean[]{false, false, false}, ExtensionTable.View.DELTA_OLD);
        this.m_inequality01Retrieval = this.m_extensionManager.getTernaryExtensionTable().createRetrieval(new boolean[]{true, true, false}, ExtensionTable.View.EXTENSION_THIS);
        this.m_inequality02Retrieval = this.m_extensionManager.getTernaryExtensionTable().createRetrieval(new boolean[]{true, false, true}, ExtensionTable.View.EXTENSION_THIS);
        this.m_assertions0Retrieval = this.m_extensionManager.getBinaryExtensionTable().createRetrieval(new boolean[]{true, false}, ExtensionTable.View.EXTENSION_THIS);
        this.m_assertions1Retrieval = this.m_extensionManager.getBinaryExtensionTable().createRetrieval(new boolean[]{false, true}, ExtensionTable.View.EXTENSION_THIS);
        this.m_conjunction = new DConjunction();
        this.m_auxiliaryVariableList = new ArrayList<DVariable>();
        this.m_unionDependencySet = new UnionDependencySet(16);
        this.m_newVariableAdded = new boolean[1];
        this.m_unknownDatatypeRestrictionsPermanent = tableau.m_permanentDLOntology.getAllUnknownDatatypeRestrictions();
        if (tableau.m_additionalDLOntology != null) {
            this.additionalDLOntologySet(tableau.m_additionalDLOntology);
        }
    }

    public void additionalDLOntologySet(DLOntology dLOntology) {
        this.m_unknownDatatypeRestrictionsAdditional = dLOntology.getAllUnknownDatatypeRestrictions();
    }

    public void additionalDLOntologyCleared() {
        this.m_unknownDatatypeRestrictionsAdditional = null;
    }

    public void clear() {
        this.m_assertionsDeltaOldRetrieval.clear();
        this.m_inequalityDeltaOldRetrieval.clear();
        this.m_inequality01Retrieval.clear();
        this.m_inequality02Retrieval.clear();
        this.m_assertions0Retrieval.clear();
        this.m_assertions1Retrieval.clear();
        this.m_conjunction.clear();
        this.m_auxiliaryVariableList.clear();
        this.m_unionDependencySet.clearConstituents();
    }

    public void applyUnknownDatatypeRestrictionSemantics() {
        Object[] objectArray = this.m_assertionsDeltaOldRetrieval.getTupleBuffer();
        this.m_assertionsDeltaOldRetrieval.open();
        while (!this.m_extensionManager.containsClash() && !this.m_assertionsDeltaOldRetrieval.afterLast()) {
            DatatypeRestriction datatypeRestriction;
            AtomicDataRange atomicDataRange;
            LiteralDataRange literalDataRange;
            Object object = objectArray[0];
            if (object instanceof DatatypeRestriction) {
                literalDataRange = (DatatypeRestriction)object;
                if (this.m_unknownDatatypeRestrictionsPermanent.contains(literalDataRange) || this.m_unknownDatatypeRestrictionsAdditional != null && this.m_unknownDatatypeRestrictionsAdditional.contains(literalDataRange)) {
                    this.generateInequalitiesFor(literalDataRange, (Node)objectArray[1], this.m_assertionsDeltaOldRetrieval.getDependencySet(), AtomicNegationDataRange.create((AtomicDataRange)literalDataRange));
                }
            } else if (object instanceof AtomicNegationDataRange && (atomicDataRange = ((AtomicNegationDataRange)(literalDataRange = (AtomicNegationDataRange)object)).getNegatedDataRange()) instanceof DatatypeRestriction && (this.m_unknownDatatypeRestrictionsPermanent.contains(datatypeRestriction = (DatatypeRestriction)atomicDataRange) || this.m_unknownDatatypeRestrictionsAdditional != null && this.m_unknownDatatypeRestrictionsAdditional.contains(datatypeRestriction))) {
                this.generateInequalitiesFor(literalDataRange, (Node)objectArray[1], this.m_assertionsDeltaOldRetrieval.getDependencySet(), datatypeRestriction);
            }
            this.m_assertionsDeltaOldRetrieval.next();
        }
    }

    protected void generateInequalitiesFor(DataRange dataRange, Node node2, DependencySet dependencySet, DataRange dataRange2) {
        this.m_unionDependencySet.clearConstituents();
        this.m_unionDependencySet.addConstituent(dependencySet);
        this.m_unionDependencySet.addConstituent(null);
        this.m_assertions0Retrieval.getBindingsBuffer()[0] = dataRange2;
        Object[] objectArray = this.m_assertions0Retrieval.getTupleBuffer();
        this.m_assertions0Retrieval.open();
        while (!this.m_assertions0Retrieval.afterLast()) {
            Node node3 = (Node)objectArray[1];
            this.m_unionDependencySet.m_dependencySets[1] = this.m_assertions0Retrieval.getDependencySet();
            if (this.m_tableauMonitor != null) {
                this.m_tableauMonitor.unknownDatatypeRestrictionDetectionStarted(dataRange, node2, dataRange2, node3);
            }
            this.m_extensionManager.addAssertion(Inequality.INSTANCE, node2, node3, this.m_unionDependencySet, false);
            if (this.m_tableauMonitor != null) {
                this.m_tableauMonitor.unknownDatatypeRestrictionDetectionFinished(dataRange, node2, dataRange2, node3);
            }
            this.m_assertions0Retrieval.next();
        }
    }

    public void checkDatatypeConstraints() {
        Serializable serializable;
        Node node2;
        if (this.m_tableauMonitor != null) {
            this.m_tableauMonitor.datatypeCheckingStarted();
        }
        this.m_conjunction.clear();
        Object[] objectArray = this.m_assertionsDeltaOldRetrieval.getTupleBuffer();
        this.m_assertionsDeltaOldRetrieval.open();
        while (!this.m_extensionManager.containsClash() && !this.m_assertionsDeltaOldRetrieval.afterLast()) {
            if (objectArray[0] instanceof DataRange) {
                node2 = (Node)objectArray[1];
                serializable = this.getAndInitializeVariableFor(node2, this.m_newVariableAdded);
                if (this.m_newVariableAdded[0]) {
                    this.m_conjunction.clearActiveVariables();
                    this.loadConjunctionFrom((DVariable)serializable);
                    this.checkConjunctionSatisfiability();
                }
            }
            this.m_assertionsDeltaOldRetrieval.next();
        }
        objectArray = this.m_inequalityDeltaOldRetrieval.getTupleBuffer();
        this.m_inequalityDeltaOldRetrieval.open();
        while (!this.m_extensionManager.containsClash() && !this.m_inequalityDeltaOldRetrieval.afterLast()) {
            if (Inequality.INSTANCE.equals(objectArray[0])) {
                node2 = (Node)objectArray[1];
                serializable = (Node)objectArray[2];
                if (!node2.getNodeType().isAbstract() && !((Node)serializable).getNodeType().isAbstract()) {
                    this.m_conjunction.clearActiveVariables();
                    DVariable dVariable = this.getAndInitializeVariableFor(node2, this.m_newVariableAdded);
                    if (this.m_newVariableAdded[0]) {
                        this.loadConjunctionFrom(dVariable);
                    }
                    DVariable dVariable2 = this.getAndInitializeVariableFor((Node)serializable, this.m_newVariableAdded);
                    if (this.m_newVariableAdded[0]) {
                        this.loadConjunctionFrom(dVariable2);
                    }
                    this.m_conjunction.addInequality(dVariable, dVariable2);
                    this.checkConjunctionSatisfiability();
                }
            }
            this.m_inequalityDeltaOldRetrieval.next();
        }
        if (this.m_tableauMonitor != null) {
            this.m_tableauMonitor.datatypeCheckingFinished(!this.m_extensionManager.containsClash());
        }
        this.m_unionDependencySet.clearConstituents();
        this.m_conjunction.clear();
        this.m_auxiliaryVariableList.clear();
    }

    protected void loadConjunctionFrom(DVariable dVariable) {
        this.m_auxiliaryVariableList.clear();
        this.m_auxiliaryVariableList.add(dVariable);
        while (!this.m_extensionManager.containsClash() && !this.m_auxiliaryVariableList.isEmpty()) {
            DVariable dVariable2;
            Node node2;
            DVariable dVariable3 = this.m_auxiliaryVariableList.remove(this.m_auxiliaryVariableList.size() - 1);
            if (this.m_conjunction.m_activeVariables.contains(dVariable3)) continue;
            this.m_conjunction.m_activeVariables.add(dVariable3);
            if (dVariable3.m_node.getNodeType() == NodeType.ROOT_CONSTANT_NODE) continue;
            this.m_inequality01Retrieval.getBindingsBuffer()[0] = Inequality.INSTANCE;
            this.m_inequality01Retrieval.getBindingsBuffer()[1] = dVariable3.m_node;
            this.m_inequality01Retrieval.open();
            Object[] objectArray = this.m_inequality01Retrieval.getTupleBuffer();
            while (!this.m_extensionManager.containsClash() && !this.m_inequality01Retrieval.afterLast()) {
                node2 = (Node)objectArray[2];
                dVariable2 = this.getAndInitializeVariableFor(node2, this.m_newVariableAdded);
                this.m_auxiliaryVariableList.add(dVariable2);
                this.m_conjunction.addInequality(dVariable3, dVariable2);
                this.m_inequality01Retrieval.next();
                this.m_interruptFlag.checkInterrupt();
            }
            this.m_inequality02Retrieval.getBindingsBuffer()[0] = Inequality.INSTANCE;
            this.m_inequality02Retrieval.getBindingsBuffer()[2] = dVariable3.m_node;
            this.m_inequality02Retrieval.open();
            objectArray = this.m_inequality02Retrieval.getTupleBuffer();
            while (!this.m_extensionManager.containsClash() && !this.m_inequality02Retrieval.afterLast()) {
                node2 = (Node)objectArray[1];
                dVariable2 = this.getAndInitializeVariableFor(node2, this.m_newVariableAdded);
                this.m_auxiliaryVariableList.add(dVariable2);
                this.m_conjunction.addInequality(dVariable2, dVariable3);
                this.m_inequality02Retrieval.next();
                this.m_interruptFlag.checkInterrupt();
            }
        }
    }

    protected DVariable getAndInitializeVariableFor(Node node2, boolean[] blArray) {
        DVariable dVariable = this.m_conjunction.getVariableForEx(node2, blArray);
        if (this.m_newVariableAdded[0]) {
            this.m_assertions1Retrieval.getBindingsBuffer()[1] = dVariable.m_node;
            this.m_assertions1Retrieval.open();
            Object[] objectArray = this.m_assertions1Retrieval.getTupleBuffer();
            while (!this.m_extensionManager.containsClash() && !this.m_assertions1Retrieval.afterLast()) {
                Object object = objectArray[0];
                if (object instanceof DataRange) {
                    this.addDataRange(dVariable, (DataRange)object);
                }
                this.m_assertions1Retrieval.next();
                this.m_interruptFlag.checkInterrupt();
            }
            if (!this.m_extensionManager.containsClash()) {
                this.normalize(dVariable);
            }
        }
        return dVariable;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void addDataRange(DVariable dVariable, DataRange dataRange) {
        if (dataRange instanceof InternalDatatype) return;
        if (dataRange instanceof DatatypeRestriction) {
            DatatypeRestriction datatypeRestriction = (DatatypeRestriction)dataRange;
            if (this.m_unknownDatatypeRestrictionsPermanent.contains(datatypeRestriction) || this.m_unknownDatatypeRestrictionsAdditional != null && this.m_unknownDatatypeRestrictionsAdditional.contains(datatypeRestriction)) return;
            dVariable.m_positiveDatatypeRestrictions.add(datatypeRestriction);
            if (dVariable.m_mostSpecificRestriction == null) {
                dVariable.m_mostSpecificRestriction = datatypeRestriction;
                return;
            } else if (DatatypeRegistry.isDisjointWith(dVariable.m_mostSpecificRestriction.getDatatypeURI(), datatypeRestriction.getDatatypeURI())) {
                Object[] objectArray;
                Object[] objectArray2;
                this.m_unionDependencySet.clearConstituents();
                this.m_unionDependencySet.addConstituent(this.m_extensionManager.getAssertionDependencySet(dVariable.m_mostSpecificRestriction, dVariable.m_node));
                this.m_unionDependencySet.addConstituent(this.m_extensionManager.getAssertionDependencySet(datatypeRestriction, dVariable.m_node));
                if (this.m_tableauMonitor != null) {
                    objectArray2 = new Object[]{dVariable.m_mostSpecificRestriction, dVariable.m_node};
                    objectArray = new Object[]{datatypeRestriction, dVariable.m_node};
                    this.m_tableauMonitor.clashDetectionStarted(objectArray2, objectArray);
                }
                this.m_extensionManager.setClash(this.m_unionDependencySet);
                if (this.m_tableauMonitor == null) return;
                objectArray2 = new Object[]{dVariable.m_mostSpecificRestriction, dVariable.m_node};
                objectArray = new Object[]{datatypeRestriction, dVariable.m_node};
                this.m_tableauMonitor.clashDetectionFinished(objectArray2, objectArray);
                return;
            } else {
                if (!DatatypeRegistry.isSubsetOf(datatypeRestriction.getDatatypeURI(), dVariable.m_mostSpecificRestriction.getDatatypeURI())) return;
                dVariable.m_mostSpecificRestriction = datatypeRestriction;
            }
            return;
        } else if (dataRange instanceof ConstantEnumeration) {
            dVariable.m_positiveConstantEnumerations.add((ConstantEnumeration)dataRange);
            return;
        } else {
            if (!(dataRange instanceof AtomicNegationDataRange)) throw new IllegalStateException("Internal error: invalid data range.");
            AtomicDataRange atomicDataRange = ((AtomicNegationDataRange)dataRange).getNegatedDataRange();
            if (atomicDataRange instanceof InternalDatatype) return;
            if (atomicDataRange instanceof DatatypeRestriction) {
                DatatypeRestriction datatypeRestriction = (DatatypeRestriction)atomicDataRange;
                if (this.m_unknownDatatypeRestrictionsPermanent.contains(datatypeRestriction) || this.m_unknownDatatypeRestrictionsAdditional != null && this.m_unknownDatatypeRestrictionsAdditional.contains(datatypeRestriction)) return;
                dVariable.m_negativeDatatypeRestrictions.add(datatypeRestriction);
                return;
            } else {
                if (!(atomicDataRange instanceof ConstantEnumeration)) throw new IllegalStateException("Internal error: invalid data range.");
                ConstantEnumeration constantEnumeration = (ConstantEnumeration)atomicDataRange;
                dVariable.m_negativeConstantEnumerations.add(constantEnumeration);
                for (int i = constantEnumeration.getNumberOfConstants() - 1; i >= 0; --i) {
                    dVariable.addForbiddenDataValue(constantEnumeration.getConstant(i).getDataValue());
                }
            }
        }
    }

    protected void checkConjunctionSatisfiability() {
        if (!this.m_extensionManager.containsClash() && !this.m_conjunction.m_activeVariables.isEmpty()) {
            if (this.m_tableauMonitor != null) {
                this.m_tableauMonitor.datatypeConjunctionCheckingStarted(this.m_conjunction);
            }
            if (this.m_conjunction.isSymmetricClique()) {
                DVariable dVariable = this.m_conjunction.m_activeVariables.get(0);
                if (!this.m_extensionManager.containsClash() && !dVariable.hasCardinalityAtLeast(this.m_conjunction.m_activeVariables.size())) {
                    this.setClashFor(this.m_conjunction.m_activeVariables);
                }
            } else if (!this.m_extensionManager.containsClash()) {
                this.eliminateTrivialInequalities();
                this.eliminateTriviallySatisfiableNodes();
                this.enumerateValueSpaceSubsets();
                if (!this.m_extensionManager.containsClash()) {
                    this.eliminateTriviallySatisfiableNodes();
                    this.checkAssignments();
                }
            }
            if (this.m_tableauMonitor != null) {
                this.m_tableauMonitor.datatypeConjunctionCheckingFinished(this.m_conjunction, !this.m_extensionManager.containsClash());
            }
        }
    }

    protected void normalize(DVariable dVariable) {
        if (!dVariable.m_positiveConstantEnumerations.isEmpty()) {
            this.normalizeAsEnumeration(dVariable);
        } else if (!dVariable.m_positiveDatatypeRestrictions.isEmpty()) {
            this.normalizeAsValueSpaceSubset(dVariable);
        }
    }

    protected void normalizeAsEnumeration(DVariable dVariable) {
        Object object;
        dVariable.m_hasExplicitDataValues = true;
        List<Object> list = dVariable.m_explicitDataValues;
        List<ConstantEnumeration> list2 = dVariable.m_positiveConstantEnumerations;
        ConstantEnumeration constantEnumeration = list2.get(0);
        block0: for (int i = constantEnumeration.getNumberOfConstants() - 1; i >= 0; --i) {
            Object object2 = constantEnumeration.getConstant(i).getDataValue();
            if (list.contains(object2) || dVariable.m_forbiddenDataValues.contains(object2)) continue;
            for (int j = list2.size() - 1; j >= 1; --j) {
                if (!this.containsDataValue(list2.get(j), object2)) continue block0;
            }
            list.add(object2);
        }
        dVariable.m_forbiddenDataValues.clear();
        List<DatatypeRestriction> list3 = dVariable.m_positiveDatatypeRestrictions;
        for (int i = list3.size() - 1; !list.isEmpty() && i >= 0; --i) {
            DatatypeRestriction datatypeRestriction = list3.get(i);
            object = DatatypeRegistry.createValueSpaceSubset(datatypeRestriction);
            this.eliminateDataValuesUsingValueSpaceSubset((ValueSpaceSubset)object, list, false);
        }
        List<DatatypeRestriction> list4 = dVariable.m_negativeDatatypeRestrictions;
        for (int i = list4.size() - 1; !list.isEmpty() && i >= 0; --i) {
            object = list4.get(i);
            ValueSpaceSubset valueSpaceSubset = DatatypeRegistry.createValueSpaceSubset((DatatypeRestriction)object);
            this.eliminateDataValuesUsingValueSpaceSubset(valueSpaceSubset, list, true);
        }
        if (list.isEmpty()) {
            this.setClashFor(dVariable);
        }
    }

    protected boolean containsDataValue(ConstantEnumeration constantEnumeration, Object object) {
        for (int i = constantEnumeration.getNumberOfConstants() - 1; i >= 0; --i) {
            if (!constantEnumeration.getConstant(i).getDataValue().equals(object)) continue;
            return true;
        }
        return false;
    }

    protected void eliminateDataValuesUsingValueSpaceSubset(ValueSpaceSubset valueSpaceSubset, List<Object> list, boolean bl) {
        for (int i = list.size() - 1; i >= 0; --i) {
            Object object = list.get(i);
            if (valueSpaceSubset.containsDataValue(object) != bl) continue;
            list.remove(i);
        }
    }

    protected void normalizeAsValueSpaceSubset(DVariable dVariable) {
        Object object;
        int n;
        String string2 = dVariable.m_mostSpecificRestriction.getDatatypeURI();
        dVariable.m_valueSpaceSubset = DatatypeRegistry.createValueSpaceSubset(dVariable.m_mostSpecificRestriction);
        List<DatatypeRestriction> list = dVariable.m_positiveDatatypeRestrictions;
        for (int i = list.size() - 1; i >= 0; --i) {
            DatatypeRestriction datatypeRestriction = list.get(i);
            if (datatypeRestriction == dVariable.m_mostSpecificRestriction) continue;
            dVariable.m_valueSpaceSubset = DatatypeRegistry.conjoinWithDR(dVariable.m_valueSpaceSubset, datatypeRestriction);
        }
        List<DatatypeRestriction> list2 = dVariable.m_negativeDatatypeRestrictions;
        for (n = list2.size() - 1; n >= 0; --n) {
            object = list2.get(n);
            String string3 = ((DatatypeRestriction)object).getDatatypeURI();
            if (DatatypeRegistry.isDisjointWith(string2, string3)) continue;
            dVariable.m_valueSpaceSubset = DatatypeRegistry.conjoinWithDRNegation(dVariable.m_valueSpaceSubset, (DatatypeRestriction)object);
        }
        if (!dVariable.m_valueSpaceSubset.hasCardinalityAtLeast(1)) {
            dVariable.m_forbiddenDataValues.clear();
            this.setClashFor(dVariable);
        } else {
            for (n = dVariable.m_forbiddenDataValues.size() - 1; n >= 0; --n) {
                object = dVariable.m_forbiddenDataValues.get(n);
                if (dVariable.m_valueSpaceSubset.containsDataValue(object)) continue;
                dVariable.m_forbiddenDataValues.remove(n);
            }
        }
    }

    protected void eliminateTrivialInequalities() {
        for (int i = this.m_conjunction.m_activeVariables.size() - 1; i >= 0; --i) {
            DVariable dVariable = this.m_conjunction.m_activeVariables.get(i);
            if (dVariable.m_mostSpecificRestriction == null) continue;
            String string2 = dVariable.m_mostSpecificRestriction.getDatatypeURI();
            for (int j = dVariable.m_unequalToDirect.size() - 1; j >= 0; --j) {
                DVariable dVariable2 = dVariable.m_unequalToDirect.get(j);
                if (dVariable2.m_mostSpecificRestriction == null || !DatatypeRegistry.isDisjointWith(string2, dVariable2.m_mostSpecificRestriction.getDatatypeURI())) continue;
                dVariable.m_unequalTo.remove(dVariable2);
                dVariable.m_unequalToDirect.remove(dVariable2);
                dVariable2.m_unequalTo.remove(dVariable);
                dVariable2.m_unequalToDirect.remove(dVariable);
            }
        }
    }

    protected void eliminateTriviallySatisfiableNodes() {
        this.m_auxiliaryVariableList.clear();
        for (int i = this.m_conjunction.m_activeVariables.size() - 1; i >= 0; --i) {
            this.m_auxiliaryVariableList.add(this.m_conjunction.m_activeVariables.get(i));
        }
        while (!this.m_auxiliaryVariableList.isEmpty()) {
            DVariable dVariable = this.m_auxiliaryVariableList.remove(this.m_auxiliaryVariableList.size() - 1);
            if (!dVariable.hasCardinalityAtLeast(dVariable.m_unequalTo.size() + 1)) continue;
            for (int i = dVariable.m_unequalTo.size() - 1; i >= 0; --i) {
                DVariable dVariable2 = dVariable.m_unequalTo.get(i);
                dVariable2.m_unequalTo.remove(dVariable);
                dVariable2.m_unequalToDirect.remove(dVariable);
                if (this.m_auxiliaryVariableList.contains(dVariable2)) continue;
                this.m_auxiliaryVariableList.add(dVariable2);
            }
            dVariable.clearEqualities();
            this.m_conjunction.m_activeVariables.remove(dVariable);
        }
    }

    protected void enumerateValueSpaceSubsets() {
        for (int i = this.m_conjunction.m_activeVariables.size() - 1; !this.m_extensionManager.containsClash() && i >= 0; --i) {
            DVariable dVariable = this.m_conjunction.m_activeVariables.get(i);
            if (dVariable.m_valueSpaceSubset == null) continue;
            dVariable.m_hasExplicitDataValues = true;
            dVariable.m_valueSpaceSubset.enumerateDataValues(dVariable.m_explicitDataValues);
            if (!dVariable.m_forbiddenDataValues.isEmpty()) {
                for (int j = dVariable.m_explicitDataValues.size() - 1; j >= 0; --j) {
                    Object object = dVariable.m_explicitDataValues.get(j);
                    if (!dVariable.m_forbiddenDataValues.contains(object)) continue;
                    dVariable.m_explicitDataValues.remove(j);
                }
            }
            dVariable.m_valueSpaceSubset = null;
            dVariable.m_forbiddenDataValues.clear();
            if (!dVariable.m_explicitDataValues.isEmpty()) continue;
            this.setClashFor(dVariable);
        }
    }

    protected void checkAssignments() {
        Collections.sort(this.m_conjunction.m_activeVariables, SmallestEnumerationFirst.INSTANCE);
        if (!this.findAssignment(0)) {
            this.setClashFor(this.m_conjunction.m_activeVariables);
        }
    }

    protected boolean findAssignment(int n) {
        if (n == this.m_conjunction.m_activeVariables.size()) {
            return true;
        }
        DVariable dVariable = this.m_conjunction.m_activeVariables.get(n);
        for (int i = dVariable.m_explicitDataValues.size() - 1; i >= 0; --i) {
            Object object = dVariable.m_explicitDataValues.get(i);
            if (this.satisfiesNeighbors(dVariable, object)) {
                dVariable.m_dataValue = object;
                if (this.findAssignment(n + 1)) {
                    return true;
                }
            }
            this.m_interruptFlag.checkInterrupt();
        }
        dVariable.m_dataValue = null;
        return false;
    }

    protected boolean satisfiesNeighbors(DVariable dVariable, Object object) {
        for (int i = dVariable.m_unequalTo.size() - 1; i >= 0; --i) {
            Object object2 = dVariable.m_unequalTo.get((int)i).m_dataValue;
            if (object2 == null || !object2.equals(object)) continue;
            return false;
        }
        return true;
    }

    protected void setClashFor(DVariable dVariable) {
        this.m_unionDependencySet.clearConstituents();
        this.loadAssertionDependencySets(dVariable);
        this.m_extensionManager.setClash(this.m_unionDependencySet);
    }

    protected void setClashFor(List<DVariable> list) {
        this.m_unionDependencySet.clearConstituents();
        for (int i = list.size() - 1; i >= 0; --i) {
            DVariable dVariable = list.get(i);
            this.loadAssertionDependencySets(dVariable);
            for (int j = dVariable.m_unequalToDirect.size() - 1; j >= 0; --j) {
                DVariable dVariable2 = dVariable.m_unequalToDirect.get(j);
                DependencySet dependencySet = this.m_extensionManager.getAssertionDependencySet(Inequality.INSTANCE, dVariable.m_node, dVariable2.m_node);
                this.m_unionDependencySet.addConstituent(dependencySet);
            }
        }
        this.m_extensionManager.setClash(this.m_unionDependencySet);
    }

    protected void loadAssertionDependencySets(DVariable dVariable) {
        DependencySet dependencySet;
        LiteralDataRange literalDataRange;
        int n;
        Node node2 = dVariable.m_node;
        for (n = dVariable.m_positiveDatatypeRestrictions.size() - 1; n >= 0; --n) {
            literalDataRange = dVariable.m_positiveDatatypeRestrictions.get(n);
            dependencySet = this.m_extensionManager.getAssertionDependencySet(literalDataRange, node2);
            this.m_unionDependencySet.addConstituent(dependencySet);
        }
        for (n = dVariable.m_negativeDatatypeRestrictions.size() - 1; n >= 0; --n) {
            literalDataRange = dVariable.m_negativeDatatypeRestrictions.get(n).getNegation();
            dependencySet = this.m_extensionManager.getAssertionDependencySet(literalDataRange, node2);
            this.m_unionDependencySet.addConstituent(dependencySet);
        }
        for (n = dVariable.m_positiveConstantEnumerations.size() - 1; n >= 0; --n) {
            literalDataRange = dVariable.m_positiveConstantEnumerations.get(n);
            dependencySet = this.m_extensionManager.getAssertionDependencySet(literalDataRange, node2);
            this.m_unionDependencySet.addConstituent(dependencySet);
        }
        for (n = dVariable.m_negativeConstantEnumerations.size() - 1; n >= 0; --n) {
            literalDataRange = dVariable.m_negativeConstantEnumerations.get(n).getNegation();
            dependencySet = this.m_extensionManager.getAssertionDependencySet(literalDataRange, node2);
            this.m_unionDependencySet.addConstituent(dependencySet);
        }
    }

    protected static int getIndexFor(int n, int n2) {
        n += ~(n << 9);
        n ^= n >>> 14;
        n += n << 4;
        n ^= n >>> 10;
        return n & n2 - 1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class SmallestEnumerationFirst
    implements Comparator<DVariable>,
    Serializable {
        private static final long serialVersionUID = 8838838641444833249L;
        public static final Comparator<DVariable> INSTANCE = new SmallestEnumerationFirst();

        protected SmallestEnumerationFirst() {
        }

        @Override
        public int compare(DVariable dVariable, DVariable dVariable2) {
            return dVariable.m_explicitDataValues.size() - dVariable2.m_explicitDataValues.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DVariable
    implements Serializable {
        private static final long serialVersionUID = -2490195841140286089L;
        protected final List<ConstantEnumeration> m_positiveConstantEnumerations = new ArrayList<ConstantEnumeration>();
        protected final List<ConstantEnumeration> m_negativeConstantEnumerations = new ArrayList<ConstantEnumeration>();
        protected final List<DatatypeRestriction> m_positiveDatatypeRestrictions = new ArrayList<DatatypeRestriction>();
        protected final List<DatatypeRestriction> m_negativeDatatypeRestrictions = new ArrayList<DatatypeRestriction>();
        protected final List<DVariable> m_unequalTo = new ArrayList<DVariable>();
        protected final List<DVariable> m_unequalToDirect = new ArrayList<DVariable>();
        protected final List<Object> m_forbiddenDataValues = new ArrayList<Object>();
        protected final List<Object> m_explicitDataValues = new ArrayList<Object>();
        protected boolean m_hasExplicitDataValues;
        protected DatatypeRestriction m_mostSpecificRestriction;
        protected Node m_node;
        protected DVariable m_nextEntry;
        protected ValueSpaceSubset m_valueSpaceSubset;
        protected Object m_dataValue;

        protected DVariable() {
        }

        protected void dispose() {
            this.m_positiveConstantEnumerations.clear();
            this.m_negativeConstantEnumerations.clear();
            this.m_positiveDatatypeRestrictions.clear();
            this.m_negativeDatatypeRestrictions.clear();
            this.m_unequalTo.clear();
            this.m_unequalToDirect.clear();
            this.m_forbiddenDataValues.clear();
            this.m_explicitDataValues.clear();
            this.m_hasExplicitDataValues = false;
            this.m_mostSpecificRestriction = null;
            this.m_node = null;
            this.m_nextEntry = null;
            this.m_valueSpaceSubset = null;
            this.m_dataValue = null;
        }

        protected void clearEqualities() {
            this.m_unequalTo.clear();
            this.m_unequalToDirect.clear();
        }

        protected void addForbiddenDataValue(Object object) {
            if (!this.m_forbiddenDataValues.contains(object)) {
                this.m_forbiddenDataValues.add(object);
            }
        }

        public boolean hasCardinalityAtLeast(int n) {
            if (this.m_hasExplicitDataValues) {
                return this.m_explicitDataValues.size() >= n;
            }
            if (this.m_valueSpaceSubset != null) {
                return this.m_valueSpaceSubset.hasCardinalityAtLeast(n + this.m_forbiddenDataValues.size());
            }
            return true;
        }

        public Node getNode() {
            return this.m_node;
        }

        public List<ConstantEnumeration> getPositiveDataValueEnumerations() {
            return Collections.unmodifiableList(this.m_positiveConstantEnumerations);
        }

        public List<ConstantEnumeration> getNegativeDataValueEnumerations() {
            return Collections.unmodifiableList(this.m_negativeConstantEnumerations);
        }

        public List<DatatypeRestriction> getPositiveDatatypeRestrictions() {
            return Collections.unmodifiableList(this.m_positiveDatatypeRestrictions);
        }

        public List<DatatypeRestriction> getNegativeDatatypeRestrictions() {
            return Collections.unmodifiableList(this.m_negativeDatatypeRestrictions);
        }

        public List<DVariable> getUnequalToDirect() {
            return Collections.unmodifiableList(this.m_unequalToDirect);
        }

        public boolean hasSameRestrictions(DVariable dVariable) {
            return this == dVariable || DVariable.equals(this.m_positiveConstantEnumerations, dVariable.m_positiveConstantEnumerations) && DVariable.equals(this.m_negativeConstantEnumerations, dVariable.m_negativeConstantEnumerations) && DVariable.equals(this.m_positiveDatatypeRestrictions, dVariable.m_positiveDatatypeRestrictions) && DVariable.equals(this.m_negativeDatatypeRestrictions, dVariable.m_negativeDatatypeRestrictions);
        }

        protected static <T> boolean equals(List<T> list, List<T> list2) {
            if (list.size() != list2.size()) {
                return false;
            }
            for (int i = list.size() - 1; i >= 0; --i) {
                T t = list.get(i);
                if (list2.contains(t)) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return this.toString(Prefixes.STANDARD_PREFIXES);
        }

        public String toString(Prefixes prefixes) {
            int n;
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = true;
            stringBuffer.append('[');
            for (n = 0; n < this.m_positiveConstantEnumerations.size(); ++n) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.m_positiveConstantEnumerations.get(n).toString(prefixes));
            }
            for (n = 0; n < this.m_negativeConstantEnumerations.size(); ++n) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.m_negativeConstantEnumerations.get(n).getNegation().toString(prefixes));
            }
            for (n = 0; n < this.m_positiveDatatypeRestrictions.size(); ++n) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.m_positiveDatatypeRestrictions.get(n).toString(prefixes));
            }
            for (n = 0; n < this.m_negativeDatatypeRestrictions.size(); ++n) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.m_negativeDatatypeRestrictions.get(n).getNegation().toString(prefixes));
            }
            stringBuffer.append(']');
            return stringBuffer.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DConjunction
    implements Serializable {
        private static final long serialVersionUID = 3597740301361593691L;
        protected final List<DVariable> m_unusedVariables = new ArrayList<DVariable>();
        protected final List<DVariable> m_usedVariables = new ArrayList<DVariable>();
        protected final List<DVariable> m_activeVariables = new ArrayList<DVariable>();
        protected DVariable[] m_buckets = new DVariable[16];
        protected int m_numberOfEntries = 0;
        protected int m_resizeThreshold = (int)((double)this.m_buckets.length * 0.75);

        protected void clear() {
            for (int i = this.m_usedVariables.size() - 1; i >= 0; --i) {
                DVariable dVariable = this.m_usedVariables.get(i);
                dVariable.dispose();
                this.m_unusedVariables.add(dVariable);
            }
            this.m_usedVariables.clear();
            this.m_activeVariables.clear();
            Arrays.fill(this.m_buckets, null);
            this.m_numberOfEntries = 0;
        }

        protected void clearActiveVariables() {
            for (int i = this.m_activeVariables.size() - 1; i >= 0; --i) {
                this.m_activeVariables.get(i).clearEqualities();
            }
            this.m_activeVariables.clear();
        }

        public List<DVariable> getActiveVariables() {
            return Collections.unmodifiableList(this.m_activeVariables);
        }

        public DVariable getVariableFor(Node node2) {
            int n = DatatypeManager.getIndexFor(node2.hashCode(), this.m_buckets.length);
            DVariable dVariable = this.m_buckets[n];
            while (dVariable != null) {
                if (dVariable.m_node == node2) {
                    return dVariable;
                }
                dVariable = dVariable.m_nextEntry;
            }
            return null;
        }

        protected DVariable getVariableForEx(Node node2, boolean[] blArray) {
            int n = DatatypeManager.getIndexFor(node2.hashCode(), this.m_buckets.length);
            DVariable dVariable = this.m_buckets[n];
            while (dVariable != null) {
                if (dVariable.m_node == node2) {
                    blArray[0] = false;
                    return dVariable;
                }
                dVariable = dVariable.m_nextEntry;
            }
            DVariable dVariable2 = this.m_unusedVariables.isEmpty() ? new DVariable() : this.m_unusedVariables.remove(this.m_unusedVariables.size() - 1);
            dVariable2.m_node = node2;
            dVariable2.m_nextEntry = this.m_buckets[n];
            this.m_buckets[n] = dVariable2;
            ++this.m_numberOfEntries;
            if (this.m_numberOfEntries >= this.m_resizeThreshold) {
                this.resize(this.m_buckets.length * 2);
            }
            blArray[0] = true;
            this.m_usedVariables.add(dVariable2);
            return dVariable2;
        }

        protected void resize(int n) {
            DVariable[] dVariableArray = new DVariable[n];
            for (int i = 0; i < this.m_buckets.length; ++i) {
                DVariable dVariable = this.m_buckets[i];
                while (dVariable != null) {
                    DVariable dVariable2 = dVariable.m_nextEntry;
                    int n2 = DatatypeManager.getIndexFor(dVariable.m_node.hashCode(), n);
                    dVariable.m_nextEntry = dVariableArray[n2];
                    dVariableArray[n2] = dVariable;
                    dVariable = dVariable2;
                }
            }
            this.m_buckets = dVariableArray;
            this.m_resizeThreshold = (int)((double)n * 0.75);
        }

        protected void addInequality(DVariable dVariable, DVariable dVariable2) {
            assert (dVariable != dVariable2);
            if (!dVariable.m_unequalTo.contains(dVariable2)) {
                dVariable.m_unequalTo.add(dVariable2);
                dVariable2.m_unequalTo.add(dVariable);
                dVariable.m_unequalToDirect.add(dVariable2);
            }
        }

        public boolean isSymmetricClique() {
            int n = this.m_activeVariables.size();
            if (n > 0) {
                DVariable dVariable = this.m_activeVariables.get(0);
                for (int i = n - 1; i >= 0; --i) {
                    DVariable dVariable2 = this.m_activeVariables.get(i);
                    if (dVariable2.m_unequalTo.size() + 1 == n && dVariable.hasSameRestrictions(dVariable2)) continue;
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            return this.toString(Prefixes.STANDARD_PREFIXES);
        }

        public String toString(Prefixes prefixes) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = true;
            for (int i = 0; i < this.m_activeVariables.size(); ++i) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append(" & ");
                }
                DVariable dVariable = this.m_activeVariables.get(i);
                stringBuffer.append(dVariable.toString(prefixes));
                stringBuffer.append('(');
                stringBuffer.append(i);
                stringBuffer.append(')');
                for (int j = 0; j < dVariable.m_unequalToDirect.size(); ++j) {
                    stringBuffer.append(" & ");
                    stringBuffer.append(i);
                    stringBuffer.append(" != ");
                    stringBuffer.append(this.m_activeVariables.indexOf(dVariable.m_unequalToDirect.get(j)));
                }
            }
            return stringBuffer.toString();
        }
    }
}

