/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.tableau;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.semanticweb.HermiT.graph.Graph;
import org.semanticweb.HermiT.model.AtLeast;
import org.semanticweb.HermiT.model.AtLeastConcept;
import org.semanticweb.HermiT.model.AtLeastDataRange;
import org.semanticweb.HermiT.model.AtomicRole;
import org.semanticweb.HermiT.model.DLClause;
import org.semanticweb.HermiT.model.ExistentialConcept;
import org.semanticweb.HermiT.model.Inequality;
import org.semanticweb.HermiT.model.InverseRole;
import org.semanticweb.HermiT.model.Role;
import org.semanticweb.HermiT.tableau.DependencySet;
import org.semanticweb.HermiT.tableau.ExtensionManager;
import org.semanticweb.HermiT.tableau.ExtensionTable;
import org.semanticweb.HermiT.tableau.Node;
import org.semanticweb.HermiT.tableau.Tableau;
import org.semanticweb.HermiT.tableau.TupleTable;
import org.semanticweb.HermiT.tableau.UnionDependencySet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExistentialExpansionManager
implements Serializable {
    private static final long serialVersionUID = 4794168582297181623L;
    protected final Tableau m_tableau;
    protected final ExtensionManager m_extensionManager;
    protected final TupleTable m_expandedExistentials;
    protected final Object[] m_auxiliaryTuple;
    protected final List<Node> m_auxiliaryNodes;
    protected final ExtensionTable.Retrieval m_ternaryExtensionTableSearch01Bound;
    protected final ExtensionTable.Retrieval m_ternaryExtensionTableSearch02Bound;
    protected final Map<Role, Role[]> m_functionalRoles;
    protected final UnionDependencySet m_binaryUnionDependencySet;
    protected int[] m_indicesByBranchingPoint;

    public ExistentialExpansionManager(Tableau tableau) {
        this.m_tableau = tableau;
        this.m_extensionManager = this.m_tableau.m_extensionManager;
        this.m_expandedExistentials = new TupleTable(2);
        this.m_auxiliaryTuple = new Object[2];
        this.m_auxiliaryNodes = new ArrayList<Node>();
        this.m_ternaryExtensionTableSearch01Bound = this.m_extensionManager.getTernaryExtensionTable().createRetrieval(new boolean[]{true, true, false}, ExtensionTable.View.TOTAL);
        this.m_ternaryExtensionTableSearch02Bound = this.m_extensionManager.getTernaryExtensionTable().createRetrieval(new boolean[]{true, false, true}, ExtensionTable.View.TOTAL);
        this.m_functionalRoles = new HashMap<Role, Role[]>();
        this.updateFunctionalRoles();
        this.m_binaryUnionDependencySet = new UnionDependencySet(2);
        this.m_indicesByBranchingPoint = new int[2];
    }

    protected void updateFunctionalRoles() {
        Graph<Role> graph = new Graph<Role>();
        HashSet<Role> hashSet = new HashSet<Role>();
        this.loadDLClausesIntoGraph(this.m_tableau.m_permanentDLOntology.getDLClauses(), graph, hashSet);
        for (Role object : graph.getElements()) {
            graph.addEdge(object, object);
            graph.addEdge(object.getInverse(), object.getInverse());
        }
        graph.transitivelyClose();
        Graph<Role> graph2 = graph.getInverse();
        this.m_functionalRoles.clear();
        for (Role role : graph.getElements()) {
            HashSet<Role> hashSet2 = new HashSet<Role>();
            Set<Role> set2 = graph.getSuccessors(role);
            for (Role role2 : set2) {
                if (!hashSet.contains(role2)) continue;
                hashSet2.addAll(graph2.getSuccessors(role2));
            }
            if (hashSet2.isEmpty()) continue;
            Role[] roleArray = new Role[hashSet2.size()];
            hashSet2.toArray(roleArray);
            this.m_functionalRoles.put(role, roleArray);
        }
    }

    protected void loadDLClausesIntoGraph(Set<DLClause> set2, Graph<Role> graph, Set<Role> set3) {
        for (DLClause dLClause : set2) {
            AtomicRole atomicRole;
            AtomicRole atomicRole2;
            if (dLClause.isAtomicRoleInclusion()) {
                atomicRole2 = (AtomicRole)dLClause.getBodyAtom(0).getDLPredicate();
                atomicRole = (AtomicRole)dLClause.getHeadAtom(0).getDLPredicate();
                graph.addEdge(atomicRole2, atomicRole);
                graph.addEdge(atomicRole2.getInverse(), atomicRole.getInverse());
                continue;
            }
            if (dLClause.isAtomicRoleInverseInclusion()) {
                atomicRole2 = (AtomicRole)dLClause.getBodyAtom(0).getDLPredicate();
                atomicRole = (AtomicRole)dLClause.getHeadAtom(0).getDLPredicate();
                graph.addEdge(atomicRole2, atomicRole.getInverse());
                graph.addEdge(atomicRole2.getInverse(), atomicRole);
                continue;
            }
            if (dLClause.isFunctionalityAxiom()) {
                atomicRole2 = (AtomicRole)dLClause.getBodyAtom(0).getDLPredicate();
                set3.add(atomicRole2);
                continue;
            }
            if (!dLClause.isInverseFunctionalityAxiom()) continue;
            atomicRole2 = (AtomicRole)dLClause.getBodyAtom(0).getDLPredicate();
            set3.add(atomicRole2.getInverse());
        }
    }

    public void markExistentialProcessed(ExistentialConcept existentialConcept, Node node2) {
        this.m_auxiliaryTuple[0] = existentialConcept;
        this.m_auxiliaryTuple[1] = node2;
        this.m_expandedExistentials.addTuple(this.m_auxiliaryTuple);
        node2.removeFromUnprocessedExistentials(existentialConcept);
    }

    public void branchingPointPushed() {
        int n = this.m_tableau.getCurrentBranchingPoint().m_level;
        int n2 = n + 1;
        if (n2 > this.m_indicesByBranchingPoint.length) {
            int n3 = this.m_indicesByBranchingPoint.length * 3 / 2;
            while (n2 > n3) {
                n3 = n3 * 3 / 2;
            }
            int[] nArray = new int[n3];
            System.arraycopy(this.m_indicesByBranchingPoint, 0, nArray, 0, this.m_indicesByBranchingPoint.length);
            this.m_indicesByBranchingPoint = nArray;
        }
        this.m_indicesByBranchingPoint[n] = this.m_expandedExistentials.getFirstFreeTupleIndex();
    }

    public void backtrack() {
        int n = this.m_indicesByBranchingPoint[this.m_tableau.getCurrentBranchingPoint().m_level];
        for (int i = this.m_expandedExistentials.getFirstFreeTupleIndex() - 1; i >= n; --i) {
            this.m_expandedExistentials.retrieveTuple(this.m_auxiliaryTuple, i);
            ExistentialConcept existentialConcept = (ExistentialConcept)this.m_auxiliaryTuple[0];
            Node node2 = (Node)this.m_auxiliaryTuple[1];
            node2.addToUnprocessedExistentials(existentialConcept);
        }
        this.m_expandedExistentials.truncate(n);
    }

    public void clear() {
        this.m_expandedExistentials.clear();
        this.m_auxiliaryTuple[0] = null;
        this.m_auxiliaryTuple[1] = null;
        this.m_ternaryExtensionTableSearch01Bound.clear();
        this.m_ternaryExtensionTableSearch02Bound.clear();
        this.m_binaryUnionDependencySet.m_dependencySets[0] = null;
        this.m_binaryUnionDependencySet.m_dependencySets[1] = null;
    }

    public boolean tryFunctionalExpansion(AtLeast atLeast, Node node2) {
        if (atLeast.getNumber() == 1) {
            if (this.getFunctionalExpansionNode(atLeast.getOnRole(), node2, this.m_auxiliaryTuple)) {
                if (this.m_tableau.m_tableauMonitor != null) {
                    this.m_tableau.m_tableauMonitor.existentialExpansionStarted(atLeast, node2);
                }
                Node node3 = (Node)this.m_auxiliaryTuple[0];
                this.m_binaryUnionDependencySet.m_dependencySets[0] = this.m_extensionManager.getConceptAssertionDependencySet(atLeast, node2);
                this.m_binaryUnionDependencySet.m_dependencySets[1] = (DependencySet)this.m_auxiliaryTuple[1];
                this.m_extensionManager.addRoleAssertion(atLeast.getOnRole(), node2, node3, this.m_binaryUnionDependencySet, true);
                if (atLeast instanceof AtLeastConcept) {
                    this.m_extensionManager.addConceptAssertion(((AtLeastConcept)atLeast).getToConcept(), node3, this.m_binaryUnionDependencySet, true);
                } else {
                    this.m_extensionManager.addDataRangeAssertion(((AtLeastDataRange)atLeast).getToDataRange(), node3, this.m_binaryUnionDependencySet, true);
                }
                if (this.m_tableau.m_tableauMonitor != null) {
                    this.m_tableau.m_tableauMonitor.existentialExpansionFinished(atLeast, node2);
                }
                return true;
            }
        } else if (atLeast.getNumber() > 1 && this.m_functionalRoles.containsKey(atLeast.getOnRole())) {
            if (this.m_tableau.m_tableauMonitor != null) {
                this.m_tableau.m_tableauMonitor.existentialExpansionStarted(atLeast, node2);
            }
            DependencySet dependencySet = this.m_extensionManager.getConceptAssertionDependencySet(atLeast, node2);
            this.m_extensionManager.setClash(dependencySet);
            if (this.m_tableau.m_tableauMonitor != null) {
                this.m_tableau.m_tableauMonitor.existentialExpansionFinished(atLeast, node2);
            }
            return true;
        }
        return false;
    }

    protected boolean getFunctionalExpansionNode(Role role, Node node2, Object[] objectArray) {
        Role[] roleArray = this.m_functionalRoles.get(role);
        if (roleArray != null) {
            for (Role role2 : roleArray) {
                int n;
                ExtensionTable.Retrieval retrieval;
                if (role2 instanceof AtomicRole) {
                    retrieval = this.m_ternaryExtensionTableSearch01Bound;
                    retrieval.getBindingsBuffer()[0] = role2;
                    retrieval.getBindingsBuffer()[1] = node2;
                    n = 2;
                } else {
                    retrieval = this.m_ternaryExtensionTableSearch02Bound;
                    retrieval.getBindingsBuffer()[0] = ((InverseRole)role2).getInverseOf();
                    retrieval.getBindingsBuffer()[2] = node2;
                    n = 1;
                }
                retrieval.open();
                if (retrieval.afterLast()) continue;
                objectArray[0] = retrieval.getTupleBuffer()[n];
                objectArray[1] = retrieval.getDependencySet();
                return true;
            }
        }
        return false;
    }

    public void doNormalExpansion(AtLeastConcept atLeastConcept, Node node2) {
        if (this.m_tableau.m_tableauMonitor != null) {
            this.m_tableau.m_tableauMonitor.existentialExpansionStarted(atLeastConcept, node2);
        }
        DependencySet dependencySet = this.m_extensionManager.getConceptAssertionDependencySet(atLeastConcept, node2);
        int n = atLeastConcept.getNumber();
        if (n == 1) {
            Node node3 = this.m_tableau.createNewTreeNode(dependencySet, node2);
            this.m_extensionManager.addRoleAssertion(atLeastConcept.getOnRole(), node2, node3, dependencySet, true);
            this.m_extensionManager.addConceptAssertion(atLeastConcept.getToConcept(), node3, dependencySet, true);
        } else {
            Node node4;
            int n2;
            this.m_auxiliaryNodes.clear();
            for (n2 = 0; n2 < n; ++n2) {
                node4 = this.m_tableau.createNewTreeNode(dependencySet, node2);
                this.m_extensionManager.addRoleAssertion(atLeastConcept.getOnRole(), node2, node4, dependencySet, true);
                this.m_extensionManager.addConceptAssertion(atLeastConcept.getToConcept(), node4, dependencySet, true);
                this.m_auxiliaryNodes.add(node4);
            }
            for (n2 = 0; n2 < n; ++n2) {
                node4 = this.m_auxiliaryNodes.get(n2);
                for (int i = n2 + 1; i < n; ++i) {
                    this.m_extensionManager.addAssertion(Inequality.INSTANCE, node4, this.m_auxiliaryNodes.get(i), dependencySet, true);
                }
            }
            this.m_auxiliaryNodes.clear();
        }
        if (this.m_tableau.m_tableauMonitor != null) {
            this.m_tableau.m_tableauMonitor.existentialExpansionFinished(atLeastConcept, node2);
        }
    }

    public void doNormalExpansion(AtLeastDataRange atLeastDataRange, Node node2) {
        if (this.m_tableau.m_tableauMonitor != null) {
            this.m_tableau.m_tableauMonitor.existentialExpansionStarted(atLeastDataRange, node2);
        }
        DependencySet dependencySet = this.m_extensionManager.getConceptAssertionDependencySet(atLeastDataRange, node2);
        int n = atLeastDataRange.getNumber();
        if (n == 1) {
            Node node3 = this.m_tableau.createNewConcreteNode(dependencySet, node2);
            this.m_extensionManager.addRoleAssertion(atLeastDataRange.getOnRole(), node2, node3, dependencySet, true);
            this.m_extensionManager.addDataRangeAssertion(atLeastDataRange.getToDataRange(), node3, dependencySet, true);
        } else {
            Node node4;
            int n2;
            this.m_auxiliaryNodes.clear();
            for (n2 = 0; n2 < n; ++n2) {
                node4 = this.m_tableau.createNewConcreteNode(dependencySet, node2);
                this.m_extensionManager.addRoleAssertion(atLeastDataRange.getOnRole(), node2, node4, dependencySet, true);
                this.m_extensionManager.addDataRangeAssertion(atLeastDataRange.getToDataRange(), node4, dependencySet, true);
                this.m_auxiliaryNodes.add(node4);
            }
            for (n2 = 0; n2 < n; ++n2) {
                node4 = this.m_auxiliaryNodes.get(n2);
                for (int i = n2 + 1; i < n; ++i) {
                    this.m_extensionManager.addAssertion(Inequality.INSTANCE, node4, this.m_auxiliaryNodes.get(i), dependencySet, true);
                }
            }
            this.m_auxiliaryNodes.clear();
        }
        if (this.m_tableau.m_tableauMonitor != null) {
            this.m_tableau.m_tableauMonitor.existentialExpansionFinished(atLeastDataRange, node2);
        }
    }

    public void expand(AtLeast atLeast, Node node2) {
        if (!this.tryFunctionalExpansion(atLeast, node2)) {
            if (atLeast instanceof AtLeastConcept) {
                this.doNormalExpansion((AtLeastConcept)atLeast, node2);
            } else {
                this.doNormalExpansion((AtLeastDataRange)atLeast, node2);
            }
        }
    }
}

