/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.tableau;

import org.semanticweb.HermiT.Prefixes;
import org.semanticweb.HermiT.model.AtLeastConcept;
import org.semanticweb.HermiT.model.AtomicNegationConcept;
import org.semanticweb.HermiT.model.DLPredicate;

public final class GroundDisjunctionHeader {
    protected final DLPredicate[] m_dlPredicates;
    protected final int[] m_disjunctStart;
    protected final int m_hashCode;
    protected final DisjunctIndexWithBacktrackings[] m_disjunctIndexesWithBacktrackings;
    protected final int m_firstAtLeastPositiveIndex;
    protected final int m_firstAtLeastNegativeIndex;
    protected GroundDisjunctionHeader m_nextEntry;

    protected GroundDisjunctionHeader(DLPredicate[] dLPredicateArray, int n, GroundDisjunctionHeader groundDisjunctionHeader) {
        int n2;
        int n3;
        this.m_dlPredicates = dLPredicateArray;
        this.m_disjunctStart = new int[this.m_dlPredicates.length];
        int n4 = 0;
        for (n3 = 0; n3 < this.m_dlPredicates.length; ++n3) {
            this.m_disjunctStart[n3] = n4;
            n4 += this.m_dlPredicates[n3].getArity();
        }
        this.m_hashCode = n;
        this.m_nextEntry = groundDisjunctionHeader;
        this.m_disjunctIndexesWithBacktrackings = new DisjunctIndexWithBacktrackings[dLPredicateArray.length];
        n3 = 0;
        int n5 = 0;
        for (n2 = 0; n2 < dLPredicateArray.length; ++n2) {
            if (!(this.m_dlPredicates[n2] instanceof AtLeastConcept)) continue;
            AtLeastConcept atLeastConcept = (AtLeastConcept)this.m_dlPredicates[n2];
            if (atLeastConcept.getToConcept() instanceof AtomicNegationConcept) {
                ++n5;
                continue;
            }
            ++n3;
        }
        this.m_firstAtLeastNegativeIndex = this.m_disjunctIndexesWithBacktrackings.length - n3 - n5;
        this.m_firstAtLeastPositiveIndex = this.m_disjunctIndexesWithBacktrackings.length - n3;
        n2 = 0;
        int n6 = this.m_firstAtLeastNegativeIndex;
        int n7 = this.m_firstAtLeastPositiveIndex;
        for (int i = 0; i < dLPredicateArray.length; ++i) {
            if (this.m_dlPredicates[i] instanceof AtLeastConcept) {
                AtLeastConcept atLeastConcept = (AtLeastConcept)this.m_dlPredicates[i];
                if (atLeastConcept.getToConcept() instanceof AtomicNegationConcept) {
                    this.m_disjunctIndexesWithBacktrackings[n6++] = new DisjunctIndexWithBacktrackings(i);
                    continue;
                }
                this.m_disjunctIndexesWithBacktrackings[n7++] = new DisjunctIndexWithBacktrackings(i);
                continue;
            }
            this.m_disjunctIndexesWithBacktrackings[n2++] = new DisjunctIndexWithBacktrackings(i);
        }
    }

    protected boolean isEqual(DLPredicate[] dLPredicateArray) {
        if (this.m_dlPredicates.length != dLPredicateArray.length) {
            return false;
        }
        for (int i = this.m_dlPredicates.length - 1; i >= 0; --i) {
            if (this.m_dlPredicates[i].equals(dLPredicateArray[i])) continue;
            return false;
        }
        return true;
    }

    public int[] getSortedDisjunctIndexes() {
        int[] nArray = new int[this.m_disjunctIndexesWithBacktrackings.length];
        for (int i = this.m_disjunctIndexesWithBacktrackings.length - 1; i >= 0; --i) {
            nArray[i] = this.m_disjunctIndexesWithBacktrackings[i].m_disjunctIndex;
        }
        return nArray;
    }

    public void increaseNumberOfBacktrackings(int n) {
        for (int i = 0; i < this.m_disjunctIndexesWithBacktrackings.length; ++i) {
            DisjunctIndexWithBacktrackings disjunctIndexWithBacktrackings = this.m_disjunctIndexesWithBacktrackings[i];
            if (disjunctIndexWithBacktrackings.m_disjunctIndex != n) continue;
            ++disjunctIndexWithBacktrackings.m_numberOfBacktrackings;
            int n2 = i < this.m_firstAtLeastNegativeIndex ? this.m_firstAtLeastNegativeIndex : (i >= this.m_firstAtLeastNegativeIndex && i < this.m_firstAtLeastPositiveIndex ? this.m_firstAtLeastPositiveIndex : this.m_disjunctIndexesWithBacktrackings.length);
            int n3 = i;
            int n4 = n3 + 1;
            while (n4 < n2 && disjunctIndexWithBacktrackings.m_numberOfBacktrackings > this.m_disjunctIndexesWithBacktrackings[n4].m_numberOfBacktrackings) {
                this.m_disjunctIndexesWithBacktrackings[n3] = this.m_disjunctIndexesWithBacktrackings[n4];
                this.m_disjunctIndexesWithBacktrackings[n4] = disjunctIndexWithBacktrackings;
                n3 = n4++;
            }
            break;
        }
    }

    public String toString(Prefixes prefixes) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.m_dlPredicates.length; ++i) {
            if (i > 0) {
                stringBuffer.append(" \\/ ");
            }
            stringBuffer.append(this.m_dlPredicates[i].toString(prefixes));
            stringBuffer.append(" (");
            for (DisjunctIndexWithBacktrackings disjunctIndexWithBacktrackings : this.m_disjunctIndexesWithBacktrackings) {
                if (disjunctIndexWithBacktrackings.m_disjunctIndex != i) continue;
                stringBuffer.append(disjunctIndexWithBacktrackings.m_numberOfBacktrackings);
                break;
            }
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toString(Prefixes.STANDARD_PREFIXES);
    }

    protected static class DisjunctIndexWithBacktrackings {
        protected final int m_disjunctIndex;
        protected int m_numberOfBacktrackings;

        public DisjunctIndexWithBacktrackings(int n) {
            this.m_disjunctIndex = n;
        }
    }
}

