/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.tableau;

import java.io.Serializable;
import org.semanticweb.HermiT.model.DescriptionGraph;
import org.semanticweb.HermiT.monitor.TableauMonitor;
import org.semanticweb.HermiT.tableau.DependencySet;
import org.semanticweb.HermiT.tableau.ExtensionManager;
import org.semanticweb.HermiT.tableau.ExtensionTable;
import org.semanticweb.HermiT.tableau.Node;
import org.semanticweb.HermiT.tableau.Tableau;
import org.semanticweb.HermiT.tableau.UnionDependencySet;

public final class MergingManager
implements Serializable {
    private static final long serialVersionUID = -8404748898127176927L;
    protected final Tableau m_tableau;
    protected final TableauMonitor m_tableauMonitor;
    protected final ExtensionManager m_extensionManager;
    protected final ExtensionTable.Retrieval m_binaryExtensionTableSearch1Bound;
    protected final ExtensionTable.Retrieval m_ternaryExtensionTableSearch1Bound;
    protected final ExtensionTable.Retrieval m_ternaryExtensionTableSearch2Bound;
    protected final Object[] m_binaryAuxiliaryTuple;
    protected final Object[] m_ternaryAuxiliaryTuple;
    protected final UnionDependencySet m_binaryUnionDependencySet;

    public MergingManager(Tableau tableau) {
        this.m_tableau = tableau;
        this.m_tableauMonitor = this.m_tableau.m_tableauMonitor;
        this.m_extensionManager = this.m_tableau.m_extensionManager;
        this.m_binaryExtensionTableSearch1Bound = this.m_extensionManager.m_binaryExtensionTable.createRetrieval(new boolean[]{false, true}, ExtensionTable.View.TOTAL);
        this.m_ternaryExtensionTableSearch1Bound = this.m_extensionManager.m_ternaryExtensionTable.createRetrieval(new boolean[]{false, true, false}, ExtensionTable.View.TOTAL);
        this.m_ternaryExtensionTableSearch2Bound = this.m_extensionManager.m_ternaryExtensionTable.createRetrieval(new boolean[]{false, false, true}, ExtensionTable.View.TOTAL);
        this.m_binaryAuxiliaryTuple = new Object[2];
        this.m_ternaryAuxiliaryTuple = new Object[3];
        this.m_binaryUnionDependencySet = new UnionDependencySet(2);
    }

    public void clear() {
        this.m_binaryExtensionTableSearch1Bound.clear();
        this.m_ternaryExtensionTableSearch1Bound.clear();
        this.m_ternaryExtensionTableSearch2Bound.clear();
        this.m_binaryAuxiliaryTuple[0] = null;
        this.m_binaryAuxiliaryTuple[1] = null;
        this.m_ternaryAuxiliaryTuple[0] = null;
        this.m_ternaryAuxiliaryTuple[1] = null;
        this.m_ternaryAuxiliaryTuple[2] = null;
    }

    public boolean mergeNodes(Node node2, Node node3, DependencySet dependencySet) {
        Object[] objectArray;
        Node node4;
        Node node5;
        Node node6;
        int n;
        assert (node2.getNodeType().isAbstract() == node3.getNodeType().isAbstract());
        if (!node2.isActive() || !node3.isActive() || node2 == node3) {
            return false;
        }
        int n2 = node2.getNodeType().getMergePrecedence();
        if (n2 < (n = node3.getNodeType().getMergePrecedence())) {
            node6 = node3;
            node5 = node2;
        } else if (n2 > n) {
            node6 = node2;
            node5 = node3;
        } else {
            boolean bl;
            node4 = node2.getClusterAnchor();
            objectArray = node3.getClusterAnchor();
            boolean bl2 = node2.m_parent == node3.m_parent || this.isDescendantOfAtMostThreeLevels(node2, (Node)objectArray);
            boolean bl3 = bl = node2.m_parent == node3.m_parent || this.isDescendantOfAtMostThreeLevels(node3, node4);
            if (bl2 && bl) {
                if (node2.m_numberOfPositiveAtomicConcepts > node3.m_numberOfPositiveAtomicConcepts) {
                    node6 = node3;
                    node5 = node2;
                } else {
                    node6 = node2;
                    node5 = node3;
                }
            } else if (bl2) {
                node6 = node2;
                node5 = node3;
            } else if (bl) {
                node6 = node3;
                node5 = node2;
            } else {
                throw new IllegalStateException("Internal error: unsupported merge type.");
            }
        }
        if (this.m_tableauMonitor != null) {
            this.m_tableauMonitor.mergeStarted(node6, node5);
        }
        for (node4 = node6; node4 != null; node4 = node4.getNextTableauNode()) {
            if (!node4.isActive() || node4.m_parent == null || node4.m_parent.isActive() && node4.m_parent != node6) continue;
            if (this.m_tableauMonitor != null) {
                this.m_tableauMonitor.nodePruned(node4);
            }
            this.m_tableau.pruneNode(node4);
        }
        this.m_binaryUnionDependencySet.m_dependencySets[1] = dependencySet;
        this.m_binaryAuxiliaryTuple[1] = node5;
        this.m_binaryExtensionTableSearch1Bound.getBindingsBuffer()[1] = node6;
        this.m_binaryExtensionTableSearch1Bound.open();
        objectArray = this.m_binaryExtensionTableSearch1Bound.getTupleBuffer();
        while (!this.m_binaryExtensionTableSearch1Bound.afterLast()) {
            Object object = objectArray[0];
            if (!(object instanceof DescriptionGraph)) {
                this.m_binaryAuxiliaryTuple[0] = object;
                if (this.m_tableauMonitor != null) {
                    this.m_tableauMonitor.mergeFactStarted(node6, node5, objectArray, this.m_binaryAuxiliaryTuple);
                }
                this.m_binaryUnionDependencySet.m_dependencySets[0] = this.m_binaryExtensionTableSearch1Bound.getDependencySet();
                this.m_extensionManager.addTuple(this.m_binaryAuxiliaryTuple, this.m_binaryUnionDependencySet, this.m_binaryExtensionTableSearch1Bound.isCore());
                if (this.m_tableauMonitor != null) {
                    this.m_tableauMonitor.mergeFactFinished(node6, node5, objectArray, this.m_binaryAuxiliaryTuple);
                }
            }
            this.m_binaryExtensionTableSearch1Bound.next();
        }
        this.m_ternaryAuxiliaryTuple[1] = node5;
        this.m_ternaryExtensionTableSearch1Bound.getBindingsBuffer()[1] = node6;
        this.m_ternaryExtensionTableSearch1Bound.open();
        objectArray = this.m_ternaryExtensionTableSearch1Bound.getTupleBuffer();
        while (!this.m_ternaryExtensionTableSearch1Bound.afterLast()) {
            Object object = objectArray[0];
            if (!(object instanceof DescriptionGraph)) {
                this.m_ternaryAuxiliaryTuple[0] = object;
                Object object2 = this.m_ternaryAuxiliaryTuple[2] = objectArray[2] == node6 ? node5 : objectArray[2];
                if (this.m_tableauMonitor != null) {
                    this.m_tableauMonitor.mergeFactStarted(node6, node5, objectArray, this.m_ternaryAuxiliaryTuple);
                }
                this.m_binaryUnionDependencySet.m_dependencySets[0] = this.m_ternaryExtensionTableSearch1Bound.getDependencySet();
                this.m_extensionManager.addTuple(this.m_ternaryAuxiliaryTuple, this.m_binaryUnionDependencySet, this.m_ternaryExtensionTableSearch1Bound.isCore());
                if (this.m_tableauMonitor != null) {
                    this.m_tableauMonitor.mergeFactFinished(node6, node5, objectArray, this.m_ternaryAuxiliaryTuple);
                }
            }
            this.m_ternaryExtensionTableSearch1Bound.next();
        }
        this.m_ternaryAuxiliaryTuple[2] = node5;
        this.m_ternaryExtensionTableSearch2Bound.getBindingsBuffer()[2] = node6;
        this.m_ternaryExtensionTableSearch2Bound.open();
        objectArray = this.m_ternaryExtensionTableSearch2Bound.getTupleBuffer();
        while (!this.m_ternaryExtensionTableSearch2Bound.afterLast()) {
            Object object = objectArray[0];
            if (!(object instanceof DescriptionGraph)) {
                this.m_ternaryAuxiliaryTuple[0] = object;
                Object object3 = this.m_ternaryAuxiliaryTuple[1] = objectArray[1] == node6 ? node5 : objectArray[1];
                if (this.m_tableauMonitor != null) {
                    this.m_tableauMonitor.mergeFactStarted(node6, node5, objectArray, this.m_ternaryAuxiliaryTuple);
                }
                this.m_binaryUnionDependencySet.m_dependencySets[0] = this.m_ternaryExtensionTableSearch2Bound.getDependencySet();
                this.m_extensionManager.addTuple(this.m_ternaryAuxiliaryTuple, this.m_binaryUnionDependencySet, this.m_ternaryExtensionTableSearch2Bound.isCore());
                if (this.m_tableauMonitor != null) {
                    this.m_tableauMonitor.mergeFactFinished(node6, node5, objectArray, this.m_ternaryAuxiliaryTuple);
                }
            }
            this.m_ternaryExtensionTableSearch2Bound.next();
        }
        this.m_tableau.m_descriptionGraphManager.mergeGraphs(node6, node5, this.m_binaryUnionDependencySet);
        this.m_tableau.mergeNode(node6, node5, dependencySet);
        if (this.m_tableauMonitor != null) {
            this.m_tableauMonitor.mergeFinished(node6, node5);
        }
        return true;
    }

    protected boolean isDescendantOfAtMostThreeLevels(Node node2, Node node3) {
        if (node2 != null) {
            Node node4 = node2.m_parent;
            if (node4 == node3) {
                return true;
            }
            if (node4 != null) {
                Node node5;
                Node node6 = node4.m_parent;
                if (node6 == node3) {
                    return true;
                }
                if (node6 != null && (node5 = node6.m_parent) == node3) {
                    return true;
                }
            }
        }
        return false;
    }
}

