/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.tableau;

import java.io.Serializable;

public final class TupleIndex
implements Serializable {
    private static final long serialVersionUID = -4284072092430590904L;
    protected static final float LOAD_FACTOR = 0.7f;
    protected static final int BUCKET_OFFSET = 1;
    protected final int[] m_indexingSequence;
    protected final TrieNodeManager m_trieNodeManager;
    protected int m_root;
    protected int[] m_buckets;
    protected int m_bucketsLengthMinusOne;
    protected int m_resizeThreshold;
    protected int m_numberOfNodes;
    protected static final int TRIE_NODE_PARENT = 0;
    protected static final int TRIE_NODE_FIRST_CHILD = 1;
    protected static final int TRIE_NODE_TUPLE_INDEX = 1;
    protected static final int TRIE_NODE_PREVIOUS_SIBLING = 2;
    protected static final int TRIE_NODE_NEXT_SIBLING = 3;
    protected static final int TRIE_NODE_NEXT_ENTRY = 4;
    protected static final int TRIE_NODE_SIZE = 5;
    protected static final int TRIE_NODE_PAGE_SIZE = 1024;

    public TupleIndex(int[] nArray) {
        this.m_indexingSequence = nArray;
        this.m_trieNodeManager = new TrieNodeManager();
        this.clear();
    }

    public int sizeInMemoy() {
        return this.m_buckets.length * 4 + this.m_trieNodeManager.size();
    }

    public int[] getIndexingSequence() {
        return this.m_indexingSequence;
    }

    public void clear() {
        this.m_trieNodeManager.clear();
        this.m_root = this.m_trieNodeManager.newTrieNode();
        this.m_trieNodeManager.initializeTrieNode(this.m_root, -1, -1, -1, -1, -1, null);
        this.m_buckets = new int[16];
        this.m_bucketsLengthMinusOne = this.m_buckets.length - 1;
        this.m_resizeThreshold = (int)((float)this.m_buckets.length * 0.7f);
        this.m_numberOfNodes = 0;
    }

    public int addTuple(Object[] objectArray, int n) {
        int n2 = this.m_root;
        for (int i = 0; i < this.m_indexingSequence.length; ++i) {
            Object object = objectArray[this.m_indexingSequence[i]];
            n2 = this.getChildNodeAddIfNecessary(n2, object);
        }
        if (this.m_trieNodeManager.getTrieNodeComponent(n2, 1) == -1) {
            this.m_trieNodeManager.setTrieNodeComponent(n2, 1, n);
            return n;
        }
        return this.m_trieNodeManager.getTrieNodeComponent(n2, 1);
    }

    public int getTupleIndex(Object[] objectArray) {
        int n = this.m_root;
        for (int i = 0; i < this.m_indexingSequence.length; ++i) {
            Object object = objectArray[this.m_indexingSequence[i]];
            if ((n = this.getChildNode(n, object)) != -1) continue;
            return -1;
        }
        return this.m_trieNodeManager.getTrieNodeComponent(n, 1);
    }

    public int removeTuple(Object[] objectArray) {
        int n;
        int n2 = this.m_root;
        for (n = 0; n < this.m_indexingSequence.length; ++n) {
            Object object = objectArray[this.m_indexingSequence[n]];
            if ((n2 = this.getChildNode(n2, object)) != -1) continue;
            return -1;
        }
        n = this.m_trieNodeManager.getTrieNodeComponent(n2, 1);
        int n3 = this.m_trieNodeManager.getTrieNodeComponent(n2, 0);
        this.removeTrieNode(n2);
        while (n3 != this.m_root && this.m_trieNodeManager.getTrieNodeComponent(n3, 1) == -1) {
            int n4 = this.m_trieNodeManager.getTrieNodeComponent(n3, 0);
            this.removeTrieNode(n3);
            n3 = n4;
        }
        return n;
    }

    protected void removeTrieNode(int n) {
        Object object = this.m_trieNodeManager.getTrieNodeObject(n);
        int n2 = this.m_trieNodeManager.getTrieNodeComponent(n, 0);
        int n3 = TupleIndex.getIndexFor(object.hashCode() + n2, this.m_bucketsLengthMinusOne);
        int n4 = this.m_buckets[n3] - 1;
        int n5 = -1;
        while (n4 != -1) {
            int n6 = this.m_trieNodeManager.getTrieNodeComponent(n4, 4);
            if (n4 == n) {
                --this.m_numberOfNodes;
                int n7 = this.m_trieNodeManager.getTrieNodeComponent(n, 2);
                int n8 = this.m_trieNodeManager.getTrieNodeComponent(n, 3);
                if (n7 == -1) {
                    this.m_trieNodeManager.setTrieNodeComponent(n2, 1, n8);
                } else {
                    this.m_trieNodeManager.setTrieNodeComponent(n7, 3, n8);
                }
                if (n8 != -1) {
                    this.m_trieNodeManager.setTrieNodeComponent(n8, 2, n7);
                }
                if (n5 == -1) {
                    this.m_buckets[n3] = n6 + 1;
                } else {
                    this.m_trieNodeManager.setTrieNodeComponent(n5, 4, n6);
                }
                this.m_trieNodeManager.deleteTrieNode(n);
                return;
            }
            n5 = n4;
            n4 = n6;
        }
        throw new IllegalStateException("Internal error: should be able to remove the child node.");
    }

    protected int getChildNode(int n, Object object) {
        int n2 = TupleIndex.getIndexFor(object.hashCode() + n, this.m_bucketsLengthMinusOne);
        int n3 = this.m_buckets[n2] - 1;
        while (n3 != -1) {
            if (n == this.m_trieNodeManager.getTrieNodeComponent(n3, 0) && object.equals(this.m_trieNodeManager.getTrieNodeObject(n3))) {
                return n3;
            }
            n3 = this.m_trieNodeManager.getTrieNodeComponent(n3, 4);
        }
        return -1;
    }

    protected int getChildNodeAddIfNecessary(int n, Object object) {
        int n2 = object.hashCode() + n;
        int n3 = TupleIndex.getIndexFor(n2, this.m_bucketsLengthMinusOne);
        int n4 = this.m_buckets[n3] - 1;
        while (n4 != -1) {
            if (n == this.m_trieNodeManager.getTrieNodeComponent(n4, 0) && object.equals(this.m_trieNodeManager.getTrieNodeObject(n4))) {
                return n4;
            }
            n4 = this.m_trieNodeManager.getTrieNodeComponent(n4, 4);
        }
        if (this.m_numberOfNodes >= this.m_resizeThreshold) {
            this.resizeBuckets();
            n3 = TupleIndex.getIndexFor(n2, this.m_bucketsLengthMinusOne);
        }
        n4 = this.m_trieNodeManager.newTrieNode();
        int n5 = this.m_trieNodeManager.getTrieNodeComponent(n, 1);
        if (n5 != -1) {
            this.m_trieNodeManager.setTrieNodeComponent(n5, 2, n4);
        }
        this.m_trieNodeManager.setTrieNodeComponent(n, 1, n4);
        this.m_trieNodeManager.initializeTrieNode(n4, n, -1, -1, n5, this.m_buckets[n3] - 1, object);
        this.m_buckets[n3] = n4 + 1;
        ++this.m_numberOfNodes;
        return n4;
    }

    protected void resizeBuckets() {
        if (this.m_buckets.length == 0x40000000) {
            this.m_resizeThreshold = Integer.MAX_VALUE;
        } else {
            int[] nArray = new int[this.m_buckets.length * 2];
            int n = nArray.length - 1;
            for (int i = this.m_bucketsLengthMinusOne; i >= 0; --i) {
                int n2 = this.m_buckets[i] - 1;
                while (n2 != -1) {
                    int n3 = this.m_trieNodeManager.getTrieNodeComponent(n2, 4);
                    int n4 = this.m_trieNodeManager.getTrieNodeObject(n2).hashCode() + this.m_trieNodeManager.getTrieNodeComponent(n2, 0);
                    int n5 = TupleIndex.getIndexFor(n4, n);
                    this.m_trieNodeManager.setTrieNodeComponent(n2, 4, nArray[n5] - 1);
                    nArray[n5] = n2 + 1;
                    n2 = n3;
                }
            }
            this.m_buckets = nArray;
            this.m_bucketsLengthMinusOne = n;
            this.m_resizeThreshold = (int)((float)this.m_buckets.length * 0.7f);
        }
    }

    protected static int getIndexFor(int n, int n2) {
        n += ~(n << 9);
        n ^= n >>> 14;
        n += n << 4;
        n ^= n >>> 10;
        return n & n2;
    }

    public static class TupleIndexRetrieval
    implements Serializable {
        private static final long serialVersionUID = 3052986474027614595L;
        protected final TupleIndex m_tupleIndex;
        protected final Object[] m_bindingsBuffer;
        protected final int[] m_selectionIndices;
        protected final int m_selectionIndicesLength;
        protected final int m_indexingSequenceLength;
        protected int m_currentTrieNode;

        public TupleIndexRetrieval(TupleIndex tupleIndex, Object[] objectArray, int[] nArray) {
            this.m_tupleIndex = tupleIndex;
            this.m_bindingsBuffer = objectArray;
            this.m_selectionIndices = nArray;
            this.m_selectionIndicesLength = this.m_selectionIndices.length;
            this.m_indexingSequenceLength = tupleIndex.m_indexingSequence.length;
        }

        public void open() {
            int n;
            this.m_currentTrieNode = this.m_tupleIndex.m_root;
            for (n = 0; n < this.m_selectionIndicesLength; ++n) {
                Object object = this.m_bindingsBuffer[this.m_selectionIndices[n]];
                this.m_currentTrieNode = this.m_tupleIndex.getChildNode(this.m_currentTrieNode, object);
                if (this.m_currentTrieNode != -1) continue;
                return;
            }
            if (this.m_selectionIndicesLength == 0 && this.m_tupleIndex.m_trieNodeManager.getTrieNodeComponent(this.m_tupleIndex.m_root, 1) == -1) {
                this.m_currentTrieNode = -1;
            } else {
                for (n = this.m_selectionIndicesLength; n < this.m_indexingSequenceLength; ++n) {
                    this.m_currentTrieNode = this.m_tupleIndex.m_trieNodeManager.getTrieNodeComponent(this.m_currentTrieNode, 1);
                }
            }
        }

        public boolean afterLast() {
            return this.m_currentTrieNode == -1;
        }

        public int getCurrentTupleIndex() {
            return this.m_tupleIndex.m_trieNodeManager.getTrieNodeComponent(this.m_currentTrieNode, 1);
        }

        public void next() {
            int n;
            for (n = this.m_indexingSequenceLength; n != this.m_selectionIndicesLength && this.m_tupleIndex.m_trieNodeManager.getTrieNodeComponent(this.m_currentTrieNode, 3) == -1; --n) {
                this.m_currentTrieNode = this.m_tupleIndex.m_trieNodeManager.getTrieNodeComponent(this.m_currentTrieNode, 0);
            }
            if (n == this.m_selectionIndicesLength) {
                this.m_currentTrieNode = -1;
            } else {
                this.m_currentTrieNode = this.m_tupleIndex.m_trieNodeManager.getTrieNodeComponent(this.m_currentTrieNode, 3);
                for (int i = n; i < this.m_indexingSequenceLength; ++i) {
                    this.m_currentTrieNode = this.m_tupleIndex.m_trieNodeManager.getTrieNodeComponent(this.m_currentTrieNode, 1);
                }
            }
        }
    }

    protected static final class TrieNodeManager
    implements Serializable {
        private static final long serialVersionUID = -1978070096232682717L;
        protected int[][] m_indexPages;
        protected Object[][] m_objectPages;
        protected int m_firstFreeTrieNode;
        protected int m_numberOfPages;

        public TrieNodeManager() {
            this.clear();
        }

        public int size() {
            int n;
            int n2 = this.m_indexPages.length * 4 + this.m_objectPages.length * 4;
            for (n = this.m_indexPages.length - 1; n >= 0; --n) {
                if (this.m_indexPages[n] == null) continue;
                n2 += this.m_indexPages[n].length * 4;
            }
            for (n = this.m_objectPages.length - 1; n >= 0; --n) {
                if (this.m_objectPages[n] == null) continue;
                n2 += this.m_objectPages[n].length * 4;
            }
            return n2;
        }

        public void clear() {
            this.m_indexPages = new int[10][];
            this.m_indexPages[0] = new int[5120];
            this.m_objectPages = new Object[10][];
            this.m_objectPages[0] = new Object[1024];
            this.m_numberOfPages = 1;
            this.m_firstFreeTrieNode = 0;
            this.setTrieNodeComponent(this.m_firstFreeTrieNode, 3, -1);
        }

        public int getTrieNodeComponent(int n, int n2) {
            return this.m_indexPages[n / 1024][n % 1024 * 5 + n2];
        }

        public void setTrieNodeComponent(int n, int n2, int n3) {
            this.m_indexPages[n / 1024][n % 1024 * 5 + n2] = n3;
        }

        public Object getTrieNodeObject(int n) {
            return this.m_objectPages[n / 1024][n % 1024];
        }

        public void setTrieNodeObject(int n, Object object) {
            this.m_objectPages[n / 1024][n % 1024] = object;
        }

        public void initializeTrieNode(int n, int n2, int n3, int n4, int n5, int n6, Object object) {
            int n7 = n / 1024;
            int n8 = n % 1024;
            int[] nArray = this.m_indexPages[n7];
            int n9 = n8 * 5;
            nArray[n9 + 0] = n2;
            nArray[n9 + 1] = n3;
            nArray[n9 + 2] = n4;
            nArray[n9 + 3] = n5;
            nArray[n9 + 4] = n6;
            this.m_objectPages[n7][n8] = object;
        }

        public int newTrieNode() {
            int n = this.m_firstFreeTrieNode;
            int n2 = this.getTrieNodeComponent(this.m_firstFreeTrieNode, 3);
            if (n2 != -1) {
                this.m_firstFreeTrieNode = n2;
            } else {
                ++this.m_firstFreeTrieNode;
                if (this.m_firstFreeTrieNode < 0) {
                    throw new OutOfMemoryError("The space of nodes in TupleIndex was exhausted: the ontology is just too large.");
                }
                int n3 = this.m_firstFreeTrieNode / 1024;
                if (n3 >= this.m_numberOfPages) {
                    if (n3 >= this.m_indexPages.length) {
                        int[][] nArrayArray = new int[this.m_indexPages.length * 3 / 2][];
                        System.arraycopy(this.m_indexPages, 0, nArrayArray, 0, this.m_indexPages.length);
                        this.m_indexPages = nArrayArray;
                        Object[][] objectArrayArray = new Object[this.m_objectPages.length * 3 / 2][];
                        System.arraycopy(this.m_objectPages, 0, objectArrayArray, 0, this.m_objectPages.length);
                        this.m_objectPages = objectArrayArray;
                    }
                    this.m_indexPages[n3] = new int[5120];
                    this.m_objectPages[n3] = new Object[1024];
                    ++this.m_numberOfPages;
                }
                this.setTrieNodeComponent(this.m_firstFreeTrieNode, 3, -1);
            }
            return n;
        }

        public void deleteTrieNode(int n) {
            this.setTrieNodeComponent(n, 3, this.m_firstFreeTrieNode);
            this.setTrieNodeObject(n, null);
            this.m_firstFreeTrieNode = n;
        }
    }
}

