/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.HermiT.tableau;

import java.io.Serializable;
import java.util.Arrays;
import org.semanticweb.HermiT.tableau.DependencySet;

public final class UnionDependencySet
implements DependencySet,
Serializable {
    private static final long serialVersionUID = 8296150535316233960L;
    protected int m_numberOfConstituents;
    protected DependencySet[] m_dependencySets;

    public UnionDependencySet(int n) {
        this.m_dependencySets = new DependencySet[n];
        this.m_numberOfConstituents = n;
    }

    public boolean containsBranchingPoint(int n) {
        for (int i = this.m_numberOfConstituents - 1; i >= 0; --i) {
            if (!this.m_dependencySets[i].containsBranchingPoint(n)) continue;
            return true;
        }
        return false;
    }

    public int getMaximumBranchingPoint() {
        int n = this.m_dependencySets[0].getMaximumBranchingPoint();
        for (int i = this.m_numberOfConstituents - 1; i >= 1; --i) {
            n = Math.max(n, this.m_dependencySets[i].getMaximumBranchingPoint());
        }
        return n;
    }

    public boolean isEmpty() {
        for (int i = this.m_numberOfConstituents - 1; i >= 0; --i) {
            if (this.m_dependencySets[i].isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void clearConstituents() {
        Arrays.fill(this.m_dependencySets, null);
        this.m_numberOfConstituents = 0;
    }

    public void addConstituent(DependencySet dependencySet) {
        if (this.m_numberOfConstituents == this.m_dependencySets.length) {
            DependencySet[] dependencySetArray = new DependencySet[this.m_numberOfConstituents * 3 / 2];
            System.arraycopy(this.m_dependencySets, 0, dependencySetArray, 0, this.m_dependencySets.length);
            this.m_dependencySets = dependencySetArray;
        }
        this.m_dependencySets[this.m_numberOfConstituents++] = dependencySet;
    }
}

