/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.io.OWLOntologyInputSourceException;
import org.semanticweb.owlapi.model.IRI;

public class FileDocumentSource
implements OWLOntologyDocumentSource {
    private final File file;

    public FileDocumentSource(File file2) {
        this.file = file2;
    }

    @Override
    public IRI getDocumentIRI() {
        return IRI.create(this.file);
    }

    @Override
    public boolean isInputStreamAvailable() {
        return true;
    }

    @Override
    public InputStream getInputStream() {
        try {
            return new BufferedInputStream(new FileInputStream(this.file));
        }
        catch (FileNotFoundException e2) {
            throw new OWLOntologyInputSourceException(e2);
        }
    }

    @Override
    public boolean isReaderAvailable() {
        return true;
    }

    @Override
    public Reader getReader() {
        try {
            return new InputStreamReader(this.getInputStream(), "UTF-8");
        }
        catch (UnsupportedEncodingException e2) {
            throw new OWLOntologyInputSourceException(e2);
        }
    }
}

