/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.zip.GZIPOutputStream;
import org.semanticweb.owlapi.io.OWLOntologyDocumentTarget;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLRuntimeException;

public class GZipFileDocumentTarget
implements OWLOntologyDocumentTarget {
    private final File out;
    private OutputStream outputStream;

    public GZipFileDocumentTarget(File os) {
        this.out = os;
    }

    @Override
    public boolean isWriterAvailable() {
        return this.isOutputStreamAvailable();
    }

    @Override
    public Writer getWriter() {
        if (!this.isWriterAvailable()) {
            throw new UnsupportedOperationException("writer not available; check with isWriterAvailable() first.");
        }
        return new OutputStreamWriter(this.getOutputStream());
    }

    @Override
    public boolean isOutputStreamAvailable() {
        return true;
    }

    @Override
    public OutputStream getOutputStream() {
        if (this.outputStream == null) {
            try {
                this.outputStream = new GZIPOutputStream(new FileOutputStream(this.out));
            }
            catch (FileNotFoundException e2) {
                throw new OWLRuntimeException(e2);
            }
            catch (IOException e3) {
                throw new OWLRuntimeException(e3);
            }
        }
        return this.outputStream;
    }

    @Override
    public boolean isDocumentIRIAvailable() {
        return true;
    }

    @Override
    public IRI getDocumentIRI() {
        return IRI.create(this.out);
    }
}

