/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.zip.GZIPInputStream;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLRuntimeException;

public class GZipStreamDocumentSource
implements OWLOntologyDocumentSource {
    private static int counter = 0;
    private final IRI documentIRI;
    private byte[] buffer;

    public GZipStreamDocumentSource(InputStream is2) {
        this(is2, GZipStreamDocumentSource.getNextDocumentIRI());
    }

    public static synchronized IRI getNextDocumentIRI() {
        return IRI.create("gzipinputstream:ontology" + ++counter);
    }

    public GZipStreamDocumentSource(InputStream stream, IRI documentIRI) {
        this.documentIRI = documentIRI;
        this.readIntoBuffer(stream);
    }

    private void readIntoBuffer(InputStream reader2) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            int length = 100000;
            byte[] tempBuffer = new byte[100000];
            int read2 = 0;
            do {
                if ((read2 = reader2.read(tempBuffer, 0, 100000)) <= 0) continue;
                bos.write(tempBuffer, 0, read2);
            } while (read2 > 0);
            this.buffer = bos.toByteArray();
        }
        catch (IOException e2) {
            throw new OWLRuntimeException(e2);
        }
    }

    @Override
    public boolean isInputStreamAvailable() {
        return this.buffer != null;
    }

    @Override
    public InputStream getInputStream() {
        if (this.buffer == null) {
            throw new OWLRuntimeException("Stream not found - check that the file is available before calling this method.");
        }
        try {
            return new GZIPInputStream(new ByteArrayInputStream(this.buffer));
        }
        catch (IOException e2) {
            throw new OWLRuntimeException(e2);
        }
    }

    @Override
    public IRI getDocumentIRI() {
        return this.documentIRI;
    }

    @Override
    public Reader getReader() {
        try {
            return new InputStreamReader(this.getInputStream(), "UTF-8");
        }
        catch (UnsupportedEncodingException e2) {
            throw new OWLRuntimeException(e2);
        }
    }

    @Override
    public boolean isReaderAvailable() {
        return this.isInputStreamAvailable();
    }
}

