/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.io;

import java.io.Serializable;
import org.semanticweb.owlapi.io.RDFNode;
import org.semanticweb.owlapi.model.IRI;

public class RDFResource
extends RDFNode
implements Serializable {
    private static final long serialVersionUID = 30406L;
    private final IRI resource;
    private final boolean anonymous;

    public RDFResource(IRI resource2, boolean anonymous) {
        this.resource = resource2;
        this.anonymous = anonymous;
    }

    public RDFResource(IRI resource2) {
        this(resource2, false);
    }

    @Override
    public boolean isLiteral() {
        return false;
    }

    public IRI getResource() {
        return this.resource;
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    public int hashCode() {
        return this.resource.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RDFResource)) {
            return false;
        }
        RDFResource other = (RDFResource)o;
        return this.resource.equals(other.resource) && this.anonymous == other.anonymous;
    }

    public String toString() {
        if (!this.anonymous) {
            return this.resource.toQuotedString();
        }
        return "_:" + this.resource;
    }
}

