/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLRuntimeException;

public class ReaderDocumentSource
implements OWLOntologyDocumentSource {
    private static int counter = 0;
    private final IRI documentIRI;
    private String buffer;

    public ReaderDocumentSource(Reader reader2) {
        this(reader2, ReaderDocumentSource.getNextDocumentIRI());
    }

    public static synchronized IRI getNextDocumentIRI() {
        return IRI.create("reader:ontology" + ++counter);
    }

    public ReaderDocumentSource(Reader reader2, IRI documentIRI) {
        this.documentIRI = documentIRI;
        this.fillBuffer(reader2);
    }

    private void fillBuffer(Reader reader2) {
        try {
            StringBuilder builder = new StringBuilder();
            int length = 100000;
            char[] tempBuffer = new char[100000];
            int read2 = 0;
            do {
                if ((read2 = reader2.read(tempBuffer, 0, 100000)) <= 0) continue;
                builder.append(tempBuffer, 0, read2);
            } while (read2 > 0);
            this.buffer = builder.toString();
        }
        catch (IOException e2) {
            throw new OWLRuntimeException(e2);
        }
    }

    @Override
    public IRI getDocumentIRI() {
        return this.documentIRI;
    }

    @Override
    public Reader getReader() {
        return new StringReader(this.buffer);
    }

    @Override
    public boolean isReaderAvailable() {
        return true;
    }

    @Override
    public boolean isInputStreamAvailable() {
        return false;
    }

    @Override
    public InputStream getInputStream() {
        throw new OWLRuntimeException("InputStream not available.  Check with ReaderDocumentSource.isReaderAvailable() first!");
    }
}

