/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.metrics;

import java.util.HashSet;
import java.util.List;
import org.semanticweb.owlapi.metrics.IntegerValuedMetric;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.util.NamedConjunctChecker;

public class NumberOfClassesWithMultipleInheritance
extends IntegerValuedMetric {
    public NumberOfClassesWithMultipleInheritance(OWLOntologyManager owlOntologyManager) {
        super(owlOntologyManager);
    }

    @Override
    public String getName() {
        return "Number of classes with asserted multiple inheritance";
    }

    @Override
    public Integer recomputeMetric() {
        HashSet<OWLClass> processed = new HashSet<OWLClass>();
        HashSet<OWLClass> clses = new HashSet<OWLClass>();
        NamedConjunctChecker checker = new NamedConjunctChecker();
        for (OWLOntology ont : this.getOntologies()) {
            block1: for (OWLClass cls : ont.getClassesInSignature()) {
                if (processed.contains(cls)) continue;
                processed.add(cls);
                int count2 = 0;
                for (OWLClassExpression sup : cls.getSubClasses(this.getOntologies())) {
                    if (checker.hasNamedConjunct(sup)) {
                        ++count2;
                    }
                    if (count2 <= 1) continue;
                    clses.add(cls);
                    continue block1;
                }
            }
        }
        return clses.size();
    }

    @Override
    protected boolean isMetricInvalidated(List<? extends OWLOntologyChange> changes) {
        for (OWLOntologyChange oWLOntologyChange : changes) {
            if (!oWLOntologyChange.isAxiomChange() || !(oWLOntologyChange.getAxiom() instanceof OWLSubClassOfAxiom)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void disposeMetric() {
    }
}

