/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.model;

import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyID;

public class OWLOntologyAlreadyExistsException
extends OWLOntologyCreationException {
    private static final long serialVersionUID = 30406L;
    private static final String ONTOLOGY_ALREADY_EXISTS = "Ontology already exists. ";
    private final OWLOntologyID ontologyID;
    private final IRI documentIRI;

    public OWLOntologyAlreadyExistsException(OWLOntologyID id2) {
        super(ONTOLOGY_ALREADY_EXISTS + id2);
        this.ontologyID = id2;
        this.documentIRI = null;
    }

    public OWLOntologyAlreadyExistsException(OWLOntologyID ontologyID, IRI documentIRI) {
        super(ONTOLOGY_ALREADY_EXISTS + ontologyID + " (New ontology loaded from " + documentIRI.toQuotedString() + ")");
        this.ontologyID = ontologyID;
        this.documentIRI = documentIRI;
    }

    public OWLOntologyAlreadyExistsException(OWLOntologyID id2, Throwable t) {
        super(ONTOLOGY_ALREADY_EXISTS + id2, t);
        this.ontologyID = id2;
        this.documentIRI = null;
    }

    public OWLOntologyAlreadyExistsException(OWLOntologyID ontologyID, IRI documentIRI, Throwable t) {
        super(ONTOLOGY_ALREADY_EXISTS + ontologyID + " (New ontology loaded from " + documentIRI.toQuotedString() + ")", t);
        this.ontologyID = ontologyID;
        this.documentIRI = documentIRI;
    }

    public OWLOntologyID getOntologyID() {
        return this.ontologyID;
    }

    public IRI getDocumentIRI() {
        return this.documentIRI;
    }
}

