/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.profiles;

import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.profiles.LexicalNotInLexicalSpace;
import org.semanticweb.owlapi.profiles.OWLProfile;
import org.semanticweb.owlapi.profiles.OWLProfileReport;
import org.semanticweb.owlapi.profiles.OWLProfileViolation;
import org.semanticweb.owlapi.profiles.OntologyIRINotAbsolute;
import org.semanticweb.owlapi.profiles.OntologyVersionIRINotAbsolute;
import org.semanticweb.owlapi.profiles.UseOfDefinedDatatypeInDatatypeRestriction;
import org.semanticweb.owlapi.profiles.UseOfIllegalFacetRestriction;
import org.semanticweb.owlapi.profiles.UseOfNonAbsoluteIRI;
import org.semanticweb.owlapi.profiles.UseOfUndeclaredDatatype;
import org.semanticweb.owlapi.util.OWLOntologyWalker;
import org.semanticweb.owlapi.util.OWLOntologyWalkerVisitor;
import org.semanticweb.owlapi.vocab.OWL2Datatype;

public class OWL2Profile
implements OWLProfile {
    @Override
    public String getName() {
        return "OWL 2";
    }

    @Override
    public IRI getIRI() {
        return OWL2_FULL;
    }

    @Override
    public OWLProfileReport checkOntology(OWLOntology ontology) {
        OWLOntologyWalker walker = new OWLOntologyWalker(ontology.getImportsClosure());
        OWL2ProfileObjectWalker visitor = new OWL2ProfileObjectWalker(walker, ontology.getOWLOntologyManager());
        walker.walkStructure(visitor);
        Set<OWLProfileViolation> pv = visitor.getProfileViolations();
        return new OWLProfileReport(this, pv);
    }

    private static class OWL2ProfileObjectWalker
    extends OWLOntologyWalkerVisitor<Object> {
        private final OWLOntologyManager man;
        private final Set<OWLProfileViolation> profileViolations = new HashSet<OWLProfileViolation>();

        public OWL2ProfileObjectWalker(OWLOntologyWalker walker, OWLOntologyManager man) {
            super(walker);
            this.man = man;
        }

        public Set<OWLProfileViolation> getProfileViolations() {
            return new HashSet<OWLProfileViolation>(this.profileViolations);
        }

        @Override
        public Object visit(OWLOntology ont) {
            OWLOntologyID id2 = ont.getOntologyID();
            if (!id2.isAnonymous()) {
                IRI versionIRI;
                IRI ontologyIRI = id2.getOntologyIRI();
                if (!ontologyIRI.isAbsolute()) {
                    this.profileViolations.add(new OntologyIRINotAbsolute(ont));
                }
                if ((versionIRI = id2.getVersionIRI()) != null && !versionIRI.isAbsolute()) {
                    this.profileViolations.add(new OntologyVersionIRINotAbsolute(ont));
                }
            }
            return null;
        }

        @Override
        public Object visit(IRI iri) {
            if (!iri.isAbsolute()) {
                this.profileViolations.add(new UseOfNonAbsoluteIRI(this.getCurrentOntology(), this.getCurrentAxiom(), iri));
            }
            return null;
        }

        @Override
        public Object visit(OWLLiteral node2) {
            if (node2.getDatatype().isBuiltIn() && !node2.getDatatype().getBuiltInDatatype().isInLexicalSpace(node2.getLiteral())) {
                this.profileViolations.add(new LexicalNotInLexicalSpace(this.getCurrentOntology(), this.getCurrentAxiom(), node2));
            }
            return null;
        }

        @Override
        public Object visit(OWLDatatypeRestriction node2) {
            for (OWLOntology ont : this.man.getImportsClosure(this.getCurrentOntology())) {
                for (OWLDatatypeDefinitionAxiom ax : ont.getAxioms(AxiomType.DATATYPE_DEFINITION)) {
                    if (!node2.getDatatype().equals(ax.getDatatype())) continue;
                    this.profileViolations.add(new UseOfDefinedDatatypeInDatatypeRestriction(this.getCurrentOntology(), this.getCurrentAxiom(), node2));
                }
            }
            for (OWLFacetRestriction r : node2.getFacetRestrictions()) {
                OWL2Datatype dt = node2.getDatatype().getBuiltInDatatype();
                if (dt.getFacets().contains((Object)r.getFacet())) continue;
                this.profileViolations.add(new UseOfIllegalFacetRestriction(this.getCurrentOntology(), this.getCurrentAxiom(), node2, r.getFacet()));
            }
            return null;
        }

        @Override
        public Object visit(OWLDatatypeDefinitionAxiom axiom) {
            if (!this.getCurrentOntology().isDeclared(axiom.getDatatype(), true)) {
                this.profileViolations.add(new UseOfUndeclaredDatatype(this.getCurrentOntology(), axiom, axiom.getDatatype()));
            }
            return null;
        }
    }
}

