/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.reasoner;

import org.semanticweb.owlapi.reasoner.ReasonerProgressMonitor;

public class ConsoleProgressMonitor
implements ReasonerProgressMonitor {
    private int lastPercentage = 0;

    @Override
    public void reasonerTaskStarted(String taskName) {
        System.out.print(taskName);
        System.out.println(" ...");
    }

    @Override
    public void reasonerTaskStopped() {
        System.out.println("    ... finished");
        this.lastPercentage = 0;
    }

    @Override
    public void reasonerTaskProgressChanged(int value, int max2) {
        int percent;
        if (max2 > 0 && this.lastPercentage != (percent = value * 100 / max2)) {
            System.out.print("    ");
            System.out.print(percent);
            System.out.println("%");
            this.lastPercentage = percent;
        }
    }

    @Override
    public void reasonerTaskBusy() {
        System.out.println("    busy ...");
    }
}

