/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.reasoner;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import org.semanticweb.owlapi.reasoner.ReasonerProgressMonitor;

public class TimedConsoleProgressMonitor
implements ReasonerProgressMonitor {
    private int lastPercentage = 0;
    private long lastTime;
    private final ThreadMXBean bean = ManagementFactory.getThreadMXBean();
    private long beginTime;

    @Override
    public void reasonerTaskStarted(String taskName) {
        System.out.print(taskName);
        System.out.println(" ...");
        this.beginTime = this.lastTime = this.bean.getCurrentThreadCpuTime();
    }

    @Override
    public void reasonerTaskStopped() {
        System.out.println("    ... finished in " + (double)(this.bean.getCurrentThreadCpuTime() - this.beginTime) / 1000000.0);
        this.lastPercentage = 0;
    }

    @Override
    public void reasonerTaskProgressChanged(int value, int max2) {
        int percent;
        long time2 = this.bean.getCurrentThreadCpuTime();
        if (max2 > 0 && this.lastPercentage != (percent = value * 100 / max2)) {
            System.out.println("    " + percent + "%\t" + (time2 - this.lastTime) / 1000000L);
            this.lastTime = time2;
            this.lastPercentage = percent;
        }
    }

    @Override
    public void reasonerTaskBusy() {
        System.out.println("    busy ...");
    }
}

