/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.util.BidirectionalShortFormProvider;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLEntitySetProvider;

public abstract class CachingBidirectionalShortFormProvider
implements BidirectionalShortFormProvider {
    private final Map<String, Set<OWLEntity>> shortForm2EntityMap = new HashMap<String, Set<OWLEntity>>();
    private final Map<OWLEntity, String> entity2ShortFormMap = new HashMap<OWLEntity, String>();

    protected CachingBidirectionalShortFormProvider() {
    }

    protected abstract String generateShortForm(OWLEntity var1);

    @Override
    public Set<String> getShortForms() {
        return CollectionFactory.getCopyOnRequestSetFromMutableCollection(this.shortForm2EntityMap.keySet());
    }

    @Deprecated
    public void rebuild(OWLEntitySetProvider<OWLEntity> entitySetProvider) {
        this.shortForm2EntityMap.clear();
        this.entity2ShortFormMap.clear();
        for (OWLEntity entity : entitySetProvider.getEntities()) {
            this.add(entity);
        }
    }

    public void add(OWLEntity entity) {
        String shortForm = this.generateShortForm(entity);
        this.entity2ShortFormMap.put(entity, shortForm);
        Set<OWLEntity> entities = this.shortForm2EntityMap.get(shortForm);
        if (entities == null) {
            entities = new HashSet<OWLEntity>(1);
        }
        entities.add(entity);
        this.shortForm2EntityMap.put(shortForm, entities);
    }

    @Deprecated
    public void remove(OWLEntity entity) {
        String shortForm = this.entity2ShortFormMap.remove(entity);
        if (shortForm != null) {
            this.shortForm2EntityMap.remove(shortForm);
        }
    }

    @Deprecated
    public void update(OWLEntity entity) {
        this.remove(entity);
        this.add(entity);
    }

    @Override
    public Set<OWLEntity> getEntities(String shortForm) {
        Set<OWLEntity> entities = this.shortForm2EntityMap.get(shortForm);
        if (entities != null) {
            return CollectionFactory.getCopyOnRequestSetFromImmutableCollection(entities);
        }
        return Collections.emptySet();
    }

    @Override
    public OWLEntity getEntity(String shortForm) {
        Set<OWLEntity> entities = this.shortForm2EntityMap.get(shortForm);
        if (entities != null) {
            if (!entities.isEmpty()) {
                return entities.iterator().next();
            }
            return null;
        }
        return null;
    }

    @Override
    public String getShortForm(OWLEntity entity) {
        String sf = this.entity2ShortFormMap.get(entity);
        if (sf != null) {
            return sf;
        }
        return this.generateShortForm(entity);
    }

    @Override
    public void dispose() {
        this.shortForm2EntityMap.clear();
        this.entity2ShortFormMap.clear();
    }
}

