/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLBuiltInAtom;
import org.semanticweb.owlapi.model.SWRLClassAtom;
import org.semanticweb.owlapi.model.SWRLDArgument;
import org.semanticweb.owlapi.model.SWRLDataPropertyAtom;
import org.semanticweb.owlapi.model.SWRLDataRangeAtom;
import org.semanticweb.owlapi.model.SWRLDifferentIndividualsAtom;
import org.semanticweb.owlapi.model.SWRLIArgument;
import org.semanticweb.owlapi.model.SWRLIndividualArgument;
import org.semanticweb.owlapi.model.SWRLLiteralArgument;
import org.semanticweb.owlapi.model.SWRLObjectPropertyAtom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.SWRLSameIndividualAtom;
import org.semanticweb.owlapi.model.SWRLVariable;
import org.semanticweb.owlapi.util.CollectionFactory;

public class OWLObjectComponentCollector
implements OWLObjectVisitor {
    private final Set<OWLObject> result = new HashSet<OWLObject>();

    public Set<OWLObject> getComponents(OWLObject object) {
        this.result.clear();
        object.accept(this);
        return new HashSet<OWLObject>(this.result);
    }

    public Set<OWLObject> getResult() {
        return CollectionFactory.getCopyOnRequestSetFromMutableCollection(this.result);
    }

    private void process(Set<? extends OWLObject> objects) {
        for (OWLObject oWLObject : objects) {
            oWLObject.accept(this);
        }
    }

    protected void handleObject(OWLObject obj) {
        this.result.add(obj);
    }

    @Override
    public void visit(OWLOntology ontology) {
        this.process(ontology.getAxioms());
    }

    @Override
    public void visit(OWLClass cls) {
        this.handleObject(cls);
        cls.getIRI().accept(this);
    }

    @Override
    public void visit(OWLObjectProperty property) {
        this.handleObject(property);
        property.getIRI().accept(this);
    }

    @Override
    public void visit(OWLObjectInverseOf property) {
        this.handleObject(property);
        property.getInverse().accept(this);
    }

    @Override
    public void visit(OWLDataProperty property) {
        this.handleObject(property);
        property.getIRI().accept(this);
    }

    @Override
    public void visit(OWLDatatype datatype) {
        this.handleObject(datatype);
        datatype.getIRI().accept(this);
    }

    @Override
    public void visit(OWLObjectIntersectionOf desc) {
        this.handleObject(desc);
        for (OWLClassExpression op : desc.getOperands()) {
            op.accept(this);
        }
    }

    @Override
    public void visit(OWLObjectUnionOf desc) {
        this.handleObject(desc);
        this.process(desc.getOperands());
    }

    @Override
    public void visit(OWLObjectComplementOf desc) {
        this.handleObject(desc);
        desc.getOperand().accept(this);
    }

    @Override
    public void visit(OWLObjectSomeValuesFrom desc) {
        this.handleObject(desc);
        ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
        ((OWLClassExpression)desc.getFiller()).accept(this);
    }

    @Override
    public void visit(OWLObjectAllValuesFrom desc) {
        this.handleObject(desc);
        ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
        ((OWLClassExpression)desc.getFiller()).accept(this);
    }

    @Override
    public void visit(OWLObjectHasValue desc) {
        this.handleObject(desc);
        ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
        ((OWLIndividual)desc.getValue()).accept(this);
    }

    @Override
    public void visit(OWLObjectMinCardinality desc) {
        this.handleObject(desc);
        ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
        ((OWLClassExpression)desc.getFiller()).accept(this);
    }

    @Override
    public void visit(OWLObjectExactCardinality desc) {
        this.handleObject(desc);
        ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
        ((OWLClassExpression)desc.getFiller()).accept(this);
    }

    @Override
    public void visit(OWLObjectMaxCardinality desc) {
        this.handleObject(desc);
        ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
        ((OWLClassExpression)desc.getFiller()).accept(this);
    }

    @Override
    public void visit(OWLObjectHasSelf desc) {
        this.handleObject(desc);
        ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLObjectOneOf desc) {
        this.handleObject(desc);
        this.process(desc.getIndividuals());
    }

    @Override
    public void visit(OWLDataSomeValuesFrom desc) {
        this.handleObject(desc);
        ((OWLDataPropertyExpression)desc.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLDataAllValuesFrom desc) {
        this.handleObject(desc);
        ((OWLDataPropertyExpression)desc.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLDataHasValue desc) {
        this.handleObject(desc);
        ((OWLDataPropertyExpression)desc.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLDataMinCardinality desc) {
        this.handleObject(desc);
        ((OWLDataPropertyExpression)desc.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLDataExactCardinality desc) {
        this.handleObject(desc);
        ((OWLDataPropertyExpression)desc.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLDataMaxCardinality desc) {
        this.handleObject(desc);
        ((OWLDataPropertyExpression)desc.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLSubClassOfAxiom axiom) {
        this.handleObject(axiom);
        axiom.getSubClass().accept(this);
        axiom.getSuperClass().accept(this);
    }

    @Override
    public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
        this.handleObject(axiom);
        axiom.getSubject().accept(this);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        ((OWLIndividual)axiom.getObject()).accept(this);
    }

    @Override
    public void visit(OWLAsymmetricObjectPropertyAxiom axiom) {
        this.handleObject(axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
        this.handleObject(axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLDisjointClassesAxiom axiom) {
        this.handleObject(axiom);
        this.process(axiom.getClassExpressions());
    }

    @Override
    public void visit(OWLDataPropertyDomainAxiom axiom) {
        this.handleObject(axiom);
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLObjectPropertyDomainAxiom axiom) {
        this.handleObject(axiom);
        axiom.getDomain().accept(this);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        this.handleObject(axiom);
        this.process(axiom.getProperties());
    }

    @Override
    public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        this.handleObject(axiom);
        axiom.getSubject().accept(this);
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        ((OWLLiteral)axiom.getObject()).accept(this);
    }

    @Override
    public void visit(OWLDifferentIndividualsAxiom axiom) {
        this.handleObject(axiom);
        this.process(axiom.getIndividuals());
    }

    @Override
    public void visit(OWLDisjointDataPropertiesAxiom axiom) {
        this.handleObject(axiom);
        this.process(axiom.getProperties());
    }

    @Override
    public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
        this.handleObject(axiom);
        this.process(axiom.getProperties());
    }

    @Override
    public void visit(OWLObjectPropertyRangeAxiom axiom) {
        this.handleObject(axiom);
        ((OWLClassExpression)axiom.getRange()).accept(this);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLObjectPropertyAssertionAxiom axiom) {
        this.handleObject(axiom);
        axiom.getSubject().accept(this);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        ((OWLIndividual)axiom.getObject()).accept(this);
    }

    @Override
    public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
        this.handleObject(axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLSubObjectPropertyOfAxiom axiom) {
        this.handleObject(axiom);
        ((OWLObjectPropertyExpression)axiom.getSubProperty()).accept(this);
        ((OWLObjectPropertyExpression)axiom.getSuperProperty()).accept(this);
    }

    @Override
    public void visit(OWLDisjointUnionAxiom axiom) {
        this.handleObject(axiom);
        axiom.getOWLClass().accept(this);
        this.process(axiom.getClassExpressions());
    }

    @Override
    public void visit(OWLDeclarationAxiom axiom) {
        this.handleObject(axiom);
        axiom.getEntity().accept(this);
    }

    @Override
    public void visit(OWLAnnotationAssertionAxiom axiom) {
        this.handleObject(axiom);
        axiom.getSubject().accept(this);
        axiom.getAnnotation().accept(this);
    }

    @Override
    public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
        this.handleObject(axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLDataPropertyRangeAxiom axiom) {
        this.handleObject(axiom);
        ((OWLDataRange)axiom.getRange()).accept(this);
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLFunctionalDataPropertyAxiom axiom) {
        this.handleObject(axiom);
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
        this.handleObject(axiom);
        this.process(axiom.getProperties());
    }

    @Override
    public void visit(OWLClassAssertionAxiom axiom) {
        this.handleObject(axiom);
        axiom.getClassExpression().accept(this);
        axiom.getIndividual().accept(this);
    }

    @Override
    public void visit(OWLEquivalentClassesAxiom axiom) {
        this.handleObject(axiom);
        this.process(axiom.getClassExpressions());
    }

    @Override
    public void visit(OWLDataPropertyAssertionAxiom axiom) {
        this.handleObject(axiom);
        axiom.getSubject().accept(this);
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        ((OWLLiteral)axiom.getObject()).accept(this);
    }

    @Override
    public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
        this.handleObject(axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
        this.handleObject(axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLSubDataPropertyOfAxiom axiom) {
        this.handleObject(axiom);
        ((OWLDataPropertyExpression)axiom.getSubProperty()).accept(this);
        ((OWLDataPropertyExpression)axiom.getSuperProperty()).accept(this);
    }

    @Override
    public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
        this.handleObject(axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLSameIndividualAxiom axiom) {
        this.handleObject(axiom);
        this.process(axiom.getIndividuals());
    }

    @Override
    public void visit(OWLSubPropertyChainOfAxiom axiom) {
        this.handleObject(axiom);
        for (OWLObjectPropertyExpression prop : axiom.getPropertyChain()) {
            prop.accept(this);
        }
        axiom.getSuperProperty().accept(this);
    }

    @Override
    public void visit(OWLInverseObjectPropertiesAxiom axiom) {
        this.handleObject(axiom);
        this.process(axiom.getProperties());
    }

    @Override
    public void visit(SWRLRule node2) {
        this.handleObject(node2);
        this.process(node2.getBody());
        this.process(node2.getHead());
    }

    @Override
    public void visit(OWLDataComplementOf node2) {
        this.handleObject(node2);
        node2.getDataRange().accept(this);
    }

    @Override
    public void visit(OWLDataOneOf node2) {
        this.handleObject(node2);
        this.process(node2.getValues());
    }

    @Override
    public void visit(OWLDatatypeRestriction node2) {
        this.handleObject(node2);
        node2.getDatatype().accept(this);
        this.process(node2.getFacetRestrictions());
    }

    @Override
    public void visit(OWLLiteral node2) {
        this.handleObject(node2);
        node2.getDatatype().accept(this);
    }

    @Override
    public void visit(OWLFacetRestriction node2) {
        this.handleObject(node2);
        node2.getFacetValue().accept(this);
    }

    @Override
    public void visit(OWLHasKeyAxiom axiom) {
        this.handleObject(axiom);
        axiom.getClassExpression().accept(this);
        for (OWLObjectPropertyExpression oWLObjectPropertyExpression : axiom.getObjectPropertyExpressions()) {
            oWLObjectPropertyExpression.accept(this);
        }
        for (OWLDataPropertyExpression oWLDataPropertyExpression : axiom.getDataPropertyExpressions()) {
            oWLDataPropertyExpression.accept(this);
        }
    }

    @Override
    public void visit(OWLAnnotationPropertyDomainAxiom axiom) {
        this.handleObject(axiom);
        axiom.getProperty().accept(this);
        axiom.getDomain().accept(this);
    }

    @Override
    public void visit(OWLAnnotationPropertyRangeAxiom axiom) {
        this.handleObject(axiom);
        axiom.getProperty().accept(this);
        axiom.getRange().accept(this);
    }

    @Override
    public void visit(OWLSubAnnotationPropertyOfAxiom axiom) {
        this.handleObject(axiom);
        axiom.getSubProperty().accept(this);
        axiom.getSuperProperty().accept(this);
    }

    @Override
    public void visit(OWLDataIntersectionOf node2) {
        this.handleObject(node2);
        for (OWLDataRange rng : node2.getOperands()) {
            rng.accept(this);
        }
    }

    @Override
    public void visit(OWLDataUnionOf node2) {
        this.handleObject(node2);
        for (OWLDataRange rng : node2.getOperands()) {
            rng.accept(this);
        }
    }

    @Override
    public void visit(OWLNamedIndividual individual) {
        this.handleObject(individual);
        individual.getIRI().accept(this);
    }

    @Override
    public void visit(OWLAnnotationProperty property) {
        this.handleObject(property);
        property.getIRI().accept(this);
    }

    @Override
    public void visit(OWLAnonymousIndividual individual) {
        this.handleObject(individual);
    }

    @Override
    public void visit(IRI iri) {
        this.handleObject(iri);
    }

    @Override
    public void visit(OWLAnnotation node2) {
    }

    @Override
    public void visit(SWRLClassAtom node2) {
        this.handleObject(node2);
        node2.getPredicate().accept(this);
        ((SWRLIArgument)node2.getArgument()).accept(this);
    }

    @Override
    public void visit(SWRLDataRangeAtom node2) {
        this.handleObject(node2);
        node2.getPredicate().accept(this);
        ((SWRLDArgument)node2.getArgument()).accept(this);
    }

    @Override
    public void visit(SWRLObjectPropertyAtom node2) {
        this.handleObject(node2);
        node2.getPredicate().accept(this);
        ((SWRLIArgument)node2.getFirstArgument()).accept(this);
        ((SWRLIArgument)node2.getSecondArgument()).accept(this);
    }

    @Override
    public void visit(SWRLDataPropertyAtom node2) {
        this.handleObject(node2);
        node2.getPredicate().accept(this);
        ((SWRLIArgument)node2.getFirstArgument()).accept(this);
        ((SWRLDArgument)node2.getSecondArgument()).accept(this);
    }

    @Override
    public void visit(SWRLBuiltInAtom node2) {
        this.handleObject(node2);
        for (SWRLDArgument obj : node2.getArguments()) {
            obj.accept(this);
        }
    }

    @Override
    public void visit(SWRLVariable node2) {
        this.handleObject(node2);
    }

    @Override
    public void visit(SWRLIndividualArgument node2) {
        this.handleObject(node2);
        node2.getIndividual().accept(this);
    }

    @Override
    public void visit(SWRLLiteralArgument node2) {
        this.handleObject(node2);
        node2.getLiteral().accept(this);
    }

    @Override
    public void visit(SWRLSameIndividualAtom node2) {
        this.handleObject(node2);
        ((SWRLIArgument)node2.getFirstArgument()).accept(this);
        ((SWRLIArgument)node2.getSecondArgument()).accept(this);
    }

    @Override
    public void visit(SWRLDifferentIndividualsAtom node2) {
        this.handleObject(node2);
        ((SWRLIArgument)node2.getFirstArgument()).accept(this);
        ((SWRLIArgument)node2.getSecondArgument()).accept(this);
    }

    @Override
    public void visit(OWLDatatypeDefinitionAxiom axiom) {
        this.handleObject(axiom);
        axiom.getDatatype().accept(this);
        axiom.getDataRange().accept(this);
    }
}

