/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.net.URI;
import java.util.StringTokenizer;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.util.IRIShortFormProvider;

public class OntologyIRIShortFormProvider
implements IRIShortFormProvider {
    public String getShortForm(OWLOntology ont) {
        if (!ont.isAnonymous()) {
            return this.getShortForm(ont.getOntologyID().getOntologyIRI());
        }
        return ont.getOntologyID().toString();
    }

    @Override
    public String getShortForm(IRI iri) {
        String shortForm = iri.toString();
        URI uri = iri.toURI();
        String path2 = uri.getPath();
        if (path2 != null && path2.length() > 0) {
            StringTokenizer tokenizer = new StringTokenizer(path2, "/", false);
            String lastPathComponent = "";
            while (tokenizer.hasMoreTokens()) {
                String tok = tokenizer.nextToken();
                if (tok.length() <= 0) continue;
                lastPathComponent = tok;
            }
            shortForm = lastPathComponent.endsWith(".owl") ? lastPathComponent.substring(0, lastPathComponent.length() - 4) : lastPathComponent;
        } else if (uri.getHost() != null) {
            shortForm = iri.toString();
        }
        return shortForm;
    }
}

