/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.vocab;

import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owlapi.model.IRI;

public enum DublinCoreVocabulary {
    CONTRIBUTOR("contributor"),
    COVERAGE("coverage"),
    CREATOR("creator"),
    DATE("date"),
    DESCRIPTION("description"),
    FORMAT("format"),
    IDENTIFIER("identifier"),
    LANGUAGE("language"),
    PUBLISHER("publisher"),
    RELATION("relation"),
    RIGHTS("rights"),
    SOURCE("source"),
    SUBJECT("subject"),
    TITLE("title"),
    TYPE("type");

    private final String shortName;
    private final String qname;
    private final IRI iri;
    public static final String NAME_SPACE = "http://purl.org/dc/elements/1.1/";
    public static final Set<IRI> ALL_URIS;

    private DublinCoreVocabulary(String name2) {
        this.shortName = name2;
        this.qname = "dc:" + name2;
        this.iri = IRI.create(NAME_SPACE, name2);
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getQName() {
        return this.qname;
    }

    @Deprecated
    public URI getURI() {
        return this.iri.toURI();
    }

    public IRI getIRI() {
        return this.iri;
    }

    public String toString() {
        return this.iri.toString();
    }

    static {
        ALL_URIS = new HashSet<IRI>();
        for (DublinCoreVocabulary v : DublinCoreVocabulary.values()) {
            ALL_URIS.add(v.getIRI());
        }
    }
}

