/*
 * Decompiled with CFR 0.152.
 */
package org.xml.sax.ext;

import org.xml.sax.Attributes;
import org.xml.sax.ext.Attributes2;
import org.xml.sax.helpers.AttributesImpl;

public class Attributes2Impl
extends AttributesImpl
implements Attributes2 {
    private boolean[] declared;
    private boolean[] specified;

    public Attributes2Impl() {
        this.specified = null;
        this.declared = null;
    }

    public Attributes2Impl(Attributes atts) {
        super(atts);
    }

    public boolean isDeclared(int index2) {
        if (index2 < 0 || index2 >= this.getLength()) {
            throw new ArrayIndexOutOfBoundsException("No attribute at index: " + index2);
        }
        return this.declared[index2];
    }

    public boolean isDeclared(String uri, String localName) {
        int index2 = this.getIndex(uri, localName);
        if (index2 < 0) {
            throw new IllegalArgumentException("No such attribute: local=" + localName + ", namespace=" + uri);
        }
        return this.declared[index2];
    }

    public boolean isDeclared(String qName) {
        int index2 = this.getIndex(qName);
        if (index2 < 0) {
            throw new IllegalArgumentException("No such attribute: " + qName);
        }
        return this.declared[index2];
    }

    public boolean isSpecified(int index2) {
        if (index2 < 0 || index2 >= this.getLength()) {
            throw new ArrayIndexOutOfBoundsException("No attribute at index: " + index2);
        }
        return this.specified[index2];
    }

    public boolean isSpecified(String uri, String localName) {
        int index2 = this.getIndex(uri, localName);
        if (index2 < 0) {
            throw new IllegalArgumentException("No such attribute: local=" + localName + ", namespace=" + uri);
        }
        return this.specified[index2];
    }

    public boolean isSpecified(String qName) {
        int index2 = this.getIndex(qName);
        if (index2 < 0) {
            throw new IllegalArgumentException("No such attribute: " + qName);
        }
        return this.specified[index2];
    }

    public void setAttributes(Attributes atts) {
        int length = atts.getLength();
        super.setAttributes(atts);
        this.declared = new boolean[length];
        this.specified = new boolean[length];
        if (atts instanceof Attributes2) {
            Attributes2 a2 = (Attributes2)atts;
            for (int i = 0; i < length; ++i) {
                this.declared[i] = a2.isDeclared(i);
                this.specified[i] = a2.isSpecified(i);
            }
        } else {
            for (int i = 0; i < length; ++i) {
                this.declared[i] = !"CDATA".equals(atts.getType(i));
                this.specified[i] = true;
            }
        }
    }

    public void addAttribute(String uri, String localName, String qName, String type2, String value) {
        super.addAttribute(uri, localName, qName, type2, value);
        int length = this.getLength();
        if (this.specified == null) {
            this.specified = new boolean[length];
            this.declared = new boolean[length];
        } else if (length > this.specified.length) {
            boolean[] newFlags = new boolean[length];
            System.arraycopy(this.declared, 0, newFlags, 0, this.declared.length);
            this.declared = newFlags;
            newFlags = new boolean[length];
            System.arraycopy(this.specified, 0, newFlags, 0, this.specified.length);
            this.specified = newFlags;
        }
        this.specified[length - 1] = true;
        this.declared[length - 1] = !"CDATA".equals(type2);
    }

    public void removeAttribute(int index2) {
        int origMax = this.getLength() - 1;
        super.removeAttribute(index2);
        if (index2 != origMax) {
            System.arraycopy(this.declared, index2 + 1, this.declared, index2, origMax - index2);
            System.arraycopy(this.specified, index2 + 1, this.specified, index2, origMax - index2);
        }
    }

    public void setDeclared(int index2, boolean value) {
        if (index2 < 0 || index2 >= this.getLength()) {
            throw new ArrayIndexOutOfBoundsException("No attribute at index: " + index2);
        }
        this.declared[index2] = value;
    }

    public void setSpecified(int index2, boolean value) {
        if (index2 < 0 || index2 >= this.getLength()) {
            throw new ArrayIndexOutOfBoundsException("No attribute at index: " + index2);
        }
        this.specified[index2] = value;
    }
}

