/*
 * Decompiled with CFR 0.152.
 */
package rationals.transformations;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import rationals.Automaton;
import rationals.NoSuchStateException;
import rationals.State;
import rationals.Transition;
import rationals.transformations.UnaryTransformation;

public class Accessible
implements UnaryTransformation {
    private State state;

    public Accessible(State s) {
        this.state = s;
    }

    public Automaton transform(Automaton a) {
        Set trs = a.delta();
        Automaton b = new Automaton();
        HashMap<State, State> stmap = new HashMap<State, State>();
        State ns2 = b.addState(true, this.state.isTerminal());
        stmap.put(this.state, ns2);
        this.explore(this.state, stmap, a, b);
        Iterator it = trs.iterator();
        while (it.hasNext()) {
            Transition tr = (Transition)it.next();
            State nstart = (State)stmap.get(tr.start());
            State nend = (State)stmap.get(tr.end());
            if (nstart == null || nend == null) continue;
            try {
                b.addTransition(new Transition(nstart, tr.label(), nend));
            }
            catch (NoSuchStateException e2) {
                System.err.println(e2.getMessage());
                return null;
            }
        }
        return b;
    }

    private void explore(State curstate, Map stmap, Automaton a, Automaton b) {
        Iterator it = a.delta(curstate).iterator();
        while (it.hasNext()) {
            Transition tr = (Transition)it.next();
            State e2 = tr.end();
            State ne = (State)stmap.get(e2);
            if (ne != null) continue;
            ne = b.addState(e2.isInitial(), e2.isTerminal());
            stmap.put(e2, ne);
            this.explore(e2, stmap, a, b);
        }
    }
}

