/*
 * Decompiled with CFR 0.152.
 */
package rationals.transformations;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import rationals.Automaton;
import rationals.NoSuchStateException;
import rationals.State;
import rationals.Transition;
import rationals.transformations.UnaryTransformation;

public class Projection
implements UnaryTransformation {
    private Set alphabet;

    public Projection(Set alphabet) {
        this.alphabet = alphabet;
    }

    public Automaton transform(Automaton a) {
        Automaton b = new Automaton();
        HashMap<State, State> smap = new HashMap<State, State>();
        Iterator it = a.delta().iterator();
        while (it.hasNext()) {
            Transition tr = (Transition)it.next();
            State os = tr.start();
            State oe = tr.end();
            Object l = tr.label();
            State ns2 = (State)smap.get(os);
            State ne = (State)smap.get(oe);
            if (ns2 == null) {
                ns2 = b.addState(os.isInitial(), os.isTerminal());
                smap.put(os, ns2);
            }
            if (ne == null) {
                ne = b.addState(oe.isInitial(), oe.isTerminal());
                smap.put(oe, ne);
            }
            if (this.alphabet.contains(l)) {
                try {
                    b.addTransition(new Transition(ns2, l, ne));
                }
                catch (NoSuchStateException e2) {}
                continue;
            }
            try {
                b.addTransition(new Transition(ns2, null, ne));
            }
            catch (NoSuchStateException e1) {}
        }
        return b;
    }
}

