/*
 * Decompiled with CFR 0.152.
 */
package rationals.transformations;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import rationals.Automaton;
import rationals.State;
import rationals.Transition;

public class TransformationsToolBox {
    public static boolean containsATerminalState(Set s) {
        Iterator i = s.iterator();
        while (i.hasNext()) {
            try {
                State e2 = (State)i.next();
                if (!e2.isTerminal()) continue;
                return true;
            }
            catch (ClassCastException classCastException) {
            }
        }
        return false;
    }

    public static boolean containsAnInitialState(Set s) {
        Iterator i = s.iterator();
        while (i.hasNext()) {
            try {
                State e2 = (State)i.next();
                if (!e2.isInitial()) continue;
                return true;
            }
            catch (ClassCastException classCastException) {
            }
        }
        return false;
    }

    public static Set epsilonClosure(Set s, Automaton a) {
        Set exp = a.getStateFactory().stateSet();
        exp.addAll(s);
        Set view = a.getStateFactory().stateSet();
        Set arr = a.getStateFactory().stateSet();
        arr.addAll(s);
        do {
            Set ns2 = a.getStateFactory().stateSet();
            ns2.addAll(exp);
            Iterator it = ns2.iterator();
            while (it.hasNext()) {
                State st = (State)it.next();
                Iterator it2 = a.delta(st).iterator();
                while (it2.hasNext()) {
                    Transition tr = (Transition)it2.next();
                    if (tr.label() != null || view.contains(tr.end()) || tr.end().equals(st)) continue;
                    exp.add(tr.end());
                    arr.add(tr.end());
                }
                exp.remove(st);
                view.add(st);
            }
        } while (!exp.isEmpty());
        return arr;
    }

    public static Map mapAlphabet(Set ts, Automaton a) {
        HashMap<Object, Set> am = new HashMap<Object, Set>();
        ArrayList tas = new ArrayList(ts);
        while (!tas.isEmpty()) {
            Transition tr = (Transition)tas.remove(0);
            Object l = tr.label();
            if (l == null) continue;
            Set as = (Set)am.get(l);
            if (as == null) {
                as = a.getStateFactory().stateSet();
                am.put(l, as);
            }
            as.add(tr.end());
        }
        return am;
    }
}

