/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.explanation.ordering;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import org.semanticweb.owlapi.io.OWLObjectRenderer;
import org.semanticweb.owlapi.model.OWLAxiom;
import uk.ac.manchester.cs.owl.explanation.ordering.EntailedAxiomTree;
import uk.ac.manchester.cs.owl.explanation.ordering.ExplanationOrderer;
import uk.ac.manchester.cs.owl.explanation.ordering.ExplanationTree;

public final class AlphaExplanationOrderer
implements ExplanationOrderer {
    protected final OWLObjectRenderer renderer;

    public AlphaExplanationOrderer(OWLObjectRenderer renderer2) {
        this.renderer = renderer2;
    }

    @Override
    public ExplanationTree getOrderedExplanation(OWLAxiom entailment, Set<OWLAxiom> axioms) {
        EntailedAxiomTree root2 = new EntailedAxiomTree(entailment);
        ArrayList<OWLAxiom> sortedAxioms = new ArrayList<OWLAxiom>(axioms);
        Collections.sort(sortedAxioms, new Comparator<OWLAxiom>(){

            @Override
            public int compare(OWLAxiom o1, OWLAxiom o2) {
                return AlphaExplanationOrderer.this.renderer.render(o1).compareTo(AlphaExplanationOrderer.this.renderer.render(o2));
            }
        });
        for (OWLAxiom ax : sortedAxioms) {
            root2.addChild(new ExplanationTree(ax));
        }
        return root2;
    }
}

