/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.explanation.ordering;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLogicalAxiom;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLProperty;
import org.semanticweb.owlapi.model.OWLPropertyAxiom;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLRule;
import uk.ac.manchester.cs.bhig.util.Tree;
import uk.ac.manchester.cs.owl.explanation.ordering.EntailedAxiomTree;
import uk.ac.manchester.cs.owl.explanation.ordering.ExplanationOrderer;
import uk.ac.manchester.cs.owl.explanation.ordering.ExplanationTree;

public class ExplanationOrdererImpl
implements ExplanationOrderer {
    private Set<OWLAxiom> currentExplanation = Collections.emptySet();
    private final Map<OWLEntity, Set<OWLAxiom>> lhs2AxiomMap = new HashMap<OWLEntity, Set<OWLAxiom>>();
    private final Map<OWLAxiom, Set<OWLEntity>> entitiesByAxiomRHS = new HashMap<OWLAxiom, Set<OWLEntity>>();
    private final SeedExtractor seedExtractor = new SeedExtractor();
    private final OWLOntologyManager man;
    private OWLOntology ont;
    private final Map<OWLObject, Set<OWLAxiom>> mappedAxioms;
    private final Set<OWLAxiom> consumedAxioms;
    private final Set<AxiomType<?>> passTypes;
    private OWLEntity currentSource;
    private OWLEntity currentTarget;
    private static Comparator<Tree<OWLAxiom>> comparator = new OWLAxiomTreeComparator();
    private static AtomicLong randomstart = new AtomicLong(System.currentTimeMillis());
    private static PropertiesFirstComparator propertiesFirstComparator = new PropertiesFirstComparator();

    public ExplanationOrdererImpl(OWLOntologyManager m) {
        this.man = m;
        this.mappedAxioms = new HashMap<OWLObject, Set<OWLAxiom>>();
        this.passTypes = new HashSet();
        this.passTypes.add(AxiomType.DISJOINT_CLASSES);
        this.consumedAxioms = new HashSet<OWLAxiom>();
    }

    private void reset() {
        this.lhs2AxiomMap.clear();
        this.entitiesByAxiomRHS.clear();
        this.consumedAxioms.clear();
    }

    @Override
    public ExplanationTree getOrderedExplanation(OWLAxiom entailment, Set<OWLAxiom> axioms) {
        this.currentExplanation = new HashSet<OWLAxiom>(axioms);
        this.buildIndices();
        EntailedAxiomTree root2 = new EntailedAxiomTree(entailment);
        this.currentSource = this.seedExtractor.getSource(entailment);
        this.insertChildren(this.currentSource, root2);
        this.currentTarget = this.seedExtractor.getTarget(entailment);
        Set axs = root2.getUserObjectClosure();
        final HashSet<OWLLogicalAxiom> targetAxioms = new HashSet<OWLLogicalAxiom>();
        if (this.currentTarget != null) {
            if (this.currentTarget.isOWLClass()) {
                targetAxioms.addAll(this.ont.getAxioms(this.currentTarget.asOWLClass()));
            }
            if (this.currentTarget.isOWLObjectProperty()) {
                targetAxioms.addAll(this.ont.getAxioms(this.currentTarget.asOWLObjectProperty()));
            }
            if (this.currentTarget.isOWLDataProperty()) {
                targetAxioms.addAll(this.ont.getAxioms(this.currentTarget.asOWLDataProperty()));
            }
            if (this.currentTarget.isOWLNamedIndividual()) {
                targetAxioms.addAll(this.ont.getAxioms(this.currentTarget.asOWLNamedIndividual()));
            }
        }
        ArrayList<OWLAxiom> rootAxioms = new ArrayList<OWLAxiom>();
        for (OWLAxiom ax : axioms) {
            if (axs.contains(ax)) continue;
            rootAxioms.add(ax);
        }
        Collections.sort(rootAxioms, new Comparator<OWLAxiom>(){

            @Override
            public int compare(OWLAxiom o1, OWLAxiom o2) {
                if (targetAxioms.contains(o1)) {
                    return 1;
                }
                if (targetAxioms.contains(o2)) {
                    return -1;
                }
                return 0;
            }
        });
        for (OWLAxiom ax : rootAxioms) {
            root2.addChild(new ExplanationTree(ax));
        }
        return root2;
    }

    private List<OWLEntity> getRHSEntitiesSorted(OWLAxiom ax) {
        Collection<OWLEntity> entities = this.getRHSEntities(ax);
        ArrayList<OWLEntity> sortedEntities = new ArrayList<OWLEntity>(entities);
        Collections.sort(sortedEntities, propertiesFirstComparator);
        return sortedEntities;
    }

    private void insertChildren(OWLEntity entity, ExplanationTree tree) {
        HashSet currentPath = new HashSet(tree.getUserObjectPathToRoot());
        Set<Object> axioms = Collections.emptySet();
        if (entity != null) {
            if (entity.isOWLClass()) {
                axioms = this.ont.getAxioms(entity.asOWLClass());
            } else if (entity.isOWLObjectProperty()) {
                axioms = this.ont.getAxioms(entity.asOWLObjectProperty());
            } else if (entity.isOWLDataProperty()) {
                axioms = this.ont.getAxioms(entity.asOWLDataProperty());
            } else if (entity.isOWLNamedIndividual()) {
                axioms = this.ont.getAxioms(entity.asOWLNamedIndividual());
            }
            for (OWLAxiom oWLAxiom : axioms) {
                if (this.passTypes.contains(oWLAxiom.getAxiomType())) continue;
                Set<OWLAxiom> mapped = ExplanationOrdererImpl.getIndexedSet(entity, this.mappedAxioms, true);
                if (this.consumedAxioms.contains(oWLAxiom) || mapped.contains(oWLAxiom) || currentPath.contains(oWLAxiom)) continue;
                mapped.add(oWLAxiom);
                this.consumedAxioms.add(oWLAxiom);
                ExplanationTree child = new ExplanationTree(oWLAxiom);
                tree.addChild(child);
                for (OWLEntity ent : this.getRHSEntitiesSorted(oWLAxiom)) {
                    this.insertChildren(ent, child);
                }
            }
        }
        this.sortChildrenAxioms(tree);
    }

    private void sortChildrenAxioms(ExplanationTree tree) {
        tree.sortChildren(comparator);
    }

    private void buildIndices() {
        this.reset();
        AxiomMapBuilder builder = new AxiomMapBuilder();
        for (OWLAxiom ax : this.currentExplanation) {
            ax.accept(builder);
        }
        try {
            if (this.ont != null) {
                this.man.removeOntology(this.ont);
            }
            this.ont = this.man.createOntology(IRI.create("http://www.semanticweb.org/", "ontology" + randomstart.incrementAndGet()));
            ArrayList<AddAxiom> changes = new ArrayList<AddAxiom>();
            for (OWLAxiom ax : this.currentExplanation) {
                changes.add(new AddAxiom(this.ont, ax));
                ax.accept(builder);
            }
            this.man.applyChanges(changes);
        }
        catch (OWLOntologyCreationException e2) {
            throw new OWLRuntimeException(e2);
        }
    }

    private static <K, E> Set<E> getIndexedSet(K obj, Map<K, Set<E>> map2, boolean addIfEmpty) {
        Set<E> values = map2.get(obj);
        if (values == null) {
            values = new HashSet();
            if (addIfEmpty) {
                map2.put(obj, values);
            }
        }
        return values;
    }

    protected Set<OWLAxiom> getAxiomsForLHS(OWLEntity lhs) {
        return ExplanationOrdererImpl.getIndexedSet(lhs, this.lhs2AxiomMap, true);
    }

    private Collection<OWLEntity> getRHSEntities(OWLAxiom axiom) {
        return ExplanationOrdererImpl.getIndexedSet(axiom, this.entitiesByAxiomRHS, true);
    }

    protected void indexAxiomsByRHSEntities(OWLObject rhs, OWLAxiom axiom) {
        ExplanationOrdererImpl.getIndexedSet(axiom, this.entitiesByAxiomRHS, true).addAll(rhs.getSignature());
    }

    private class AxiomMapBuilder
    implements OWLAxiomVisitor {
        @Override
        public void visit(OWLSubClassOfAxiom axiom) {
            if (!axiom.getSubClass().isAnonymous()) {
                ExplanationOrdererImpl.this.getAxiomsForLHS(axiom.getSubClass().asOWLClass()).add(axiom);
                ExplanationOrdererImpl.this.indexAxiomsByRHSEntities(axiom.getSuperClass(), axiom);
            }
        }

        @Override
        public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
        }

        @Override
        public void visit(OWLAsymmetricObjectPropertyAxiom axiom) {
            if (!((OWLObjectPropertyExpression)axiom.getProperty()).isAnonymous()) {
                ExplanationOrdererImpl.this.getAxiomsForLHS(((OWLObjectPropertyExpression)axiom.getProperty()).asOWLObjectProperty()).add(axiom);
            }
        }

        @Override
        public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
            if (!((OWLObjectPropertyExpression)axiom.getProperty()).isAnonymous()) {
                ExplanationOrdererImpl.this.getAxiomsForLHS(((OWLObjectPropertyExpression)axiom.getProperty()).asOWLObjectProperty()).add(axiom);
            }
        }

        @Override
        public void visit(OWLDisjointClassesAxiom axiom) {
            for (OWLClassExpression desc : axiom.getClassExpressions()) {
                if (!desc.isAnonymous()) {
                    ExplanationOrdererImpl.this.getAxiomsForLHS(desc.asOWLClass()).add(axiom);
                }
                ExplanationOrdererImpl.this.indexAxiomsByRHSEntities(desc, axiom);
            }
        }

        @Override
        public void visit(OWLDataPropertyDomainAxiom axiom) {
            ExplanationOrdererImpl.this.getAxiomsForLHS(((OWLDataPropertyExpression)axiom.getProperty()).asOWLDataProperty()).add(axiom);
            ExplanationOrdererImpl.this.indexAxiomsByRHSEntities(axiom.getDomain(), axiom);
        }

        public void visit(OWLImportsDeclaration axiom) {
        }

        @Override
        public void visit(OWLObjectPropertyDomainAxiom axiom) {
            if (!((OWLObjectPropertyExpression)axiom.getProperty()).isAnonymous()) {
                ExplanationOrdererImpl.this.getAxiomsForLHS(((OWLObjectPropertyExpression)axiom.getProperty()).asOWLObjectProperty()).add(axiom);
            }
            ExplanationOrdererImpl.this.indexAxiomsByRHSEntities(axiom.getDomain(), axiom);
        }

        @Override
        public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
            for (OWLObjectPropertyExpression prop : axiom.getProperties()) {
                if (!prop.isAnonymous()) {
                    ExplanationOrdererImpl.this.getAxiomsForLHS(prop.asOWLObjectProperty()).add(axiom);
                }
                ExplanationOrdererImpl.this.indexAxiomsByRHSEntities(prop, axiom);
            }
        }

        @Override
        public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        }

        @Override
        public void visit(OWLDifferentIndividualsAxiom axiom) {
            for (OWLIndividual ind : axiom.getIndividuals()) {
                if (ind.isAnonymous()) continue;
                ExplanationOrdererImpl.this.getAxiomsForLHS(ind.asOWLNamedIndividual()).add(axiom);
                ExplanationOrdererImpl.this.indexAxiomsByRHSEntities(ind, axiom);
            }
        }

        @Override
        public void visit(OWLDisjointDataPropertiesAxiom axiom) {
            for (OWLDataPropertyExpression prop : axiom.getProperties()) {
                ExplanationOrdererImpl.this.getAxiomsForLHS(prop.asOWLDataProperty()).add(axiom);
                ExplanationOrdererImpl.this.indexAxiomsByRHSEntities(prop, axiom);
            }
        }

        @Override
        public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
            for (OWLObjectPropertyExpression prop : axiom.getProperties()) {
                if (!prop.isAnonymous()) {
                    ExplanationOrdererImpl.this.getAxiomsForLHS(prop.asOWLObjectProperty()).add(axiom);
                }
                ExplanationOrdererImpl.this.indexAxiomsByRHSEntities(prop, axiom);
            }
        }

        @Override
        public void visit(OWLObjectPropertyRangeAxiom axiom) {
            if (!((OWLObjectPropertyExpression)axiom.getProperty()).isAnonymous()) {
                ExplanationOrdererImpl.this.getAxiomsForLHS(((OWLObjectPropertyExpression)axiom.getProperty()).asOWLObjectProperty()).add(axiom);
            }
            ExplanationOrdererImpl.this.indexAxiomsByRHSEntities((OWLObject)axiom.getRange(), axiom);
        }

        @Override
        public void visit(OWLObjectPropertyAssertionAxiom axiom) {
        }

        @Override
        public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
            if (!((OWLObjectPropertyExpression)axiom.getProperty()).isAnonymous()) {
                ExplanationOrdererImpl.this.getAxiomsForLHS(((OWLObjectPropertyExpression)axiom.getProperty()).asOWLObjectProperty()).add(axiom);
            }
        }

        @Override
        public void visit(OWLSubObjectPropertyOfAxiom axiom) {
            if (!((OWLObjectPropertyExpression)axiom.getSubProperty()).isAnonymous()) {
                ExplanationOrdererImpl.this.getAxiomsForLHS(((OWLObjectPropertyExpression)axiom.getSubProperty()).asOWLObjectProperty()).add(axiom);
            }
            ExplanationOrdererImpl.this.indexAxiomsByRHSEntities((OWLObject)axiom.getSuperProperty(), axiom);
        }

        @Override
        public void visit(OWLDisjointUnionAxiom axiom) {
            ExplanationOrdererImpl.this.getAxiomsForLHS(axiom.getOWLClass()).add(axiom);
        }

        @Override
        public void visit(OWLDeclarationAxiom axiom) {
        }

        @Override
        public void visit(OWLAnnotationAssertionAxiom axiom) {
        }

        @Override
        public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
            if (!((OWLObjectPropertyExpression)axiom.getProperty()).isAnonymous()) {
                ExplanationOrdererImpl.this.getAxiomsForLHS(((OWLObjectPropertyExpression)axiom.getProperty()).asOWLObjectProperty()).add(axiom);
            }
        }

        @Override
        public void visit(OWLDataPropertyRangeAxiom axiom) {
            if (!((OWLDataPropertyExpression)axiom.getProperty()).isAnonymous()) {
                ExplanationOrdererImpl.this.getAxiomsForLHS(((OWLDataPropertyExpression)axiom.getProperty()).asOWLDataProperty()).add(axiom);
            }
            ExplanationOrdererImpl.this.indexAxiomsByRHSEntities((OWLObject)axiom.getRange(), axiom);
        }

        @Override
        public void visit(OWLFunctionalDataPropertyAxiom axiom) {
            if (!((OWLDataPropertyExpression)axiom.getProperty()).isAnonymous()) {
                ExplanationOrdererImpl.this.getAxiomsForLHS(((OWLDataPropertyExpression)axiom.getProperty()).asOWLDataProperty()).add(axiom);
            }
        }

        @Override
        public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
            for (OWLDataPropertyExpression prop : axiom.getProperties()) {
                ExplanationOrdererImpl.this.getAxiomsForLHS(prop.asOWLDataProperty()).add(axiom);
                ExplanationOrdererImpl.this.indexAxiomsByRHSEntities(prop, axiom);
            }
        }

        @Override
        public void visit(OWLClassAssertionAxiom axiom) {
            if (!axiom.getIndividual().isAnonymous()) {
                ExplanationOrdererImpl.this.getAxiomsForLHS(axiom.getIndividual().asOWLNamedIndividual()).add(axiom);
                ExplanationOrdererImpl.this.indexAxiomsByRHSEntities(axiom.getClassExpression(), axiom);
            }
        }

        @Override
        public void visit(OWLEquivalentClassesAxiom axiom) {
            for (OWLClassExpression desc : axiom.getClassExpressions()) {
                if (!desc.isAnonymous()) {
                    ExplanationOrdererImpl.this.getAxiomsForLHS(desc.asOWLClass()).add(axiom);
                }
                ExplanationOrdererImpl.this.indexAxiomsByRHSEntities(desc, axiom);
            }
        }

        @Override
        public void visit(OWLDataPropertyAssertionAxiom axiom) {
            ExplanationOrdererImpl.this.indexAxiomsByRHSEntities(axiom.getSubject(), axiom);
        }

        @Override
        public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
            if (!((OWLObjectPropertyExpression)axiom.getProperty()).isAnonymous()) {
                ExplanationOrdererImpl.this.getAxiomsForLHS(((OWLObjectPropertyExpression)axiom.getProperty()).asOWLObjectProperty()).add(axiom);
            }
        }

        @Override
        public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
            if (!((OWLObjectPropertyExpression)axiom.getProperty()).isAnonymous()) {
                ExplanationOrdererImpl.this.getAxiomsForLHS(((OWLObjectPropertyExpression)axiom.getProperty()).asOWLObjectProperty()).add(axiom);
            }
        }

        @Override
        public void visit(OWLSubDataPropertyOfAxiom axiom) {
            ExplanationOrdererImpl.this.getAxiomsForLHS(((OWLDataPropertyExpression)axiom.getSubProperty()).asOWLDataProperty()).add(axiom);
            ExplanationOrdererImpl.this.indexAxiomsByRHSEntities((OWLObject)axiom.getSuperProperty(), axiom);
        }

        @Override
        public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
            if (!((OWLObjectPropertyExpression)axiom.getProperty()).isAnonymous()) {
                ExplanationOrdererImpl.this.getAxiomsForLHS(((OWLObjectPropertyExpression)axiom.getProperty()).asOWLObjectProperty()).add(axiom);
            }
        }

        @Override
        public void visit(OWLSameIndividualAxiom axiom) {
            for (OWLIndividual ind : axiom.getIndividuals()) {
                if (ind.isAnonymous()) continue;
                ExplanationOrdererImpl.this.getAxiomsForLHS(ind.asOWLNamedIndividual()).add(axiom);
                ExplanationOrdererImpl.this.indexAxiomsByRHSEntities(ind, axiom);
            }
        }

        @Override
        public void visit(OWLSubPropertyChainOfAxiom axiom) {
        }

        @Override
        public void visit(OWLDatatypeDefinitionAxiom axiom) {
        }

        @Override
        public void visit(OWLInverseObjectPropertiesAxiom axiom) {
            if (!axiom.getFirstProperty().isAnonymous()) {
                ExplanationOrdererImpl.this.getAxiomsForLHS(axiom.getFirstProperty().asOWLObjectProperty()).add(axiom);
            }
            ExplanationOrdererImpl.this.indexAxiomsByRHSEntities(axiom.getFirstProperty(), axiom);
            ExplanationOrdererImpl.this.indexAxiomsByRHSEntities(axiom.getSecondProperty(), axiom);
        }

        @Override
        public void visit(SWRLRule rule) {
        }

        @Override
        public void visit(OWLHasKeyAxiom axiom) {
            if (!axiom.getClassExpression().isAnonymous()) {
                ExplanationOrdererImpl.this.indexAxiomsByRHSEntities(axiom.getClassExpression().asOWLClass(), axiom);
            }
        }

        @Override
        public void visit(OWLAnnotationPropertyDomainAxiom axiom) {
        }

        @Override
        public void visit(OWLAnnotationPropertyRangeAxiom axiom) {
        }

        @Override
        public void visit(OWLSubAnnotationPropertyOfAxiom axiom) {
        }
    }

    private static class SeedExtractor
    implements OWLAxiomVisitor {
        private OWLEntity source;
        private OWLEntity target;

        public OWLEntity getSource(OWLAxiom axiom) {
            axiom.accept(this);
            return this.source;
        }

        public OWLEntity getTarget(OWLAxiom axiom) {
            axiom.accept(this);
            return this.target;
        }

        @Override
        public void visit(OWLSubClassOfAxiom axiom) {
            OWLClassExpression classExpression;
            if (!axiom.getSubClass().isAnonymous()) {
                this.source = axiom.getSubClass().asOWLClass();
            }
            if (!axiom.getSuperClass().isOWLNothing() && !(classExpression = axiom.getSuperClass()).isAnonymous()) {
                this.target = classExpression.asOWLClass();
            }
        }

        @Override
        public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
        }

        @Override
        public void visit(OWLAsymmetricObjectPropertyAxiom axiom) {
        }

        @Override
        public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
        }

        @Override
        public void visit(OWLDisjointClassesAxiom axiom) {
            for (OWLClassExpression ce : axiom.getClassExpressions()) {
                if (ce.isAnonymous()) continue;
                if (this.source == null) {
                    this.source = ce.asOWLClass();
                    continue;
                }
                if (this.target != null) break;
                this.target = ce.asOWLClass();
            }
        }

        @Override
        public void visit(OWLDataPropertyDomainAxiom axiom) {
        }

        public void visit(OWLImportsDeclaration axiom) {
        }

        @Override
        public void visit(OWLObjectPropertyDomainAxiom axiom) {
        }

        @Override
        public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        }

        @Override
        public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        }

        @Override
        public void visit(OWLDifferentIndividualsAxiom axiom) {
        }

        @Override
        public void visit(OWLDisjointDataPropertiesAxiom axiom) {
        }

        @Override
        public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
        }

        @Override
        public void visit(OWLObjectPropertyRangeAxiom axiom) {
        }

        @Override
        public void visit(OWLObjectPropertyAssertionAxiom axiom) {
        }

        @Override
        public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
        }

        @Override
        public void visit(OWLSubObjectPropertyOfAxiom axiom) {
            if (!((OWLObjectPropertyExpression)axiom.getSubProperty()).isAnonymous()) {
                this.source = ((OWLObjectPropertyExpression)axiom.getSubProperty()).asOWLObjectProperty();
            }
            if (!((OWLObjectPropertyExpression)axiom.getSuperProperty()).isAnonymous()) {
                this.target = ((OWLObjectPropertyExpression)axiom.getSuperProperty()).asOWLObjectProperty();
            }
        }

        @Override
        public void visit(OWLDisjointUnionAxiom axiom) {
        }

        @Override
        public void visit(OWLDeclarationAxiom axiom) {
        }

        @Override
        public void visit(OWLAnnotationAssertionAxiom axiom) {
        }

        @Override
        public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
        }

        @Override
        public void visit(OWLDataPropertyRangeAxiom axiom) {
        }

        @Override
        public void visit(OWLFunctionalDataPropertyAxiom axiom) {
        }

        @Override
        public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
        }

        @Override
        public void visit(OWLClassAssertionAxiom axiom) {
            if (!axiom.getClassExpression().isAnonymous()) {
                this.source = axiom.getIndividual().asOWLNamedIndividual();
                this.target = axiom.getClassExpression().asOWLClass();
            }
        }

        @Override
        public void visit(OWLEquivalentClassesAxiom axiom) {
            for (OWLClass cls : axiom.getNamedClasses()) {
                if (this.source == null) {
                    this.source = cls;
                    continue;
                }
                if (this.target != null) break;
                this.target = cls;
            }
        }

        @Override
        public void visit(OWLDataPropertyAssertionAxiom axiom) {
        }

        @Override
        public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
        }

        @Override
        public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
        }

        @Override
        public void visit(OWLSubDataPropertyOfAxiom axiom) {
        }

        @Override
        public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
        }

        @Override
        public void visit(OWLSameIndividualAxiom axiom) {
        }

        @Override
        public void visit(OWLSubPropertyChainOfAxiom axiom) {
        }

        @Override
        public void visit(OWLInverseObjectPropertiesAxiom axiom) {
        }

        @Override
        public void visit(SWRLRule rule) {
        }

        @Override
        public void visit(OWLHasKeyAxiom axiom) {
        }

        @Override
        public void visit(OWLAnnotationPropertyDomainAxiom axiom) {
        }

        @Override
        public void visit(OWLAnnotationPropertyRangeAxiom axiom) {
        }

        @Override
        public void visit(OWLSubAnnotationPropertyOfAxiom axiom) {
        }

        @Override
        public void visit(OWLDatatypeDefinitionAxiom axiom) {
        }
    }

    private static final class OWLAxiomTreeComparator
    implements Comparator<Tree<OWLAxiom>>,
    Serializable {
        private static final long serialVersionUID = 30406L;

        @Override
        public int compare(Tree<OWLAxiom> o1, Tree<OWLAxiom> o2) {
            OWLAxiom ax1 = o1.getUserObject();
            OWLAxiom ax2 = o2.getUserObject();
            if (ax1 instanceof OWLEquivalentClassesAxiom) {
                return 1;
            }
            if (ax2 instanceof OWLEquivalentClassesAxiom) {
                return -1;
            }
            if (ax1 instanceof OWLPropertyAxiom) {
                return -1;
            }
            int childCount1 = o1.getChildCount();
            childCount1 = childCount1 > 0 ? 0 : 1;
            int childCount2 = o2.getChildCount();
            int diff2 = childCount1 - (childCount2 = childCount2 > 0 ? 0 : 1);
            if (diff2 != 0) {
                return diff2;
            }
            if (ax1 instanceof OWLSubClassOfAxiom && ax2 instanceof OWLSubClassOfAxiom) {
                OWLSubClassOfAxiom sc1 = (OWLSubClassOfAxiom)ax1;
                OWLSubClassOfAxiom sc2 = (OWLSubClassOfAxiom)ax2;
                return sc1.getSuperClass().compareTo(sc2.getSuperClass());
            }
            return 1;
        }
    }

    private static final class PropertiesFirstComparator
    implements Comparator<OWLObject> {
        @Override
        public int compare(OWLObject o1, OWLObject o2) {
            if (o1 instanceof OWLProperty) {
                return -1;
            }
            if (o1.equals(o2)) {
                return 0;
            }
            return 1;
        }
    }
}

