/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.Collection;
import java.util.Set;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import uk.ac.manchester.cs.owl.owlapi.OWLAnnotationImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLAxiomImpl;

public class OWLAnnotationAssertionAxiomImpl
extends OWLAxiomImpl
implements OWLAnnotationAssertionAxiom {
    private static final long serialVersionUID = 30406L;
    private final OWLAnnotationSubject subject;
    private final OWLAnnotationProperty property;
    private final OWLAnnotationValue value;

    public OWLAnnotationAssertionAxiomImpl(OWLAnnotationSubject subject, OWLAnnotationProperty property, OWLAnnotationValue value, Collection<? extends OWLAnnotation> annotations) {
        super(annotations);
        this.subject = subject;
        this.property = property;
        this.value = value;
    }

    @Override
    public OWLAnnotationAssertionAxiom getAxiomWithoutAnnotations() {
        if (!this.isAnnotated()) {
            return this;
        }
        return new OWLAnnotationAssertionAxiomImpl(this.getSubject(), this.getProperty(), this.getValue(), NO_ANNOTATIONS);
    }

    @Override
    public boolean isDeprecatedIRIAssertion() {
        return this.property.isDeprecated() && this.getAnnotation().isDeprecatedIRIAnnotation();
    }

    @Override
    public OWLAnnotationAssertionAxiom getAnnotatedAxiom(Set<OWLAnnotation> annotations) {
        return new OWLAnnotationAssertionAxiomImpl(this.getSubject(), this.getProperty(), this.getValue(), this.mergeAnnos(annotations));
    }

    @Override
    public OWLAnnotationValue getValue() {
        return this.value;
    }

    @Override
    public OWLAnnotationSubject getSubject() {
        return this.subject;
    }

    @Override
    public OWLAnnotationProperty getProperty() {
        return this.property;
    }

    @Override
    public OWLAnnotation getAnnotation() {
        return new OWLAnnotationImpl(this.property, this.value, NO_ANNOTATIONS);
    }

    @Override
    public boolean isLogicalAxiom() {
        return false;
    }

    @Override
    public boolean isAnnotationAxiom() {
        return true;
    }

    @Override
    protected int compareObjectOfSameType(OWLObject object) {
        OWLAnnotationAssertionAxiom other = (OWLAnnotationAssertionAxiom)object;
        int diff2 = 0;
        diff2 = this.subject.compareTo(other.getSubject());
        if (diff2 != 0) {
            return diff2;
        }
        diff2 = this.property.compareTo(other.getProperty());
        if (diff2 != 0) {
            return diff2;
        }
        return this.value.compareTo(other.getValue());
    }

    @Override
    public void accept(OWLObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void accept(OWLAxiomVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLAxiomVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public AxiomType<?> getAxiomType() {
        return AxiomType.ANNOTATION_ASSERTION;
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            if (!(obj instanceof OWLAnnotationAssertionAxiom)) {
                return false;
            }
            OWLAnnotationAssertionAxiom other = (OWLAnnotationAssertionAxiom)obj;
            return this.subject.equals(other.getSubject()) && this.property.equals(other.getProperty()) && this.value.equals(other.getValue());
        }
        return false;
    }
}

