/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import org.semanticweb.owlapi.model.OWLAnnotationValueVisitor;
import org.semanticweb.owlapi.model.OWLAnnotationValueVisitorEx;
import org.semanticweb.owlapi.model.OWLDataVisitor;
import org.semanticweb.owlapi.model.OWLDataVisitorEx;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectImpl;

public class OWLLiteralImplFloat
extends OWLObjectImpl
implements OWLLiteral {
    private static final long serialVersionUID = 30406L;
    private final float literal;
    private final OWLDatatype datatype;
    private final int hashcode;

    public OWLLiteralImplFloat(float literal, OWLDatatype datatype) {
        this.literal = literal;
        this.datatype = datatype;
        this.hashcode = this.getHashCode();
    }

    @Override
    public int hashCode() {
        return this.hashcode;
    }

    private int getHashCode() {
        int hashCode = 277;
        hashCode = hashCode * 37 + this.getDatatype().hashCode();
        hashCode = hashCode * 37 + (int)(this.literal * 65536.0f);
        return hashCode;
    }

    @Override
    public String getLiteral() {
        return Float.toString(this.literal);
    }

    @Override
    public boolean isRDFPlainLiteral() {
        return false;
    }

    @Override
    public boolean hasLang() {
        return false;
    }

    @Override
    public boolean isInteger() {
        return false;
    }

    @Override
    public int parseInteger() throws NumberFormatException {
        throw new NumberFormatException("this literal is not an integer but a float");
    }

    @Override
    public boolean isBoolean() {
        return false;
    }

    @Override
    public boolean parseBoolean() throws NumberFormatException {
        throw new NumberFormatException("this literal is not a boolean but a float");
    }

    @Override
    public boolean isDouble() {
        return false;
    }

    @Override
    public double parseDouble() throws NumberFormatException {
        throw new NumberFormatException("this literal is not a double but a float");
    }

    @Override
    public boolean isFloat() {
        return true;
    }

    @Override
    public float parseFloat() throws NumberFormatException {
        return this.literal;
    }

    @Override
    public String getLang() {
        return "";
    }

    @Override
    public boolean hasLang(String l) {
        return false;
    }

    @Override
    public OWLDatatype getDatatype() {
        return this.datatype;
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            if (obj instanceof OWLLiteralImplFloat) {
                OWLLiteralImplFloat other = (OWLLiteralImplFloat)obj;
                return this.literal == other.literal && this.datatype.equals(other.getDatatype());
            }
            if (obj instanceof OWLLiteral) {
                return this.datatype.equals(((OWLLiteral)obj).getDatatype()) && this.getLiteral().equals(((OWLLiteral)obj).getLiteral());
            }
        }
        return false;
    }

    @Override
    public void accept(OWLDataVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLDataVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public void accept(OWLAnnotationValueVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLAnnotationValueVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    protected int compareObjectOfSameType(OWLObject object) {
        OWLLiteral other = (OWLLiteral)object;
        int diff2 = this.getLiteral().compareTo(other.getLiteral());
        if (diff2 != 0) {
            return diff2;
        }
        return this.datatype.compareTo(other.getDatatype());
    }

    @Override
    public void accept(OWLObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return visitor.visit(this);
    }
}

