/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.semanticweb.owlapi.io.ToStringRenderer;
import org.semanticweb.owlapi.model.EntityType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.HashCode;
import org.semanticweb.owlapi.util.OWLClassExpressionCollector;
import org.semanticweb.owlapi.util.OWLObjectTypeIndexProvider;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;
import uk.ac.manchester.cs.owl.owlapi.OWLAnnotationPropertyImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLClassImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDataFactoryImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDataPropertyImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDatatypeImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLEntityCollectionContainerCollector;
import uk.ac.manchester.cs.owl.owlapi.OWLNamedIndividualImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectPropertyImpl;

public abstract class OWLObjectImpl
implements OWLObject,
Serializable {
    private static final long serialVersionUID = 30406L;
    protected static final Set<OWLAnnotation> NO_ANNOTATIONS = Collections.emptySet();
    private int hashCode = 0;
    private transient WeakReference<Set<OWLEntity>> signature = null;
    private transient WeakReference<Set<OWLAnonymousIndividual>> anons;
    @Deprecated
    private static OWLDataFactory f = new OWLDataFactoryImpl(false, false);
    protected static final OWLClass OWL_THING = new OWLClassImpl(OWLRDFVocabulary.OWL_THING.getIRI());

    static <E extends OWLEntity> E getOWLEntity(EntityType<E> entityType, IRI iri) {
        if (entityType.equals(EntityType.CLASS)) {
            return (E)new OWLClassImpl(iri);
        }
        if (entityType.equals(EntityType.OBJECT_PROPERTY)) {
            return (E)new OWLObjectPropertyImpl(iri);
        }
        if (entityType.equals(EntityType.DATA_PROPERTY)) {
            return (E)new OWLDataPropertyImpl(iri);
        }
        if (entityType.equals(EntityType.ANNOTATION_PROPERTY)) {
            return (E)new OWLAnnotationPropertyImpl(iri);
        }
        if (entityType.equals(EntityType.NAMED_INDIVIDUAL)) {
            return (E)new OWLNamedIndividualImpl(iri);
        }
        if (entityType.equals(EntityType.DATATYPE)) {
            return (E)new OWLDatatypeImpl(iri);
        }
        return null;
    }

    @Override
    public Set<OWLEntity> getSignature() {
        HashSet<OWLEntity> set2 = null;
        if (this.signature != null) {
            set2 = (HashSet<OWLEntity>)this.signature.get();
        }
        if (set2 == null) {
            set2 = new HashSet<OWLEntity>();
            HashSet<OWLAnonymousIndividual> anon = new HashSet<OWLAnonymousIndividual>();
            OWLEntityCollectionContainerCollector collector = new OWLEntityCollectionContainerCollector(set2, anon);
            this.accept(collector);
            this.signature = new WeakReference<HashSet<OWLEntity>>(set2);
            this.anons = new WeakReference<HashSet<OWLAnonymousIndividual>>(anon);
        }
        return CollectionFactory.getCopyOnRequestSetFromImmutableCollection(set2);
    }

    @Override
    public Set<OWLAnonymousIndividual> getAnonymousIndividuals() {
        if (this.signature == null || this.signature.get() == null) {
            this.getSignature();
        }
        return CollectionFactory.getCopyOnRequestSetFromImmutableCollection((Collection)this.anons.get());
    }

    @Override
    public Set<OWLClass> getClassesInSignature() {
        HashSet<OWLClass> result = new HashSet<OWLClass>();
        for (OWLEntity ent : this.getSignature()) {
            if (!ent.isOWLClass()) continue;
            result.add(ent.asOWLClass());
        }
        return result;
    }

    @Override
    public Set<OWLDataProperty> getDataPropertiesInSignature() {
        HashSet<OWLDataProperty> result = new HashSet<OWLDataProperty>();
        for (OWLEntity ent : this.getSignature()) {
            if (!ent.isOWLDataProperty()) continue;
            result.add(ent.asOWLDataProperty());
        }
        return result;
    }

    @Override
    public Set<OWLObjectProperty> getObjectPropertiesInSignature() {
        HashSet<OWLObjectProperty> result = new HashSet<OWLObjectProperty>();
        for (OWLEntity ent : this.getSignature()) {
            if (!ent.isOWLObjectProperty()) continue;
            result.add(ent.asOWLObjectProperty());
        }
        return result;
    }

    @Override
    public Set<OWLNamedIndividual> getIndividualsInSignature() {
        HashSet<OWLNamedIndividual> result = new HashSet<OWLNamedIndividual>();
        for (OWLEntity ent : this.getSignature()) {
            if (!ent.isOWLNamedIndividual()) continue;
            result.add(ent.asOWLNamedIndividual());
        }
        return result;
    }

    @Override
    public Set<OWLDatatype> getDatatypesInSignature() {
        HashSet<OWLDatatype> result = new HashSet<OWLDatatype>();
        for (OWLEntity ent : this.getSignature()) {
            if (!ent.isOWLDatatype()) continue;
            result.add(ent.asOWLDatatype());
        }
        return result;
    }

    @Override
    public Set<OWLClassExpression> getNestedClassExpressions() {
        OWLClassExpressionCollector collector = new OWLClassExpressionCollector();
        return this.accept(collector);
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && obj instanceof OWLObject;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = HashCode.hashCode(this);
        }
        return this.hashCode;
    }

    @Override
    public int compareTo(OWLObject o) {
        int otherTypeIndex;
        OWLObjectTypeIndexProvider typeIndexProvider = new OWLObjectTypeIndexProvider();
        int thisTypeIndex = typeIndexProvider.getTypeIndex(this);
        int diff2 = thisTypeIndex - (otherTypeIndex = typeIndexProvider.getTypeIndex(o));
        if (diff2 == 0) {
            return this.compareObjectOfSameType(o);
        }
        return diff2;
    }

    protected abstract int compareObjectOfSameType(OWLObject var1);

    public String toString() {
        return ToStringRenderer.getInstance().getRendering(this);
    }

    @Override
    public boolean isTopEntity() {
        return false;
    }

    @Override
    public boolean isBottomEntity() {
        return false;
    }

    protected static int compareSets(Set<? extends OWLObject> set1, Set<? extends OWLObject> set2) {
        TreeSet<? extends OWLObject> ss1 = set1 instanceof SortedSet ? (TreeSet<? extends OWLObject>)set1 : new TreeSet<OWLObject>(set1);
        TreeSet<? extends OWLObject> ss2 = set2 instanceof SortedSet ? (TreeSet<? extends OWLObject>)set2 : new TreeSet<OWLObject>(set2);
        Iterator thisIt = ss1.iterator();
        Iterator otherIt = ss2.iterator();
        for (int i = 0; i < ss1.size() && i < ss2.size(); ++i) {
            OWLObject o2;
            OWLObject o1 = (OWLObject)thisIt.next();
            int diff2 = o1.compareTo(o2 = (OWLObject)otherIt.next());
            if (diff2 == 0) continue;
            return diff2;
        }
        return ss1.size() - ss2.size();
    }

    protected static int compareLists(List<? extends OWLObject> list1, List<? extends OWLObject> list2) {
        int size;
        int n = size = list1.size() < list2.size() ? list1.size() : list2.size();
        for (int i = 0; i < size; ++i) {
            OWLObject o2;
            OWLObject o1 = list1.get(i);
            int diff2 = o1.compareTo(o2 = list2.get(i));
            if (diff2 == 0) continue;
            return diff2;
        }
        return list1.size() - list2.size();
    }
}

