/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi.turtle.parser;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.coode.owlapi.turtle.TurtleOntologyFormat;
import org.semanticweb.owlapi.io.AbstractOWLParser;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.io.OWLParserException;
import org.semanticweb.owlapi.io.OWLParserIOException;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChangeException;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.UnloadableImportException;
import org.semanticweb.owlapi.util.DefaultPrefixManager;
import uk.ac.manchester.cs.owl.owlapi.turtle.parser.ConsoleTripleHandler;
import uk.ac.manchester.cs.owl.owlapi.turtle.parser.OWLRDFConsumerAdapter;
import uk.ac.manchester.cs.owl.owlapi.turtle.parser.ParseException;
import uk.ac.manchester.cs.owl.owlapi.turtle.parser.TripleHandler;
import uk.ac.manchester.cs.owl.owlapi.turtle.parser.TurtleParser;
import uk.ac.manchester.cs.owl.owlapi.turtle.parser.TurtleParserException;

public class TurtleOntologyParser
extends AbstractOWLParser {
    @Override
    public OWLOntologyFormat parse(OWLOntologyDocumentSource documentSource, OWLOntology ontology) throws OWLParserException, UnloadableImportException, IOException {
        return this.parse(documentSource, ontology, new OWLOntologyLoaderConfiguration());
    }

    @Override
    public OWLOntologyFormat parse(OWLOntologyDocumentSource documentSource, OWLOntology ontology, OWLOntologyLoaderConfiguration configuration) throws OWLParserException, IOException, OWLOntologyChangeException, UnloadableImportException {
        Reader reader2 = null;
        InputStream is2 = null;
        try {
            TurtleParser parser;
            if (documentSource.isReaderAvailable()) {
                reader2 = documentSource.getReader();
                parser = new TurtleParser(reader2, (TripleHandler)new ConsoleTripleHandler(), documentSource.getDocumentIRI().toString());
            } else if (documentSource.isInputStreamAvailable()) {
                is2 = documentSource.getInputStream();
                parser = new TurtleParser(is2, (TripleHandler)new ConsoleTripleHandler(), documentSource.getDocumentIRI().toString());
            } else {
                is2 = new BufferedInputStream(documentSource.getDocumentIRI().toURI().toURL().openStream());
                parser = new TurtleParser(is2, (TripleHandler)new ConsoleTripleHandler(), documentSource.getDocumentIRI().toString());
            }
            OWLRDFConsumerAdapter consumer = new OWLRDFConsumerAdapter(ontology, parser, configuration);
            TurtleOntologyFormat format2 = new TurtleOntologyFormat();
            consumer.setOntologyFormat(format2);
            parser.setTripleHandler(consumer);
            parser.parseDocument();
            DefaultPrefixManager prefixManager = parser.getPrefixManager();
            for (String prefixName : prefixManager.getPrefixNames()) {
                format2.setPrefix(prefixName, prefixManager.getPrefix(prefixName));
            }
            TurtleOntologyFormat turtleOntologyFormat = format2;
            return turtleOntologyFormat;
        }
        catch (ParseException e2) {
            throw new TurtleParserException(e2);
        }
        catch (IOException e3) {
            throw new OWLParserIOException(e3);
        }
        finally {
            if (is2 != null) {
                is2.close();
            } else if (reader2 != null) {
                reader2.close();
            }
        }
    }
}

