/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owlapi.dlsyntax;

import java.io.PrintWriter;
import java.util.Set;
import org.semanticweb.owlapi.io.XMLUtils;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import org.semanticweb.owlapi.util.ShortFormProvider;
import org.semanticweb.owlapi.util.SimpleShortFormProvider;
import uk.ac.manchester.cs.owlapi.dlsyntax.DLSyntax;
import uk.ac.manchester.cs.owlapi.dlsyntax.DLSyntaxHTMLOntologyFormat;
import uk.ac.manchester.cs.owlapi.dlsyntax.DLSyntaxObjectRenderer;
import uk.ac.manchester.cs.owlapi.dlsyntax.DLSyntaxOntologyStorerBase;

public class DLSyntaxHTMLOntologyStorer
extends DLSyntaxOntologyStorerBase {
    private static final long serialVersionUID = 30406L;
    protected ShortFormProvider sfp = new SimpleShortFormProvider();

    @Override
    public boolean canStoreOntology(OWLOntologyFormat ontologyFormat) {
        return ontologyFormat.equals(new DLSyntaxHTMLOntologyFormat());
    }

    @Override
    protected String getRendering(final OWLEntity subject, OWLAxiom axiom) {
        DLSyntaxObjectRenderer ren = new DLSyntaxObjectRenderer(){

            @Override
            protected String renderEntity(OWLEntity entity) {
                if (!entity.equals(subject)) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("<a href=\"#");
                    sb.append(DLSyntaxHTMLOntologyStorer.this.sfp.getShortForm(entity));
                    sb.append("\">");
                    sb.append(DLSyntaxHTMLOntologyStorer.this.sfp.getShortForm(entity));
                    sb.append("</a>");
                    return sb.toString();
                }
                return DLSyntaxHTMLOntologyStorer.this.sfp.getShortForm(entity);
            }

            @Override
            protected void write(DLSyntax keyword2) {
                super.write(XMLUtils.escapeXML(keyword2.toString()));
            }
        };
        ren.setFocusedObject(subject);
        ren.setShortFormProvider(this.sfp);
        String rendering = ren.render(axiom);
        return rendering;
    }

    @Override
    protected void beginWritingOntology(OWLOntology ontology, PrintWriter writer2) {
        writer2.println("<html>");
        writer2.println("<body>");
        writer2.print("<h1>");
        writer2.print("Ontology: ");
        writer2.print(ontology.getOntologyID().toString());
        writer2.println("</h1>");
    }

    protected void writeEntity(OWLEntity entity, PrintWriter writer2) {
    }

    @Override
    protected void endWritingOntology(OWLOntology ontology, PrintWriter writer2) {
        writer2.println("</body>");
        writer2.println("</html>");
    }

    @Override
    protected void beginWritingAxiom(OWLAxiom axiom, PrintWriter writer2) {
        writer2.println("<div class=\"axiombox\"> ");
    }

    @Override
    protected void endWritingAxiom(OWLAxiom axiom, PrintWriter writer2) {
        writer2.println(" </div>");
    }

    @Override
    protected void beginWritingAxioms(OWLEntity subject, Set<? extends OWLAxiom> axioms, PrintWriter writer2) {
        writer2.print("<h2><a name=\"");
        writer2.print(this.sfp.getShortForm(subject));
        writer2.print("\">");
        writer2.print(subject.toString());
        writer2.println("</a></h2>");
        writer2.println("<div class=\"entitybox\">");
    }

    @Override
    protected void endWritingAxioms(OWLEntity subject, Set<? extends OWLAxiom> axioms, PrintWriter writer2) {
        writer2.println("</div>");
    }

    @Override
    protected void beginWritingGeneralAxioms(Set<? extends OWLAxiom> axioms, PrintWriter writer2) {
        writer2.println("<div>");
    }

    @Override
    protected void endWritingGeneralAxioms(Set<? extends OWLAxiom> axioms, PrintWriter writer2) {
        writer2.println("</div>");
    }

    @Override
    protected void beginWritingUsage(OWLEntity subject, Set<? extends OWLAxiom> axioms, PrintWriter writer2) {
        writer2.println("<div class=\"usage\" style=\"margin-left: 60px; size: tiny\">");
        writer2.print("<h3>Usages (" + axioms.size() + ")</h3>");
    }

    @Override
    protected void endWritingUsage(OWLEntity subject, Set<? extends OWLAxiom> axioms, PrintWriter writer2) {
        writer2.println("</div>");
    }
}

