/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owlapi.dlsyntax;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.Set;
import java.util.TreeSet;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.util.AbstractOWLOntologyStorer;
import uk.ac.manchester.cs.owlapi.dlsyntax.DLSyntaxObjectRenderer;

public abstract class DLSyntaxOntologyStorerBase
extends AbstractOWLOntologyStorer {
    private static final long serialVersionUID = 30406L;
    private OWLOntology ont;

    @Override
    protected void storeOntology(OWLOntologyManager manager, OWLOntology ontology, Writer w, OWLOntologyFormat format2) throws OWLOntologyStorageException {
        this.storeOntology(ontology, w, format2);
    }

    @Override
    protected void storeOntology(OWLOntology ontology, Writer w, OWLOntologyFormat format2) throws OWLOntologyStorageException {
        this.ont = ontology;
        PrintWriter writer2 = new PrintWriter(w);
        this.beginWritingOntology(ontology, writer2);
        for (OWLObjectProperty oWLObjectProperty : new TreeSet<OWLObjectProperty>(ontology.getObjectPropertiesInSignature())) {
            this.write(oWLObjectProperty, ontology.getAxioms(oWLObjectProperty), writer2);
        }
        for (OWLDataProperty oWLDataProperty : new TreeSet<OWLDataProperty>(ontology.getDataPropertiesInSignature())) {
            this.write(oWLDataProperty, ontology.getAxioms(oWLDataProperty), writer2);
        }
        for (OWLClass oWLClass : new TreeSet<OWLClass>(ontology.getClassesInSignature())) {
            this.write(oWLClass, ontology.getAxioms(oWLClass), writer2);
        }
        for (OWLNamedIndividual oWLNamedIndividual : new TreeSet<OWLNamedIndividual>(ontology.getIndividualsInSignature())) {
            this.write(oWLNamedIndividual, ontology.getAxioms(oWLNamedIndividual), writer2);
        }
        this.beginWritingGeneralAxioms(ontology.getGeneralClassAxioms(), writer2);
        for (OWLAxiom oWLAxiom : ontology.getGeneralClassAxioms()) {
            this.beginWritingAxiom(oWLAxiom, writer2);
            this.writeAxiom(null, oWLAxiom, writer2);
            this.endWritingAxiom(oWLAxiom, writer2);
        }
        this.endWritingGeneralAxioms(ontology.getGeneralClassAxioms(), writer2);
        this.endWritingOntology(ontology, writer2);
        writer2.flush();
    }

    private void write(OWLEntity entity, Set<? extends OWLAxiom> axioms, PrintWriter writer2) {
        this.beginWritingAxioms(entity, axioms, writer2);
        for (OWLAxiom oWLAxiom : new TreeSet<OWLAxiom>(axioms)) {
            this.beginWritingAxiom(oWLAxiom, writer2);
            this.writeAxiom(entity, oWLAxiom, writer2);
            this.endWritingAxiom(oWLAxiom, writer2);
        }
        TreeSet<OWLAxiom> usages = new TreeSet<OWLAxiom>(this.ont.getReferencingAxioms(entity));
        usages.removeAll(axioms);
        this.beginWritingUsage(entity, usages, writer2);
        for (OWLAxiom usage : usages) {
            if (axioms.contains(usage)) continue;
            this.beginWritingAxiom(usage, writer2);
            this.writeAxiom(entity, usage, writer2);
            this.endWritingAxiom(usage, writer2);
        }
        this.endWritingUsage(entity, usages, writer2);
        this.endWritingAxioms(entity, axioms, writer2);
    }

    protected void writeAxiom(OWLEntity subject, OWLAxiom axiom, PrintWriter writer2) {
        writer2.write(this.getRendering(subject, axiom));
    }

    protected String getRendering(OWLEntity subject, OWLAxiom axiom) {
        DLSyntaxObjectRenderer ren = new DLSyntaxObjectRenderer();
        return ren.render(axiom);
    }

    protected void beginWritingOntology(OWLOntology ontology, PrintWriter writer2) {
    }

    protected void endWritingOntology(OWLOntology ontology, PrintWriter writer2) {
    }

    protected void beginWritingAxiom(OWLAxiom axiom, PrintWriter writer2) {
    }

    protected void endWritingAxiom(OWLAxiom axiom, PrintWriter writer2) {
    }

    protected void beginWritingAxioms(OWLEntity subject, Set<? extends OWLAxiom> axioms, PrintWriter writer2) {
    }

    protected void endWritingAxioms(OWLEntity subject, Set<? extends OWLAxiom> axioms, PrintWriter writer2) {
    }

    protected void beginWritingUsage(OWLEntity subject, Set<? extends OWLAxiom> axioms, PrintWriter writer2) {
    }

    protected void endWritingUsage(OWLEntity subject, Set<? extends OWLAxiom> axioms, PrintWriter writer2) {
    }

    protected void beginWritingGeneralAxioms(Set<? extends OWLAxiom> axioms, PrintWriter writer2) {
    }

    protected void endWritingGeneralAxioms(Set<? extends OWLAxiom> axioms, PrintWriter writer2) {
    }
}

