/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owlapi.dlsyntax.parser;

import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;
import uk.ac.manchester.cs.BOMSafeJavaCharStream;
import uk.ac.manchester.cs.owlapi.dlsyntax.parser.DLSyntaxParserConstants;
import uk.ac.manchester.cs.owlapi.dlsyntax.parser.DLSyntaxParserTokenManager;
import uk.ac.manchester.cs.owlapi.dlsyntax.parser.ParseException;
import uk.ac.manchester.cs.owlapi.dlsyntax.parser.Token;

public class DLSyntaxParser
implements DLSyntaxParserConstants {
    private String defaultNamespace = "http://www.sematicweb.org/ontologies/Ontology" + System.nanoTime();
    private Map<String, String> namespaceMap = new HashMap<String, String>();
    private OWLDataFactory factory;
    private Map<String, IRI> iriMap = new HashMap<String, IRI>();
    private Map<String, IRI> qnameIRIMap = new HashMap<String, IRI>();
    public DLSyntaxParserTokenManager token_source;
    BOMSafeJavaCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[0];
    private static int[] jj_la1_0;
    private final JJCalls[] jj_2_rtns = new JJCalls[50];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public void setOWLDataFactory(OWLDataFactory factory) {
        this.factory = factory;
    }

    public void setPrefixMapping(String prefix, String namespace2) {
        this.namespaceMap.put(prefix, namespace2);
    }

    public void setDefaultNamespace(String ns2) {
        this.defaultNamespace = ns2;
    }

    public IRI getIRI(String val2) {
        IRI iri = this.iriMap.get(val2);
        if (iri == null) {
            iri = IRI.create(val2);
            this.iriMap.put(val2, iri);
        }
        return iri;
    }

    public IRI getIRIFromId(String qname) {
        if (qname.equals("top") || qname.equals("\u22a4")) {
            return OWLRDFVocabulary.OWL_THING.getIRI();
        }
        if (qname.equals("bottom") || qname.equals("\u22a5")) {
            return OWLRDFVocabulary.OWL_NOTHING.getIRI();
        }
        IRI iri = this.qnameIRIMap.get(qname);
        if (iri == null) {
            iri = this.getIRI(this.defaultNamespace + "#" + qname);
            this.qnameIRIMap.put(qname, iri);
        }
        return iri;
    }

    public final OWLClassExpression parseDescription() throws ParseException {
        OWLClassExpression desc = this.parseClassDescription();
        this.jj_consume_token(0);
        return desc;
    }

    public final Set<OWLAxiom> parseAxioms() throws ParseException {
        LinkedHashSet<OWLAxiom> axioms = new LinkedHashSet<OWLAxiom>();
        OWLAxiom ax = this.parseAxiom();
        axioms.add(ax);
        while (this.jj_2_1(5)) {
            if (this.jj_2_2(5)) {
                this.jj_consume_token(30);
                ax = this.parseAxiom();
                axioms.add(ax);
                continue;
            }
            if (this.jj_2_3(5)) {
                this.jj_consume_token(30);
                continue;
            }
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(0);
        return axioms;
    }

    public final OWLAxiom parseAxiom() throws ParseException {
        if (this.jj_2_4(5)) {
            this.jj_consume_token(16);
            OWLAxiom ax = this.parsePropertyAxiom();
            return ax;
        }
        if (this.jj_2_5(5)) {
            OWLAxiom ax = this.parseClassAxiom();
            return ax;
        }
        if (this.jj_2_6(5)) {
            OWLAxiom ax = this.parseIndividualAxiom();
            return ax;
        }
        if (this.jj_2_7(5)) {
            OWLAxiom ax = this.parseObjectPropertyAssertion();
            return ax;
        }
        if (this.jj_2_8(5)) {
            OWLAxiom ax = this.parseDataPropertyAssertion();
            return ax;
        }
        if (this.jj_2_9(5)) {
            OWLAxiom ax = this.parseDifferentIndividualsAxiom();
            return ax;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final OWLAxiom parseIndividualAxiom() throws ParseException {
        OWLAxiom ax;
        if (this.jj_2_10(5)) {
            ax = this.parseClassAssertion();
        } else if (this.jj_2_11(5)) {
            ax = this.parseSameIndividual();
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return ax;
    }

    public final OWLAxiom parseDifferentIndividualsAxiom() throws ParseException {
        HashSet<OWLIndividual> inds = new HashSet<OWLIndividual>();
        OWLIndividual ind = this.parseIndividualId();
        inds.add(ind);
        this.jj_consume_token(6);
        ind = this.parseIndividualId();
        inds.add(ind);
        while (this.jj_2_12(5)) {
            this.jj_consume_token(6);
            ind = this.parseIndividualId();
            inds.add(ind);
        }
        return this.factory.getOWLDifferentIndividualsAxiom(inds);
    }

    public final OWLAxiom parseObjectPropertyAssertion() throws ParseException {
        OWLObjectPropertyExpression prop = this.parseObjectPropertyId();
        this.jj_consume_token(10);
        OWLIndividual subj = this.parseIndividualId();
        this.jj_consume_token(31);
        OWLIndividual obj = this.parseIndividualId();
        this.jj_consume_token(11);
        return this.factory.getOWLObjectPropertyAssertionAxiom(prop, subj, obj);
    }

    public final OWLAxiom parseDataPropertyAssertion() throws ParseException {
        OWLDataPropertyExpression prop = this.parseDataPropertyId();
        this.jj_consume_token(10);
        OWLIndividual subj = this.parseIndividualId();
        this.jj_consume_token(31);
        OWLLiteral obj = this.parseLiteral();
        this.jj_consume_token(11);
        return this.factory.getOWLDataPropertyAssertionAxiom(prop, subj, obj);
    }

    public final OWLAxiom parseSameIndividual() throws ParseException {
        OWLIndividual indA = this.parseIndividualId();
        this.jj_consume_token(24);
        OWLIndividual indB = this.parseIndividualId();
        return this.factory.getOWLSameIndividualAxiom(CollectionFactory.createSet(indA, indB));
    }

    public final OWLAxiom parseClassAssertion() throws ParseException {
        if (!this.jj_2_15(5)) {
            if (this.jj_2_16(5)) {
                OWLClassExpression desc = this.parseClassDescription();
                this.jj_consume_token(10);
                OWLIndividual ind = this.parseIndividualId();
                this.jj_consume_token(11);
                if (this.jj_2_13(5)) {
                    this.jj_consume_token(30);
                    this.jj_input_stream.backup(1);
                } else if (this.jj_2_14(5)) {
                    this.jj_consume_token(0);
                } else {
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                return this.factory.getOWLClassAssertionAxiom(desc, ind);
            }
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(10);
        OWLClassExpression desc = this.parseDescription();
        this.jj_consume_token(11);
        throw new ParseException("Missing return statement in function");
    }

    public final OWLAxiom parseClassAxiom() throws ParseException {
        boolean subClassAxiom = false;
        OWLClassExpression lhs = this.parseClassDescription();
        if (this.jj_2_17(5)) {
            OWLObjectSomeValuesFrom restriction;
            this.jj_consume_token(4);
            OWLClassExpression rhs = this.parseClassDescription();
            if (lhs.isOWLThing()) {
                OWLObjectMaxCardinality restriction2;
                if (rhs instanceof OWLObjectAllValuesFrom) {
                    OWLObjectAllValuesFrom restriction3 = (OWLObjectAllValuesFrom)rhs;
                    return this.factory.getOWLObjectPropertyRangeAxiom((OWLObjectPropertyExpression)restriction3.getProperty(), (OWLClassExpression)restriction3.getFiller());
                }
                if (rhs instanceof OWLObjectMaxCardinality && (restriction2 = (OWLObjectMaxCardinality)rhs).getCardinality() == 1 && ((OWLClassExpression)restriction2.getFiller()).isOWLThing()) {
                    return this.factory.getOWLFunctionalObjectPropertyAxiom((OWLObjectPropertyExpression)restriction2.getProperty());
                }
            } else if (lhs instanceof OWLObjectSomeValuesFrom && ((OWLClassExpression)(restriction = (OWLObjectSomeValuesFrom)lhs).getFiller()).isOWLThing()) {
                return this.factory.getOWLObjectPropertyDomainAxiom((OWLObjectPropertyExpression)restriction.getProperty(), rhs);
            }
            if (rhs instanceof OWLObjectComplementOf && !rhs.isAnonymous()) {
                return this.factory.getOWLDisjointClassesAxiom(lhs, ((OWLObjectComplementOf)rhs).getOperand());
            }
            return this.factory.getOWLSubClassOfAxiom(lhs, rhs);
        }
        if (this.jj_2_18(5)) {
            this.jj_consume_token(5);
            OWLClassExpression rhs = this.parseClassDescription();
            return this.factory.getOWLEquivalentClassesAxiom(lhs, rhs);
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final OWLAxiom parsePropertyChain() throws ParseException {
        ArrayList<OWLObjectPropertyExpression> props = new ArrayList<OWLObjectPropertyExpression>();
        OWLObjectPropertyExpression prop = this.parseObjectPropertyId();
        props.add(prop);
        this.jj_consume_token(7);
        prop = this.parseObjectPropertyId();
        props.add(prop);
        while (this.jj_2_19(5)) {
            this.jj_consume_token(7);
            prop = this.parseObjectPropertyId();
            props.add(prop);
        }
        this.jj_consume_token(4);
        OWLObjectPropertyExpression supProp = this.parseObjectPropertyId();
        return this.factory.getOWLSubPropertyChainOfAxiom(props, supProp);
    }

    public final OWLAxiom parsePropertyAxiom() throws ParseException {
        if (this.jj_2_23(5)) {
            OWLObjectPropertyExpression lhs = this.parseObjectPropertyId();
            if (this.jj_2_20(5)) {
                this.jj_consume_token(4);
                OWLObjectPropertyExpression rhs = this.parseObjectPropertyId();
                return this.factory.getOWLSubObjectPropertyOfAxiom(lhs, rhs);
            }
            if (this.jj_2_21(5)) {
                this.jj_consume_token(5);
                OWLObjectPropertyExpression rhs = this.parseObjectPropertyId();
                if (rhs instanceof OWLObjectInverseOf) {
                    OWLObjectInverseOf inv = (OWLObjectInverseOf)rhs;
                    return this.factory.getOWLInverseObjectPropertiesAxiom(lhs, inv.getInverse());
                }
                return this.factory.getOWLEquivalentObjectPropertiesAxiom(CollectionFactory.createSet(lhs, rhs));
            }
            if (this.jj_2_22(5)) {
                this.jj_consume_token(25);
                this.jj_consume_token(26);
                return this.factory.getOWLTransitiveObjectPropertyAxiom(lhs);
            }
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        if (this.jj_2_24(5)) {
            OWLAxiom ax = this.parsePropertyChain();
            return ax;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final OWLClassExpression parseClassDescription() throws ParseException {
        OWLClassExpression desc = this.Or();
        return desc;
    }

    public final OWLClassExpression Or() throws ParseException {
        HashSet<OWLClassExpression> operands = new HashSet<OWLClassExpression>();
        OWLClassExpression desc = this.And();
        operands.add(desc);
        while (this.jj_2_25(5)) {
            this.jj_consume_token(18);
            desc = this.And();
            operands.add(desc);
        }
        if (operands.size() == 1) {
            return desc;
        }
        return this.factory.getOWLObjectUnionOf(operands);
    }

    public final OWLClassExpression And() throws ParseException {
        HashSet<OWLClassExpression> operands = new HashSet<OWLClassExpression>();
        OWLClassExpression desc = this.NonNaryBooleanDescription();
        operands.add(desc);
        while (this.jj_2_26(5)) {
            this.jj_consume_token(17);
            desc = this.NonNaryBooleanDescription();
            operands.add(desc);
        }
        if (operands.size() == 1) {
            return desc;
        }
        return this.factory.getOWLObjectIntersectionOf(operands);
    }

    public final OWLClassExpression NonNaryBooleanDescription() throws ParseException {
        OWLClassExpression desc;
        if (this.jj_2_27(5)) {
            desc = this.parseRestriction();
        } else if (this.jj_2_28(5)) {
            desc = this.parseObjectComplementOf();
        } else if (this.jj_2_29(5)) {
            desc = this.NamedClassOrNestedDescription();
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return desc;
    }

    public final OWLObjectPropertyExpression parseObjectPropertyId() throws ParseException {
        boolean inverse = false;
        IRI iri = this.parseId();
        if (this.jj_2_30(5)) {
            this.jj_consume_token(9);
            inverse = true;
        }
        if (inverse) {
            OWLObjectProperty prop = this.factory.getOWLObjectProperty(iri);
            return this.factory.getOWLObjectInverseOf(prop);
        }
        return this.factory.getOWLObjectProperty(iri);
    }

    public final OWLDataPropertyExpression parseDataPropertyId() throws ParseException {
        boolean inverse = false;
        IRI iri = this.parseId();
        return this.factory.getOWLDataProperty(iri);
    }

    public final OWLClassExpression parseRestriction() throws ParseException {
        OWLClassExpression desc;
        if (this.jj_2_31(5)) {
            desc = this.parseSomeRestriction();
        } else if (this.jj_2_32(5)) {
            desc = this.parseDataSomeRestriction();
        } else if (this.jj_2_33(5)) {
            desc = this.parseAllRestriction();
        } else if (this.jj_2_34(5)) {
            desc = this.parseCardinalityRestriction();
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return desc;
    }

    public final OWLClassExpression parseSomeRestriction() throws ParseException {
        this.jj_consume_token(20);
        OWLObjectPropertyExpression prop = this.parseObjectPropertyId();
        if (this.jj_2_35(5)) {
            this.jj_consume_token(8);
        }
        OWLClassExpression filler = this.NamedClassOrNestedDescription();
        return this.factory.getOWLObjectSomeValuesFrom(prop, filler);
    }

    public final OWLClassExpression parseDataSomeRestriction() throws ParseException {
        this.jj_consume_token(20);
        OWLDataPropertyExpression prop = this.parseDataPropertyId();
        if (this.jj_2_36(5)) {
            this.jj_consume_token(8);
        }
        OWLDataRange filler = this.parseDataOneOf();
        return this.factory.getOWLDataSomeValuesFrom(prop, filler);
    }

    public final OWLClassExpression parseAllRestriction() throws ParseException {
        this.jj_consume_token(21);
        OWLObjectPropertyExpression prop = this.parseObjectPropertyId();
        if (this.jj_2_37(5)) {
            this.jj_consume_token(8);
        }
        OWLClassExpression filler = this.NamedClassOrNestedDescription();
        return this.factory.getOWLObjectAllValuesFrom(prop, filler);
    }

    public final OWLClassExpression parseCardinalityRestriction() throws ParseException {
        OWLClassExpression filler = null;
        boolean min2 = false;
        boolean exactly = false;
        boolean max2 = false;
        if (this.jj_2_38(5)) {
            this.jj_consume_token(22);
            min2 = true;
        } else if (this.jj_2_39(5)) {
            this.jj_consume_token(24);
            exactly = true;
        } else if (this.jj_2_40(5)) {
            this.jj_consume_token(23);
            max2 = true;
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        Token t = this.jj_consume_token(27);
        OWLObjectPropertyExpression prop = this.parseObjectPropertyId();
        if (this.jj_2_42(5)) {
            if (this.jj_2_41(5)) {
                this.jj_consume_token(8);
            }
            filler = this.NamedClassOrNestedDescription();
        }
        int card = Integer.parseInt(t.image);
        if (filler == null) {
            filler = this.factory.getOWLThing();
        }
        if (min2) {
            return this.factory.getOWLObjectMinCardinality(card, prop, filler);
        }
        if (exactly) {
            return this.factory.getOWLObjectExactCardinality(card, prop, filler);
        }
        return this.factory.getOWLObjectMaxCardinality(card, prop, filler);
    }

    public final OWLIndividual parseIndividualId() throws ParseException {
        IRI iri = this.parseId();
        return this.factory.getOWLNamedIndividual(iri);
    }

    public final OWLClassExpression parseObjectComplementOf() throws ParseException {
        this.jj_consume_token(19);
        OWLClassExpression op = this.NamedClassOrNestedDescription();
        return this.factory.getOWLObjectComplementOf(op);
    }

    public final OWLClassExpression parseObjectOneOf() throws ParseException {
        HashSet<OWLIndividual> inds = new HashSet<OWLIndividual>();
        this.jj_consume_token(14);
        OWLIndividual ind = this.parseIndividualId();
        inds.add(ind);
        while (this.jj_2_43(5)) {
            ind = this.parseIndividualId();
            inds.add(ind);
        }
        this.jj_consume_token(15);
        return this.factory.getOWLObjectOneOf(inds);
    }

    public final OWLDataRange parseDataOneOf() throws ParseException {
        HashSet<OWLLiteral> values = new HashSet<OWLLiteral>();
        this.jj_consume_token(14);
        OWLLiteral val2 = this.parseLiteral();
        values.add(val2);
        while (this.jj_2_44(5)) {
            val2 = this.parseLiteral();
            values.add(val2);
        }
        this.jj_consume_token(15);
        return this.factory.getOWLDataOneOf(values);
    }

    public final OWLClassExpression NamedClassOrNestedDescription() throws ParseException {
        OWLClassExpression desc;
        if (this.jj_2_45(5)) {
            desc = this.parseClassId();
        } else if (this.jj_2_46(5)) {
            desc = this.NestedClassDescription();
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return desc;
    }

    public final OWLClass parseClassId() throws ParseException {
        IRI iri = this.parseId();
        return this.factory.getOWLClass(iri);
    }

    public final OWLClassExpression NestedClassDescription() throws ParseException {
        if (this.jj_2_47(5)) {
            this.jj_consume_token(10);
            OWLClassExpression desc = this.Or();
            this.jj_consume_token(11);
            return desc;
        }
        if (this.jj_2_48(5)) {
            OWLClassExpression desc = this.parseObjectOneOf();
            return desc;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final OWLLiteral parseLiteral() throws ParseException {
        if (this.jj_2_49(5)) {
            Token t = this.jj_consume_token(27);
            return this.factory.getOWLLiteral(Integer.parseInt(t.image));
        }
        if (this.jj_2_50(5)) {
            Token t = this.jj_consume_token(28);
            return this.factory.getOWLLiteral(Double.parseDouble(t.image));
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final IRI parseId() throws ParseException {
        Token t = this.jj_consume_token(29);
        String name2 = t.image;
        return this.getIRIFromId(name2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(6, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_8(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_8();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(7, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_9(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_9();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(8, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_10(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_10();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(9, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_11(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_11();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(10, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_12(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_12();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(11, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_13(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_13();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(12, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_14(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_14();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(13, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_15(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_15();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(14, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_16(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_16();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(15, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_17(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_17();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(16, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_18(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_18();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(17, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_19(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_19();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(18, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_20(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_20();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(19, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_21(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_21();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(20, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_22(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_22();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(21, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_23(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_23();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(22, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_24(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_24();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(23, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_25(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_25();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(24, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_26(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_26();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(25, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_27(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_27();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(26, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_28(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_28();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(27, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_29(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_29();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(28, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_30(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_30();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(29, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_31(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_31();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(30, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_32(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_32();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(31, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_33(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_33();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(32, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_34(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_34();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(33, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_35(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_35();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(34, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_36(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_36();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(35, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_37(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_37();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(36, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_38(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_38();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(37, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_39(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_39();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(38, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_40(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_40();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(39, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_41(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_41();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(40, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_42(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_42();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(41, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_43(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_43();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(42, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_44(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_44();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(43, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_45(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_45();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(44, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_46(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_46();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(45, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_47(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_47();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(46, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_48(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_48();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(47, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_49(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_49();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(48, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_50(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_50();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(49, xla);
        }
    }

    private boolean jj_3R_27() {
        if (this.jj_scan_token(20)) {
            return true;
        }
        if (this.jj_3R_20()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_35()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_26();
    }

    private boolean jj_3_12() {
        if (this.jj_scan_token(6)) {
            return true;
        }
        return this.jj_3R_17();
    }

    private boolean jj_3_17() {
        if (this.jj_scan_token(4)) {
            return true;
        }
        return this.jj_3R_19();
    }

    private boolean jj_3R_10() {
        if (this.jj_3R_19()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_17()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_18()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_13() {
        return this.jj_scan_token(30);
    }

    private boolean jj_3_34() {
        return this.jj_3R_30();
    }

    private boolean jj_3_33() {
        return this.jj_3R_29();
    }

    private boolean jj_3_32() {
        return this.jj_3R_28();
    }

    private boolean jj_3_31() {
        return this.jj_3R_27();
    }

    private boolean jj_3R_24() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_31()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_32()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_33()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3_34()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_26() {
        if (this.jj_scan_token(17)) {
            return true;
        }
        return this.jj_3R_23();
    }

    private boolean jj_3_16() {
        if (this.jj_3R_19()) {
            return true;
        }
        if (this.jj_scan_token(10)) {
            return true;
        }
        if (this.jj_3R_17()) {
            return true;
        }
        if (this.jj_scan_token(11)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_13()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_14()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_48() {
        return this.jj_3R_35();
    }

    private boolean jj_3R_36() {
        return this.jj_3R_37();
    }

    private boolean jj_3_15() {
        if (this.jj_scan_token(10)) {
            return true;
        }
        if (this.jj_3R_18()) {
            return true;
        }
        return this.jj_scan_token(11);
    }

    private boolean jj_3R_15() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_15()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_16()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_30() {
        return this.jj_scan_token(9);
    }

    private boolean jj_3R_16() {
        if (this.jj_3R_17()) {
            return true;
        }
        if (this.jj_scan_token(24)) {
            return true;
        }
        return this.jj_3R_17();
    }

    private boolean jj_3R_20() {
        if (this.jj_3R_37()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_30()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3_19() {
        if (this.jj_scan_token(7)) {
            return true;
        }
        return this.jj_3R_20();
    }

    private boolean jj_3_41() {
        return this.jj_scan_token(8);
    }

    private boolean jj_3_44() {
        return this.jj_3R_31();
    }

    private boolean jj_3_42() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_41()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_26();
    }

    private boolean jj_3R_37() {
        return this.jj_scan_token(29);
    }

    private boolean jj_3_3() {
        return this.jj_scan_token(30);
    }

    private boolean jj_3_29() {
        return this.jj_3R_26();
    }

    private boolean jj_3_43() {
        return this.jj_3R_17();
    }

    private boolean jj_3_28() {
        return this.jj_3R_25();
    }

    private boolean jj_3_25() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        return this.jj_3R_22();
    }

    private boolean jj_3_27() {
        return this.jj_3R_24();
    }

    private boolean jj_3_50() {
        return this.jj_scan_token(28);
    }

    private boolean jj_3R_23() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_27()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_28()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_29()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_31() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_49()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_50()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_13() {
        if (this.jj_3R_36()) {
            return true;
        }
        if (this.jj_scan_token(10)) {
            return true;
        }
        if (this.jj_3R_17()) {
            return true;
        }
        if (this.jj_scan_token(31)) {
            return true;
        }
        return this.jj_3R_31();
    }

    private boolean jj_3_49() {
        return this.jj_scan_token(27);
    }

    private boolean jj_3_46() {
        return this.jj_3R_33();
    }

    private boolean jj_3R_33() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_47()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_48()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_47() {
        if (this.jj_scan_token(10)) {
            return true;
        }
        if (this.jj_3R_34()) {
            return true;
        }
        return this.jj_scan_token(11);
    }

    private boolean jj_3R_22() {
        Token xsp;
        if (this.jj_3R_23()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_26());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_12() {
        if (this.jj_3R_20()) {
            return true;
        }
        if (this.jj_scan_token(10)) {
            return true;
        }
        if (this.jj_3R_17()) {
            return true;
        }
        if (this.jj_scan_token(31)) {
            return true;
        }
        return this.jj_3R_17();
    }

    private boolean jj_3R_32() {
        return this.jj_3R_37();
    }

    private boolean jj_3_45() {
        return this.jj_3R_32();
    }

    private boolean jj_3R_14() {
        Token xsp;
        if (this.jj_3R_17()) {
            return true;
        }
        if (this.jj_scan_token(6)) {
            return true;
        }
        if (this.jj_3R_17()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_12());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_26() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_45()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_46()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_34() {
        Token xsp;
        if (this.jj_3R_22()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_25());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_2() {
        if (this.jj_scan_token(30)) {
            return true;
        }
        return this.jj_3R_8();
    }

    private boolean jj_3_1() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_2()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_3()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_38() {
        Token xsp;
        if (this.jj_scan_token(14)) {
            return true;
        }
        if (this.jj_3R_31()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_44());
        this.jj_scanpos = xsp;
        return this.jj_scan_token(15);
    }

    private boolean jj_3_11() {
        return this.jj_3R_16();
    }

    private boolean jj_3_10() {
        return this.jj_3R_15();
    }

    private boolean jj_3R_11() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_10()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_11()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_19() {
        return this.jj_3R_34();
    }

    private boolean jj_3_40() {
        return this.jj_scan_token(23);
    }

    private boolean jj_3R_35() {
        Token xsp;
        if (this.jj_scan_token(14)) {
            return true;
        }
        if (this.jj_3R_17()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_43());
        this.jj_scanpos = xsp;
        return this.jj_scan_token(15);
    }

    private boolean jj_3_9() {
        return this.jj_3R_14();
    }

    private boolean jj_3_8() {
        return this.jj_3R_13();
    }

    private boolean jj_3_7() {
        return this.jj_3R_12();
    }

    private boolean jj_3_6() {
        return this.jj_3R_11();
    }

    private boolean jj_3_24() {
        return this.jj_3R_21();
    }

    private boolean jj_3_5() {
        return this.jj_3R_10();
    }

    private boolean jj_3_22() {
        if (this.jj_scan_token(25)) {
            return true;
        }
        return this.jj_scan_token(26);
    }

    private boolean jj_3_4() {
        if (this.jj_scan_token(16)) {
            return true;
        }
        return this.jj_3R_9();
    }

    private boolean jj_3R_8() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_4()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_5()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_6()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3_7()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3_8()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3_9()) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_25() {
        if (this.jj_scan_token(19)) {
            return true;
        }
        return this.jj_3R_26();
    }

    private boolean jj_3_21() {
        if (this.jj_scan_token(5)) {
            return true;
        }
        return this.jj_3R_20();
    }

    private boolean jj_3_37() {
        return this.jj_scan_token(8);
    }

    private boolean jj_3R_17() {
        return this.jj_3R_37();
    }

    private boolean jj_3_20() {
        if (this.jj_scan_token(4)) {
            return true;
        }
        return this.jj_3R_20();
    }

    private boolean jj_3_39() {
        return this.jj_scan_token(24);
    }

    private boolean jj_3_23() {
        if (this.jj_3R_20()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_20()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_21()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_22()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_9() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_23()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_24()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_36() {
        return this.jj_scan_token(8);
    }

    private boolean jj_3R_18() {
        if (this.jj_3R_19()) {
            return true;
        }
        return this.jj_scan_token(0);
    }

    private boolean jj_3R_21() {
        Token xsp;
        if (this.jj_3R_20()) {
            return true;
        }
        if (this.jj_scan_token(7)) {
            return true;
        }
        if (this.jj_3R_20()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_19());
        this.jj_scanpos = xsp;
        if (this.jj_scan_token(4)) {
            return true;
        }
        return this.jj_3R_20();
    }

    private boolean jj_3_35() {
        return this.jj_scan_token(8);
    }

    private boolean jj_3_38() {
        return this.jj_scan_token(22);
    }

    private boolean jj_3R_30() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_38()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_39()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_40()) {
                    return true;
                }
            }
        }
        if (this.jj_scan_token(27)) {
            return true;
        }
        if (this.jj_3R_20()) {
            return true;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_42()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3_14() {
        return this.jj_scan_token(0);
    }

    private boolean jj_3_18() {
        if (this.jj_scan_token(5)) {
            return true;
        }
        return this.jj_3R_19();
    }

    private boolean jj_3R_29() {
        if (this.jj_scan_token(21)) {
            return true;
        }
        if (this.jj_3R_20()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_37()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_26();
    }

    private boolean jj_3R_28() {
        if (this.jj_scan_token(20)) {
            return true;
        }
        if (this.jj_3R_36()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_36()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_38();
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[0];
    }

    public DLSyntaxParser(InputStream stream) {
        this(stream, null);
    }

    public DLSyntaxParser(InputStream stream, String encoding2) {
        int i;
        try {
            this.jj_input_stream = new BOMSafeJavaCharStream(stream, encoding2, 1, 1);
        }
        catch (UnsupportedEncodingException e2) {
            throw new OWLRuntimeException(e2);
        }
        this.token_source = new DLSyntaxParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 0; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding2) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding2, 1, 1);
        }
        catch (UnsupportedEncodingException e2) {
            throw new OWLRuntimeException(e2);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 0; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public DLSyntaxParser(Reader stream) {
        int i;
        this.jj_input_stream = new BOMSafeJavaCharStream(stream, 1, 1);
        this.token_source = new DLSyntaxParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 0; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 0; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public DLSyntaxParser(DLSyntaxParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 0; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(DLSyntaxParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 0; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index2) {
        Token t = this.token;
        for (int i = 0; i < index2; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            block1: for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] != this.jj_expentry[i]) continue block1;
                }
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[32];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 0; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) == 0) continue;
                la1tokens[j] = true;
            }
        }
        for (i = 0; i < 32; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 50; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                            break;
                        }
                        case 5: {
                            this.jj_3_6();
                            break;
                        }
                        case 6: {
                            this.jj_3_7();
                            break;
                        }
                        case 7: {
                            this.jj_3_8();
                            break;
                        }
                        case 8: {
                            this.jj_3_9();
                            break;
                        }
                        case 9: {
                            this.jj_3_10();
                            break;
                        }
                        case 10: {
                            this.jj_3_11();
                            break;
                        }
                        case 11: {
                            this.jj_3_12();
                            break;
                        }
                        case 12: {
                            this.jj_3_13();
                            break;
                        }
                        case 13: {
                            this.jj_3_14();
                            break;
                        }
                        case 14: {
                            this.jj_3_15();
                            break;
                        }
                        case 15: {
                            this.jj_3_16();
                            break;
                        }
                        case 16: {
                            this.jj_3_17();
                            break;
                        }
                        case 17: {
                            this.jj_3_18();
                            break;
                        }
                        case 18: {
                            this.jj_3_19();
                            break;
                        }
                        case 19: {
                            this.jj_3_20();
                            break;
                        }
                        case 20: {
                            this.jj_3_21();
                            break;
                        }
                        case 21: {
                            this.jj_3_22();
                            break;
                        }
                        case 22: {
                            this.jj_3_23();
                            break;
                        }
                        case 23: {
                            this.jj_3_24();
                            break;
                        }
                        case 24: {
                            this.jj_3_25();
                            break;
                        }
                        case 25: {
                            this.jj_3_26();
                            break;
                        }
                        case 26: {
                            this.jj_3_27();
                            break;
                        }
                        case 27: {
                            this.jj_3_28();
                            break;
                        }
                        case 28: {
                            this.jj_3_29();
                            break;
                        }
                        case 29: {
                            this.jj_3_30();
                            break;
                        }
                        case 30: {
                            this.jj_3_31();
                            break;
                        }
                        case 31: {
                            this.jj_3_32();
                            break;
                        }
                        case 32: {
                            this.jj_3_33();
                            break;
                        }
                        case 33: {
                            this.jj_3_34();
                            break;
                        }
                        case 34: {
                            this.jj_3_35();
                            break;
                        }
                        case 35: {
                            this.jj_3_36();
                            break;
                        }
                        case 36: {
                            this.jj_3_37();
                            break;
                        }
                        case 37: {
                            this.jj_3_38();
                            break;
                        }
                        case 38: {
                            this.jj_3_39();
                            break;
                        }
                        case 39: {
                            this.jj_3_40();
                            break;
                        }
                        case 40: {
                            this.jj_3_41();
                            break;
                        }
                        case 41: {
                            this.jj_3_42();
                            break;
                        }
                        case 42: {
                            this.jj_3_43();
                            break;
                        }
                        case 43: {
                            this.jj_3_44();
                            break;
                        }
                        case 44: {
                            this.jj_3_45();
                            break;
                        }
                        case 45: {
                            this.jj_3_46();
                            break;
                        }
                        case 46: {
                            this.jj_3_47();
                            break;
                        }
                        case 47: {
                            this.jj_3_48();
                            break;
                        }
                        case 48: {
                            this.jj_3_49();
                            break;
                        }
                        case 49: {
                            this.jj_3_50();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index2, int xla) {
        JJCalls p = this.jj_2_rtns[index2];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        DLSyntaxParser.jj_la1_init_0();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends OWLRuntimeException {
        private LookaheadSuccess() {
        }
    }
}

