/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.owl.owlapi.tutorialowled2011;

import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owlapi.debugging.BlackBoxOWLDebugger;
import org.semanticweb.owlapi.debugging.OWLDebugger;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;
import uk.ac.manchester.owl.owlapi.tutorialowled2011.OWLTutorialSyntaxObjectRenderer;

public class Debugger {
    private final OWLOntology ontology;
    private final OWLDebugger debugger;
    private final OWLReasoner checker;
    private final OWLClass bottom;

    public Debugger(OWLOntologyManager manager, OWLOntology ontology, OWLReasonerFactory reasonerFactory) {
        this.ontology = ontology;
        this.checker = reasonerFactory.createNonBufferingReasoner(ontology);
        this.debugger = new BlackBoxOWLDebugger(manager, ontology, reasonerFactory);
        this.bottom = manager.getOWLDataFactory().getOWLNothing();
    }

    public void report(PrintWriter writer2) throws OWLException {
        OWLTutorialSyntaxObjectRenderer renderer2 = new OWLTutorialSyntaxObjectRenderer(this.ontology, writer2);
        renderer2.header();
        HashSet<OWLClass> unsatisfiables = new HashSet<OWLClass>();
        for (OWLClass clazz : this.ontology.getClassesInSignature()) {
            if (this.checker.isSatisfiable(clazz) || clazz.equals(this.bottom)) continue;
            unsatisfiables.add(clazz);
        }
        writer2.println("<h1>Ontology Debugging Report</h1>");
        writer2.println("<br>Ontology: " + this.ontology.getOntologyID() + "<br>");
        if (unsatisfiables.isEmpty()) {
            writer2.println("<br>No Unsatisfiable Classes found<br>");
        } else {
            for (OWLClass unsatisfiable : unsatisfiables) {
                writer2.println("<div class='box'>\n");
                writer2.println("<h2 class='cl'>");
                unsatisfiable.accept(renderer2);
                writer2.println("</h2>");
                writer2.println("<br>Axioms causing inconsistency:<br>");
                writer2.println("<ul>");
                Set<OWLAxiom> sos = this.debugger.getSOSForIncosistentClass(unsatisfiable);
                for (OWLAxiom axiom : sos) {
                    writer2.println("<li>");
                    axiom.accept(renderer2);
                    writer2.println("</li>");
                }
                writer2.println("</ul>");
                writer2.println("</div>\n");
            }
        }
        renderer2.footer();
    }
}

