module(..., package.seeall)

require("lua_tda")
require "lpeg"
require "core"
--tda = require "tda_to_protege" !!!!!!!!!!
specific = require "OWL_specific"
styleMechanism = require "OWLGrEd_UserFields.styleMechanism"

--atrod tipu pie kura piesaistams eksporta translets (parent-vecakelements pie kura ir jaunais lauks, obj-tads ar semantiku)
function findAxiomAnnotationPath(obj, parent)
	local val = obj:attr("tagValue")
	if string.find(val, "Path") ~= nil then
		local ending = string.find(val, ")")
		local path = string.sub(val, 6, ending-1)
		if path ~= ".." then 
			pathTable = styleMechanism.split(path, "/")
			for i,v in pairs(pathTable) do 
				local parent2 = parent:find("/compartType[caption='" .. v .. "']")
				if parent2:is_empty() then parent2 = parent:find("/subCompartType[caption='" .. v .. "']") end
				parent = parent2
				if string.find(parent:attr("id"), "AutoGeneratedGroup") ~= nil then parent = parent:find("/subCompartType[caption='" .. v .. "']") end
				if string.find(parent:attr("id"), "CheckBoxFictitious") ~= nil then parent = parent:find("/subCompartType[caption='" .. v .. "']") end
			end
		end
		local parentCaption = string.sub(parent:attr("caption"), 19)
		local parentCaptionA = parent:attr("caption")
		if string.find(parent:attr("id"), "CheckBoxFictitious") ~= nil then parent = parent:find("/subCompartType[caption='" .. parentCaption .. "']") end
		if string.find(parent:attr("id"), "AutoGeneratedGroup") ~= nil then parent = parent:find("/subCompartType[caption='" .. parentCaptionA .. "']") end
		if parent:find("/parentCompartType"):is_not_empty() and string.find(parent:find("/parentCompartType"):attr("id"), "AutoGeneratedGroup") ~= nil and parent:attr("id") == "Label" then
			local parent2 = parent:find("/parentCompartType/parentCompartType")
			if parent2:is_empty() then parent2 = parent:find("/parentCompartType/elemType") end
			parent = parent2
		end
	end
	return parent
end

--izveido jaunu CompartType (field-AA# dalas lauks, kas atbilst compartType)
function createCompartType(field)
	return lQuery.create("CompartType", {
			caption = lQuery(field):attr("name")
			,id = lQuery(field):attr("name")
			,startValue = lQuery(field):attr("defaultValue")
			,adornmentPrefix = lQuery(field):attr("prefix")
			,adornmentSuffix = lQuery(field):attr("suffix")
			,pattern = lQuery(field):attr("pattern")
			,concatStyle = lQuery(field):attr("delimiter")
			,isEssential = true
			,nr = 0
			,isStereotypable = false
			,isStereotype = false
			,isMultiple = false
			,isHint = false
			,toBeInvisible = false
			,is_occurrence_compartment = false
			,isDiagramName = false
		}):link("compartStyle",lQuery.create("CompartStyle",{
				alignment = 0,adjustment = 0,lineWidth = 1,lineColor = 0,fontTypeFace = "Arial",fontCharSet = 1,fontColor = 0,fontSize = 9,fontPitch = 0,fontStyle = 0,id = lQuery(field):attr("name"),caption = lQuery(field):attr("name"),isVisible = 1,nr = 0,picWidth = 0,picHeight = 0,picPos = 1,picStyle = 0,adornment = 0
			}))
end

function createCompartTypeTextAreaButtonSubField(field)
	return lQuery.create("CompartType", {
			caption = lQuery(field):attr("name")
			,id = lQuery(field):attr("name")
			,startValue = lQuery(field):attr("defaultValue")
			,adornmentPrefix = ""
			,adornmentSuffix = ""
			,pattern = lQuery(field):attr("pattern")
			,isEssential = true
			,nr = 0
			,isStereotypable = false
			,isStereotype = false
			,isMultiple = false
			,isHint = false
			,toBeInvisible = false
			,is_occurrence_compartment = false
			,isDiagramName = false
		}):link("compartStyle",lQuery.create("CompartStyle",{
				alignment = 0,adjustment = 0,lineWidth = 1,lineColor = 0,fontTypeFace = "Arial",fontCharSet = 1,fontColor = 0,fontSize = 9,fontPitch = 0,fontStyle = 0,id = lQuery(field):attr("name"),caption = lQuery(field):attr("name"),isVisible = 1,nr = 0,picWidth = 0,picHeight = 0,picPos = 1,picStyle = 0,adornment = 0
			}))
end

--izveido jaunu CompartType ar TextArea+Button tipu (field-AA# dalas lauks, kas atbilst compartType)
function createCompartTypeTextAreaButton(field)
	return lQuery.create("CompartType", {
			caption = lQuery(field):attr("name")
			,id = lQuery(field):attr("name")
			,startValue = lQuery(field):attr("defaultValue")
			,adornmentPrefix = lQuery(field):attr("prefix")
			,adornmentSuffix = lQuery(field):attr("suffix")
			,pattern = lQuery(field):attr("pattern")
			,isEssential = true
			,nr = 0
			,isStereotypable = false
			,isStereotype = false
			,isMultiple = false
			,isHint = false
			,toBeInvisible = false
			,is_occurrence_compartment = false
			,isDiagramName = false
		}):link("compartStyle",lQuery.create("CompartStyle",{
				alignment = 0,adjustment = 0,lineWidth = 1,lineColor = 0,fontTypeFace = "Arial",fontCharSet = 1,fontColor = 0,fontSize = 9,fontPitch = 0,fontStyle = 0,id = lQuery(field):attr("name"),caption = lQuery(field):attr("name"),isVisible = 1,nr = 0,picWidth = 0,picHeight = 0,picPos = 1,picStyle = 0,adornment = 0
			}))
end

--izveido jaunu ASFictitiousCompartType (field-AA# dalas lauks, kas atbilst compartType)
function createASFictious(field)
	return lQuery.create("CompartType", {
			caption = lQuery(field):attr("name")
			,id = "ASFictitious" .. lQuery(field):attr("name")
			,concatStyle = lQuery(field):attr("delimiter")
			,isEssential = true
			,pattern = lQuery(field):attr("pattern")
			,nr = 0
			,isStereotypable = false
			,isStereotype = false
			,isMultiple = false
			,isHint = false
			,toBeInvisible = false
			,is_occurrence_compartment = false
			,isDiagramName = false
		}):link("compartStyle",lQuery.create("CompartStyle",{
				alignment = 0,adjustment = 0,lineWidth = 1,lineColor = 0,fontTypeFace = "Arial",fontCharSet = 1,fontColor = 0,fontSize = 9,fontPitch = 0,fontStyle = 0,id = lQuery(field):attr("name"),caption = lQuery(field):attr("name"),isVisible = 1,nr = 0,picWidth = 0,picHeight = 0,picPos = 1,picStyle = 0,adornment = 0
			}))
end

--atrod compartType no cela (field-AA#dalas lauks, context-konteksta tips)
function findCompartType(field, context)
    
	if context == nil then 
	    context = lQuery(field):find("/context")
	end
	local path = context:attr("path")
	local pathTable = styleMechanism.split(path, "/")
	local elemType = lQuery("ElemType[caption='" .. context:attr("elTypeName") .. "']")
	local comparType
	local compType
	
	if #pathTable ~= 1 then
		compType = elemType:find("/compartType[caption='" .. pathTable[1] .. "']")
		local pat = lpeg.P("ASFictitious")
		if lpeg.match(pat, compType:attr("id")) then 
			compType = compType:find("/subCompartType[caption='" .. pathTable[1] .. "']")
		end
		for i=2,#pathTable,1 do 
			if pathTable[i] ~= "" then 		
				local compartType2 = compType:find("/subCompartType[caption='" .. context:attr("type") .. "']")
				if compartType2:is_empty() then  
					compartType2 = compType:find("/subCompartType[caption='CheckBoxFictitious" .. context:attr("type") .. "']")
					if compartType2:is_empty() then compartType2 = compType:find("/subCompartType[id='ASFictitious" .. context:attr("type") .. "']") end
				end	
				compType=compartType2
				if lpeg.match(pat, compType:attr("id")) then 
					compType = compType:find("/subCompartType[caption='" .. pathTable[i] .. "']")
				end
			end
		end
		
		local compartType2 = compType:find("/subCompartType[caption='" .. context:attr("type") .. "']")

		local pat = lpeg.P("ASFictitious")
		local pat2 = lpeg.P("(")
		pat2 = anywhere(pat2)
		local contextType
		
		if compartType2:is_empty() then  
			compType3 = compType:find("/subCompartType[caption='CheckBoxFictitious" .. context:attr("type") .. "']")
			if compType3:is_empty() then 
				contextType = context:attr("type")
				if lpeg.match(pat2, context:attr("type"))~= nil then 
					contextType = string.sub(context:attr("type"), 1, lpeg.match(pat2, context:attr("type"))-2)
				end
				compType = compType:find("/subCompartType[id='ASFictitious" .. contextType .. "']")
			else compType=compType3
			end
		else compType=compartType2 end
		
		if lpeg.match(pat, compType:attr("id")) then 
			compType = compType:find("/subCompartType[caption='" .. context:attr("type") .. "']")
			if compType:is_empty() then compType = compType:find("/subCompartType[caption='CheckBoxFictitious" .. context:attr("type") .. "']") end
		end
	else--ja ir pirma limenja lauks
		local pat = lpeg.P("ASFictitious")
			
		local pat2 = lpeg.P("(")
		pat2 = anywhere(pat2)
		local contextType
		local compartType2 = elemType:find("/compartType[caption='" .. context:attr("type") .. "']")
		if compartType2:is_empty() then  
			compType = elemType:find("/compartType[caption='CheckBoxFictitious" .. context:attr("type") .. "']")
			if compType:is_empty() then 
				contextType = context:attr("type")
				if lpeg.match(pat2, context:attr("type"))~= nil then 
					contextType = string.sub(context:attr("type"), 1, lpeg.match(pat2, context:attr("type"))-2)
				end
				compType = elemType:find("/compartType[id='ASFictitious" .. contextType .. "']")
			end
		else compType=compartType2 end

		if lpeg.match(pat, compType:attr("id")) then 
			compType = compType:find("/subCompartType[caption='" .. context:attr("type") .. "']")
		end
	end
	return compType
end

--pievieno jauno lauku pareizaja vieta diagrama (lauks piesaistits elemType) 
--(field-lauks, elemType-elementa tips, fieldTypes-lauka tips, compartType-kompartmenta tips, compartTypeASFictitious-, elemType-elementa tips)	
function createDisplayPlaceBeforeElem(field, elemType, fieldTypes, compartType, compartTypeASFictitious, elemType)		
	--atrast to kas ir noradita displayPlaceBefore atributaa
	--ievietot tabula pirms tas jauno instanci
	--atjaunot saites
	if lQuery(field):attr("displayPlaceBefore") ~= "" then 
		--atlasit visas piesaistitas compartType instances, ierakstit tas tabulaa
		local l = 0
		local t = {}
		lQuery(elemType):find("/compartType"):each(function(obj)
			if obj:attr("caption") == lQuery(field):attr("displayPlaceBefore") then
				if fieldTypes ~= "TextArea+Button" then
					table.insert(t, compartType)
				else table.insert(t, compartTypeASFictitious) end
				l = 1
			end
			table.insert(t, obj)
			obj:remove_link("elemType", elemType)
		end)
		for i,v in pairs(t) do
			v:link("elemType", elemType)
		end
		if l == 0 then 
			if fieldTypes ~= "TextArea+Button" then
				compartType:link("elemType", elemType)  --ja ir uzrakstits neeksistejoss lauks pirms kura ir japievieno
			else compartTypeASFictitious:link("elemType", elemType) end --ja ir uzrakstits neeksistejoss lauks pirms kura ir japievieno
		end
	else
		if fieldTypes ~= "TextArea+Button" then
			compartType:link("elemType", elemType)
		else compartTypeASFictitious:link("elemType", elemType) end
	end
end

--pievieno jauno lauku pareizaja vieta diagrama (lauks piesaistits compartType) 
--(field-lauks, compType-elementa tips, fieldTypes-lauka tips, compartType-kompartmenta tips, compartTypeASFictitious-, elemType-elementa tips)	
function createDisplayPlaceBeforeComp(field, compType, fieldTypes, compartType, compartTypeASFictitious)
	--atrast to kas ir noradita displayPlaceBefore atributaa
	--ievietot tabula pirms tas jauno instanci
	--atjaunot saites
	if lQuery(field):attr("displayPlaceBefore") ~= "" then 
		--atlasit visas piesaistitas compartType instances, ierakstit tas gtabulaa
		local l = 0
		local t = {}
		lQuery(compType):find("/subCompartType"):each(function(obj)
			if obj:attr("caption") == lQuery(field):attr("displayPlaceBefore") then
				if fieldTypes ~= "TextArea+Button" then
					table.insert(t, compartType)
				else table.insert(t, compartTypeASFictitious) end
				l = 1
			end
			table.insert(t, obj)
			obj:remove_link("parentCompartType", compType)
		end)
		for i,v in pairs(t) do
			v:link("parentCompartType", compType)
		end
		if l == 0 then 
			if fieldTypes ~= "TextArea+Button" then
				compartType:link("parentCompartType", compType)  --ja ir uzrakstits neeksistejoss lauks pirms kura ir japievieno
			else compartTypeASFictitious:link("parentCompartType", compType) end --ja ir uzrakstits neeksistejoss lauks pirms kura ir japievieno
		end
	else
		if fieldTypes ~= "TextArea+Button" then
			compartType:link("parentCompartType", compType)
		else compartTypeASFictitious:link("parentCompartType", compType) end
	end
end

--pievieno jauno lauku pareizeja vieta
--(field-lauks, contextType-konteksta tips, propertyRow-lauka tips, propertyEditorTab-lauka cilne, compType-kompartmenta tips, elemType-elementa tips)
function createPropertyEditorTab(field, contextType, propertyRow, propertyEditorTab, compType, elemType)
	if propertyEditorTab ~= "" then 
		--ja tabs ir
		local propertyTab = lQuery("PropertyDiagram[id = '" .. contextType .. "']/propertyTab[caption = '" .. propertyEditorTab .. "']")
		if propertyTab:is_empty() then propertyTab = lQuery("PropertyDiagram[id = '" .. field:find("/context"):attr("elTypeName") .. "']/propertyTab[caption = '" .. propertyEditorTab .. "']") end
		
		--ja tada tab nav, tad izveidot to
		if propertyTab:is_empty() then
			local propertyDiagram = lQuery("PropertyDiagram[id = '" .. contextType .. "']")
			if propertyDiagram:is_empty() then lQuery("PropertyDiagram[id = '" .. field:find("/context"):attr("elTypeName") .. "']") end
			propertyTab = lQuery.create("PropertyTab", {id=propertyEditorTab, caption=propertyEditorTab}):link("propertyDiagram", propertyDiagram)
		end
		
		--savakt visus propertyRow, kas ir piesaistiti atrastajam PropertyTab
		--ierakstit tabulaa
		--ievietot pareizaja vieta jauno ProreptyRow
		--atjaunot saites
		local t = {}
		local l = 0
			
		lQuery(propertyTab):find("/propertyRow"):each(function(obj)
			if obj:attr("id") == lQuery(field):attr("propertyEditorPlaceBefore") then
				table.insert(t, propertyRow)
				l = 1
			end
			table.insert(t, obj)
			obj:remove_link("propertyTab", propertyTab)
		end)
		for i,v in pairs(t) do
			v:link("propertyTab", propertyTab)
		end
		if l == 0 then propertyRow:link("propertyTab" ,propertyTab) end
	--ja ir japiesaista ipasibas diagramai
	else
		local pat = lpeg.P("(")
		pat = anywhere(pat)
		if contextType~= nil and lpeg.match(pat, contextType)~= nil then 
			contextType = string.sub(contextType, 1, lpeg.match(pat, contextType)-2)
		end
		--atrodam propertyDiagram
		local propertyDiagram
		if elemType ~= nil then 
			propertyDiagram = elemType:find("/propertyDiagram")
		else
			propertyDiagram = compType:find("/propertyDiagram")
			if propertyDiagram:size() == 0 then propertyDiagram = compType:find("/parentCompartType/propertyDiagram") end
			if propertyDiagram:size() == 0 then propertyDiagram = compType:find("/elemType/propertyDiagram") end
			if propertyDiagram:size() == 0 then propertyDiagram = compType:find("/parentCompartType/parentCompartType/propertyDiagram") end
			if propertyDiagram:size() == 0 then propertyDiagram = compType:find("/parentCompartType/parentCompartType/parentCompartType/propertyDiagram") end
			if propertyDiagram:size() == 0 then propertyDiagram = lQuery("PropertyDiagram[id = '" .. contextType .. "']") end
		end
		if contextType == "Attributes" then propertyDiagram = lQuery("PropertyDiagram[id = 'Attributes']") end
		if propertyDiagram:size() == 0 then
			--izveidot jaunu PD
			propertyDiagram = lQuery.create("PropertyDiagram", {id = contextType, width = 250}):link("elemType", lQuery("ElemType[id = '" .. contextType .. "']")) 
		end
		--ja compType sakas ar CheckBoxFictitious, tad iet limeni zemak
		if compType~=nil and string.find(compType:attr("id"), "CheckBoxFictitious")~=nil then
			propertyDiagram = compType:find("/subCompartType[id='" .. string.sub(compType:attr("id"), 19) .. "']/propertyRow/calledDiagram")
		elseif compType~=nil and compType:find("/parentCompartType"):is_not_empty() and string.find(compType:find("/parentCompartType"):attr("id"), "CheckBoxFictitious")~=nil then
			propertyDiagram = compType:find("/parentCompartType/subCompartType[id='" .. string.sub(compType:find("/parentCompartType"):attr("id"), 19) .. "']/propertyRow/calledDiagram")
		end
		local t = {}
		local l = 0
		lQuery(propertyDiagram):find("/propertyRow"):each(function(obj)
			if obj:attr("id") == lQuery(field):attr("propertyEditorPlaceBefore") then
				table.insert(t, propertyRow)
				l = 1
			end
			table.insert(t, obj)
			obj:remove_link("propertyDiagram", propertyDiagram)
		end)
		for i,v in pairs(t) do
			v:link("propertyDiagram", propertyDiagram)
		end
		if l == 0 then propertyRow:link("propertyDiagram", propertyDiagram) end
	end
end

function anywhere (p)
  return lpeg.P{ p + 1 * lpeg.V(1) }
end

--atrod compartType kuram ir japiekarto stils (choiceItem-AA# dalas choiceItem, target--compartType nosaukums, inv-pazime, ka ir javeido inversais lauks)
function getTarget(choiceItem, target, styleSetting, inv)
	local compartTypeName = choiceItem:find("/field/context"):attr("type")
	local elemTypeName = choiceItem:find("/field/context"):attr("elTypeName")
	local elemType = lQuery("ElemType[caption='" .. elemTypeName .."']")
	if choiceItem:find("/field/context"):attr("mode") == "Element" then 
		elemType = lQuery("ElemType[caption='" .. choiceItem:find("/field/context"):attr("type") .."']")
	end
	--jaatrod compartType zem elemType
	--local path = choiceItem:find("/field/context"):attr("path")
	local path = styleSetting:attr("path")
	local pathTable = styleMechanism.split(path, "/")

	local compartType
	local values
	if compartTypeName ~= "" then 	
		--if choiceItem:find("/field/context"):attr("mode") == "Element" or path=="" then 
		if path=="" then 
		--if choiceItem:find("/field/context"):attr("mode") == "Element" and path=="" then 
			values = elemType:find("/compartType[caption='" .. target .. "']")
			local pat = lpeg.P("ASFictitious")
			if lpeg.match(pat, values:attr("id")) then 
				values = values:find("/subCompartType[caption='" .. target .. "']")
			end
		elseif #pathTable ~= 1 then
			compartType = elemType:find("/compartType[caption='" .. pathTable[1] .. "']")
			
			if inv == 1 then 
				compartType2 = compartType:find("/aa#mirror")
				if compartType2:is_empty() then compartType = compartType:find("/aa#mirrorInv")
				else compartType = compartType2 end
			end
			local pat = lpeg.P("ASFictitious")
			if lpeg.match(pat, compartType:attr("id")) then 
				compartType = compartType:find("/subCompartType[caption='" .. pathTable[1] .. "']")
			end
			for i=2,#pathTable,1 do 
				if pathTable[i] ~= "" then 
					compartType = compartType:find("/subCompartType[caption='" .. pathTable[i] .. "']")
					local pat2 = lpeg.P("(")
					pat2 = anywhere(pat2)
					if lpeg.match(pat2, pathTable[i])~= nil then 
						pathTable[i] = string.sub(pathTable[i], 1, lpeg.match(pat2, pathTable[i])-2)
					end
					if lpeg.match(pat, compartType:attr("id")) then 
						compartType = compartType:find("/subCompartType[caption='" .. pathTable[i] .. "']")
					end
				end
			end
			
			-- compartType = compartType:find("/subCompartType[caption='" .. compartTypeName .. "']")
			
			-- local pat = lpeg.P("ASFictitious")
			-- if lpeg.match(pat, compartType:attr("id")) then 
				-- compartType = compartType:find("/subCompartType[caption='" .. compartTypeName .. "']")
			-- end
			values = lQuery(compartType):find("/subCompartType[caption='" .. target .. "']")
		else--ja ir pirma limenja lauks
			compartType = elemType:find("/compartType[caption='" .. compartTypeName .. "']")
			if inv == 1 then 
				compartType2 = compartType:find("/aa#mirror")
				if compartType2:is_empty() then compartType = compartType:find("/aa#mirrorInv")
				else compartType = compartType2 end
			end
			
			local pat = lpeg.P("ASFictitious")
			if lpeg.match(pat, compartType:attr("id")) then 
				compartType = compartType:find("/subCompartType[caption='" .. compartTypeName .. "']")
			end
			values = lQuery(compartType):find("/subCompartType[caption='" .. target .. "']")
		end	
		return values
	end
end

--izveido ChoiceItem
function createChoiceItem(field, compartType, contextType, elemType, elTypeName, inv)	
	local choiceItem = lQuery(field):find("/choiceItem"):each(function(obj)
		local ci = lQuery.create("ChoiceItem", {
			value = lQuery(obj):attr("caption")
		}):link("compartType", compartType)
			
		if lQuery(field):attr("fieldType") == "CheckBox" then
			local notation = lQuery.create("Notation", {value = lQuery(obj):attr("notation")}):link("choiceItem", ci)
		else local notation = lQuery.create("Notation", {value = lQuery(obj):attr("caption")}):link("choiceItem", ci)end
		--izveidot tag
		local tagItem = lQuery(obj):find("/tag"):each(function(objTag)
			if lQuery(objTag):attr("tagValue") ~= "" then
				local tag = lQuery.create("Tag", {
					value = lQuery(objTag):attr("tagValue")
					,key = lQuery(objTag):attr("tagKey")
				}):link("choiceItem", ci)
				
				if lQuery(objTag):attr("tagKey") == "owl_Field_axiom" then
						createImportSemanticsChoiceItem(field, ci, objTag)
					end
				
				if lQuery(objTag):attr("tagKey") == "owl_Axiom_Annotation" then
					--atrast vecak elementu
					local parent = ci:find("/compartType/parentCompartType")
					if parent:is_empty() then parent = ci:find("/compartType/elemType") end
					--atrast celu no gramatikas
					parent = findAxiomAnnotationPath(objTag, parent)

					if parent:find("/translet[extensionPoint='OWLGrEd_GetAxiomAnnotation'][procedureName = 'OWLGrEd_UserFields.axiom.getAxiomAnnotation']"):is_empty() then
						lQuery.create("Translet", {extensionPoint = 'OWLGrEd_GetAxiomAnnotation', procedureName = 'OWLGrEd_UserFields.axiom.getAxiomAnnotation'})
						:link("type", parent)
					end
					tag:link("axiomAnnotationType", parent)
				end
			end
		end)
	
		--izveidot ElementStyleSetting
		--novilkt saiti uz ElemType un ChoiceItem
		local elemStyle = lQuery(obj):find("/styleSetting[isElementStyleSetting = true]"):each(function(objS)
			local val = lQuery(objS):find("/elemStyleFeature"):attr("itemName")
			local style = lQuery(objS):find("/elemStyleFeature"):attr("itemName")
			if inv == 1 then
				local value = style
				if string.find(value, "start") ~= nil then
					local startStyle = string.sub(value, 6)
					value = "end" .. startStyle
					style = value
				elseif string.find(value, "end") ~= nil then
					local startStyle = string.sub(value, 4)
					value = "start" .. startStyle		
					style = value
				end
			end
			local elStSet = lQuery.create("ElementStyleSetting", {
				setting = style
				,value = lQuery(objS):attr("value")
				,procSetValue = lQuery(objS):attr("procSetValue")
				,procCondition = "setElemStyleByChoiceItem"
				,strength = 5
			}):link("elemType", elemType)
				:link("choiceItem", ci)
			-- if style == "widthProc" then 
				-- elStSet:attr("procSetValue", "setAutoWidth") 
				-- elStSet:attr("setting", "width") 
			-- end
			local ct = lQuery(ci):find("/compartType")
			--ja vel nav targeta, tad to izveidojam
			if lQuery(ct):find("/translet[procedureName = 'OWLGrEd_UserFields.owl_fields_specific.setDependentStyle']"):is_empty() then
				lQuery.create("Translet", {extensionPoint = 'procFieldEntered', procedureName = 'OWLGrEd_UserFields.owl_fields_specific.setDependentStyle'})
				:link("type", ct)
			end
			if lQuery(elemType):find("/translet[procedureName = 'OWLGrEd_UserFields.owl_fields_specific.setDefaultStyle']"):is_empty() then
				lQuery.create("Translet", {extensionPoint = 'procNewElement', procedureName = 'OWLGrEd_UserFields.owl_fields_specific.setDefaultStyle'})
				:link("type", elemType)
			end
			if lQuery(elemType):find("/translet[procedureName = 'OWLGrEd_UserFields.owl_fields_specific.styleCode']"):is_empty() then
				lQuery.create("Translet", {extensionPoint = 'procCopied', procedureName = 'OWLGrEd_UserFields.owl_fields_specific.styleCode'})
				:link("type", elemType)
			end
		end)
		local fieldStyle = lQuery(obj):find("/styleSetting[isElementStyleSetting != true]"):each(function(objS)
			local comType = getTarget(obj, lQuery(objS):attr("target"), objS, inv)
			local elStSet = lQuery.create("CompartmentStyleSetting", {
				setting = lQuery(objS):find("/fieldStyleFeature"):attr("itemName")
				,value = lQuery(objS):attr("value")
				,procCondition = "setCompartStyleByChoiceItem"
				,procSetValue = lQuery(objS):attr("procSetValue")
				,strength = 5
			})
			:link("compartType", comType)
			:link("choiceItem", ci)
			local elemType = comType
			local l = 0
			while l ~=1 do
				local temp = elemType:find("/subCompartType")
				if temp:is_empty() then temp = elemType:find("/elemType") l = 1 end
				elemType = temp
			end
			if lQuery(elemType):find("/translet[procedureName = 'OWLGrEd_UserFields.owl_fields_specific.setDefaultStyle']"):is_empty() then
				lQuery.create("Translet", {extensionPoint = 'procNewElement', procedureName = 'OWLGrEd_UserFields.owl_fields_specific.setDefaultStyle'})
				:link("type", elemType)
			end
			if lQuery(elemType):find("/translet[procedureName = 'OWLGrEd_UserFields.owl_fields_specific.styleCode']"):is_empty() then
				lQuery.create("Translet", {extensionPoint = 'procCopied', procedureName = 'OWLGrEd_UserFields.owl_fields_specific.styleCode'})
				:link("type", elemType)
			end
			local setting = elStSet:attr("setting")
			if string.find(setting, "prefix-")~= nil then 
				elStSet:attr("setting", "prefix")
				elStSet:attr("settingMode", string.sub(setting, 8))
				local ct = lQuery(ci):find("/compartType")
				if lQuery(ct):find("/translet[procedureName = 'OWLGrEd_UserFields.owl_fields_specific.setAllPrefixesView']"):is_empty() and lQuery(ct):find("/translet[extensionPoint = 'procGetPrefix']"):is_empty() then
					lQuery.create("Translet", {extensionPoint = 'procGetPrefix', procedureName = 'OWLGrEd_UserFields.owl_fields_specific.setAllPrefixesView'})
					:link("type", comType)
				end
				elStSet:attr("procCondition", "setTextStyle")
			elseif
				string.find(setting, "suffix-")~= nil then 
				elStSet:attr("setting", "suffix")
				elStSet:attr("settingMode", string.sub(setting, 8))
				local ct = lQuery(ci):find("/compartType")
				if lQuery(ct):find("/translet[procedureName = 'OWLGrEd_UserFields.owl_fields_specific.setAllSuffixesView']"):is_empty() then
					lQuery.create("Translet", {extensionPoint = 'procGetSuffix', procedureName = 'OWLGrEd_UserFields.owl_fields_specific.setAllSuffixesView'})
					:link("type", comType)
				end
				elStSet:attr("procCondition", "setTextStyle")
			end
			if setting == "isVisible" then 
				local ct = lQuery(ci):find("/compartType")
				
				if lQuery(comType):find("/translet[procedureName = 'OWLGrEd_UserFields.owl_fields_specific.setIsHidden']"):is_empty() then
					lQuery.create("Translet", {extensionPoint = 'procIsHidden', procedureName = 'OWLGrEd_UserFields.owl_fields_specific.setIsHidden'})
					:link("type", comType)
				end
				if comType:find("/elemType"):is_empty() and comType:find("/parentCompartType"):attr("isGroup") ~= "true" then 
				--if field:find("/context"):attr("mode")=="Group Item" or field:find("/context"):attr("mode")=="Text" then 
					elStSet:attr("procCondition", "setTextStyle")
				end
			end
				
			local ct = lQuery(ci):find("/compartType")
			--ja vel nav targeta, tad to izveidojam
			if lQuery(ct):find("/translet[procedureName = 'OWLGrEd_UserFields.owl_fields_specific.setDependentStyle']"):is_empty() then
				lQuery.create("Translet", {extensionPoint = 'procFieldEntered', procedureName = 'OWLGrEd_UserFields.owl_fields_specific.setDependentStyle'})
				:link("type", ct)
			end
		end)
	end)
end

function createImportSemanticsChoiceItem(field, ci, obj)
	local contextType = field:find("/context")
	local forVariable
	if contextType:attr("type")=="Class" then forVariable = "owlFields:ForClass_ShowAnnotation_InField"
	elseif contextType:attr("type")=="Object" then forVariable = "owlFields:ForIndiv_ShowAnnotation_InField"
	elseif contextType:attr("type")=="Attributes" then forVariable = "owlFields:ForAttr_ShowAnnotation_InField"
	else forVariable = "owlFields:ForRole_ShowAnnotation_InField" end
			
	local open = string.find(lQuery(obj):attr("tagValue"), "%(")
	local close = string.find(lQuery(obj):attr("tagValue"), ")")
	local space = string.find(lQuery(obj):attr("tagValue"), " ")
	local fieldName = string.sub(lQuery(obj):attr("tagValue"), open+1, space-1)
	local axiomType = string.sub(lQuery(obj):attr("tagValue"), 1, open-1)
	local path = field:attr("name")
	
	local subject = string.find(lQuery(obj):attr("tagValue"), "$subject ")
	local value = string.sub(lQuery(obj):attr("tagValue"), subject+9, close-1)

	local axiom = axiomType .. "(\nAnnotation(owlFields:ShowAnnotation_RequireValue " .. value .. ")\nAnnotation(owlFields:ShowAnnotation_CreateValue " .. value .. ")\n" .. forVariable .. "\n" .. fieldName .. '\n"' .. path .. '")'

	lQuery.create("Tag", {
		value = axiom
		,key = "owl_Fields_ImportSpec"
	}):link("choiceItem", ci)
end

function createImportSemanticsField(field ,compartType, obj)
	-- print("fffffff", field:attr("name"))
	local contextType = field:find("/context")
				local forVariable
				if contextType:attr("type")=="Class" then forVariable = "owlFields:ForClass_ShowAnnotation_InField"
				elseif contextType:attr("type")=="Object" then forVariable = "owlFields:ForIndiv_ShowAnnotation_InField"
				elseif contextType:attr("type")=="Attributes" then forVariable = "owlFields:ForAttr_ShowAnnotation_InField"
				else forVariable = "owlFields:ForRole_ShowAnnotation_InField" end
				
				local open = string.find(lQuery(obj):attr("tagValue"), "%(")
				local space = string.find(lQuery(obj):attr("tagValue"), " ")
				local fieldName = string.sub(lQuery(obj):attr("tagValue"), open+1, space-1)
				local axiomType = string.sub(lQuery(obj):attr("tagValue"), 1, open-1)
				local path = ''
				local comType
				if contextType:attr("elTypeName") == "" then
					comType = lQuery("ElemType[id='" .. contextType:attr("type") .. "']")
					comType = comType:find("/compartType[caption='" .. field:attr("name") .. "']")
					path=path .. comType:attr("id")
				else
					comType = findCompartType(field)
					comType = comType:find("/subCompartType[caption='" .. field:attr("name") .. "']")	
					path=path .. comType:attr("id")
				end
				comType = comType:find("/subCompartType[caption='" .. field:attr("name") .. "']")
				while comType:is_not_empty() do
					path=path.. "/" .. comType:attr("id")
					comType = comType:find("/subCompartType[caption='" .. field:attr("name") .. "']")
				end
				local axiom = axiomType .. "(\n" .. forVariable .. "\n" .. fieldName .. '\n"' .. path .. '")'

				lQuery.create("Tag", {
					value = axiom
					,key = "owl_Fields_ImportSpec"
				}):link("type", compartType)
end

--izveido tagu (field-lauks,compartType-kompartmenta tips)
function createTag(field ,compartType)
	local tag = lQuery(field):find("/tag"):each(function(obj)
		if lQuery(obj):attr("tagValue") ~= "" then
			local tag = lQuery.create("Tag", {
				value = lQuery(obj):attr("tagValue")
				,key = lQuery(obj):attr("tagKey")
			}):link("type", compartType)
			if lQuery(obj):attr("tagKey") == "owl_Field_axiom" then
				createImportSemanticsField(field ,compartType, obj)
			end
			if lQuery(obj):attr("tagKey") == "owl_Axiom_Annotation" then
				--atrast vecak elementu
				local parent = compartType:find("/parentCompartType")
				if parent:is_empty() then parent = compartType:find("/elemType") end
				parent = findAxiomAnnotationPath(obj, parent)

				if parent:find("/translet[extensionPoint='OWLGrEd_GetAxiomAnnotation'][procedureName = 'OWLGrEd_UserFields.axiom.getAxiomAnnotation']"):is_empty() then
					lQuery.create("Translet", {extensionPoint = 'OWLGrEd_GetAxiomAnnotation', procedureName = 'OWLGrEd_UserFields.axiom.getAxiomAnnotation'})
					:link("type", parent)
				end
				tag:link("axiomAnnotationType", parent)
			end
		end
	end)
end

--izveido transletu (field-lauks,compartType-kompartmenta tips)
function createTranslet(field, compartType)
	local translet = lQuery(field):find("/translet"):each(function(obj)
			lQuery.create("Translet", {
				procedureName = lQuery(obj):attr("procedure")
				,extensionPoint = lQuery(obj):find("/task"):attr("taskName")
			}):link("type", compartType)
		end)
end

--izveido apakslauka stilu
function createFieldCompartTypeStyle(fieldTypes, compartType, compartTypeASFictitious, field)
	--atlasit no field "isVisible" stilus
	local  isVisibleStyle = field:find("/selfStyleSetting:has(/fieldStyleFeature[itemName='isVisible'])"):each(function(obj)
		if obj:attr("value")=="0" then
			if lQuery(compartType):find("/translet[procedureName = 'OWLGrEd_UserFields.owl_fields_specific.setIsHidden']"):is_empty() then
				lQuery.create("Translet", {extensionPoint = 'procIsHidden', procedureName = 'OWLGrEd_UserFields.owl_fields_specific.setIsHiddenYes'})
				:link("type", compartType)
			else
				lQuery(compartType):find("/translet[procedureName = 'OWLGrEd_UserFields.owl_fields_specific.setIsHidden']"):attr("procedureName", "OWLGrEd_UserFields.owl_fields_specific.setIsHiddenNo")
			end
		else
			if lQuery(compartType):find("/translet[procedureName = 'OWLGrEd_UserFields.owl_fields_specific.setIsHidden']"):is_empty() then
				lQuery.create("Translet", {extensionPoint = 'procIsHidden', procedureName = 'OWLGrEd_UserFields.owl_fields_specific.setIsHiddenNo'})
				:link("type", compartType)
			else
				lQuery(compartType):find("/translet[procedureName = 'OWLGrEd_UserFields.owl_fields_specific.setIsHidden']"):attr("procedureName", "OWLGrEd_UserFields.owl_fields_specific.setIsHiddenYes")
			end
		end
	end)
	
	local css = compartType:find("/compartmentStyleSetting"):filter(function(obj)
		return lQuery(obj):find("/choiceItem"):is_empty()
	end)
	css:delete()
	lQuery(compartType):find("/translet[procedureName = 'OWLGrEd_UserFields.owl_fields_specific.setPrefixField']"):delete()
	
	local  prefix = field:find("/selfStyleSetting:has(/fieldStyleFeature[itemName^='prefix-'])")
	prefix:each(function(obj)
		if lQuery(compartType):find("/translet[procedureName = 'OWLGrEd_UserFields.owl_fields_specific.setPrefixField']"):is_empty()  and lQuery(compartType):find("/translet[extensionPoint = 'procGetPrefix']"):is_empty() then
			lQuery.create("Translet", {extensionPoint = 'procGetPrefix', procedureName = 'OWLGrEd_UserFields.owl_fields_specific.setPrefixField'})
			:link("type", compartType)
		end
		
		lQuery.create("CompartmentStyleSetting", {
			setting = string.sub(lQuery(obj):find("/fieldStyleFeature"):attr("itemName"), 1, 6)
			,value = lQuery(obj):attr("value")
			,procCondition = "setTextStyle"
			,procSetValue = lQuery(obj):attr("procSetValue")
			,strength = 5
			,settingMode = string.sub(lQuery(obj):find("/fieldStyleFeature"):attr("itemName"), 8)
		})
		:link("compartType", compartType)
		local elemType = compartType
		local l = 0
		while l ~=1 do
			local temp = elemType:find("/subCompartType")
			if temp:is_empty() then temp = elemType:find("/elemType") l = 1 end
			elemType = temp
		end
		if lQuery(elemType):find("/translet[procedureName = 'OWLGrEd_UserFields.owl_fields_specific.setDefaultStyle']"):is_empty() then
			lQuery.create("Translet", {extensionPoint = 'procNewElement', procedureName = 'OWLGrEd_UserFields.owl_fields_specific.setDefaultStyle'})
			:link("type", elemType)
		end
		if lQuery(elemType):find("/translet[procedureName = 'OWLGrEd_UserFields.owl_fields_specific.styleCode']"):is_empty() then
			lQuery.create("Translet", {extensionPoint = 'procCopied', procedureName = 'OWLGrEd_UserFields.owl_fields_specific.styleCode'})
			:link("type", elemType)
		end
	end)
	
	local  suffix = field:find("/selfStyleSetting:has(/fieldStyleFeature[itemName^='suffix-'])")
	suffix:each(function(obj)
		if lQuery(compartType):find("/translet[procedureName = 'OWLGrEd_UserFields.owl_fields_specific.setSuffixField']"):is_empty() then
			lQuery.create("Translet", {extensionPoint = 'procGetSuffix', procedureName = 'OWLGrEd_UserFields.owl_fields_specific.setSuffixField'})
			:link("type", compartType)
		end
		lQuery.create("CompartmentStyleSetting", {
			setting = string.sub(lQuery(obj):find("/fieldStyleFeature"):attr("itemName"), 1, 6)
			,value = lQuery(obj):attr("value")
			,procCondition = "setTextStyle"
			,procSetValue = lQuery(obj):attr("procSetValue")
			,strength = 5
			,settingMode = string.sub(lQuery(obj):find("/fieldStyleFeature"):attr("itemName"), 8)
		})
		:link("compartType", compartType)
		local elemType = compartType
		local l = 0
		while l ~=1 do
			local temp = elemType:find("/subCompartType")
			if temp:is_empty() then temp = elemType:find("/elemType") l = 1 end
			elemType = temp
		end
		if lQuery(elemType):find("/translet[procedureName = 'OWLGrEd_UserFields.owl_fields_specific.setDefaultStyle']"):is_empty() then
			lQuery.create("Translet", {extensionPoint = 'procNewElement', procedureName = 'OWLGrEd_UserFields.owl_fields_specific.setDefaultStyle'})
			:link("type", elemType)
		end
		if lQuery(elemType):find("/translet[procedureName = 'OWLGrEd_UserFields.owl_fields_specific.styleCode']"):is_empty() then
			lQuery.create("Translet", {extensionPoint = 'procCopied', procedureName = 'OWLGrEd_UserFields.owl_fields_specific.styleCode'})
			:link("type", elemType)
		end
	end)
end

--izveido lauka stilu
function createFieldStyle(fieldTypes, compartType, compartTypeASFictitious, field, inv)
	local compartStyle = lQuery.create("CompartStyle",{
		alignment = 0,adjustment = 0,lineWidth = 1,lineColor = 0,fontTypeFace = "Arial",fontCharSet = 1,fontColor = 0,fontSize = 9,fontPitch = 0,fontStyle = 0,id = lQuery(field):attr("name"),caption = lQuery(field):attr("name"),isVisible = 1,nr = 0,picWidth = 0,picHeight = 0,picPos = 1,picStyle = 0,adornment = 0
	})
			
	if fieldTypes ~= "TextArea+Button" then
		compartType:find("/compartStyle"):delete()
		compartStyle:link("compartType", compartType)
	else  
		compartTypeASFictitious:find("/compartStyle"):delete()
		compartStyle:link("compartType", compartTypeASFictitious)
	end
	
	local fieldStyle = lQuery(field):find("/selfStyleSetting"):each(function(obcFS)
		local style = obcFS:attr("value")
		local fieldStyleFeature = obcFS:find("/fieldStyleFeature"):attr("itemName")
		local a
		if inv == 1 then	
			local val = style
			local t = styleMechanism.valuesTable()
			a = t[fieldStyleFeature]
			if fieldStyleFeature == "adjustment" then
				local t = styleMechanism.valuesTable()
				a = t[fieldStyleFeature .. "Line"]
				for i,v in pairs(a) do 
					if tonumber(v) == tonumber(val) then val = i end
				end	
			end
			if string.find(val, "Start") ~= nil then
				local startStyle = string.sub(val, 6)
				val = "End" .. startStyle
				style = a[val]
			elseif string.find(val, "End") ~= nil then
				local startStyle = string.sub(val, 4)
				val = "Start" .. startStyle
				style = a[val]
			end
		end	
		if fieldStyleFeature == "fontStyleBold" then
			local num = tostring(styleMechanism.toBin(tonumber(lQuery(compartStyle):attr("fontStyle"))))
			local len = string.len(num)
			val = lQuery(compartStyle):attr("fontStyle")
			if string.sub(num, len, len) ~= "1" and style == "1" then 
			val = val + 1
			elseif string.sub(num, len, len) == "1" and style == "0" then
			val = val - 1
			end
			lQuery(compartStyle):attr("fontStyle", val)
		elseif fieldStyleFeature == "fontStyleItalic" then
			local num = tostring(styleMechanism.toBin(tonumber(lQuery(compartStyle):attr("fontStyle"))))
			local len = string.len(num)
			val = lQuery(compartStyle):attr("fontStyle")
			if string.sub(num, len-1, len-1) ~= "1" and style == "1" then 
			val = val + 2 
			elseif string.sub(num, len-1, len-1) == "1" and style == "0" then
			val = val - 2
			end
			lQuery(compartStyle):attr("fontStyle", val)
		elseif fieldStyleFeature == "fontStyleUnderline" then
			local num = tostring(styleMechanism.toBin(tonumber(lQuery(compartStyle):attr("fontStyle"))))
			local len = string.len(num)
			val = lQuery(compartStyle):attr("fontStyle")
			if string.sub(num, len-2, len-2) ~= "1" and style == "1" then 
			val = val + 4
			elseif string.sub(num, len-2, len-2) == "1" and style == "0" then
			val = val - 4
			end
			lQuery(compartStyle):attr("fontStyle", val)
		elseif fieldStyleFeature == "fontStyleStrikeout" then
			local num = tostring(styleMechanism.toBin(tonumber(lQuery(compartStyle):attr("fontStyle"))))
			local len = string.len(num)
			val = lQuery(compartStyle):attr("fontStyle")
			if string.sub(num, len-3, len-3) ~= "1" and style == "1" then 
			val = val + 8 
			elseif string.sub(num, len-3, len-3) == "1" and style == "0" then
			val = val - 8
			end
			lQuery(compartStyle):attr("fontStyle", val)			
		elseif string.find(fieldStyleFeature, "prefix-") == nil and string.find(fieldStyleFeature, "suffix-") == nil then
			lQuery(compartStyle):attr(fieldStyleFeature, style)
		end
	end)
			
	local  prefix = field:find("/selfStyleSetting:has(/fieldStyleFeature[itemName^='prefix-'])")
	prefix:each(function(obj)
		if lQuery(compartType):find("/translet[procedureName = 'OWLGrEd_UserFields.owl_fields_specific.setPrefixField']"):is_empty() and lQuery(compartType):find("/translet[extensionPoint = 'procGetPrefix']"):is_empty() then
			lQuery.create("Translet", {extensionPoint = 'procGetPrefix', procedureName = 'OWLGrEd_UserFields.owl_fields_specific.setPrefixField'})
			:link("type", compartType)
		end
		
		lQuery.create("CompartmentStyleSetting", {
			setting = string.sub(lQuery(obj):find("/fieldStyleFeature"):attr("itemName"), 1, 6)
			,value = lQuery(obj):attr("value")
			,procCondition = "setTextStyle"
			,procSetValue = lQuery(obj):attr("procSetValue")
			,strength = 5
			,settingMode = string.sub(lQuery(obj):find("/fieldStyleFeature"):attr("itemName"), 8)
		})
		:link("compartType", compartType)
		local elemType = compartType
		local l = 0
		while l ~=1 do
			local temp = elemType:find("/subCompartType")
			if temp:is_empty() then temp = elemType:find("/elemType") l = 1 end
			elemType = temp
		end
		if lQuery(elemType):find("/translet[procedureName = 'OWLGrEd_UserFields.owl_fields_specific.setDefaultStyle']"):is_empty() then
			lQuery.create("Translet", {extensionPoint = 'procNewElement', procedureName = 'OWLGrEd_UserFields.owl_fields_specific.setDefaultStyle'})
			:link("type", elemType)
		end
		if lQuery(elemType):find("/translet[procedureName = 'OWLGrEd_UserFields.owl_fields_specific.styleCode']"):is_empty() then
			lQuery.create("Translet", {extensionPoint = 'procCopied', procedureName = 'OWLGrEd_UserFields.owl_fields_specific.styleCode'})
			:link("type", elemType)
		end
	end)
	
	local  suffix = field:find("/selfStyleSetting:has(/fieldStyleFeature[itemName^='suffix-'])")
	suffix:each(function(obj)
		if lQuery(compartType):find("/translet[procedureName = 'OWLGrEd_UserFields.owl_fields_specific.setSuffixField']"):is_empty() then
			lQuery.create("Translet", {extensionPoint = 'procGetSuffix', procedureName = 'OWLGrEd_UserFields.owl_fields_specific.setSuffixField'})
			:link("type", compartType)
		end
		lQuery.create("CompartmentStyleSetting", {
			setting = string.sub(lQuery(obj):find("/fieldStyleFeature"):attr("itemName"), 1, 6)
			,value = lQuery(obj):attr("value")
			,procCondition = "setTextStyle"
			,procSetValue = lQuery(obj):attr("procSetValue")
			,strength = 5
			,settingMode = string.sub(lQuery(obj):find("/fieldStyleFeature"):attr("itemName"), 8)
		})
		:link("compartType", compartType)
		local elemType = compartType
		local l = 0
		while l ~=1 do
			local temp = elemType:find("/subCompartType")
			if temp:is_empty() then temp = elemType:find("/elemType") l = 1 end
			elemType = temp
		end
		if lQuery(elemType):find("/translet[procedureName = 'OWLGrEd_UserFields.owl_fields_specific.setDefaultStyle']"):is_empty() then
			lQuery.create("Translet", {extensionPoint = 'procNewElement', procedureName = 'OWLGrEd_UserFields.owl_fields_specific.setDefaultStyle'})
			:link("type", elemType)
		end
		if lQuery(elemType):find("/translet[procedureName = 'OWLGrEd_UserFields.owl_fields_specific.styleCode']"):is_empty() then
			lQuery.create("Translet", {extensionPoint = 'procCopied', procedureName = 'OWLGrEd_UserFields.owl_fields_specific.styleCode'})
			:link("type", elemType)
		end
	end)
end

--pieliek luku pie vecaka compartmenta tipa
function insertCompartTypeToCompart(parentCompType, compType, newParentCompartType)
	--atlasit visas piesaistitas compartType instances, ierakstit tas tabulaa
	local l = 0
	local t = {}
	lQuery(parentCompType):find("/subCompartType"):each(function(obj)
		if obj:attr("caption") == lQuery(compType):attr("id") then
			table.insert(t, newParentCompartType)
			l = 1
		end
		table.insert(t, obj)
		obj:remove_link("parentCompartType", parentCompType)
	end)
	for i,v in pairs(t) do
		v:link("parentCompartType", parentCompType)
	end
	if l == 0 then 
		newParentCompartType:link("parentCompartType", parentCompType)  --ja ir uzrakstits neeksistejoss lauks pirms kura ir japievieno
	end
end

--pieliek luku pie vecaka elementa tipa
function insertCompartTypeToElement(elemType, compType, newParentCompartType)
	--atlasit visas piesaistitas compartType instances, ierakstit tas tabulaa
	local l = 0
	local t = {}
	lQuery(elemType):find("/compartType"):each(function(obj)
		if obj:attr("caption") == lQuery(compType):attr("caption") then
			table.insert(t, newParentCompartType)
			l = 1
		end
		table.insert(t, obj)
		obj:remove_link("elemType", elemType)
	end)
	for i,v in pairs(t) do
		v:link("elemType", elemType)
	end
	if l == 0 then 
		newParentCompartType:link("elemType", elemType)  --ja ir uzrakstits neeksistejoss lauks pirms kura ir japievieno
	end
end

--pielaista lauku ipasibu diagrammai
function insertCompartTypeToDiagram(propertyRowOld, propertyRowNew, oldDia)
	--atlasit visas piesaistitas compartType instances, ierakstit tas tabulaa
	local l = 0
	local t = {}
	lQuery(oldDia):find("/propertyRow"):each(function(obj)
		if obj:attr("id") == lQuery(propertyRowOld):attr("id") then
			table.insert(t, propertyRowNew)
			l = 1
		end
		table.insert(t, obj)
		obj:remove_link("propertyDiagram", oldDia)
	end)
	for i,v in pairs(t) do
		v:link("propertyDiagram", oldDia)
	end
	if l == 0 then 
		propertyRowNew:link("propertyDiagram", oldDia)  --ja ir uzrakstits neeksistejoss lauks pirms kura ir japievieno
	end
end

--piesaista lauku cilnei
function insertCompartTypeToTab(propertyRowOld, propertyRowNew, tab)
	--atlasit visas piesaistitas compartType instances, ierakstit tas tabulaa
	local l = 0
	local t = {}
	lQuery(tab):find("/propertyRow"):each(function(obj)
		if obj:attr("id") == lQuery(propertyRowOld):attr("id") then
			table.insert(t, propertyRowNew)
			l = 1
		end
		table.insert(t, obj)
		obj:remove_link("propertyTab", tab)
	end)
	for i,v in pairs(t) do
		v:link("propertyTab", tab)
	end
	if l == 0 then 
		propertyRowNew:link("propertyTab", tab)  --ja ir uzrakstits neeksistejoss lauks pirms kura ir japievieno
	end
end

--vaido laukus(field-lauks, extension-profils kauram japiesaista lauks)
function fields(field, extension)
	local contextType = lQuery(field):find("/context"):attr("type")
	local mode = lQuery(field):find("/context"):attr("mode")
	local elTypeName = lQuery(field):find("/context"):attr("elTypeName")
	local hasMirror = lQuery(field):find("/context"):attr("hasMirror")
	local dia

	if mode == "Element" then
		if field:attr("isExistingField")=="true" then 
			--atrast compartType
			local elemType = lQuery("ElemType[id = '" .. contextType .. "']")
			local compartType = elemType:find("/compartType[id = '" .. field:attr("name") .. "']")
			lQuery(extension):link("type", compartType)--piesaistam pie extension
			--izveido tag
			createTag(field ,compartType)
		else
			--atrodam elenemta tipu
			local elemType = lQuery("ElemType[id = '" .. contextType .. "']")
			local compartType
			local compartTypeASFictitious
			
			local fieldTypes = lQuery(field):attr("fieldType")--RowType
			if fieldTypes ~= "TextArea+Button" then
				compartType = createCompartType(field)--azveidojam compartType(field)
				lQuery(extension):link("type", compartType)--piesaistam pie extension
			else
				compartType = createCompartTypeTextAreaButton(field)
				compartTypeASFictitious = createASFictious(field)
				lQuery(compartTypeASFictitious):link("subCompartType", compartType)
				lQuery(extension):link("type", compartTypeASFictitious)
				--izveidot diagrammu ar tadu pasu nosaukumu, ka laukam
				dia = lQuery.create("PropertyDiagram", {id = lQuery(field):attr("name"), width = 250}):link("compartType", compartTypeASFictitious) 
			end
			
			if fieldTypes == "InputField+Button" then 
				dia = lQuery.create("PropertyDiagram", {id = lQuery(field):attr("name"), width = 250}):link("compartType", compartType) 
			end
			--piesaistit elementType compartType
			createDisplayPlaceBeforeElem(field, elemType, fieldTypes, compartType, compartTypeASFictitious, elemType)
			
			--izveidot rowType(propertyRow)
			local propertyRow = lQuery.create("PropertyRow", {
				id = lQuery(field):attr("name")
				,caption = lQuery(field):attr("name")
				,rowType = lQuery(field):attr("fieldType")
				,isEditable = true
				,isReadOnly = false
				,isFirstRespondent = false
			})
			if fieldTypes == "InputField+Button" or fieldTypes == "TextArea+Button" then 
				--saita starp diagramu un propertyRow
				dia:link("calledPropertyRow", propertyRow)
			end
			--piesaistit propertyRow compartType
			if fieldTypes ~= "TextArea+Button" then
				propertyRow:link("compartType", compartType)
			else propertyRow:link("compartType", compartTypeASFictitious) end
			
			--piesaistit PropertyTab
			local propertyEditorTab = lQuery(field):attr("propertyEditorTab")
			createPropertyEditorTab(field, contextType, propertyRow, propertyEditorTab, compType, elemType)
			
			--izveidot choiceItem
			createChoiceItem(field, compartType, contextType, elemType)

			--izveido translet
			createTranslet(field, compartType)
			
			--izveido stilu
			createFieldStyle(fieldTypes, compartType, compartTypeASFictitious, field)
			
			local subCompartType = lQuery(field):find("/subField"):each(function(obj)
				subFields(compartType, obj, dia)
			end)
			
			--izveido tag
			createTag(field ,compartType)
		end
	elseif mode == "Group" then
		elemType = lQuery("ElemType[id='" .. elTypeName .. "']")
		local compartType
		local compartTypeASFictitious
		local compartTypeInv
		local compartTypeASFictitiousInv
		local diaInv
		local compTypeInv
		
		local compType = lQuery("CompartType[id='" .. contextType .. "']:has(/elemType[id='" .. elTypeName .."'])")
		local fieldTypes = lQuery(field):attr("fieldType")
		
		
		if field:attr("isExistingField")=="true" then 
			--atrast compartType
			local compartType = compType:find("/subCompartType[id = '" .. field:attr("name") .. "']")
			lQuery(extension):link("type", compartType)--piesaistam pie extension
			--izveido tag
			createTag(field ,compartType)
		else
			if lQuery(field):find("/context"):attr("type") == "Role" and fieldTypes == "TextArea+Button" then
				local ct = lQuery.create("CompartType", {
					caption = lQuery(field):attr("name"),id = lQuery(field):attr("name"),isEssential = true,pattern = lQuery(field):attr("pattern"),nr = 0,isStereotypable = false,isStereotype = false,isMultiple = false,isHint = false,toBeInvisible = false,is_occurrence_compartment = false,isDiagramName = false,isGroup = false,--adornmentSuffix = "}",adornmentPrefix = "{"
				}):link("parentCompartType", compType)
					:link("compartStyle",lQuery.create("CompartStyle",{
					alignment = 0,adjustment = 0,lineWidth = 1,lineColor = 0,fontTypeFace = "Arial",fontCharSet = 1,fontColor = 0,fontSize = 9,fontPitch = 0,fontStyle = 0,id = lQuery(field):attr("name"),caption = lQuery(field):attr("name"),isVisible = 1,nr = 0,picWidth = 0,picHeight = 0,picPos = 1,picStyle = 0,adornment = 0
				}))
				compType= ct
			end
			
			if fieldTypes ~= "TextArea+Button" then
				compartType = createCompartType(field)
				lQuery(extension):link("type", compartType)
			else
				compartType = createCompartTypeTextAreaButton(field)
				compartTypeASFictitious = createASFictious(field)
				lQuery(compartTypeASFictitious):link("subCompartType", compartType)
				lQuery(extension):link("type", compartTypeASFictitious)
				dia = lQuery.create("PropertyDiagram", {id = lQuery(field):attr("name"), width = 250}):link("compartType", compartTypeASFictitious) 
			end
			
			if fieldTypes == "InputField+Button" then 
				dia = lQuery.create("PropertyDiagram", {id = lQuery(field):attr("name"), width = 250}):link("compartType", compartType) 
			end
			
			--piesaistit compartType subCompartType
			createDisplayPlaceBeforeComp(field, compType, fieldTypes, compartType, compartTypeASFictitious)
			
			--local rowType = lQuery(field):find("/fieldType")
			local propertyRow = lQuery.create("PropertyRow", {
				id = lQuery(field):attr("name")
				,caption = lQuery(field):attr("name")
				,rowType = lQuery(field):attr("fieldType")
				,isEditable = true
				,isReadOnly = false
				,isFirstRespondent = false
			})
			
			if fieldTypes == "InputField+Button" or fieldTypes == "TextArea+Button" then 
				--saita starp diagramu un propertyRow
				dia:link("calledPropertyRow", propertyRow)
			end
			
			if fieldTypes ~= "TextArea+Button" then
				propertyRow:link("compartType", compartType)
			else propertyRow:link("compartType", compartTypeASFictitious) end
			
			--piesaistit PropertyTab
			local propertyEditorTab = lQuery(field):attr("propertyEditorTab")
			createPropertyEditorTab(field, elTypeName, propertyRow, propertyEditorTab, compType)
			
			--izveidot choiceItem
			createChoiceItem(field, compartType, contextType, elemType, elTypeName)
			
			--izveido translet
			createTranslet(field, compartType)
			
			--izveido stilu
			createFieldStyle(fieldTypes, compartType, compType, field)
			
			local subCompartType = lQuery(field):find("/subField"):each(function(obj)
				subFields(compartType, obj, dia)
			end)
			
			--izveido tag
			createTag(field ,compartType)
		end	
		if hasMirror == "1" then 
			compTypeInv = lQuery("CompartType[id='" .. contextType .. "']:has(/elemType[id='" .. elTypeName .."'])"):find("/aa#mirror")
			if compTypeInv:is_empty() then compTypeInv = compType:find("/aa#mirrorInv") end
			local fieldTypes = lQuery(field):attr("fieldType")
			
			if field:attr("isExistingField")=="true" then 
				--atrast compartType
				local compartType = compTypeInv:find("/subCompartType[id = '" .. field:attr("name") .. "']")
				lQuery(extension):link("type", compartType)--piesaistam pie extension
				--izveido tag
				createTag(field ,compartType)
			else
				if lQuery(field):find("/context"):attr("type") == "Role" and fieldTypes == "TextArea+Button" then
					local ct = lQuery.create("CompartType", {
						caption = lQuery(field):attr("name"),id = lQuery(field):attr("name"),isEssential = true,pattern = lQuery(field):attr("pattern"),nr = 0,isStereotypable = false,isStereotype = false,isMultiple = false,isHint = false,toBeInvisible = false,is_occurrence_compartment = false,isDiagramName = false,isGroup = false--,adornmentSuffix = "}",adornmentPrefix = "{"
					}):link("parentCompartType", compTypeInv)
						:link("compartStyle",lQuery.create("CompartStyle",{
						alignment = 0,adjustment = 0,lineWidth = 1,lineColor = 0,fontTypeFace = "Arial",fontCharSet = 1,fontColor = 0,fontSize = 9,fontPitch = 0,fontStyle = 0,id = lQuery(field):attr("name"),caption = lQuery(field):attr("name"),isVisible = 1,nr = 0,picWidth = 0,picHeight = 0,picPos = 1,picStyle = 0,adornment = 0
					}))
					compTypeInv= ct
				end
				
				if fieldTypes ~= "TextArea+Button" then
					compartTypeInv = createCompartType(field)
					lQuery(extension):link("type", compartTypeInv)
					lQuery(compartTypeInv):link("aa#mirror", compartType)
				else
					compartTypeInv = createCompartTypeTextAreaButton(field)
					compartTypeASFictitiousInv = createASFictious(field)
					lQuery(compartTypeASFictitiousInv):link("subCompartType", compartTypeInv)
					lQuery(compartTypeASFictitiousInv):link("aa#mirror", compartTypeASFictitious)
					lQuery(extension):link("type", compartTypeASFictitiousInv)
					diaInv = lQuery.create("PropertyDiagram", {id = lQuery(field):attr("name"), width = 250}):link("compartType", compartTypeASFictitiousInv) 
				end

				if fieldTypes == "InputField+Button" then 
					diaInv = lQuery.create("PropertyDiagram", {id = lQuery(field):attr("name"), width = 250}):link("compartType", compartTypeInv) 
				end
				
				--piesaistit compartType subCompartType
				createDisplayPlaceBeforeComp(field, compTypeInv, fieldTypes, compartTypeInv, compartTypeASFictitiousInv)
				
				--piesaistit propertyRow
				local propertyRowInv = lQuery.create("PropertyRow", {
					id = lQuery(field):attr("name")
					,caption = lQuery(field):attr("name")
					,rowType = lQuery(field):attr("fieldType")
					,isEditable = true
					,isReadOnly = false
					,isFirstRespondent = false
				})
				
				if fieldTypes == "InputField+Button" or fieldTypes == "TextArea+Button" then 
					--saita starp diagramu un propertyRow
					diaInv:link("calledPropertyRow", propertyRowInv)
				end
				
				if fieldTypes ~= "TextArea+Button" then
					propertyRowInv:link("compartType", compartTypeInv)
				else propertyRowInv:link("compartType", compartTypeASFictitiousInv) end
				
				--piesaistit PropertyTab
				local propertyEditorTab = lQuery(field):attr("propertyEditorTab")
				local propertyTab = lQuery("PropertyDiagram[id = '" .. elTypeName .. "']/propertyTab[caption != '" .. propertyEditorTab .. "']")
				propertyEditorTab = propertyTab:attr("caption")
				createPropertyEditorTab(field, elTypeName, propertyRowInv, propertyEditorTab, compTypeInv)	
				
				--izveidot choiceItem
				createChoiceItem(field, compartTypeInv, compTypeInv:attr("id"), elemType, elTypeName, 1)
						
				--izveido translet
				createTranslet(field, compartTypeInv)
				
				--izveido stilu
				createFieldStyle(fieldTypes, compartTypeInv, compTypeInv, field, 1)
				
				local subCompartType = lQuery(field):find("/subField"):each(function(obj)
					subFields(compartTypeInv, obj, diaInv)
				end)
				
				--izveido tag
				createTag(field ,compartTypeInv)
			end
		end
	elseif mode == "Group Item" or mode == "Text" then
		local parentCompartType = findCompartType(field)
		local parent = findCompartType(field):find("/parentCompartType")
		--atrast compartType no path un elTypeName
		local compType = findCompartType(field)--parrent compartType
		
		
		if field:attr("isExistingField")=="true" then 
			--atrast compartType
			local compartType = compType:find("/subCompartType[id = '" .. field:attr("name") .. "']")
			lQuery(extension):link("type", compartType)--piesaistam pie extension
			--izveido tag
			createTag(field ,compartType)
		else
			if parentCompartType:find("/propertyRow"):attr("rowType") == "CheckBox" then
				
				local parentCompType = compType:find("/parentCompartType")--atribute
				local newParentCompartType

				if findCompartType(field):find("/propertyRow/propertyTab"):is_empty() then--ja nav taba
					if parentCompType:is_empty() then --ja ir piesaistits pie pirma limena lauka
						parentCompType = compType:find("/elemType")
						newParentCompartType = lQuery.create("CompartType", {id = "CheckBoxFictitious" .. parentCompartType:attr("id")
							,caption = "CheckBoxFictitious" .. parentCompartType:attr("caption")
							,startValue = parentCompartType:attr("startValue")
							,adornmentPrefix = parentCompartType:attr("adornmentPrefix")
							,adornmentSuffix = parentCompartType:attr("adornmentSuffix")
							,pattern = parentCompartType:attr("pattern")
							,isEssential = true
							,nr = 0
							,isStereotypable = false
							,isStereotype = false
							,isMultiple = false
							,isHint = false
							,toBeInvisible = false
							,is_occurrence_compartment = false
							,isDiagramName = false
						}):link("elemType", parentCompType)
						
						local style = compType:find("/compartStyle")
						compType:remove_link("compartStyle", style)
						style:link("compartType", newParentCompartType)
						
						lQuery.create("CompartStyle",{
								alignment = 0,adjustment = 0,lineWidth = 1,lineColor = 0,fontTypeFace = "Arial",fontCharSet = 1,fontColor = 0,fontSize = 9,fontPitch = 0
								,fontStyle = 0,id = lQuery(newParentCompartType):attr("id"),caption = lQuery(newParentCompartType):attr("caption")
								,isVisible = 1,nr = 0,picWidth = 0,picHeight = 0,picPos = 1,picStyle = 0,adornment = 0
						}):link("compartType", compType)
						compType:remove_link("elemType", parentCompType)
						
						parentCompartType:attr("adornmentPrefix", "")
						parentCompartType:attr("adornmentSuffix", "")
					else
						newParentCompartType = lQuery.create("CompartType", {id = "CheckBoxFictitious" .. parentCompartType:attr("id")
							,caption = "CheckBoxFictitious" .. parentCompartType:attr("caption")
							,startValue = parentCompartType:attr("startValue")
							,adornmentPrefix = parentCompartType:attr("adornmentPrefix")
							,adornmentSuffix = parentCompartType:attr("adornmentSuffix")
							,pattern = parentCompartType:attr("pattern")
							,isEssential = true
							,nr = 0
							,isStereotypable = false
							,isStereotype = false
							,isMultiple = false
							,isHint = false
							,toBeInvisible = false
							,is_occurrence_compartment = false
							,isDiagramName = false
						}):link("parentCompartType", parentCompType)
						parentCompartType:attr("adornmentPrefix", "")
						parentCompartType:attr("adornmentSuffix", "")
						compType:remove_link("parentCompartType", parentCompType)
					end
					compType:link("parentCompartType", newParentCompartType)
					compType:find("/propertyRow"):attr("rowType", "CheckBox+Button")
			
					local oldDia = compType:find("/propertyRow/propertyDiagram")
					dia = lQuery.create("PropertyDiagram", {id = parentCompartType:attr("id"), width = 250}):link("compartType", compType)
					
					if oldDia:size() == 0 then 
						if parent:is_empty() then --pie elementa
							oldDia = findCompartType(field):find("/elemType/compartType/subCompartType/propertyRow/propertyDiagram")
						else
							oldDia = findCompartType(field):find("/parentCompartType/subCompartType/subCompartType/propertyRow/propertyDiagram")
						end
						if oldDia:size() == 0 then
							oldDia = findCompartType(field):find("/subCompartType/propertyRow/propertyTab/propertyDiagram")
						end
					end
					compType:find("/propertyRow"):link("calledDiagram", dia)
					compType = newParentCompartType
				else
					if parentCompType:is_empty() then --ja ir piesaistits pie pirma limena lauka
					
						parentCompType = compType:find("/elemType")
						newParentCompartType = lQuery.create("CompartType", {id = "CheckBoxFictitious" .. parentCompartType:attr("id")
							,caption = "CheckBoxFictitious" .. parentCompartType:attr("caption")
							,startValue = parentCompartType:attr("startValue")
							,adornmentPrefix = parentCompartType:attr("adornmentPrefix")
							,adornmentSuffix = parentCompartType:attr("adornmentSuffix")
							,pattern = parentCompartType:attr("pattern")
							,isEssential = true
							,nr = 0
							,isStereotypable = false
							,isStereotype = false
							,isMultiple = false
							,isHint = false
							,toBeInvisible = false
							,is_occurrence_compartment = false
							,isDiagramName = false
						}):link("elemType", parentCompType)
						compType:remove_link("elemType", parentCompType)
			
						--japarliek stils no ta kompartmenta, kas bija uz to ko izveidojam
						local style = compType:find("/compartStyle")
						compType:remove_link("compartStyle", style)
						style:link("compartType", newParentCompartType)
						parentCompartType:attr("adornmentPrefix", "")
						parentCompartType:attr("adornmentSuffix", "")
						
						lQuery.create("CompartStyle",{
								alignment = 0,adjustment = 0,lineWidth = 1,lineColor = 0,fontTypeFace = "Arial",fontCharSet = 1,fontColor = 0,fontSize = 9,fontPitch = 0
								,fontStyle = 0,id = lQuery(newParentCompartType):attr("id"),caption = lQuery(newParentCompartType):attr("caption")
								,isVisible = 1,nr = 0,picWidth = 0,picHeight = 0,picPos = 1,picStyle = 0,adornment = 0
						}):link("compartType", compType)
						compType:remove_link("elemType", parentCompType)
						compType:find("/propertyRow"):attr("rowType", "CheckBox+Button")
					else
						newParentCompartType = lQuery.create("CompartType", {id = "CheckBoxFictitious" .. parentCompartType:attr("id")
							,caption = "CheckBoxFictitious" .. parentCompartType:attr("caption")
							,startValue = parentCompartType:attr("startValue")
							,adornmentPrefix = parentCompartType:attr("adornmentPrefix")
							,adornmentSuffix = parentCompartType:attr("adornmentSuffix")
							,pattern = parentCompartType:attr("pattern")
							,isEssential = true
							,nr = 0
							,isStereotypable = false
							,isStereotype = false
							,isMultiple = false
							,isHint = false
							,toBeInvisible = false
							,is_occurrence_compartment = false
							,isDiagramName = false
						}):link("parentCompartType", parentCompType)
						parentCompartType:attr("adornmentPrefix", "")
						parentCompartType:attr("adornmentSuffix", "")
						compType:remove_link("parentCompartType", parentCompType)
						
						local style = compType:find("/compartStyle")
						compType:remove_link("compartStyle", style)
						style:link("compartType", newParentCompartType)
						
						lQuery.create("CompartStyle",{
								alignment = 0,adjustment = 0,lineWidth = 1,lineColor = 0,fontTypeFace = "Arial",fontCharSet = 1,fontColor = 0,fontSize = 9,fontPitch = 0
								,fontStyle = 0,id = lQuery(newParentCompartType):attr("id"),caption = lQuery(newParentCompartType):attr("caption")
								,isVisible = 1,nr = 0,picWidth = 0,picHeight = 0,picPos = 1,picStyle = 0,adornment = 0
						}):link("compartType", compType)
						compType:remove_link("elemType", parentCompType)
						compType:find("/propertyRow"):attr("rowType", "CheckBox+Button")
					end
					compType:link("parentCompartType", newParentCompartType)
					compType:find("/propertyRow"):attr("rowType", "CheckBox+Button")

					dia = lQuery.create("PropertyDiagram", {id = parentCompartType:attr("id"), width = 250}):link("compartType", compType)
					
					compType:find("/propertyRow"):link("calledDiagram", dia)

					compType = newParentCompartType
		
					compType = newParentCompartType
				end
			
			elseif parentCompartType:find("/subCompartType"):is_empty() then
				local parentCompType = compType:find("/parentCompartType")--atribute
				local newParentCompartType

				if findCompartType(field):find("/propertyRow/propertyTab"):is_empty() then--ja nav taba
					if parentCompType:is_empty() then --ja ir piesaistits pie pirma limena lauka
						parentCompType = compType:find("/elemType")
				
						local presentation = compType:find("/presentation")
						compType:remove_link("presentation", presentation)
						newParentCompartType = lQuery.create("CompartType", {id = "AutoGeneratedGroup" .. parentCompartType:attr("id")
							,caption = parentCompartType:attr("caption")
							,adornmentPrefix = parentCompartType:attr("adornmentPrefix")
							,adornmentSuffix = parentCompartType:attr("adornmentSuffix")
							,pattern = parentCompartType:attr("pattern")
							,isEssential = true
							,nr = 0
							,isStereotypable = false
							,isStereotype = false
							,isMultiple = false
							,isHint = false
							,toBeInvisible = false
							,is_occurrence_compartment = false
							,isDiagramName = false
						}):link("presentation", presentation)
						
						--izveidot sakarstu ar visiem compartType piesaistitie pie elemType
						insertCompartTypeToElement(parentCompType, compType, newParentCompartType)
						
						compType:remove_link("elemType", parentCompType)
			
						--japarliek stils no ta kompartmenta, kas bija uz to ko izveidojam
						local style = compType:find("/compartStyle")
						compType:remove_link("compartStyle", style)
						style:link("compartType", newParentCompartType)
						
						parentCompartType:attr("adornmentPrefix", "")
						parentCompartType:attr("adornmentSuffix", "")
					else
						newParentCompartType = lQuery.create("CompartType", {id = "AutoGeneratedGroup" .. parentCompartType:attr("id")
							,caption = parentCompartType:attr("caption")
							,startValue = parentCompartType:attr("startValue")
							,adornmentPrefix = parentCompartType:attr("adornmentPrefix")
							,adornmentSuffix = parentCompartType:attr("adornmentSuffix")
							,pattern = parentCompartType:attr("pattern")
							,isEssential = true
							,nr = 0
							,isStereotypable = false
							,isStereotype = false
							,isMultiple = false
							,isHint = false
							,toBeInvisible = false
							,is_occurrence_compartment = false
							,isDiagramName = false
						})
						
						insertCompartTypeToCompart(parentCompType, compType, newParentCompartType)
						
						parentCompartType:attr("adornmentPrefix", "")
						parentCompartType:attr("adornmentSuffix", "")
						compType:remove_link("parentCompartType", parentCompType)
					end
					compType:link("parentCompartType", newParentCompartType)
					
					local propertyRowNew = lQuery.create("PropertyRow", {
						id = parentCompartType:attr("id")
						,caption = parentCompartType:attr("id")
						,rowType = "InputField+Button"
						,isEditable = true
						,isReadOnly = false
						,isFirstRespondent = false
					}):link("compartType", newParentCompartType)
					
					
					local oldDia = compType:find("/propertyRow/propertyDiagram")
					if oldDia:size() == 0 then 
						if parent:is_empty() then --pie elementa
							oldDia = findCompartType(field):find("/elemType/compartType/subCompartType/propertyRow/propertyDiagram")
						else
							oldDia = findCompartType(field):find("/parentCompartType/subCompartType/subCompartType/propertyRow/propertyDiagram")
						end
						if oldDia:size() == 0 then
							oldDia = findCompartType(field):find("/subCompartType/propertyRow/propertyTab/propertyDiagram")
						end
					end
					if contextType ~= "Multiplicity" then
						dia = lQuery.create("PropertyDiagram", {id = parentCompartType:attr("id"), width = 250}):link("compartType", newParentCompartType)
					
						propertyRowNew:link("calledDiagram", dia)
						
						insertCompartTypeToDiagram(compType:find("/propertyRow"),propertyRowNew, oldDia)
						compType:find("/propertyRow"):remove_link("propertyDiagram", oldDia)
						compType:find("/propertyRow"):link("propertyDiagram", dia)
					else
						dia = oldDia
					end
					compType = newParentCompartType
				else
					if parentCompType:is_empty() then --ja ir piesaistits pie pirma limena lauka
						parentCompType = compType:find("/elemType")
						local presentation = compType:find("/presentation")
						compType:remove_link("presentation", presentation)
						newParentCompartType = lQuery.create("CompartType", {id = "AutoGeneratedGroup" .. parentCompartType:attr("id")
							,caption = parentCompartType:attr("caption")
							,adornmentPrefix = parentCompartType:attr("adornmentPrefix")
							,adornmentSuffix = parentCompartType:attr("adornmentSuffix")
							,pattern = parentCompartType:attr("pattern")
							,isEssential = true
							,nr = 0
							,isStereotypable = false
							,isStereotype = false
							,isMultiple = false
							,isHint = false
							,toBeInvisible = false
							,is_occurrence_compartment = false
							,isDiagramName = false
						})
						:link("presentation", presentation)
						
						insertCompartTypeToElement(parentCompType, compType, newParentCompartType)
						compType:remove_link("elemType", parentCompType)
						
						--japarliek stils no ta kompartmenta, kas bija uz to ko izveidojam
						local style = compType:find("/compartStyle")
						compType:remove_link("compartStyle", style)
						style:link("compartType", newParentCompartType)
						parentCompartType:attr("adornmentPrefix", "")
						parentCompartType:attr("adornmentSuffix", "")
					else
						newParentCompartType = lQuery.create("CompartType", {id = "AutoGeneratedGroup" .. parentCompartType:attr("id")
							,caption = parentCompartType:attr("caption")
							,startValue = parentCompartType:attr("startValue")
							,adornmentPrefix = parentCompartType:attr("adornmentPrefix")
							,adornmentSuffix = parentCompartType:attr("adornmentSuffix")
							,pattern = parentCompartType:attr("pattern")
							,isEssential = true
							,nr = 0
							,isStereotypable = false
							,isStereotype = false
							,isMultiple = false
							,isHint = false
							,toBeInvisible = false
							,is_occurrence_compartment = false
							,isDiagramName = false
						})
						parentCompartType:attr("adornmentPrefix", "")
						parentCompartType:attr("adornmentSuffix", "")
						
						insertCompartTypeToCompart(parentCompType, compType, newParentCompartType)
						
						compType:remove_link("parentCompartType", parentCompType)
						
						local style = compType:find("/compartStyle")
						compType:remove_link("compartStyle", style)
						style:link("compartType", newParentCompartType)
		
					end
					compType:link("parentCompartType", newParentCompartType)
					
					local propertyRowNew = lQuery.create("PropertyRow", {
						id = parentCompartType:attr("id")
						,caption = parentCompartType:attr("id")
						,rowType = "InputField+Button"
						,isEditable = true
						,isReadOnly = false
						,isFirstRespondent = false
					}):link("compartType", newParentCompartType)
					
					local tab = compType:find("/propertyRow/propertyTab")
					
					if contextType ~= "Multiplicity" then
						dia = lQuery.create("PropertyDiagram", {id = parentCompartType:attr("id"), width = 250}):link("compartType", newParentCompartType)
						propertyRowNew:link("calledDiagram", dia)
						insertCompartTypeToTab(compType:find("/propertyRow"),propertyRowNew, tab)
						
						compType:find("/propertyRow"):remove_link("propertyTab", tab)
						compType:find("/propertyRow"):link("propertyDiagram", dia)
					end
					compType = newParentCompartType
				end
			end
			local compartType
			local compartTypeASFictitious
			local fieldTypes = lQuery(field):attr("fieldType")
			
			if lQuery(field):find("/context"):attr("type") == "Attributes" and fieldTypes == "TextArea+Button" then
				local ct = lQuery.create("CompartType", {
					caption = lQuery(field):attr("name"),id = lQuery(field):attr("name"),isEssential = true,pattern = lQuery(field):attr("pattern"),nr = 0,isStereotypable = false,isStereotype = false,isMultiple = false,isHint = false,toBeInvisible = false,is_occurrence_compartment = false,isDiagramName = false,isGroup = false,adornmentSuffix = "}",adornmentPrefix = "{"
				}):link("parentCompartType", compType)
					:link("compartStyle",lQuery.create("CompartStyle",{
					alignment = 0,adjustment = 0,lineWidth = 1,lineColor = 0,fontTypeFace = "Arial",fontCharSet = 1,fontColor = 0,fontSize = 9,fontPitch = 0,fontStyle = 0,id = lQuery(field):attr("name"),caption = lQuery(field):attr("name"),isVisible = 1,nr = 0,picWidth = 0,picHeight = 0,picPos = 1,picStyle = 0,adornment = 0
				}))
				compType= ct
			end
			
			if fieldTypes ~= "TextArea+Button" then
				compartType = createCompartType(field)
				lQuery(extension):link("type", compartType)
			else
				compartType = createCompartTypeTextAreaButton(field)
				compartTypeASFictitious = createASFictious(field)
				lQuery(compartTypeASFictitious):link("subCompartType", compartType)
				lQuery(extension):link("type", compartTypeASFictitious)
				dia = lQuery.create("PropertyDiagram", {id = lQuery(field):attr("name"), width = 250}):link("compartType", compartTypeASFictitious) 
			end

			if fieldTypes == "InputField+Button" then 
				dia = lQuery.create("PropertyDiagram", {id = lQuery(field):attr("name"), width = 250}):link("compartType", compartType) 
			end
			
			--piesaistit compartType subCompartType
			createDisplayPlaceBeforeComp(field, compType, fieldTypes, compartType, compartTypeASFictitious)
			
			--local rowType = lQuery(field):find("/fieldType")
			local propertyRow = lQuery.create("PropertyRow", {
				id = lQuery(field):attr("name")
				,caption = lQuery(field):attr("name")
				,rowType = lQuery(field):attr("fieldType")
				,isEditable = true
				,isReadOnly = false
				,isFirstRespondent = false
			})
			
			if fieldTypes == "InputField+Button" or fieldTypes == "TextArea+Button" then 
				--saita starp diagramu un propertyRow
				dia:link("calledPropertyRow", propertyRow)
			end
			
			if fieldTypes ~= "TextArea+Button" then
				propertyRow:link("compartType", compartType)
			else propertyRow:link("compartType", compartTypeASFictitious) end
			
			--piesaistit PropertyTab
			local propertyEditorTab = lQuery(field):attr("propertyEditorTab")
			createPropertyEditorTab(field, contextType, propertyRow, propertyEditorTab, compType)
			
			--izveidot choiceItem
			createChoiceItem(field, compartType, contextType, elemType, elTypeName)
			
			--izveido translet
			createTranslet(field, compartType)
			
			--izveido stilu
			
			--jauna funkcija
			createFieldCompartTypeStyle(fieldTypes, compartType, compartTypeASFictitious, field)
			
			--createFieldStyle(fieldTypes, compartType, compartTypeASFictitious, field)
			
			local subCompartType = lQuery(field):find("/subField"):each(function(obj)
				subFields(compartType, obj, dia)
			end)
			
			--izveido tag
			createTag(field ,compartType)
		end	
		if contextType == "Multiplicity" then
			compartType:attr("shouldBeIncluded", "OWLGrEd_UserFields.owl_fields_specific.hide_for_OWL_Fields")
			compartType:find("/propertyRow"):attr("shouldBeIncluded", "OWLGrEd_UserFields.owl_fields_specific.hide_for_OWL_Fields")
		end
		
		if hasMirror == "1" then 
			local compartTypeInv
			local compartTypeASFictitiousInv
			compTypeInv = compType:find("/aa#mirror")
			if compTypeInv:is_empty() then compTypeInv = compType:find("/aa#mirrorInv") end
			if compTypeInv:is_empty() then compTypeInv = compType:find("/subCompartType/aa#mirror") end
			if compTypeInv:is_empty() then compTypeInv = compType:find("/subCompartType/aa#mirrorInv") end
			
		  if field:attr("isExistingField")=="true" then 
				--atrast compartType
				local compartType = compType:find("/subCompartType[id = '" .. field:attr("name") .. "']")
				lQuery(extension):link("type", compartType)--piesaistam pie extension
				--izveido tag
				createTag(field ,compartType)
		  else
			
			  local parentCompartTypeInv = compTypeInv
				
			  if parentCompartTypeInv:find("/propertyRow"):attr("rowType") == "CheckBox" then
				
				local parentCompType = compTypeInv:find("/parentCompartType")--atribute
				local newParentCompartType
				if findCompartType(field):find("/subCompartType/aa#mirror"):find("/propertyRow/propertyTab"):is_empty() then--ja nav taba
					if parentCompType:is_empty() then --ja ir piesaistits pie pirma limena lauka
						parentCompType = compTypeInv:find("/elemType")
						newParentCompartType = lQuery.create("CompartType", {id = "CheckBoxFictitious" .. parentCompartTypeInv:attr("id")
							,caption = "CheckBoxFictitious" .. parentCompartTypeInv:attr("caption")
							,startValue = parentCompartTypeInv:attr("startValue")
							,adornmentPrefix = parentCompartTypeInv:attr("adornmentPrefix")
							,adornmentSuffix = parentCompartTypeInv:attr("adornmentSuffix")
							,pattern = parentCompartTypeInv:attr("pattern")
							,isEssential = true
							,nr = 0
							,isStereotypable = false
							,isStereotype = false
							,isMultiple = false
							,isHint = false
							,toBeInvisible = false
							,is_occurrence_compartment = false
							,isDiagramName = false
						}):link("elemType", parentCompType)
						
						local style = compTypeInv:find("/compartStyle")
						compTypeInv:remove_link("compartStyle", style)
						style:link("compartType", newParentCompartType)
						
						lQuery.create("CompartStyle",{
								alignment = 0,adjustment = 0,lineWidth = 1,lineColor = 0,fontTypeFace = "Arial",fontCharSet = 1,fontColor = 0,fontSize = 9,fontPitch = 0
								,fontStyle = 0,id = lQuery(newParentCompartType):attr("id"),caption = lQuery(newParentCompartType):attr("caption")
								,isVisible = 1,nr = 0,picWidth = 0,picHeight = 0,picPos = 1,picStyle = 0,adornment = 0
						}):link("compartType", compTypeInv)
						compTypeInv:remove_link("elemType", parentCompType)
						
						parentCompartTypeInv:attr("adornmentPrefix", "")
						parentCompartTypeInv:attr("adornmentSuffix", "")
					else
						newParentCompartType = lQuery.create("CompartType", {id = "CheckBoxFictitious" .. parentCompartTypeInv:attr("id")
							,caption = "CheckBoxFictitious" .. parentCompartTypeInv:attr("caption")
							,startValue = parentCompartTypeInv:attr("startValue")
							,adornmentPrefix = parentCompartTypeInv:attr("adornmentPrefix")
							,adornmentSuffix = parentCompartTypeInv:attr("adornmentSuffix")
							,pattern = parentCompartTypeInv:attr("pattern")
							,isEssential = true
							,nr = 0
							,isStereotypable = false
							,isStereotype = false
							,isMultiple = false
							,isHint = false
							,toBeInvisible = false
							,is_occurrence_compartment = false
							,isDiagramName = false
						}):link("parentCompartType", parentCompType)
						parentCompartTypeInv:attr("adornmentPrefix", "")
						parentCompartTypeInv:attr("adornmentSuffix", "")
						
						compTypeInv:remove_link("parentCompartType", parentCompType)
					end
					compTypeInv:link("parentCompartType", newParentCompartType)
					compTypeInv:find("/propertyRow"):attr("rowType", "CheckBox+Button")
					
					local oldDia = compTypeInv:find("/propertyRow/propertyDiagram")
					dia = lQuery.create("PropertyDiagram", {id = parentCompartTypeInv:attr("id"), width = 250}):link("compartType", compTypeInv)
					
					if oldDia:size() == 0 then 
						if parent:is_empty() then --pie elementa
							oldDia = findCompartType(field):find("/elemType/compartType/subCompartType/propertyRow/propertyDiagram")
						else
							oldDia = findCompartType(field):find("/parentCompartType/subCompartType/subCompartType/propertyRow/propertyDiagram")
						end
						if oldDia:size() == 0 then
							oldDia = findCompartType(field):find("/subCompartType/propertyRow/propertyTab/propertyDiagram")
						end
					end
					compTypeInv:find("/propertyRow"):link("calledDiagram", dia)
					compTypeInv = newParentCompartType
				else
					if parentCompType:is_empty() then --ja ir piesaistits pie pirma limena lauka
						
						parentCompType = compTypeInv:find("/elemType")
						newParentCompartType = lQuery.create("CompartType", {id = "CheckBoxFictitious" .. parentCompartTypeInv:attr("id")
							,caption = "CheckBoxFictitious" .. parentCompartTypeInv:attr("caption")
							,startValue = parentCompartTypeInv:attr("startValue")
							,adornmentPrefix = parentCompartTypeInv:attr("adornmentPrefix")
							,adornmentSuffix = parentCompartTypeInv:attr("adornmentSuffix")
							,pattern = parentCompartTypeInv:attr("pattern")
							,isEssential = true
							,nr = 0
							,isStereotypable = false
							,isStereotype = false
							,isMultiple = false
							,isHint = false
							,toBeInvisible = false
							,is_occurrence_compartment = false
							,isDiagramName = false
						}):link("elemType", parentCompType)
						
						compTypeInv:remove_link("elemType", parentCompType)
			
						--japarliek stils no ta kompartmenta, kas bija uz to ko izveidojam
						local style = compTypeInv:find("/compartStyle")
						compTypeInv:remove_link("compartStyle", style)
						style:link("compartType", newParentCompartType)
						parentCompartTypeInv:attr("adornmentPrefix", "")
						parentCompartTypeInv:attr("adornmentSuffix", "")
						
						lQuery.create("CompartStyle",{
								alignment = 0,adjustment = 0,lineWidth = 1,lineColor = 0,fontTypeFace = "Arial",fontCharSet = 1,fontColor = 0,fontSize = 9,fontPitch = 0
								,fontStyle = 0,id = lQuery(newParentCompartType):attr("id"),caption = lQuery(newParentCompartType):attr("caption")
								,isVisible = 1,nr = 0,picWidth = 0,picHeight = 0,picPos = 1,picStyle = 0,adornment = 0
						}):link("compartType", compTypeInv)
						compTypeInv:remove_link("elemType", parentCompType)
						compTypeInv:find("/propertyRow"):attr("rowType", "CheckBox+Button")
					else
						newParentCompartType = lQuery.create("CompartType", {id = "CheckBoxFictitious" .. parentCompartTypeInv:attr("id")
							,caption = "CheckBoxFictitious" .. parentCompartTypeInv:attr("caption")
							,startValue = parentCompartTypeInv:attr("startValue")
							,adornmentPrefix = parentCompartTypeInv:attr("adornmentPrefix")
							,adornmentSuffix = parentCompartTypeInv:attr("adornmentSuffix")
							,pattern = parentCompartTypeInv:attr("pattern")
							,isEssential = true
							,nr = 0
							,isStereotypable = false
							,isStereotype = false
							,isMultiple = false
							,isHint = false
							,toBeInvisible = false
							,is_occurrence_compartment = false
							,isDiagramName = false
						}):link("parentCompartType", parentCompType)
						parentCompartTypeInv:attr("adornmentPrefix", "")
						parentCompartTypeInv:attr("adornmentSuffix", "")
						
						
						compTypeInv:remove_link("parentCompartType", parentCompType)
						
						local style = compTypeInv:find("/compartStyle")
						compTypeInv:remove_link("compartStyle", style)
						style:link("compartType", newParentCompartType)
						
						lQuery.create("CompartStyle",{
								alignment = 0,adjustment = 0,lineWidth = 1,lineColor = 0,fontTypeFace = "Arial",fontCharSet = 1,fontColor = 0,fontSize = 9,fontPitch = 0
								,fontStyle = 0,id = lQuery(newParentCompartType):attr("id"),caption = lQuery(newParentCompartType):attr("caption")
								,isVisible = 1,nr = 0,picWidth = 0,picHeight = 0,picPos = 1,picStyle = 0,adornment = 0
						}):link("compartType", compTypeInv)
						compTypeInv:remove_link("elemType", parentCompType)
						compTypeInv:find("/propertyRow"):attr("rowType", "CheckBox+Button")
					end
					compTypeInv:link("parentCompartType", newParentCompartType)
					compTypeInv:find("/propertyRow"):attr("rowType", "CheckBox+Button")

					dia = lQuery.create("PropertyDiagram", {id = parentCompartTypeInv:attr("id"), width = 250}):link("compartType", compTypeInv)
					
					compTypeInv:find("/propertyRow"):link("calledDiagram", dia)

					compTypeInv = newParentCompartType
					compTypeInv = newParentCompartType
				end
			
			  elseif parentCompartTypeInv:find("/subCompartType"):is_empty() then
					local parentCompType = compTypeInv:find("/parentCompartType")--atribute
					local newParentCompartType

					if findCompartType(field):find("/subCompartType/aa#mirror"):find("/propertyRow/propertyTab"):is_empty() then
						if parentCompType:is_empty() then --ja ir piesaistits pie pirma limena lauka
							parentCompType = compTypeInv:find("/elemType")
							local presentation = compTypeInv:find("/presentation")
							compTypeInv:remove_link("presentation", presentation)
							newParentCompartType = lQuery.create("CompartType", {id = "AutoGeneratedGroup" .. parentCompartTypeInv:attr("id")
								,caption = parentCompartTypeInv:attr("caption")
								,adornmentPrefix = parentCompartTypeInv:attr("adornmentPrefix")
								,adornmentSuffix = parentCompartTypeInv:attr("adornmentSuffix")
								,pattern = parentCompartTypeInv:attr("pattern")
								,isEssential = true
								,nr = 0
								,isStereotypable = false
								,isStereotype = false
								,isMultiple = false
								,isHint = false
								,toBeInvisible = false
								,is_occurrence_compartment = false
								,isDiagramName = false
							})
							:link("presentation", presentation)
							
							insertCompartTypeToElement(parentCompType, compTypeInv, newParentCompartType)
							
							compTypeInv:remove_link("elemType", parentCompType)
				
							--japarliek stils no ta kompartmenta, kas bija uz to ko izveidojam
							local style = compTypeInv:find("/compartStyle")
							compTypeInv:remove_link("compartStyle", style)
							style:link("compartType", newParentCompartType)
							
							parentCompartTypeInv:attr("adornmentPrefix", "")
							parentCompartTypeInv:attr("adornmentSuffix", "")
						else
							newParentCompartType = lQuery.create("CompartType", {id = "AutoGeneratedGroup" .. parentCompartTypeInv:attr("id")
								,caption = parentCompartTypeInv:attr("caption")
								,startValue = parentCompartTypeInv:attr("startValue")
								,adornmentPrefix = parentCompartTypeInv:attr("adornmentPrefix")
								,adornmentSuffix = parentCompartTypeInv:attr("adornmentSuffix")
								,pattern = parentCompartTypeInv:attr("pattern")
								,isEssential = true
								,nr = 0
								,isStereotypable = false
								,isStereotype = false
								,isMultiple = false
								,isHint = false
								,toBeInvisible = false
								,is_occurrence_compartment = false
								,isDiagramName = false
							})
							parentCompartTypeInv:attr("adornmentPrefix", "")
							parentCompartTypeInv:attr("adornmentSuffix", "")
							
							insertCompartTypeToCompart(parentCompType, compTypeInv, newParentCompartType)
							
							compTypeInv:remove_link("parentCompartType", parentCompType)
						end
						compTypeInv:link("parentCompartType", newParentCompartType)
						
						local propertyRowNew = lQuery.create("PropertyRow", {
							id = parentCompartTypeInv:attr("id")
							,caption = parentCompartTypeInv:attr("id")
							,rowType = "InputField+Button"
							,isEditable = true
							,isReadOnly = false
							,isFirstRespondent = false
						}):link("compartType", newParentCompartType)
						
						
						local oldDia = compTypeInv:find("/propertyRow/propertyDiagram")
						if oldDia:size() == 0 then 
							if parent:is_empty() then --pie elementa
								oldDia = findCompartType(field):find("/elemType/compartType/subCompartType/propertyRow/propertyDiagram")
							else
								oldDia = findCompartType(field):find("/parentCompartType/subCompartType/subCompartType/propertyRow/propertyDiagram")
							end
							if oldDia:size() == 0 then
								oldDia = findCompartType(field):find("/subCompartType/propertyRow/propertyTab/propertyDiagram")
							end
						end
						if contextType ~= "Multiplicity" then
							dia = lQuery.create("PropertyDiagram", {id = parentCompartTypeInv:attr("id"), width = 250}):link("compartType", newParentCompartType)
							
							propertyRowNew:link("calledDiagram", dia)
			
							insertCompartTypeToDiagram(compTypeInv:find("/propertyRow"),propertyRowNew, oldDia)
							
							compTypeInv:find("/propertyRow"):remove_link("propertyDiagram", oldDia)
							compTypeInv:find("/propertyRow"):link("propertyDiagram", dia)
						else
							dia = oldDia
						end
						compTypeInv = newParentCompartType
					else
						if parentCompType:is_empty() then --ja ir piesaistits pie pirma limena lauka
							parentCompType = compTypeInv:find("/elemType")
							local presentation = compTypeInv:find("/presentation")
							compTypeInv:remove_link("presentation", presentation)
							newParentCompartType = lQuery.create("CompartType", {id = "AutoGeneratedGroup" .. parentCompartTypeInv:attr("id")
								,caption = parentCompartTypeInv:attr("caption")
								,adornmentPrefix = parentCompartTypeInv:attr("adornmentPrefix")
								,adornmentSuffix = parentCompartTypeInv:attr("adornmentSuffix")
								,pattern = parentCompartTypeInv:attr("pattern")
								,isEssential = true
								,nr = 0
								,isStereotypable = false
								,isStereotype = false
								,isMultiple = false
								,isHint = false
								,toBeInvisible = false
								,is_occurrence_compartment = false
								,isDiagramName = false
							})
							:link("presentation", presentation)
							
							insertCompartTypeToElement(parentCompType, compTypeInv, newParentCompartType)
							
							compTypeInv:remove_link("elemType", parentCompType)
				
							--japarliek stils no ta kompartmenta, kas bija uz to ko izveidojam
							local style = compTypeInv:find("/compartStyle")
							compTypeInv:remove_link("compartStyle", style)
							style:link("compartType", newParentCompartType)
							parentCompartTypeInv:attr("adornmentPrefix", "")
							parentCompartTypeInv:attr("adornmentSuffix", "")
						else
							newParentCompartType = lQuery.create("CompartType", {id = "AutoGeneratedGroup" .. parentCompartTypeInv:attr("id")
								,caption = parentCompartTypeInv:attr("caption")
								,startValue = parentCompartTypeInv:attr("startValue")
								,adornmentPrefix = parentCompartTypeInv:attr("adornmentPrefix")
								,adornmentSuffix = parentCompartTypeInv:attr("adornmentSuffix")
								,pattern = parentCompartTypeInv:attr("pattern")
								,isEssential = true
								,nr = 0
								,isStereotypable = false
								,isStereotype = false
								,isMultiple = false
								,isHint = false
								,toBeInvisible = false
								,is_occurrence_compartment = false
								,isDiagramName = false
							})
							parentCompartTypeInv:attr("adornmentPrefix", "")
							parentCompartTypeInv:attr("adornmentSuffix", "")
							
							insertCompartTypeToCompart(parentCompType, compTypeInv, newParentCompartType)
							
							compTypeInv:remove_link("parentCompartType", parentCompType)
							
							local style = compTypeInv:find("/compartStyle")
							compTypeInv:remove_link("compartStyle", style)
							style:link("compartType", newParentCompartType)
			
						end
						compTypeInv:link("parentCompartType", newParentCompartType)
						
						local propertyRowNew = lQuery.create("PropertyRow", {
							id = parentCompartTypeInv:attr("id")
							,caption = parentCompartTypeInv:attr("id")
							,rowType = "InputField+Button"
							,isEditable = true
							,isReadOnly = false
							,isFirstRespondent = false
						}):link("compartType", newParentCompartType)
						
						dia = lQuery.create("PropertyDiagram", {id = parentCompartTypeInv:attr("id"), width = 250}):link("compartType", newParentCompartType)
						
						local tab = compTypeInv:find("/propertyRow/propertyTab")
						if contextType ~= "Multiplicity" then
							insertCompartTypeToTab(compTypeInv:find("/propertyRow"),propertyRowNew, tab)
							propertyRowNew:link("calledDiagram", dia)
							
							compTypeInv:find("/propertyRow"):remove_link("propertyTab", tab)
							compTypeInv:find("/propertyRow"):link("propertyDiagram", dia)
						end
						compTypeInv = newParentCompartType
					end
				end
			
				local fieldTypes = lQuery(field):attr("fieldType")
				if fieldTypes ~= "TextArea+Button" then
					compartTypeInv = createCompartType(field)
					lQuery(extension):link("type", compartTypeInv)
					lQuery(compartTypeInv):link("aa#mirror", compartType)
				else
					compartTypeInv = createCompartTypeTextAreaButton(field)
					compartTypeASFictitiousInv = createASFictious(field)
					lQuery(compartTypeASFictitiousInv):link("subCompartType", compartTypeInv)
					lQuery(compartTypeASFictitiousInv):link("aa#mirror", compartTypeASFictitious)
					lQuery(extension):link("type", compartTypeASFictitiousInv)
					diaInv = lQuery.create("PropertyDiagram", {id = lQuery(field):attr("name"), width = 250}):link("compartType", compartTypeASFictitiousInv) 
				end

				if fieldTypes == "InputField+Button" then 
					diaInv = lQuery.create("PropertyDiagram", {id = lQuery(field):attr("name"), width = 250}):link("compartType", compartTypeInv) 
				end
				
				--piesaistit compartType subCompartType
				createDisplayPlaceBeforeComp(field, compTypeInv, fieldTypes, compartTypeInv, compartTypeASFictitiousInv)
				
				--piesaistit propertyRow
				local propertyRowInv = lQuery.create("PropertyRow", {
					id = lQuery(field):attr("name")
					,caption = lQuery(field):attr("name")
					,rowType = lQuery(field):attr("fieldType")
					,isEditable = true
					,isReadOnly = false
					,isFirstRespondent = false
				})
				
				if fieldTypes == "InputField+Button" or fieldTypes == "TextArea+Button" then 
					--saita starp diagramu un propertyRow
					diaInv:link("calledPropertyRow", propertyRowInv)
				end
				
				if fieldTypes ~= "TextArea+Button" then
					propertyRowInv:link("compartType", compartTypeInv)
				else propertyRowInv:link("compartType", compartTypeASFictitiousInv) end
				
				--piesaistit PropertyTab
				local propertyEditorTab = lQuery(field):attr("propertyEditorTab")
				if propertyEditorTab~="" then
					local propertyTab = lQuery("PropertyDiagram[id = '" .. elTypeName .. "']/propertyTab[caption != '" .. propertyEditorTab .. "']")
					propertyEditorTab = propertyTab:attr("caption")
				end
		
				createPropertyEditorTab(field, contextType, propertyRowInv, propertyEditorTab, compTypeInv)
				
				--izveidot choiceItem
				createChoiceItem(field, compartTypeInv, contextType, elemType, elTypeName, 1)
				
				
				
				--izveido translet
				createTranslet(field, compartTypeInv)
				
				--izveido stilu
				createFieldCompartTypeStyle(fieldTypes, compartTypeInv, compartTypeASFictitiousInv, field)
				--createFieldStyle(fieldTypes, compartTypeInv, compartTypeASFictitiousInv, field)
				
				if contextType == "Multiplicity" then
					compartType:attr("shouldBeIncluded", "OWLGrEd_UserFields.owl_fields_specific.hide_for_OWL_Fields")
					compartType:find("/propertyRow"):attr("shouldBeIncluded", "OWLGrEd_UserFields.owl_fields_specific.hide_for_OWL_Fields")
				end
				
				local subCompartType = lQuery(field):find("/subField"):each(function(obj)
					subFields(compartTypeInv, obj, diaInv)
				end)
				
				--izveido tag
				createTag(field ,compartTypeInv)
			end
		end	
	end
end

--izveido apakslaukus(superField-virslauks, field-lauks, diagrama-diagramma)
function subFields(superField, field, diagrama)
	--print("subFields subFields subFields")
	local compartType
	local compartTypeASFictitious
	local fieldTypes = lQuery(field):attr("fieldType")
	
	if fieldTypes == "TextArea+Button" then
		local ct = lQuery.create("CompartType", {
			caption = lQuery(field):attr("name"),id = lQuery(field):attr("name"),isEssential = true,pattern = lQuery(field):attr("pattern"),nr = 0,isStereotypable = false,isStereotype = false,isMultiple = false,isHint = false,toBeInvisible = false,is_occurrence_compartment = false,isDiagramName = false,isGroup = false,adornmentSuffix = field:attr("suffix"),adornmentPrefix = field:attr("prefix")
		}):link("parentCompartType", superField)
		:link("compartStyle",lQuery.create("CompartStyle",{
		alignment = 0,adjustment = 0,lineWidth = 1,lineColor = 0,fontTypeFace = "Arial",fontCharSet = 1,fontColor = 0,fontSize = 9,fontPitch = 0,fontStyle = 0,id = lQuery(field):attr("name"),caption = lQuery(field):attr("name"),isVisible = 1,nr = 0,picWidth = 0,picHeight = 0,picPos = 1,picStyle = 0,adornment = 0
		}))
		superField= ct
	end	
	 
	if fieldTypes ~= "TextArea+Button" then
		compartType = createCompartType(field)
		compartType:link("parentCompartType", superField)
	else
		compartType = createCompartTypeTextAreaButtonSubField(field)
		compartTypeASFictitious = createASFictious(field)
		lQuery(compartTypeASFictitious):link("subCompartType", compartType)
		lQuery(compartTypeASFictitious):link("parentCompartType", superField)
		dia = lQuery.create("PropertyDiagram", {id = lQuery(field):attr("name"), width = 250}):link("compartType", compartTypeASFictitious) 
	end
	
	if fieldTypes == "InputField+Button" then 
		dia = lQuery.create("PropertyDiagram", {id = lQuery(field):attr("name"), width = 250}):link("compartType", compartType) 
	end
	
		--local rowType = lQuery(field):find("/fieldType")
		local propertyRow = lQuery.create("PropertyRow", {
			id = lQuery(field):attr("name")
			,caption = lQuery(field):attr("name")
			,rowType = lQuery(field):attr("fieldType")
			,isEditable = true
			,isReadOnly = false
			,isFirstRespondent = false
		})
		
		if fieldTypes == "InputField+Button" or fieldTypes == "TextArea+Button" then 
			--saita starp diagramu un propertyRow
			dia:link("calledPropertyRow", propertyRow)
		end 
		
		if diagrama ~= nil then
			diagrama:link("propertyRow", propertyRow)
		end
		if fieldTypes ~= "TextArea+Button" then
			propertyRow:link("compartType", compartType)
		else propertyRow:link("compartType", compartTypeASFictitious) end
		
		local choiceItem = lQuery(field):find("/choiceItem"):each(function(obj)
			local ci = lQuery.create("ChoiceItem", {
				value = lQuery(obj):attr("caption")
			}):link("compartType", compartType)
			
			if lQuery(field):attr("fieldType") == "CheckBox" then
				local notation = lQuery.create("Notation", {value = lQuery(obj):attr("notation")}):link("choiceItem", ci)
			else local notation = lQuery.create("Notation", {value = lQuery(obj):attr("caption")}):link("choiceItem", ci)
			end
			
			local tagItem = lQuery(obj):find("/tag"):each(function(objTag)
				if lQuery(objTag):attr("tagValue") ~= "" then
					local tag = lQuery.create("Tag", {
						value = lQuery(objTag):attr("tagValue")
						,key = lQuery(objTag):attr("tagKey")
					}):link("choiceItem", ci)
					
					if lQuery(objTag):attr("tagKey") == "owl_Field_axiom" then
						createImportSemanticsChoiceItem(field, ci, objTag)
					end
					
					if lQuery(objTag):attr("tagKey") == "owl_Axiom_Annotation" then
						--atrast vecak elementu
						local parent = ci:find("/compartType/parentCompartType")
						if parent:is_empty() then parent = ci:find("/compartType/elemType") end
	
						parent = findAxiomAnnotationPath(objTag, parent)
						
						if parent:find("/translet[extensionPoint='OWLGrEd_GetAxiomAnnotation'][procedureName = 'OWLGrEd_UserFields.axiom.getAxiomAnnotation']"):is_empty() then
							lQuery.create("Translet", {extensionPoint = 'OWLGrEd_GetAxiomAnnotation', procedureName = 'OWLGrEd_UserFields.axiom.getAxiomAnnotation'})
							:link("type", parent)
						end
						tag:link("axiomAnnotationType", parent)
					end
				end
			end)
		end)
		
		local tag = lQuery(field):find("/tag"):each(function(obj)
			if lQuery(obj):attr("tagValue") ~= "" then
				local tag = lQuery.create("Tag", {
					value = lQuery(obj):attr("tagValue")
					,key = lQuery(obj):attr("tagKey")
				}):link("type", compartType)
				
				if lQuery(obj):attr("tagKey") == "owl_Field_axiom" then
					createImportSemanticsField(field ,compartType, obj)
				end
				
				if lQuery(obj):attr("tagKey") == "owl_Axiom_Annotation" then
						--atrast vecak elementu
						local parent = ci:find("/compartType/parentCompartType")
						if parent:is_empty() then parent = ci:find("/compartType/elemType") end
						
						parent = findAxiomAnnotationPath(obj, parent)
						
						if parent:find("/translet[extensionPoint='OWLGrEd_GetAxiomAnnotation'][procedureName = 'OWLGrEd_UserFields.axiom.getAxiomAnnotation']"):is_empty() then
							lQuery.create("Translet", {extensionPoint = 'OWLGrEd_GetAxiomAnnotation', procedureName = 'OWLGrEd_UserFields.axiom.getAxiomAnnotation'})
							:link("type", parent)
						end
						tag:link("axiomAnnotationType", parent)
				end
			end
		end)

		if lQuery(field):find("/selfStyleSetting"):is_not_empty() then
			local compartStyle = lQuery.create("CompartStyle",{
				alignment = 0,adjustment = 0,lineWidth = 1,lineColor = 0,fontTypeFace = "Arial",fontCharSet = 1,fontColor = 0,fontSize = 9
				,fontPitch = 0,fontStyle = 0,id = lQuery(compartType):attr("id"),caption = lQuery(compartType):attr("caption"),isVisible = 1
				,nr = 0,picWidth = 0,picHeight = 0,picPos = 1,picStyle = 0,adornment = 0
				--un citas noklusetas vertibas
			}):link("compartType", compartType)
			local selfStyleSetting = lQuery(field):find("/selfStyleSetting"):each(function(obj)
				lQuery(compartStyle):attr(obj:find("/fieldStyleFeature"):attr("itemName"), obj:attr("value"))
			end)
		end
		
		--izveido translet
		createTranslet(field, compartType)
		
		local subCompartType = lQuery(field):find("/subField"):each(function(obj)
			subFields(compartType, obj, dia, diaInv)
		end)
end