(ns lv.lumii.tda.core
	(:use lv.lumii.tda.export
				lv.lumii.tda.import
				lv.lumii.tda
				lv.lumii.tda.ontology-diff)
	(:import javax.swing.JOptionPane
			 java.io.StringWriter
			 java.io.PrintWriter)
	(:gen-class
	    :name "owlgred.OWLGrEdImport"
	    :methods [#^{:static true} [test [String] String]
				  #^{:static true} [read [String] String]
				  #^{:static true} [read_from_protege [String] String]
				  #^{:static true} [read_module [String] String]
				  #^{:static true} [write [String] String]
				  #^{:static true} [diff [String] String]]))
	
(defn -test
  "A Java-callable wrapper"
  [arg]
  (apply str (repeat (Integer/parseInt arg) "a")))

(defn deserialize-args [arg-str]
	(with-in-str (.replace arg-str "\\\n" "\n") (read)))

(defn stack-trace-to-string [e]
	(let [errors (new StringWriter)]
		(.printStackTrace e (new PrintWriter errors))
		(.toString errors)))

(defn -read
	"read ontology from file, apply custom render prefs, return table"
	[arg-str-representation]
	(try 
		(let [table (deserialize-args arg-str-representation)]
			(init)
			(embeded-export-to-tda table))
		(catch java.lang.Exception e 
					(do (JOptionPane/showMessageDialog nil (str e) "Error loading ontology" JOptionPane/ERROR_MESSAGE)
							(str "error - " (stack-trace-to-string e))))))

;
(defn -read_from_protege
	"a table ontologies - ontology str, ontology iri, active ontology iri, custom render prefs. returns table for owlgred import"
	[arg-str-representation]
	(try 
		(let [table (deserialize-args arg-str-representation)]
			(init)
			(embeded-export-to-tda-from-pratege table))
		(catch java.lang.Exception e 
					(do (println e)
							(JOptionPane/showMessageDialog nil (str e) "Error loading ontology" JOptionPane/ERROR_MESSAGE)
							(str "error - " (stack-trace-to-string e))))))


;
(defn -read_module
	"read ontology from file, apply custom render prefs, extract module, return table"
	[arg-str-representation]
	(try 
		(let [table (deserialize-args arg-str-representation)]
			(init)
			(embeded-module-export-to-tda table))
		(catch java.lang.Exception e 
					(do (JOptionPane/showMessageDialog nil (str e) "Error loading ontology" JOptionPane/ERROR_MESSAGE)
							(str "error - " (stack-trace-to-string e))))))

;
(defn -write
	"serialize ontology"
	[arg-str-representation]
	(let [table (deserialize-args arg-str-representation)]
		(init)
		(embeded-import-from-tda table)))

;
(defn -diff
	"diff ontology with one in file"
	[arg-str-representation]
	(try
		(let [table (deserialize-args arg-str-representation)]
			(init)
			(diff-ontologies table))
		(catch java.lang.Exception e 
					(do (JOptionPane/showMessageDialog nil (str e) "Error loading ontology" JOptionPane/ERROR_MESSAGE)
							(str "error - " (stack-trace-to-string e))))))